/**
 * <addCard>
 * -----------------------------------------------------------------------------
 * addCard.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins] TESTS
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */
 jQuery(document).ready(function( $ ) {

	Vue.component('addCard', {

      //  ╔═╗╦═╗╔═╗╔═╗╔═╗
      //  ╠═╝╠╦╝║ ║╠═╝╚═╗
      //  ╩  ╩╚═╚═╝╩  ╚═╝
      props: [
        'label',// Billing Or Add ard
      ],

      //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
      //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
      //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
      data: function (){
        return {
            // isBillingEnabled: false,

            // hasBillingCard: false,
        
            // Syncing/loading states for this page.
            syncingOpenCheckout: false,
            syncingUpdateCard: false,
            syncingRemoveCard: false,
        
            // Form data
            formData: { /* … */ },
        
            // Server error state for the form
            cloudError: '',
        
            // For the Stripe checkout window
            checkoutHandler: undefined,
        
            // For the confirmation modal:
            removeCardModalVisible: false,
        };
      },
      

      //  ╦ ╦╔╦╗╔╦╗╦
      //  ╠═╣ ║ ║║║║
      //  ╩ ╩ ╩ ╩ ╩╩═╝
      template: `
      <div class="billing">
              <div class="row mb-3" v-if="isBillingEnabled">
                  <div class="col-sm-6 pl-0">
                      <label for="toInternal">{{label}}</label>
                  </div>
                  <div class="col-sm-6">
                      <span class="float-sm-right">
                      <ajax-button :syncing="syncingOpenCheckout || syncingUpdateCard" class="" @click="clickStripeCheckoutButton()">
                          <span slot="syncing-state">
                          <span v-if="syncingOpenCheckout">Connecting...</span>
                          <span v-else>Updating...</span>
                          </span>
                          <span slot="default">{{ me.hasBillingCard ? 'Change card' : 'Add card' }}</span>
                      </ajax-button>
                      </span>
                  </div>
                  <div v-if="isBillingEnabled && me.hasBillingCard">
                    <div class="row">
                        <div class="col-3">Credit card:</div>
                        <div class="col">{{me.billingCardBrand}} ending in <strong>{{me.billingCardLast4}}</strong> <a class="remove-button ml-2" @click="clickRemoveCardButton()">Remove</a></div>
                    </div>
                    <div class="row">
                        <div class="col-3">Expiration:</div>
                        <div class="col">{{me.billingCardExpMonth}}/{{me.billingCardExpYear}}</div>
                    </div>
                  </div>
                  <div class="alert alert-danger" v-else-if="isBillingEnabled && cloudError">
                  There was an error updating your credit card information. Please check your information and try again, or <a href="/contact">contact support</a> if the error persists.
                  </div>
                  <div class="alert alert-secondary" v-else-if="isBillingEnabled">
                  You have not linked a payment source to your account. In order to access paid features, you'll need to provide your credit card information. (Don't worry: you will only be charged when you've reached the limit of your free plan.)
                  </div>
              </div>
        
                <modal v-if="removeCardModalVisible" @close="closeRemoveCardModal()" v-cloak>
                <div class="modal-header">
                <h5 class="modal-title">Remove Card Info?</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span>&times;</span>
                </button>
                </div>
                <ajax-form action="updateBillingCard" :syncing.sync="syncingRemoveCard" :cloud-error.sync="cloudError" :handle-parsing="handleParsingRemoveCardForm" @submitted="submittedRemoveCardForm()">
                <div class="modal-body">
                    <p>Are you sure you want to remove your {{me.billingCardBrand}} ending in <strong>{{me.billingCardLast4}}</strong>?</p>
                    <p class="text-muted">This may restrict your access to paid features.</p>
                    <p class="text-danger" v-if="cloudError"><small>An error occured while processing your request. Please check your information and try again, or <a href="/contact">contact support</a> if the error persists.</small></p>
                </div>
                <div class="modal-footer">
                    <button data-dismiss="modal" class="btn btn-outline-secondary mr-1">Nevermind</button>
                    <ajax-button type="submit" :syncing="syncingRemoveCard" class="btn btn-danger ml-1">Remove</ajax-button>
                </div>
                </ajax-form>
                </modal>
        
          </div>

        
      `,

      //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
      //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
      //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
      beforeMount: function (){
        _.extend(this, window.SAILS_LOCALS);

        this.isBillingEnabled = !!this.stripePublishableKey;
        console.log("this.stripePublishableKey",this.stripePublishableKey);
        console.log("this.me.hasBillingCard",this.me.hasBillingCard);
        // Determine whether there is billing info for this user.
        this.me.hasBillingCard = (
          this.me.billingCardBrand &&
          this.me.billingCardLast4 &&
          this.me.billingCardExpMonth &&
          this.me.billingCardExpYear
        );
      },



      //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
      //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
      //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
      methods: {

        clickStripeCheckoutButton: async function() {

          // Prevent double-posting if it's still loading.
          if(this.syncingUpdateCard) { return; }

          // Show syncing state for opening checkout.
          this.syncingOpenCheckout = true;

          // Clear out error states.
          this.cloudError = false;

          // Open Stripe Checkout.
          var billingCardInfo = await parasails.util.openStripeCheckout(this.stripePublishableKey, this.me.emailAddress);
          // Clear the loading state for opening checkout.
          this.syncingOpenCheckout = false;
          if (!billingCardInfo) {
            // (if the user canceled the dialog, avast)
            return;
          }

          // Now that payment info has been successfully added, update the billing
          // info for this user in our backend.
          this.syncingUpdateCard = true;
          await Cloud.updateBillingCard.with(billingCardInfo)
          .tolerate(()=>{
            this.cloudError = true;
          });
          this.syncingUpdateCard = false;

          // Upon success, update billing info in the UI.
          if (!this.cloudError) {
            Object.assign(this.me, _.pick(billingCardInfo, ['billingCardLast4', 'billingCardBrand', 'billingCardExpMonth', 'billingCardExpYear']));
            this.me.hasBillingCard = true;
          }
        },

        clickRemoveCardButton: async function() {
          this.removeCardModalVisible = true;
        },

        closeRemoveCardModal: async function() {
          this.removeCardModalVisible = false;
          this.cloudError = false;
        },

        submittedRemoveCardForm: async function() {

          // Update billing info on success.
          this.me.billingCardLast4 = undefined;
          this.me.billingCardBrand = undefined;
          this.me.billingCardExpMonth = undefined;
          this.me.billingCardExpYear = undefined;
          this.me.hasBillingCard = false;

          // Close the modal and clear it out.
          this.closeRemoveCardModal();

        },

        handleParsingRemoveCardForm: function() {
          return {
            // Set to empty string to indicate the default payment source
            // for this customer is being completely removed.
            stripeToken: ''
          };
        },

      }

  });

});

