/**
 * <balances>
 * -----------------------------------------------------------------------------
 * balances.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */
 jQuery(document).ready(function( $ ) {


	Vue.component('balances', {
  

    //  ╔═╗╦═╗╔═╗╔═╗╔═╗
    //  ╠═╝╠╦╝║ ║╠═╝╚═╗
    //  ╩  ╩╚═╚═╝╩  ╚═╝
    props: [
      // 'markets',// « The JS timestamp to format
      // 'buyCurrency',
      // 'type',
    ],

    //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
    //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
    //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
    data: function (){
      return {
       //…
            refreshUrl:'',
            isBillingEnabled: false,

            hasBillingCard: false,

            // Syncing/loading states for this page.
            syncingOpenCheckout: false,
            syncingUpdateCard: false,
            syncingRemoveCard: false,
            totalUsdValue: 0,
            expiresAt:0,
            // Form data
            formData: { 
            transferType: "internal"
            },

            // For tracking client-side validation errors in our form.
            // > Has property set to `true` for each invalid property in `formData`.
            formErrors: { /* … */ },

            // Syncing / loading state
            syncing: false,

            // Server error state
            cloudError: '',

            // Success state when form has been submitted
            cloudSuccess: false,

            loadingBalances: true,
            cloudLoadingError: '',

            smsNumber:"",
            smsBalance:0,
            appToken:"",
            stableToken:"",
            shareLink:"",
            sellCurrencies:[],
            paymentMethods:[],
            balances:[],
            baseUrl:"",
            environment:"",
      };
    },

    /*
                    (type && market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
                  || (type && market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
    */

    //  ╦ ╦╔╦╗╔╦╗╦
    //  ╠═╣ ║ ║║║║
    //  ╩ ╩ ╩ ╩ ╩╩═╝
    template: `
    <div class="balances-component">
    <div v-if="loadingBalances" class="text-center">
    <h1>Your balances are being loaded...</h1>
    <ajax-button type="submit" :syncing="loadingBalances" class="btn btn-primary mint">Refesh</ajax-button>
  </div>
  <div v-else="">
    <div class="container">
      <div class="row mb-3">
        <div class="col-sm-12">
          <h2 class="text-center">Balances </h2>
          <h4 class="text-center">Total Value: $ {{ totalUsdValue }} USD </h4>
          <!-- {{balances}} -->
          <!-- <p class="text-center">
            Estimated value of holdings: $311.99 USD / 0.02756142 BTC
          </p> -->
        </div>
        <div class="col-sm-12 text-right float-right">
          <% if(me){ %>
            <!-- {{shareLink}} -->
            <share-modal id="share" class="float-right" label="Share UnitedCoin" :share-link="shareLink"></share-modal>
        
        <% } %>
          <!-- <span class="float-sm-right">
            <ajax-form action="balances" :syncing.sync="syncing" :cloud-error.sync="cloudError" @submitted="gotBalances($event)" :form-data="formData" >
              <ajax-button type="submit" :syncing="syncing" class="btn btn-sm btn-outline-info getBalances">Refresh</ajax-button>
            </ajax-form>
          </span> -->
        </div>
      </div>
      <!-- <p>(See also <em>assets/styles/pages/account/balances.less</em>, <em>assets/js/pages/account/balances.page.js</em>, and <em>api/controllers/account/view-balances.js</em>.)</p> -->
      <!-- {{paymentMethods}} -->
      <!-- {{balances}} -->
      <div class="row mb-3">
        <div class="col-md-12">
          <table class="table" align="center">
            <thead>
              <tr>
                <th>Coin</th>
                <th>Price</th>
                <th>Total Balance</th>
                <th>On Orders</th>
                <!-- <th>BTC Value</th> -->
                <th>USD Value</th>
                <th></th>
              </tr>
            </thead>
            <tbody class="balances">
              <!-- <tr v-for="balance in paymentMethods" v-if="false" :class="balance.currency.shopifyBuyProductHandle +' '+ balance.currency.symbol + '  united-token-product'"> -->
              <tr v-for="balance in paymentMethods" :class="balance.currency.shopifyBuyProductHandle +' '+ balance.currency.symbol +' '+ balance.currency.symbolBase + '  united-token-product'">
              <!-- <tr v-for="balance in paymentMethods" :class="balance.currency.shopifyBuyProductHandle +' '+ balance.currency.symbol + '  united-product'"> -->
                <td>
                  <!-- {{balance.currency}} -->
  
                  <span class="currency">{{balance.currency.name}}</span> 
                </td>
                <td class="">
                  <!-- <span class="price"></span> <span class="payment-currency">USD</span> -->
                  <span class="displayPrice">{{balance.currency.price.toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",")}}</span> <span class="payment-currency">{{balance.currency.paymentMethod.symbol}}</span>
  
                </td>
                <td v-if="balance.ownerType == 'user'">
                  <span class="balance">{{balance.available}} </span> 
                </td>
                <td v-if="balance.ownerType == 'token'">
                  <span class="balance">{{balance.spendingBalance}} </span> 
                </td>
                <td>
                  <span class="order">{{balance.order}} </span> 
                  <!-- {{balance}} -->
  
                </td>
                <!-- <td>
                  <span class="btcValue">{{balance.btcValue}} </span> 
                </td> -->
                <td>
                  <span v-if="balance.currency.id  == stableToken.id" class="usdValue">$ {{(1 * (balance.spendingBalance + balance.order) ).toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",")}} USD </span> 
                  <span v-else class="usdValue">$ {{balance.currency.lastPrice ? (balance.currency.lastPrice * (balance.spendingBalance + balance.order) ).toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",") : 0.00 }} USD </span> 
                </td>
                <td class="" >
                  <button v-if="balance.currency.id == appToken.id || balance.currency.id == stableToken.id " class="btn btn-sm btn-success cart">Deposit</button>
                  <a :href="balance.currency.symbolBase" v-else="" class="btn btn-sm btn-success deposit" data-toggle="modal" data-target="#confirmModal">Deposit</a>
  
  
                  <a :href="'/markets/'+balance.currency.market" v-if="balance.currency.id == appToken.id" class="btn btn-sm btn-outline-info  btn-danger" >Withdraw</a>
                  <a href="/cards/transfer" v-else-if="balance.currency.id == stableToken.id " class="btn btn-sm btn-outline-info  btn-danger" >Withdraw</a>
                  <a :href="balance.currency.symbolBase"  v-else="" class="btn btn-sm btn-outline-info withdraw btn-danger" data-toggle="modal" data-target="#transferModal">Withdraw</a>
                      
                  <a type="submit"  :href="balance.currency.symbol" class="d-md-inline-block d-lg-inline-block d-lx-inline-block btn btn-sm btn-outline-info btn-primary send" data-toggle="modal" data-target="#transferModal">Send</a>
                  <!-- <a type="submit"  :href="'/exchange/transfer/'" class="d-none d-sm-inline-block d-xs-inline-block d-md-none btn btn-sm btn-outline-info btn-primary send" >Send</a> -->
  
  
                  <input type="hidden" class="shopifyVariantId" value="" >
                  <input type="hidden" class="tokenId" :value="balance.currency.id" >
                  <input type="hidden" class="productId" :value="balance.currency.buyProductId" >
                  <input type="hidden" class="accountId" :value="balance.id" >
                  <input type="hidden" class="price" :value="balance.currency.price" >
                  <input type="hidden" class="market" :value="balance.currency.market" >
                  <input type="hidden" class="title" :value="balance.currency.name" >
                  <input type="hidden" class="img" :value="balance.currency.logo" >
                  <input type="hidden" class="shopifyHandle" :value="balance.currency.shopifyBuyProductHandle" >
                  <input type="hidden" class="variantPrice" :value="balance.currency.price" >
                  <input type="hidden" class="quantity" value="1" >
                  <input type="hidden" class="type" value="token" >
                  
  
  
                  <!-- <input type="hidden" class="shopifyVariantId" value="" >
                  <input type="hidden" class="productId" :value="balance.currency.buyProductId" >
                  <input type="hidden" class="accountId" :value="balance.id" >
                  <input type="hidden" class="title" :value="balance.currency.name" >
                  <input type="hidden" class="img" :value="balance.currency.logo" >
                  <input type="hidden" class="shopifyHandle" :value="balance.currency.shopifyBuyProductHandle" >
                  <input type="hidden" class="variantPrice" :value="balance.currency.price" >
                  <input type="hidden" class="quantity" value="1" >
                  <input type="hidden" class="type" value="token" > -->
                  <!-- {{balance.currency.price}} -->
  
  
  
         
                </td>
              </tr>
              <tr  class="UNITS_STELLAR sms united-token-product'">
                <!-- <tr v-for="balance in paymentMethods" :class="balance.currency.shopifyBuyProductHandle +' '+ balance.currency.symbol + '  united-product'"> -->
                  <td>
                    <!-- {{balance.currency}} -->
    
                    <span class="currency">UNITS Stellar</span> 
                  </td>
                  <td class="">
                    <!-- <span class="price"></span> <span class="payment-currency">USD</span> -->
                    <span class="displayPrice">{{appToken.price.toFixed(2)}} </span> <span class="payment-currency"></span>
    
                  </td>
                  <td>
                    <span class="balance"> {{smsBalance.spendingBalance}} </span> 
                  </td>
             
                  <td>
                    <span class="order">0 </span> 
                    <!-- {{balance}} -->
    
                  </td>
                  <!-- <td>
                    <span class="btcValue">{{balance.btcValue}} </span> 
                  </td> -->
                  <td>
                    <span class="usdValue">$ {{appToken.lastPrice ? (appToken.lastPrice * (smsBalance.spendingBalance) ).toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",") : 0.00 }} USD </span> 
                  </td>
                  <td class="" >
                    <a href="UNITS_STELLAR" class="btn btn-sm btn-success deposit" data-toggle="modal" data-target="#confirmModal">Deposit</a>
  
                    <a href="UNITS_STELLAR"  class="btn btn-sm btn-outline-info withdraw btn-danger" data-toggle="modal" data-target="#transferModal">Withdraw</a>
                        
                    <a type="submit"  href="UNITS_STELLAR" class="d-none d-sm-none d-md-inline-block d-lg-inline-block d-lx-inline-block btn btn-sm btn-outline-info btn-primary send" data-toggle="modal" data-target="#transferModal">Send</a>
                    <!-- <a type="submit"  :href="'/exchange/transfer/'" class="d-none d-sm-inline-block d-xs-inline-block d-md-none btn btn-sm btn-outline-info btn-primary send" >Send</a> -->
    
    
                    <input type="hidden" class="shopifyVariantId" value="UNITS_STELLAR" >
                    <input type="hidden" class="tokenId" value="UNITS_STELLAR" >
                    <input type="hidden" class="productId" value="UNITS_STELLAR" >
                    <input type="hidden" class="accountId" value="UNITS_STELLAR" >
                    <input type="hidden" class="price" :value="appToken.price" >
                    <input type="hidden" class="market" value="UNITS_STELLAR" >
                    <input type="hidden" class="title" value="UNITS - Stellar" >
                    <input type="hidden" class="img" value="appToken.logo" >
                    <input type="hidden" class="shopifyHandle" value="UNITS_STELLAR" >
                    <input type="hidden" class="variantPrice" :value="appToken.price"  >
                    <input type="hidden" class="address" :value="smsBalance.address"  >
                    <input type="hidden" class="quantity" value="1" >
                    <input type="hidden" class="type" value="token" >
                    
    
    
                    <!-- <input type="hidden" class="shopifyVariantId" value="" >
                    <input type="hidden" class="productId" :value="balance.currency.buyProductId" >
                    <input type="hidden" class="accountId" :value="balance.id" >
                    <input type="hidden" class="title" :value="balance.currency.name" >
                    <input type="hidden" class="img" :value="balance.currency.logo" >
                    <input type="hidden" class="shopifyHandle" :value="balance.currency.shopifyBuyProductHandle" >
                    <input type="hidden" class="variantPrice" :value="balance.currency.price" >
                    <input type="hidden" class="quantity" value="1" >
                    <input type="hidden" class="type" value="token" > -->
                    <!-- {{balance.currency.price}} -->
    
    
    
           
                  </td>
              </tr>
              <!-- <tr v-for="balance in sellCurrencies"  v-if="false " :class="balance.currency.shopifyBuyProductHandle +' '+ balance.currency.symbol + ' united-token-product '"> -->
              <tr v-for="balance in sellCurrencies"   :class="balance.currency.shopifyBuyProductHandle +' '+ balance.currency.symbol +' '+ balance.currency.symbolBase + ' united-token-product '">
                  <td>
                    <span class="currency">{{balance.currency.name}}</span> 
                  </td>
                  <td class="">
                    <span class="displayPrice">{{balance.currency.price.toFixed(2)}}</span> <span class="payment-currency">{{balance.currency.paymentMethod.symbol}}</span>
                  </td>
                  <td v-if="balance.ownerType == 'user'">
                    <span class="balance">{{balance.available}} </span> 
                  </td>
                  <td v-if="balance.ownerType == 'token'">
                    <span class="balance">{{balance.spendingBalance}} </span> 
                  </td>
                  <td>
                    <span class="order">{{balance.order}} </span> 
                    <!-- {{balance}} -->
    
                  </td>
                  <!-- <td>
                    <span class="btcValue">{{balance.btcValue}} </span> 
                  </td> -->
                  <td>
                    <span class="usdValue">{{balance.currency.lastPrice ? (balance.currency.lastPrice * (balance.spendingBalance + balance.order) ).toFixed(2) : 0.00 }} USD </span> 
                  </td>
                  <td class="" >
                    <button class="btn btn-sm btn-success cart">Deposit</button>
                    <a :href="'/markets/'+balance.currency.market"  class="btn btn-sm btn-outline-info  btn-danger">Withdraw</a>
                    <a type="submit"  :href="balance.currency.symbol" class="d-md-inline-block d-lg-inline-block d-lx-inline-block btn btn-sm btn-outline-info deposit btn-primary send" data-toggle="modal" data-target="#transferModal">Send</a>
                    <!-- <a type="submit"  :href="'/exchange/transfer/'" class="d-none d-sm-inline-block d-xs-inline-block d-md-none btn btn-sm btn-outline-info btn-primary send" >Send</a> -->
                        
                    <input type="hidden" class="shopifyVariantId" value="" >
                    <input type="hidden" class="tokenId" :value="balance.currency.id" >
                    <input type="hidden" class="productId" :value="balance.currency.buyProductId" >
                    <input type="hidden" class="accountId" :value="balance.id" >
                    <input type="hidden" class="price" :value="balance.currency.price" >
                    <input type="hidden" class="market" :value="balance.currency.market" >
                    <input type="hidden" class="title" :value="balance.currency.name" >
                    <input type="hidden" class="img" :value="balance.currency.logo" >
                    <input type="hidden" class="shopifyHandle" :value="balance.currency.shopifyBuyProductHandle" >
                    <input type="hidden" class="variantPrice" :value="balance.currency.price" >
                    <input type="hidden" class="quantity" value="1" >
                    <input type="hidden" class="type" value="token" >
                    <!-- {{balance.currency.price}} -->
  
    
           
                  </td>
              </tr>
             
            </tbody>
          </table>
          <!-- <cart-modal id="cart" :environment="environment" checkout-redirect="/balances/" checkout-action="buyUnits" product-class="united-product" shop-slug="unitedcoin"  shop="unitedcoin.myshopify.com" storefront-access-token="57eb127019ea45acfe87f917fe00ac3f"></cart-modal> -->
          
          <token-cart-modal id="token-cart" :environment="environment" checkout-redirect="/balances/" checkout-action="buyUnits" :payment-methods="paymentMethods" product-class="united-token-product" shop="unitedcoin.myshopify.com" storefront-access-token="57eb127019ea45acfe87f917fe00ac3f"></token-cart-modal>
  
  
        </div>
  
      </div>
      <div class="row mb-3">
        <div class="col-sm-12">
          <h2 class="text-center">Reserve Balances</h2>
          <!-- <h4 class="text-center">Total Value: $ {{ totalUsdValue }} USD </h4> -->
          <!-- {{balances}} -->
          <!-- <p class="text-center">
            Estimated value of holdings: $311.99 USD / 0.02756142 BTC
          </p> -->
        </div>
      </div>
      <div class="row mb-3">
        <div class="col-md-12">
          <table class="table" align="center">
            <thead>
              <tr>
                <th>Coin</th>
                <th>Price</th>
                <th>Total Balance</th>
                <th>On Orders</th>
                <!-- <th>BTC Value</th> -->
                <th>USD Value</th>
                <th></th>
              </tr>
            </thead>
            <tbody class="balances">


              <tr v-for="balance in reserves"   :class="balance.currency.shopifyBuyProductHandle +' '+ balance.currency.symbol +' '+ balance.currency.symbolBase + ' united-token-product '">
                  <td>
                    <span class="currency">{{balance.currency.name}}</span> 
                  </td>
                  <td class="">
                    <span class="displayPrice">{{balance.currency.price.toFixed(2)}}</span> <span class="payment-currency">{{balance.currency.paymentMethod.symbol}}</span>
                  </td>
                  <td v-if="balance.ownerType == 'user'">
                    <span class="balance">{{balance.available}} </span> 
                  </td>
                  <td v-if="balance.ownerType == 'token'">
                    <span class="balance">{{balance.spendingBalance}} </span> 
                  </td>
                  <td>
                    <span class="order">{{balance.order}} </span> 
                    <!-- {{balance}} -->
    
                  </td>
                  <!-- <td>
                    <span class="btcValue">{{balance.btcValue}} </span> 
                  </td> -->
                  <td>
                    <span class="usdValue">{{balance.currency.lastPrice ? (balance.currency.lastPrice * (balance.spendingBalance + balance.order) ).toFixed(2) : 0.00 }} USD </span> 
                  </td>
                  <td class="" >
                    <button class="btn btn-sm btn-success cart">Deposit</button>
                    <a :href="'/markets/'+balance.currency.market"  class="btn btn-sm btn-outline-info  btn-danger">Withdraw</a>
                    <a type="submit"  :href="balance.currency.symbol" class="d-md-inline-block d-lg-inline-block d-lx-inline-block btn btn-sm btn-outline-info deposit btn-primary send" data-toggle="modal" data-target="#transferModal">Send</a>
                    <!-- <a type="submit"  :href="'/exchange/transfer/'" class="d-none d-sm-inline-block d-xs-inline-block d-md-none btn btn-sm btn-outline-info btn-primary send" >Send</a> -->
                        
                    <input type="hidden" class="shopifyVariantId" value="" >
                    <input type="hidden" class="tokenId" :value="balance.currency.id" >
                    <input type="hidden" class="productId" :value="balance.currency.buyProductId" >
                    <input type="hidden" class="accountId" :value="balance.id" >
                    <input type="hidden" class="price" :value="balance.currency.price" >
                    <input type="hidden" class="market" :value="balance.currency.market" >
                    <input type="hidden" class="title" :value="balance.currency.name" >
                    <input type="hidden" class="img" :value="balance.currency.logo" >
                    <input type="hidden" class="shopifyHandle" :value="balance.currency.shopifyBuyProductHandle" >
                    <input type="hidden" class="variantPrice" :value="balance.currency.price" >
                    <input type="hidden" class="quantity" value="1" >
                    <input type="hidden" class="type" value="token" >
                    <!-- {{balance.currency.price}} -->
  
    
           
                  </td>
              </tr>
              <tr v-for="balance in tethers"   :class="balance.currency.shopifyBuyProductHandle +' '+ balance.currency.symbol +' '+ balance.currency.symbolBase + ' united-token-product tetherBalance ' + 'tethered_'+balance.currency.tetherTokenSymbol">
                  <td>
                    <!-- <span class="currency">{{balance.currency.tetherTokenName}}</span>  -->
                    <span class="currency">{{balance.currency.tetherTokenSymbol}}</span> 
                  </td>
                  <td class="">
                    <span v-if="balance.currency.tetherTokenSymbol == 'TestWrap' || balance.currency.tetherTokenSymbol == 'USTELLAR' || balance.currency.tetherTokenSymbol == 'US'" class="displayPrice">{{appToken.price.toFixed(2)}}</span>
                    <span v-else="">{{balance.currency.price.toFixed(2)}}</span>
                    <span class="payment-currency">{{balance.currency.paymentMethod.symbol}}</span>
                  </td>
                  <!-- <td v-if="balance.ownerType == 'user'">
                    <span class="balance">{{balance.available}} </span> 
                  </td>
                  <td v-if="balance.ownerType == 'token'">
                    <span class="balance">{{balance.spendingBalance + balance.available}} </span> 
                  </td> -->
                  <td >
                    <span class="balance">{{(balance.spendingBalance + balance.available) / balance.currency.tetherFactor}} </span> 
                  </td>
                  <td>
                    <span class="order">{{balance.order / balance.currency.tetherFactor}} </span> 
                    <!-- {{balance}} -->
    
                  </td>
                  <!-- <td>
                    <span class="btcValue">{{balance.btcValue}} </span> 
                  </td> -->
                  <td>
                    
                    <span v-if="balance.currency.tetherTokenSymbol == 'TestWrap' || balance.currency.tetherTokenSymbol == 'USTELLAR' || balance.currency.tetherTokenSymbol == 'US'" class="usdValue">{{appToken.lastPrice ? (appToken.lastPrice * ( (balance.available + balance.spendingBalance + balance.order) / balance.currency.tetherFactor ) ).toFixed(2) : 0.00 }} USD </span> 
                    <span v-else="" class="usdValue">{{balance.currency.lastPrice ? (balance.currency.lastPrice * (balance.spendingBalance + balance.order) ).toFixed(2) : 0.00 }} USD </span> 
                  </td>
                  <td class="" >
                    <a :href="'tethered_'+balance.currency.tetherTokenSymbol" class="btn btn-sm btn-success deposit" data-toggle="modal" data-target="#confirmModal">Deposit</a>

                    <a :href="'tethered_'+balance.currency.tetherTokenSymbol"   class="btn btn-sm btn-outline-info withdraw btn-danger" data-toggle="modal" data-target="#transferModal">Withdraw</a>
                    <a :href="'tethered_'+balance.currency.tetherTokenSymbol"  class="btn btn-sm btn-outline-info send btn-primary" data-toggle="modal" data-target="#transferModal">Send</a>
                    


                    <!-- <a type="submit"  :href="balance.currency.symbol" class="d-md-inline-block d-lg-inline-block d-lx-inline-block btn btn-sm btn-outline-info deposit btn-primary send" data-toggle="modal" data-target="#transferModal">Send</a> -->
                    <!-- <a type="submit"  :href="'/exchange/transfer/'" class="d-none d-sm-inline-block d-xs-inline-block d-md-none btn btn-sm btn-outline-info btn-primary send" >Send</a> -->
                        
                    <input type="hidden" class="shopifyVariantId" value="" >
                    <input type="hidden" class="tetherFactor" :value="balance.currency.tetherFactor" >
                    <input type="hidden" class="tokenId" :value="balance.currency.id" >
                    <input type="hidden" class="productId" :value="balance.currency.buyProductId" >
                    <input type="hidden" class="accountId" :value="balance.id" >
                    <input type="hidden" class="balanceId" :value="balance.id" >
                    <input type="hidden" class="price" :value="balance.currency.price" >
                    <input type="hidden" class="market" :value="balance.currency.market" >
                    <input type="hidden" class="title" :value="balance.currency.name" >
                    <input type="hidden" class="img" :value="balance.currency.logo" >
                    <input type="hidden" class="shopifyHandle" :value="balance.currency.shopifyBuyProductHandle" >
                    <input type="hidden" class="variantPrice" :value="balance.currency.price" >
                    <input type="hidden" class="quantity" value="1" >
                    <input type="hidden" class="type" value="token" >
                    <input type="hidden" class="verificationDepositAmount" value="14" >
                    <!-- {{balance.currency.price}} -->

    
          
                  </td>
              </tr>
              
             
            </tbody>
          </table>
          <!-- <cart-modal id="cart" :environment="environment" checkout-redirect="/balances/" checkout-action="buyUnits" product-class="united-product" shop-slug="unitedcoin"  shop="unitedcoin.myshopify.com" storefront-access-token="57eb127019ea45acfe87f917fe00ac3f"></cart-modal> -->
          
  
  
        </div>
  
      </div>
      <div class="row mb-3">
        <div class="col-sm-12">
          <h2 class="text-center">Unclaimed Balances</h2>
          <!-- <h4 class="text-center">Total Value: $ {{ totalUsdValue }} USD </h4> -->
          <!-- {{balances}} -->
          <!-- <p class="text-center">
            Estimated value of holdings: $311.99 USD / 0.02756142 BTC
          </p> -->
        </div>
      </div>
      <div class="row mb-3">
        <div class="col-md-12">
          <table class="table" align="center">
            <thead>
              <tr>
                <th>Coin</th>
                <th>Price</th>
                <th>Total Balance</th>
                <th>On Orders</th>
                <!-- <th>BTC Value</th> -->
                <th>USD Value</th>
                <th></th>
              </tr>
            </thead>
            <tbody class="balances">


              <tr v-for="balance in unclaimedBalances"   :class="balance.currency.shopifyBuyProductHandle +' '+ balance.currency.symbol +' '+ balance.currency.symbolBase + ' united-token-product unclaimedBalance ' + 'unclaimed_'+balance.currency.tetherTokenSymbol + ' tethered_'+balance.currency.symbolBase">
                  <td>
                    <span class="currency">{{balance.currency.tetherTokenSymbol}}</span> 
                  </td>
                  <td class="">
                    <span v-if="balance.currency.tetherTokenSymbol == 'TestWrap' || balance.currency.tetherTokenSymbol == 'USTELLAR' || balance.currency.tetherTokenSymbol == 'US'" class="displayPrice">{{appToken.price.toFixed(2)}}</span>
                    <span v-else="">{{balance.currency.price.toFixed(2)}}</span>
                    <span class="payment-currency">{{balance.currency.paymentMethod.symbol}}</span>
                  </td>

                  <td >
                    <span class="balance">{{(balance.spendingBalance + balance.available) / balance.currency.tetherFactor}} </span> 
                  </td>
                  <td>
                    <span class="order">{{balance.order / balance.currency.tetherFactor}} </span> 
    
                  </td>
      
                  <td>
                    
                    <span v-if="balance.currency.tetherTokenSymbol == 'TestWrap' || balance.currency.tetherTokenSymbol == 'USTELLAR' || balance.currency.tetherTokenSymbol == 'US'" class="usdValue">{{appToken.lastPrice ? (appToken.lastPrice * ( (balance.available + balance.spendingBalance + balance.order) / balance.currency.tetherFactor ) ).toFixed(2) : 0.00 }} USD </span> 
                    <span v-else="" class="usdValue">{{balance.currency.lastPrice ? (balance.currency.lastPrice * (balance.spendingBalance + balance.order) ).toFixed(2) : 0.00 }} USD </span> 
                  </td>
                  <td class="" >
                    <a :href="'unclaimed_'+balance.currency.tetherTokenSymbol" class="btn btn-sm btn-success deposit" data-toggle="modal" data-target="#confirmModal">Deposit</a>
  
                    <a :href="'unclaimed_'+balance.currency.tetherTokenSymbol"  class="btn btn-sm btn-outline-info withdraw btn-danger" data-toggle="modal" data-target="#confirmModal">Withdraw</a>
                    <a :href="'unclaimed_'+balance.currency.tetherTokenSymbol"  class="btn btn-sm btn-outline-info withdraw btn-primary" data-toggle="modal" data-target="#confirmModal">Send</a>


                        
                    <input type="hidden" class="shopifyVariantId" value="" >
                    <input type="hidden" class="tetherFactor" :value="balance.currency.tetherFactor" >
                    <input type="hidden" class="tokenId" :value="balance.currency.id" >
                    <input type="hidden" class="productId" :value="balance.currency.buyProductId" >
                    <input type="hidden" class="accountId" :value="balance.id" >
                    <input type="hidden" class="balanceId" :value="balance.id" >
                    <input type="hidden" class="price" :value="balance.currency.price" >
                    <input type="hidden" class="market" :value="balance.currency.market" >
                    <input type="hidden" class="title" :value="balance.currency.name" >
                    <input type="hidden" class="img" :value="balance.currency.logo" >
                    <input type="hidden" class="shopifyHandle" :value="balance.currency.shopifyBuyProductHandle" >
                    <input type="hidden" class="variantPrice" :value="balance.currency.price" >
                    <input type="hidden" class="quantity" value="1" >
                    <input type="hidden" class="type" value="token" >
                    <input type="hidden" class="verificationDepositAmount" value="14" >
           
                  </td>
              </tr>
             
            </tbody>
          </table>
          <!-- <cart-modal id="cart" :environment="environment" checkout-redirect="/balances/" checkout-action="buyUnits" product-class="united-product" shop-slug="unitedcoin"  shop="unitedcoin.myshopify.com" storefront-access-token="57eb127019ea45acfe87f917fe00ac3f"></cart-modal> -->
          
  
  
        </div>
  
      </div>
      <ajax-form action="transfer" :syncing.sync="syncing" :cloud-error.sync="cloudError" @submitted="submittedForm($event)" :handle-parsing="handleParsingForm">
  
        <!-- Confrim Modal -->
        <div class="modal fade" id="confirmModal" tabindex="-1" role="dialog" aria-labelledby="confirmLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
              <div class="modal-content">
                <div class="modal-header send-btn deposit-btn withdraw-btn tether-sms-withdraw-btn action-btn">
                  <h5 class="modal-title" id="confirmLabel">Confim <span class="currency"></span> <span class=action></span> </h5>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                  </button>
                </div>
                <div class="modal-header verify-sms-withdraw-btn action-btn">
                  <h5 class="modal-title" id="confirmLabel">Verify <span class="currency"></span> Deposit </h5>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                  </button>
                </div>
                <div class="modal-body verify-sms-withdraw-btn action-btn">
                    <h6>Send {{formData.toAddress}} <span class="memo tether-sms-withdraw-btn action-btn">Memo: {{formData.toMemo}}</span>  {{formData.amount}} <span class="currency"></span></h6>
  
                    <p>IMPORTANT Send only <span class="currency"></span> to this deposit address.</p>
  
                    <p class="danger"> Sending any other currency to this address may result in the loss of your <span class=currency></span>!</p>
                    
                  <!-- <p><span class="currency"></span> <span class=action></span>s will be available after 12 network confirmations.</p> -->
                </div>
                <div class="modal-body deposit-btn withdraw-btn tether-sms-withdraw-btn">
                    <h6>Send {{formData.toAddress}} <span class="memo tether-sms-withdraw-btn action-btn">Memo: {{formData.toMemo}}</span>  {{formData.amount}} <span class="currency"></span></h6>
  
                    <p>IMPORTANT Send only <span class="currency"></span> to this <span class=action></span> address.</p>
  
                    <p class="danger"> Sending any other currency to this address may result in the loss of your <span class=action></span>!</p>
                    
                  <!-- <p><span class="currency"></span> <span class=action></span>s will be available after 12 network confirmations.</p> -->
                </div>
                
                <div class="modal-body send-btn ">
                    <h6>Send {{formData.toPayment}} {{formData.amount}} <span class="currency"></span></h6>
                    <br>
                    <p><span class="currency"></span> <span class=action></span>s will be available after 12 network confirmations.</p>
                </div>
                <p class="danger send-btn withdraw-btn tether-sms-withdraw-btn" v-if="formErrors.cloudError">There was a cloud error completing this transaction.</p>
                <p class="success send-btn withdraw-btn tether-sms-withdraw-btn" v-if="formErrors.transferSuccess">Your transfer has been sent successfully!</p>
  
                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                  <!-- <button data-dismiss="modal" data-toggle="modal" data-target="#transferModal" type="button" class="btn btn-primary withdraw-btn confirmWithdraw">Confirm Withdraw</button> -->
                  <button data-dismiss="modal" data-toggle="modal" data-target="#transferModal" type="button" class="btn btn-primary d-none  deposit-modal-btn">Confirm Deposit</button>
                  <ajax-button  type="submit" :syncing="syncing" class="btn btn-primary deposit-btn confirmDeposit">Confirm Deposit</ajax-button>
                  <ajax-button  type="submit" :syncing="syncing" class="btn btn-primary action-btn verify-sms-withdraw-btn verifyDeposit">Verify Deposit</ajax-button>

                  
  
                  <ajax-button  type="submit" :syncing="syncing" class="btn btn-primary withdraw-btn tether-sms-withdraw-btn action-btn">Confirm Withdraw</ajax-button>
  
                  <!-- <button data-dismiss="modal" data-dismiss="modal" type="button" class="btn btn-primary send-btn transferSend" >Confirm Transfer</button> -->
                  <ajax-button  type="submit" :syncing="syncing" class="btn btn-primary send-btn">Confirm Transfer</ajax-button>
  
  
                </div>
              </div>
            </div>
        </div>
        <!-- end Confirm modal -->
        <!-- Transfer Modal -->
        <div class="modal fade" id="transferModal" tabindex="-1" role="dialog" aria-labelledby="transferModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title send-btn deposit-btn withdraw-btn tether-sms-withdraw-btn action-btn" id="transferModalLabel"> <span class=action></span> <span class="currency"></span>  </h5>
                  <h5 class="modal-title verify-sms-withdraw-btn action-btn" id="transferModalLabel"> Verify <span class="currency"></span> Deposit </h5>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                  </button>
                </div>
                <div class="modal-body">
                  <p class="deposit-btn action-btn">
                    <label class="deposit-address-msg deposit-address-show"> Deposit Address:</label>
                    <label class="deposit-address-msg deposit-address-register"> Please text "UNITS" to the following number to create your deposit address.</label>
                    <label class="deposit-address-msg deposit-via-sms">All deposits must be sent to the sms wallet linked to the phone number <span class=tetherDepositPhoneOrAddress>{{smsNumber}}</span>. Please text the amount you want to deposit from the phone linked to the phone number {{me.phone}} to the following number to complete your deposit.</label>
                    <br><br>
                    <!-- <h6 id="copyDepositAddress" class="deposit-btn depositAddress"></h6> -->
                  </p>
                  <div class="sms-withdraw-btn action-btn">
                    <p class="sms-withdraw-btn action-btn">
                      <label class=""> Please text "UNITS" to the following number to <span class=action></span> your <span class="currency"></span> </label><br><br>
                      <!-- <h6 id="copyDepositAddress" class="">{{smsNumber}}</h6> -->
                    </p>
  
                  </div>
                  <div class="verify-sms-withdraw-btn action-btn">
                    <p class="verify-sms-withdraw-btn action-btn">
                      <label class="">You must send a verifcation deposit from the phone linked to the phone number {{me.phone}} to transfer these funds.  Please text the message below to {{smsNumber}} to verify this account. This verification request expries <js-timestamp :at="expiresAt" format="timeago" short="false"></js-timestamp>. </label><br><br>
                      <!-- <h6 id="copyDepositAddress" class="">{{smsNumber}}</h6> -->
                    </p>
  
                  </div>
                  <h6 id="copyDepositAddress" class="deposit-btn depositAddress sms-withdraw-btn verify-sms-withdraw-btn action-btn"></h6>
  
                  
        
                  
                  <form class="withdraw-btn tether-sms-withdraw-btn action-btn">
                      <div class="col-sm-12 withdraw-btn action-btn">
                        <div class="form-group">
                          <label for="withdrawAddress">Withdraw Address</label>
                          <input class="form-control" id="withdrawAddress" :class="[formErrors.toAddress ? 'is-invalid' : '']" v-model.trim="formData.toAddress" type="text" >
                          <!-- <div class="invalid-feedback" >Please enter your full name.</div> -->
                          <div class="danger" v-if="formErrors.toAddress">Please enter a valid <span class="currency"></span> address.</div>
  
                        </div>
                      </div>
                      <div class="col-sm-12 tether-sms-withdraw-btn action-btn">
                        <div class="form-group">
                          <label for="withdrawAddress">Withdraw Address</label>
                          <select class="form-control toAddress-select" required :class="[formErrors.toAddress ? 'is-invalid' : '']" v-model.trim="formData.toAddress"  name="toAddress" >
                            <option value="Bitmart"> Bitmart </option>
                          </select>
                          <!-- <div class="invalid-feedback" >Please enter your full name.</div> -->
                          <div class="danger" v-if="formErrors.toAddress">Please enter a valid <span class="currency"></span> address.</div>
  
                        </div>
                      </div>
                      <div class="col-sm-12 tether-sms-withdraw-btn action-btn">
                        <div class="form-group">
                          <label for="toMemo">Withdraw Memo</label>
                          <input class="form-control" id="toMemo" :class="[formErrors.toMemo ? 'is-invalid' : '']" v-model.trim="formData.toMemo" type="text" >
                          <!-- <div class="invalid-feedback" >Please enter your full name.</div> -->
                          <div class="danger" v-if="formErrors.toMemo">Please enter a valid <span class="currency"></span> Bitmart memo.</div>
  
                        </div>
                      </div>
                      <div class="col-sm-12">
                        <div class="form-group">
                          <label for="withdrawAmount">Amount</label>
                          <input class="form-control" id="withdrawAmount" name="withdrawAmount" type="number" step="0.01" min="0"  :class="[formErrors.amount ? 'is-invalid' : '']" v-model.trim="formData.amount"  >
                          <!-- <div class="invalid-feedback" >Please enter your full name.</div> -->
                          <div class="danger" v-if="formErrors.amount">Please enter an amount.</div>
                          <div class="danger" v-if="formErrors.tooMuch">Your amount exceeds your available balance.</div>
                        </div>
                      </div>
                      <div class="col-sm-12">
                          <div class="form-group">
                            <label for="withdrawMax">Available Withdraw Amount <span class="withdrawMax withdrawMaxSpan">0</span> <span class="currency"></span></label>
                          </div>
                        </div>
                  </form>
                  <form class="send-btn action-btn">
                    <div class="col-sm-12">
                      <div class="form-group transferType payment" >
                        <label for="toPayment">To</label>
                        <input class="form-control" id="toPayment" type="text"  :class="[formErrors.toPayment ? 'is-invalid' : '']" v-model.trim="formData.toPayment" placeholder="email">
                        <div class="danger" v-if="formErrors.toPayment">Please enter a valid email address or phone number.</div>
                      </div>
                    </div>
                    <div class="col-sm-12">
                      <div class="form-group">
                        <label for="withdrawAmount">Amount</label>
                        <input class="form-control" id="withdrawAmount" name="withdrawAmount" type="number" step="0.01" min="0" :class="[formErrors.amount ? 'is-invalid' : '']" v-model.trim="formData.amount"    >
                        <div class="danger" v-if="formErrors.amount">Please enter an amount.</div>
                        <div class="danger" v-if="formErrors.tooMuch">Your amount exceeds your available balance.</div>
                      </div>
                    </div>
                    <div class="form-group transferType payment" style="display:none"> 
                      <label for="note">Note</label>
                        <textarea v-model.trim="formData.note" class="form-control" id="note" name="note"  v-model.trim="formData.note"  aria-describedby="noteHelp" ></textarea>
                        <div class="danger" v-if="formErrors.note">Please enter a note.</div>
                    </div>
                    <div class="col-sm-12">
                        <div class="form-group withdrawMax">
                          <label for="withdrawMax">Available Send Amount <span class="withdrawMaxSpan">1000</span> <span class="currency"></span></label>
                        </div>
                      </div>
                </form>
  
        
                </div>
                <div class="modal-footer">
                  <input type="hidden" id="accountId">
                  <input type="hidden" id="toPaymentMethod">
                  
                  <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                  
                  <button onClick="copyAddress(event)" type="button" class="btn btn-primary deposit-btn action-btn sms-withdraw-btn  verify-sms-withdraw-btn " href="copyDepositAddress" >Copy</button>
                  <!-- <input type="hidden" id="copyDepositAddress"  class="d-none" /> -->
  
                  <button @click="handleParsingForm"  type="button" class="btn btn-primary withdraw-btn tether-sms-withdraw-btn action-btn transferWithdraw transferModalWithdraw">Confirm Withdraw</button>
                  <button @click="handleParsingForm" type="button" class="btn btn-primary send-btn action-btn transferModalSend">Send</button>
                  
                </div>
              </div>
            </div>
        </div>
        <!-- End Confirm modal -->
      </ajax-form>
  
    </div>

  </div>

    </div>
      
    `,
    // <tr v-for="market in markets" :id="market.id" v-if="market && market.sellCurrencyId && !market.sellCurrencyId.buyCurrency && market.sellCurrencyId.icoOrder && (!market.sellCurrencyIndexToken && !type || market.sellCurrencyIndexToken && type) && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" >
    //
    //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
    //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
    //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
    beforeMount: async function() {
        // Attach any initial data from the server.
        this.currency = this.$route.params.id;

          // _.extend(this, YOH_SHOW_LOCALS);
          _.extend(this, YOH_SHOW_LOCALS);

        await this.listen();  

    },
    mounted: async function() {

    
       
      },



    //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
    //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
    //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
    methods: {

        listen: async function() {
          var Balances = this;
          //show loading// syincing
          this.loadingBalances = true;

          // var csrf = await CSRF.token();
          // var apiRequestHeader = {
          //     'X-CSRF-Token':csrf._csrf,
          //       // 'cookie':cookie
          //   };
          $.ajax({
                type: "POST",
              //   url: this.refreshUrl+"/markets/orders/cancel",
              url: '/api/balances',
              data: {},
                // headers:apiRequestHeader,
                success: function(data, textStatus, request)
                {
                    if(resData.flag){
                        _.extend(Balances, resData);
                        Balances.loadingBalances = false;
                        // Balances.refresh();
                        Balances.calculateTotalUsdValue();
                        setTimeout(() => {
                          
                          $(".deposit").on("click", function(event) {
                              event.preventDefault();
                              var currency = $(event.target).attr("href");
                              console.log("currency",currency);
                              Balances.confirmDeposit(currency);
                          });
                          $(".withdraw").on("click", function(event) {
                              event.preventDefault();
                              var currency = $(event.target).attr("href");
                              console.log("currency",currency);
                              Balances.confirmWithdraw(currency);
                          });
                          $(".send").on("click", function(event) {
                              event.preventDefault();
                              var currency = $(event.target).attr("href");
                              console.log("currency",currency);
                              Balances.confirmSend(currency);
                          });
            
                        }, 1000);
                        
            
                      }else if(resData.mustLogin){
                        window.location.href = resData.redirect;
                      } else{
                        Balances.loadingBalances = false;
                      }
    
                }
              });
    
        //   var csrf = await CSRF.token();
        //     console.log('csrf',csrf);
        //     var apiRequestHeader = {
        //       'X-CSRF-Token':csrf._csrf,
        //         // 'cookie':cookie
        //     };
        //   io.socket.request({
        //       method: 'post',
        //       url: '/api/balances',
        //       data: {},
        //       headers: apiRequestHeader
        //     }, function (resData, jwres) {
    
        //       if(resData.flag){
        //         _.extend(Balances, resData);
        //         Balances.loadingBalances = false;
        //         // Balances.refresh();
        //         Balances.calculateTotalUsdValue();
        //         setTimeout(() => {
                  
        //           $(".deposit").on("click", function(event) {
        //               event.preventDefault();
        //               var currency = $(event.target).attr("href");
        //               console.log("currency",currency);
        //               Balances.confirmDeposit(currency);
        //           });
        //           $(".withdraw").on("click", function(event) {
        //               event.preventDefault();
        //               var currency = $(event.target).attr("href");
        //               console.log("currency",currency);
        //               Balances.confirmWithdraw(currency);
        //           });
        //           $(".send").on("click", function(event) {
        //               event.preventDefault();
        //               var currency = $(event.target).attr("href");
        //               console.log("currency",currency);
        //               Balances.confirmSend(currency);
        //           });
    
        //         }, 1000);
                
    
        //       }else if(resData.mustLogin){
        //         window.location.href = resData.redirect;
        //       } else{
        //         Balances.loadingBalances = false;
        //       }
              
        //       if (jwres.error) {
        //         console.log(jwres.statusCode); // => e.g. 403
        //         this.cloudLoadingError = true;
    
        //         return;
        //       }
            
        //       console.log(jwres.statusCode); // => e.g. 200
            
        //   });
    
        },
    
        calculateTotalUsdValue:  function() {
          var Balances = this;
          var sellCurrencies = Balances.sellCurrencies;
          var paymentMethods = Balances.paymentMethods;
          var reserves = Balances.reserves;
          var appToken = Balances.appToken;
          var smsBalance = Balances.smsBalance;
          var totalUsdValue = 0;
          var smsUsdBalance = appToken.lastPrice ? (appToken.lastPrice * (smsBalance.spendingBalance) ).toFixed(2) : 0;
          totalUsdValue = smsUsdBalance;
          totalUsdValue = parseFloat(totalUsdValue);
    
          for (let i = 0; i < sellCurrencies.length; i++) {
            const balance = sellCurrencies[i];
            var usdValue = balance.currency.lastPrice ? (balance.currency.lastPrice * (balance.spendingBalance + balance.order) ).toFixed(2) : 0;
            usdValue = parseFloat(usdValue);
            totalUsdValue += usdValue;
          }
          for (let i = 0; i < paymentMethods.length; i++) {
            const balance = paymentMethods[i];
            var usdValue = balance.currency.lastPrice ? (balance.currency.lastPrice * (balance.spendingBalance + balance.order) ).toFixed(2) : 0;
            usdValue = parseFloat(usdValue);
            totalUsdValue += usdValue;
          }
          for (let i = 0; i < reserves.length; i++) {
            const balance = reserves[i];
            var usdValue = balance.currency.lastPrice ? (balance.currency.lastPrice * (balance.spendingBalance + balance.order) ).toFixed(2) : 0;
            usdValue = parseFloat(usdValue);
            totalUsdValue += usdValue;
          }
          this.totalUsdValue = totalUsdValue.toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
          
          
        },
        refresh: async function() {
          var page = this;
          $.ajax({
                type: "GET",
                url: this.refreshUrl+"/api/balances",
                data: {}, // serializes the form's elements.
                success: function(data, textStatus, request)
                {
                    console.log('got the data!!!',data); // show response from the php script.
                    var balances = data.balances;
                    page.render(balances);
    
                }
              });
          // window.location = '/';
        },
        confirmSend: async function(currency) {
          var Balances = this;
          var isUnclaimed = currency.startsWith("unclaimed_");
          var isTethered = currency.startsWith("tethered_");
          if(isUnclaimed || isTethered){
            var currencyArray = currency.split("_");
            var currencyLabel = currencyArray[1];
          }else{
            var currencyLabel = currency;
          }
          $(".modal .action").html("send");
          $(".modal .currency").html(currencyLabel);
          $(".modal .withdraw-btn, .modal .deposit-btn,.modal .action-btn").hide();
          var accountId = $("."+currency +" .accountId").val();
          this.formData.fromAccountId = accountId;
          this.formData.currency = currency;
          this.formData.currency = currency;
          this.formData.transferType = "exchange";
    
          if(currency == "UNITS_STELLAR"){
            $(".modal .sms-withdraw-btn").show();
            // Balances.copyAddress(currency);
            var smsNumber = this.smsNumber;
            $(".depositAddress").html(smsNumber);
            $("#copyDepositAddress").val(smsNumber); 
            $("#copyDepositAddress").html(smsNumber); 
    
          }else{
            $(".modal .send-btn").show();
    
            Balances.withdrawMax(currency);
            this.formData.confirm = false;
            $(".transferSend").off("click").on("click", function(event) {
              Balances.send(currency);
            });
          }
          
    
          
        },
        copyAddress: async function() {
          var Balances = this;
          // /* Get the text field */
          // var copyText = document.getElementById("copyDepositAddress");
    
          // /* Select the text field */
          // copyText.select();
          // copyText.setSelectionRange(0, 99999); /* For mobile devices */
    
          // /* Copy the text inside the text field */
          // document.execCommand("copy");
    
          // /* Alert the copied text */
          // alert("Copied the text: " + copyText.value);
    
          var $temp = $("<input>");
          $("body").append($temp);
          $temp.val($(".depositAddress").text()).select();
          document.execCommand("copy");
          $temp.remove();
    
          alert("Copied the text: " + $(".depositAddress").text());
    
        },
        confirmDeposit: async function(currency) {
          var Balances = this;
          var isUnclaimed = currency.startsWith("unclaimed_");
          var isTethered = currency.startsWith("tethered_");
          if(isUnclaimed || isTethered){
            var currencyArray = currency.split("_");
            var currencyLabel = currencyArray[1];
          }else{
            var currencyLabel = currency;
          }
    
          $(".modal .action").html("deposit");
          $(".modal .currency").html(currencyLabel);
          $(".depositAddress").html("");
          $(".modal .withdraw-btn").hide();
          $(".modal .withdraw-btn, .modal .send-btn, .modal .action-btn").hide();
          $(".modal .deposit-btn").show();
          $(".confirmDeposit").off("click").on("click", function(event) {
            console.log("confirm deposit cliked");
            Balances.depositAddress(currency);
          });
          $(".verifyDeposit").off("click").on("click", function(event) {
            console.log("confirm deposit cliked");
            Balances.verifyDeposit(currency);
          });
          
          $(".copyDepositAddress").off("click").on("click", function(event) {
            console.log("confirm deposit cliked");
            Balances.copyAddress(currency);
          });
        },
        confirmWithdraw: async function(currency) {
          var smsNumber = this.smsNumber;
          var Balances = this;
          var isUnclaimed = currency.startsWith("unclaimed_");
          var isTethered = currency.startsWith("tethered_");
          if(isUnclaimed || isTethered){
            var currencyArray = currency.split("_");
            var currencyLabel = currencyArray[1];
          }else{
            var currencyLabel = currency;
          }
    
    
          var accountId = $("."+currency +" .accountId").val();
          var verificationDepositAmount = $("."+currency +" .verificationDepositAmount").val();
          this.formData.fromAccountId = accountId;
          this.formData.currency = currency;
          this.formData.currency = currency;
          this.formData.transferType = "external";
    
          $(".modal .action").html("withdraw");
          $(".modal .currency").html(currencyLabel);
          $(".modal .deposit-btn, .modal .send-btn,.modal .action-btn").hide();
    
          if(isTethered){
            this.formData.network = "stellar";
    
            $(".modal .tether-sms-withdraw-btn").show();
            // Balances.copyAddress(currency);
            var smsNumber = this.smsNumber;
            var verificationMsg = "send $"+verificationDepositAmount + " to "+smsNumber;
            $(".depositAddress").html(verificationMsg);
            $("#copyDepositAddress").val(verificationMsg); 
            $("#copyDepositAddress").html(verificationMsg); 
            Balances.withdrawMax(currency);
            $(".transferWithdraw").off("click").on("click", function(event) {
              Balances.withdraw(currency);
            });
    
    
    
          }else if(isUnclaimed){
            $(".modal .verify-sms-withdraw-btn").show();
            // Balances.copyAddress(currency);
            var smsNumber = this.smsNumber;
            var verificationMsg = "send $"+verificationDepositAmount + " to "+smsNumber;
            $(".depositAddress").html(verificationMsg);
            $("#copyDepositAddress").val(verificationMsg); 
            $("#copyDepositAddress").html(verificationMsg); 
            $(".verifyDeposit").off("click").on("click", function(event) {
              console.log("verify deposit cliked");
              Balances.verifyDeposit(currency);
            });
    
    
    
          }else if(currency == "UNITS_STELLAR"){
            $(".modal .sms-withdraw-btn").show();
            // Balances.copyAddress(currency);
            var smsNumber = this.smsNumber;
            $(".depositAddress").html(smsNumber);
            $("#copyDepositAddress").val(smsNumber); 
            $("#copyDepositAddress").html(smsNumber); 
    
    
    
          }else{
            this.formData.network = "";
    
            $(".modal .withdraw-btn").show();
            Balances.withdrawMax(currency);
            $(".transferWithdraw").off("click").on("click", function(event) {
              Balances.withdraw(currency);
            });
          }
    
    
          
        },
        withdrawMax: async function(currency) {
          var Balances = this;
          var balance = $("."+currency +" .balance").html();
          var locked = $("."+currency +" .locked").html();
          balance =  parseFloat(balance);
          locked =  parseFloat(locked);
          // var withdrawMax = balance - locked;
          var withdrawMax = balance;
          console.log("balance",balance);
          console.log("locked",locked);
          console.log("withdrawMax",withdrawMax);
          $(".withdrawMaxSpan").html(withdrawMax);
          $(".withdrawMax").off("click").on("click", function(event) {
            console.log("withdrawMax",withdrawMax);
            $("#withdrawAmount").val(withdrawMax);
            Balances.formData.amount = withdrawMax;
            console.log("withdrawMax Balances.formData.amount",Balances.formData.amount);
    
          });
        },
        send: async function(currency){
            console.log("send " + currency);
            var Balances = this;
            var withdrawAmount = $("#withdrawAmount").val();
            var toPayment = $("#toPayment").val();
            var accountId = $("#accountId").val();
            var note = $("#note").val();
            var toPaymentMethod = $("#toPaymentMethod").val();
            
            
            // var csrf = await CSRF.token();
            // console.log('csrf',csrf);
            console.log('currency',currency);
            // var apiRequestHeader = {
            //   'X-CSRF-Token':csrf._csrf,
            //     // 'cookie':cookie
            // };
            return io.socket.request({
              method: 'post',
              url: '/balances/send',
              data: {
                fromAccountId:accountId,
                note:note,
                toPayment:toPayment,
                amount:withdrawAmount
              },
              // headers: apiRequestHeader
              }, function (resData, jwres) {
              console.log('resData',resData); // => e.g. 403
              window.location.href = "/balances";
              // $("#transfer .send").html(address.address);
              // if(resData.flag){
              //   // Balances.refresh(resData.market);
              // }
    
    
              if (jwres.error) {
                console.log(jwres.statusCode); // => e.g. 403
                return;
              }
            
              console.log(jwres.statusCode); // => e.g. 200
            
            });
          
        },
        withdraw: async function(currency){
          console.log("withdraw " + currency);
    
          var Balances = this;
          var withdrawAmount = $("#withdrawAmount").val();
          var withdrawAddress = $("#withdrawAddress").val();
    
          // ["transferType","fromAccountId","toInternal","toExternal","toPayment","toDeposit","toPaymentMethod","amount","note","accountNumber","routingNumber","toAddress"]},"c
          // var withdrawAddressResult = await Cloud.transfer.with({currency:tokenId}).tolerate(()=>{
          //   this.cloudError = true;
          // });
          this.syncingUpdateAddress = false;
          // console.log("withdrawAddress withdrawAddressResult", withdrawAddressResult);
          
          // var csrf = await CSRF.token();
          // console.log('csrf',csrf);
          // console.log('currency',currency);
          // var apiRequestHeader = {
          //   'X-CSRF-Token':csrf._csrf,
          //     // 'cookie':cookie
          // };
        //  return io.socket.request({
        //   method: 'post',
        //   url: '/balances/withdraw',
        //   data: {currency:currency,address:withdrawAddress,amount:withdrawAmount},
        //   headers: apiRequestHeader
        //   }, function (resData, jwres) {
        //   console.log('resData',resData); // => e.g. 403
        //   window.location.href = "/balances";
        //   // $("#transfer .withdraw").html(address.address);
        //   // if(resData.flag){
        //   //   // Balances.refresh(resData.market);
        //   // }
    
    
        //   if (jwres.error) {
        //     console.log(jwres.statusCode); // => e.g. 403
        //     return;
        //   }
        
        //   console.log(jwres.statusCode); // => e.g. 200
        
        // });
        
      },
        depositAddress: async function(currency){
          this.syncingUpdateAddress = true;
          this.syncing = true;
          var smsNumber = this.smsNumber;
          var isUnclaimed = currency.startsWith("unclaimed_");
          var isTethered = currency.startsWith("tethered_");
          if(isUnclaimed || isTethered){
            var currencyArray = currency.split("_");
            var currencyLabel = currencyArray[1];
          }else{
            var currencyLabel = currency;
          }
    
          $(".deposit-address-msg").hide();
    
          if(isUnclaimed || isTethered){
            // show sms transfer deposit message
            var address = smsNumber;
            $(".deposit-via-sms").show();
    
          }else if(currency == "UNITS_STELLAR"){
            var address = $("."+currency + " .address").val();
            if(address){
              $(".deposit-address-show").show();
    
            }else{
              var address = smsNumber;
              $(".deposit-address-register").show();
            }
    
          }else{
            $(".deposit-address-show").show();
    
            console.log("depositAddress " + currency);
            var tokenId = $("."+currency + " .tokenId").val();
            console.log("depositAddress " + currency, tokenId);
    
    
            var Balances = this;
    
            var depositAddressResult = await Cloud.depositAddress.with({currency:tokenId}).tolerate(()=>{
              this.cloudError = true;
            });
            console.log("depositAddress depositAddressResult", depositAddressResult);
    
            var address = depositAddressResult.address;
    
          }
          
          console.log('balance',address); // => e.g. 403
          $(".depositAddress").html(address);
          //show modal / click deposit modal 
          $(".deposit-modal-btn").click();
          this.syncingUpdateAddress = false;
          this.syncing = false;
    
          $("#copyDepositAddress").val(address); 
          $("#copyDepositAddress").html(address); 
    
    
          
        //   var csrf = await CSRF.token();
        //   console.log('csrf',csrf);
        //   console.log('currency',currency);
        //   var apiRequestHeader = {
        //     'X-CSRF-Token':csrf._csrf,
        //       // 'cookie':cookie
        //   };
        //  return io.socket.request({
        //   method: 'post',
        //   url: '/balances/address',
        //   data: {currency:tokenId},
        //   headers: apiRequestHeader
        // }, function (resData, jwres) {
        //   var address = resData.address;
        //   console.log('balance',address); // => e.g. 403
        //   $(".depositAddress").html(address);
        //   // if(resData.flag){
        //   //   // Balances.refresh(resData.market);
        //   // }
    
    
        //   if (jwres.error) {
        //     console.log(jwres.statusCode); // => e.g. 403
        //     return;
        //   }
        
        //   console.log(jwres.statusCode); // => e.g. 200
        
        // });
        
      },
      verifyDeposit: async function(currency){
          this.syncingUpdateAddress = true;
          this.syncing = true;
          var smsNumber = this.smsNumber;
          var isUnclaimed = currency.startsWith("unclaimed_");
          var isTethered = currency.startsWith("tethered_");
          if(isUnclaimed || isTethered){
            var currencyArray = currency.split("_");
            var currencyLabel = currencyArray[1];
          }else{
            var currencyLabel = currency;
          }
    
          $(".deposit-address-msg").hide();
    
          
          $(".deposit-address-show").show();
    
          console.log("verifyDeposit " + currency);
          var balanceId = $("."+currency + " .balanceId").val();
          console.log("verifyDeposit " + currency, balanceId);
    
    
          var Balances = this;
    
          var verifyDepositResult = await Cloud.createVerificationRequest.with({balanceId:balanceId}).tolerate(()=>{
            this.cloudError = true;
          });
          console.log("verifyDeposit verifyDepositResult", verifyDepositResult);
    
          var success = verifyDepositResult.success;
          var verificationDepositAmount = verifyDepositResult.verificationDepositAmount;
          var expiresAt = verifyDepositResult.expiresAt;
          Balances.expiresAt =  expiresAt;
          if(success){
            $(".verificationDepositAmount").html(verificationDepositAmount);
            $(".expiresAt").html(expiresAt);
    
    
          }else{
    
          }
    
    
    
          
          //show modal / click deposit modal 
          $(".deposit-modal-btn").click();
          this.syncingUpdateAddress = false;
          this.syncing = false;
    
          var smsNumber = this.smsNumber;
          var verificationMsg = "send $"+verificationDepositAmount + " to "+smsNumber;
          $(".depositAddress").html(verificationMsg);
          $("#copyDepositAddress").val(verificationMsg); 
          $("#copyDepositAddress").html(verificationMsg); 
        
      },
        render: async function(balances) {
          $.each( balances, function( id, market ) {
            console.log( id + ": " + market );
            console.log( $("#"+id).length );
            var ticker = market.ticker;
            /*
              avg_price: "0.0"
              buy: "0.0"
              high: "0.0"
              last: "0.0"
              low: "0.0"
              open: "0.0"
              price_change_percent: "+0.00%"
              sell: "0.0"
              vol: "0.0"
              volume: "0.0"
            */
          //  $(".tickers").append(
          //     $("<div id='"+id+"'>")
          //       .append("<h3 class='avg_price'>"+ticker.avg_price+"</h3>")
          //   );
    
            // var tr = $("<tr id='"+id+"'>");
            // $("<td class='avg_price'>"+ticker.avg_price+"</td>")
            // console.log("tr",tr.html());
            // $(".tickers").append(tr);
            // console.log( $(".tickers").length, "tickets length" );
    
          });
        },
        // listen: async function() {
          
        //   // window.location = '/';
        // },
        //transer/send 
        changeTransferType: async function(e) {
          var type = $("#transferType").val();
          // var isFreeze = $(e.target).hasClass("freeze");
          // var isClose = $(e.target).hasClass("close");
          // var isView = $(e.target).hasClass("view");
          // var isOpen = $(e.target).hasClass("open");
          $(".nav-transfers .transferType").hide();
          $(".nav-transfers ."+type).show();
        },
        submittedForm: async function(data) {
          console.log("submittedForm");
          if(data.flag){
            this.syncing = true;
            this.formErrors.transferSuccess = true;
            window.location = '/balances';
          }else{
            this.formErrors.cloudError = true;
            
          }
        },
        
        handleParsingForm: function() {
          // Clear out any pre-existing error messages.
          console.log("handleParsingForm");
          this.formErrors = {};
    
          var argins = this.formData;
          var currency = argins.currency;
          var transferType = argins.transferType;
          var isUnclaimed = currency.startsWith("unclaimed_");
          var isTethered = currency.startsWith("tethered_");
    
    
          var balance = $("."+currency +" .balance").html();
          balance = parseFloat(balance);
          console.log("balance",balance);
          
          if(!argins.amount || argins.amount == 0 ) {
            this.formErrors.amount = true;
          }
          
          if(!argins.toAddress && argins.transferType == "external") {
            this.formErrors.toAddress = true;
          }
          if(!argins.toMemo && argins.network == "stellar") {
            this.formErrors.toMemo = true;
          }
          if(argins.amount > balance){
            this.formErrors.tooMuch = true;
    
            console.log("balance too much ",argins.amount,balance);
          }
          console.log("argins.toPayment",argins.toPayment);
    
          if(argins.transferType == "exchange") {
            if(!argins.toPayment ) {
              this.formErrors.toPayment = true;
            }
            var validToPayment = this.validPhoneOrEmail(argins.toPayment);
            console.log("validToPayment",validToPayment);
            if(!validToPayment && argins.transferType == "exchange"){
              this.formErrors.toPayment = true;
            }
          }
          if(isTethered){
            var tetherFactor = $("."+currency + " .tetherFactor").val();
            argins.tetherFactor = tetherFactor;
            
          }
          
    
          // If there were any issues, they've already now been communicated to the user,
          // so simply return undefined.  (This signifies that the submission should be
          // cancelled.)
          if (Object.keys(this.formErrors).length > 0) {
            return;
          }else{
            if(!argins.confirm){
              $('#confirmModal').modal("show");
              $('#transferModal').modal("hide");
              this.formData.confirm = true;
    
            }
          }
    
          return argins;
        },
        validPhoneOrEmail: function(phoneOrEmail){
          var validEmail = false;
          var validPhone = false;
          //validate email
          phoneOrEmail =  phoneOrEmail.toLowerCase();
          var emailReg = /^\b[A-Z0-9._%-]+@[A-Z0-9.-]+\.[A-Z]{2,4}\b$/i;
          if(!emailReg.test(phoneOrEmail) || phoneOrEmail == '')
          {
            console.log('Please enter a valid email address.');
            validEmail = false;
          }else{
            validEmail = true;
            this.formData.toPaymentMethod = "email";
            console.log('valid email address.');
    
          }
    
          //validate phone
          var intRegex = /[0-9 -()+]+$/;
          if((phoneOrEmail.length < 6) || (!intRegex.test(phoneOrEmail)))
          {
            console.log('Please enter a valid phone number.');
            validPhone = false;
          }else{
            validPhone = true;
            this.formData.toPaymentMethod = "phone";
            console.log('valid phone.');
          }
    
          if(!validPhone && !validEmail){
            this.formData.toPaymentMethod = undefined;
            return false;
          }else{
            // this.formData.fromAccountId = this.formData.fromSpendAccountId;
            return true;
          }
          
        },
      }



  });

});

