/**
 * <account-table>
 * -----------------------------------------------------------------------------
 * account table.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */

 jQuery(document).ready(function( $ ) {

	Vue.component('accountTable', {

    //  ╔═╗╦═╗╔═╗╔═╗╔═╗
    //  ╠═╝╠╦╝║ ║╠═╝╚═╗
    //  ╩  ╩╚═╚═╝╩  ╚═╝
    props: [
      'accounts',// « The JS timestamp to format
      'label',// « Whether to shorten the formatted date by not including the time of day (may only be used with timeago, and even then only applicable in certain situations)
      'format',// « one of: 'calendar', 'timeago' (defaults to 'timeago'.  Otherwise, the "calendar" format displays data as US-style calendar dates with a four-character year, separated by dashes.  In other words: "MM-DD-YYYY")
    ],

    //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
    //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
    //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
    data: function (){
      return {
        formatType: undefined,
        formattedTimestamp: '',
        interval: undefined
      };
    },

    //  ╦ ╦╔╦╗╔╦╗╦
    //  ╠═╣ ║ ║║║║
    //  ╩ ╩ ╩ ╩ ╩╩═╝
    template: `
    <div class="row mb-3 accounts">
      <div class="col-md-12">
          <table class="table" align="center">
              <thead>
              <tr>
                  <th>Total Amount</th>
                  <th>Token Fee</th>
                  <th>Fiat Fee</th>
                  <th>Net Amount</th>
                  <th>Date</th>
                  <th></th>
              </tr>
              </thead>
              <tbody>
                  <tr v-for="account in accounts">
                  <td>
                      <span class="totalAmount">{{ account.totalAmount }} {{ account.paymentMethod.symbol }}</span>
                  </td>
                  <td>
                      <span class="tokenFee">{{ account.tokenFee }} {{ account.paymentMethod.symbol }}</span>
                  </td>
                  <td>
                      <span class="serviceFee">{{ account.serviceFee }} USD</span>
                  </td>
                  <td>
                      <span class="netAmount">{{ account.netAmount }} {{ account.paymentMethod.symbol }}</span>
                  </td>
                  <td>
                      <js-timestamp class="createdAt" :at="account.createdAt" format="calendar"></js-timestamp><br/>

                  </td>
                  <td>
                      <a class="btn btn-sm  details" href="#" @click="clickaccountDetails($event)" data-toggle="modal" data-target="#detailsModal">Details</a>
                      <input type="hidden" class="account_id" :value="account.id">
                      <input type="hidden" class="type" :value="label">
                      <input type="hidden" class="note" :value="account.note">
                      
                      <div v-if="account.accountId">
                        <div v-if="account.accountId.receipt">
                          <input type="hidden" class="accountHash" :value="account.accountId.receipt.accountHash">
                          <input type="hidden" class="blockHash" :value="account.accountId.receipt.blockHash">
                          <input type="hidden" class="blockNumber" :value="account.accountId.receipt.blockNumber">
                        </div>
                        <div v-else>
                          <input type="hidden" class="accountHash" :value="account.accountId.status">
                          <input type="hidden" class="blockHash" :value="account.accountId.status">
                          <input type="hidden" class="blockNumber" :value="account.accountId.status">
                        </div>
                      </div>
                      <div v-else>
                        <input type="hidden" class="accountHash" value="enqued">
                        <input type="hidden" class="blockHash" value="enqued">
                        <input type="hidden" class="blockNumber" value="enqued">
                      </div>
                      
                  </td>
                  </tr>

              </tbody>
          </table>
      </div>
    </div>
      
    `,

    //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
    //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
    //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
    beforeMount: function() {
        console.log("this.at",this.totals);

    },



    //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
    //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
    //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
    methods: {
      clickaccountDetails: async function(event) {
          this.modal = 'example';
          var tokenFee = $(event.target).parents('tr').find('.tokenFee').html();
          var serviceFee = $(event.target).parents('tr').find('.serviceFee').html();
          var totalAmount = $(event.target).parents('tr').find('.totalAmount').html();
          var createdAt = $(event.target).parents('tr').find('.createdAt').html();
          var netAmount = $(event.target).parents('tr').find('.netAmount').html();
          var accountHash = $(event.target).parents('tr').find('.accountHash').val();
          var blockHash = $(event.target).parents('tr').find('.blockHash').val();
          var blockNumber = $(event.target).parents('tr').find('.blockNumber').val();
          var note = $(event.target).parents('tr').find('.note').val();
          var type = $(event.target).parents('tr').find('.type').val();

          /*
            accountHash:
            '0xb2b8e820258d375c0085aba53583a4566c28e6e7fcc49e67c45238e20501a68e',
          accountIndex: 0,
          blockHash:
            '0xb2e0fafb8e022773e0cc0d257e2dd0f652c3b008b054c57826ca0646fcc88b40',
          blockNumber: 479,
          */
    
          $('.detailsModal .netAmount').html(netAmount);
          $('.detailsModal .tokenFee').html(tokenFee);
          $('.detailsModal .serviceFee').html(serviceFee);
          $('.detailsModal .totalAmount').html(totalAmount);
          $('.detailsModal .createdAt').html(createdAt);
          $('.detailsModal .accountHash').html(accountHash);
          $('.detailsModal .blockHash').html(blockHash);
          $('.detailsModal .blockNumber').html(blockNumber);
          $('.detailsModal .note').html(note);
          $('.detailsModal .type').html(type);
          $('.detailsModal .submit').html("Pay Invoice");
          
        },

    }

  });

});

