/**
 * <attribute-table>
 * -----------------------------------------------------------------------------
 * Transaction table.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */
 jQuery(document).ready(function( $ ) {

   Vue.component('attributeTable', {

  //  ╔═╗╦═╗╔═╗╔═╗╔═╗
  //  ╠═╝╠╦╝║ ║╠═╝╚═╗
  //  ╩  ╩╚═╚═╝╩  ╚═╝
  props: [
    'attributes',// « The JS timestamp to format
    'label',// « The JS timestamp to format
    'id',// « The JS timestamp to format
    'type',// « The JS timestamp to format
  ],

  //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
  //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
  //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
  data: function (){
    return {

    };
  },

  //  ╦ ╦╔╦╗╔╦╗╦
  //  ╠═╣ ║ ║║║║
  //  ╩ ╩ ╩ ╩ ╩╩═╝
  template: `
  
  <div :id="id+'-attributes'" class="attributes-box">
    <div class="attributes">
        <div :class="'attribute ' + label ">
          <div class="row edit value">
              <div class="form-group col-md-4 col-sm-12">
                <label for="key">Attribute</label>
                <input name="attributes[0][key]" type="text" class="form-control key" id="key" aria-describedby="keyHelp" placeholder="Enter key">
                <small id="keyHelp" class="form-text text-muted"></small>
              </div>
              <div class="form-group col-md-4 col-sm-12">
                <label for="meta">Value</label>
                <input name="attributes[0][meta]" type="text" class="form-control meta" id="meta" aria-describedby="toHelp" placeholder="Enter to">
                <small id="toHelp" class="form-text text-muted"></small>
              </div>
              <div class="form-group col-md-4 col-sm-12" style="margin-right:-24px">
                  <label for="meta">Type</label>
                  <select name="attributes[0][metaType]" class="form-control metaType" id="metaType">
                    <option value="text">Text</option>
                    <option value="link">Link</option>
                  </select>
                  <small id="toHelp" class="form-text text-muted">Is this attribute text or a link?</small>
                </div>
              <input name="attributes[0][new]"  type="hidden"   value="true" >
          </div>
        </div>
          


    </div>
    <div class="row  ">
        <div class="col-12">
            <button type="button"  class="btn btn-primary add-attribute">Add Attribute</button>
        </div>
    </div>
  </div>
    
  `,

  //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
  //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
  //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
  beforeMount: function() {

  },
  mounted: async function() {
    // document.addEventListener('DOMContentLoaded', function() {
      this.attributeCnt = 0;
      this.attributeIds = [];
      this.setAttribute();
      console.log("this.attributes",this.attributes);
      this.loadAttributes();
      this.bindUIActions();

      

    // });
    //1-213-373-4253
    

    
  },

  //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
  //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
  //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
  methods: {
    bindUIActions: function() {
      var Attributes = this;
      Attributes.addAttribute();
      Attributes.approve();
      Attributes.pickup();
    },
    approve: async function(){
        var Attribute = this;
        var id = this.id;

        $( "#"+id+"-attributes .approve").off("click").on("click", function(event) {
          event.preventDefault();
          console.log($(event.target).parents(".attribute").length);
          console.log($(event.target).parents(".attribute").find(".attributeId").length);
          var attributeId = $(event.target).parents(".attribute").find(".attributeId").val();
          console.log("approve attributeId",attributeId);
          Attribute.approveAttribute(attributeId);
          $(event.target).parents(".attribute").remove();

        });


    },
    approveAttribute: async function(attributeId){
      var Attribute = this;
      var id = this.id;
      this.sync = true;


      // var csrf = await CSRF.token();
      // console.log('csrf',csrf);
      console.log('attributeId',attributeId);
      // var apiRequestHeader = {
      //   'X-CSRF-Token':csrf._csrf,
      //     // 'cookie':cookie
      // };
      return io.socket.request({
        method: 'post',
        url: '/schedule/attribute/approve',
        data: {attributeId:attributeId},
        // headers: apiRequestHeader
      }, function (resData, jwres) {
        console.log(resData); // => e.g. 403

        if (jwres.error) {
          console.log(jwres.statusCode); // => e.g. 403
          return;
        }
      
        console.log(jwres.statusCode); // => e.g. 200
      
      });

  },
  pickup: async function(){
    var Attribute = this;
    var id = this.id;

    $( "#"+id+"-attributes .pickup").off("click").on("click", function(event) {
      event.preventDefault();
      console.log($(event.target).parents(".attribute").length);
      console.log($(event.target).parents(".attribute").find(".attributeId").length);
      var attributeId = $(event.target).parents(".attribute").find(".attributeId").val();
      console.log("pickup attributeId",attributeId);
      Attribute.pickupAttribute(attributeId);
      $(event.target).parents(".attribute").remove();


    });


},
pickupAttribute: async function(attributeId){
  var Attribute = this;
  var id = this.id;
  this.sync = true;


  // var csrf = await CSRF.token();
  // console.log('csrf',csrf);
  console.log('attributeId',attributeId);
  // var apiRequestHeader = {
  //   'X-CSRF-Token':csrf._csrf,
  //     // 'cookie':cookie
  // };
  return io.socket.request({
    method: 'post',
    url: '/schedule/attribute/pickup',
    data: {attributeId:attributeId},
    // headers: apiRequestHeader
  }, function (resData, jwres) {
    console.log(resData); // => e.g. 403

    if (jwres.error) {
      console.log(jwres.statusCode); // => e.g. 403
      return;
    }
  
    console.log(jwres.statusCode); // => e.g. 200
  
  });

},
    loadAttributes: function() {
      var attributes = this.attributes;
      var Attributes = this;
      var id = this.id;
      var type = this.type;
      console.log("#"+id+"-attributes .attributes should be empty",$( "#"+id+"-attributes .attributes" ).length );

      if(attributes && attributes.length > 0){
        $( "#"+id+"-attributes .attributes" ).html("");

        for (let i = 0; i < attributes.length; i++) {
          const attribute = attributes[i];
          //get clone
          Attributes.renderAttribute(attribute);
        }
        this.attributeIds.sort().reverse();
        this.attributeCnt = this.attributeIds[0];
        this.activateDelete();

      }else{
        console.log("loadattributes type",type);
        if(type !== "edit"){
          $( "#"+id+"-attributes .attributes" ).html("");
        }
      }
      console.log("attributes comp type",type);
      if(type !== "edit"){
        $( "#"+id+"-attributes .add-attribute" ).hide();
        console.log("attributes comp should hide",$( "#"+id+"-attributes .add-attribute" ).length);

      }
      Attributes.updateListener();
      


      console.log("id",id);
      var attribute = $( "#"+id+"-attributes .attribute" ).clone();
      this.attribute = attribute;
      console.log("this.attribute",this.attribute);
    },
    updateListener: function() {
      var id = this.id;
      console.log("listen for update");
      console.log("id length",$( "#"+id ).length);
      console.log("id length key",$( "#"+id+"-attributes .attributes .key" ).length);
      console.log("id length meta",$( "#"+id+"-attributes .attributes .meta" ).length);
      console.log("id length",$( "#"+id+"-attributes .attributes .key, #"+id+"-attributes .attributes .meta" ).length);
      $( "#"+id+"-attributes .attributes .key, #"+id+"-attributes .attributes .meta" ).on('change', function(e) {
        console.log("change on",e.target);
        var attribute = $(e.target).parents(".attribute").find( ".updated" ).val(true);
      });
    },
    setAttribute: function() {
      var id = this.id;
      console.log("id",id);
      var attribute = $( "#"+id+"-attributes .attribute" ).clone();
      this.attribute = attribute;
      console.log("this.attribute",this.attribute);
    },
    addAttribute: function() {
      var Attributes = this;
      var id = this.id;
      console.log("added addAttribute click");

      $( "#"+id+"-attributes .add-attribute").off("click").on("click", function(event) {
        event.preventDefault();
        var attribute = Attributes.renderNewAttribute();
      });
    },
    activateDelete: function() {
      var Attributes = this;
      var id = this.id;

      $( "#"+id+"-attributes .delete").off("click").on("click", function(event) {
        event.preventDefault();
        console.log("children delete length",$(event.target).parents(".attribute").find(".delete").length);
        $(event.target).parents(".attribute").find(".delete").val("true");
        $(event.target).parents(".attribute").remove();
      });
    },
    cloneAttribute: function() {
      var Attributes = this;
      var attribute = Attributes.attribute;
      Attributes.attribute = attribute.clone();
      return attribute;
    },
    renderView: function() {
      // var Attributes = this;
      // var type = this.type;
      // if
      
      // return attribute;
    },
    renderAttribute: function(attribute) {
      var Attributes = this;
      var id = this.id;
      var type = this.type;
      var label = this.label;

      if(attribute.status == "dropped" || attribute.status == "open"){
        var name = "Open Attribute";
      }else{
        var name = attribute.fullName;
      }
      var textTypeSelected =  attribute.metaType == "text" ?  'selected="selected"' : ''; 
      var linkTypeSelected =  attribute.metaType == "link" ?  'selected="selected"' : ''; 
      var attributeObj = `
            <div class="attribute mt-3 `+type+` `+attribute.status+` `+label+`" >
              <div class="row edit value">
                  <div class="form-group col-md-4 col-sm-12">
                    <label for="key">Attribute</label>
                    <input name="attributes[`+attribute.id+`][key]" type="text" value="`+attribute.key+`" class="form-control key" id="key" aria-describedby="keyHelp" placeholder="Enter key">
                    <small id="keyHelp" class="form-text text-muted"></small>
                  </div>
                  <div class="form-group col-md-4 col-sm-12" style="margin-right:-24px">
                    <label for="meta">Value</label>
                    <input name="attributes[`+attribute.id+`][meta]" type="text"   value="`+attribute.meta+`" class="form-control meta" id="meta" aria-describedby="toHelp" placeholder="Enter to">
                    <small id="toHelp" class="form-text text-muted"></small>
                  </div>
                  <div class="form-group col-md-4 col-sm-12" style="margin-right:-24px">
                    <label for="meta">Type</label>
                    <select name="attributes[`+attribute.id+`][metaType]" class="form-control metaType" id="metaType">
                      <option value="text" `+textTypeSelected+` >Text</option>
                      <option value="link" `+linkTypeSelected+`>Link</option>
                    </select>
                    <small id="toHelp" class="form-text text-muted">Is this attribute text or a link?</small>
                  </div>
                  
                  
                  <div class="form-group fl-r pl-2 pt-4" style="position: relative;right: -2%;top: 11px;">
                    <label> </label>
                    <label class="delete">X</label>
                  </div>
                  <input name="attributes[`+attribute.id+`][updated]" type="hidden"  class="updated" value="false" >
                  <input name="attributes[`+attribute.id+`][delete]" type="hidden"  class="delete" value="false" >
                  <input name="attributes[`+attribute.id+`][id]"  type="hidden"   value="`+attribute.id+`" >

              </div>

               
            </div>             
        
      `;
      $( "#"+id+"-attributes .attributes" ).append( attributeObj );
      attribute.id = parseInt(attribute.id);
      this.attributeIds.push(attribute.id);


    },
    renderNewAttribute: function() {
      this.attributeCnt++; 
      var id = this.id;
      var attributeCnt = this.attributeCnt;
      var label = this.label;

      var attributeObj = `
            <div class="attribute `+label+`" >
              <div class="row edit value">
                  <div class="form-group col-md-4 col-sm-12">
                    <label for="key">Attribute</label>
                    <input name="attributes[`+attributeCnt+`][key]" type="text"  class="form-control key" id="key" aria-describedby="keyHelp" placeholder="Enter key">
                    <small id="keyHelp" class="form-text text-muted"></small>
                  </div>
                  <div class="form-group col-md-4 col-sm-12" style="margin-right:-24px">
                    <label for="meta">Value</label>
                    <input name="attributes[`+attributeCnt+`][meta]" type="text"    class="form-control meta" id="meta" aria-describedby="toHelp" placeholder="Enter to">
                    <small id="toHelp" class="form-text text-muted"></small>
                  </div>
                  <div class="form-group col-md-4 col-sm-12" style="margin-right:-24px">
                    <label for="meta">Type</label>
                    <select name="attributes[`+attributeCnt+`][metaType]" class="form-control metaType" id="metaType">
                      <option value="text">Text</option>
                      <option value="link">Link</option>
                    </select>
                    <small id="toHelp" class="form-text text-muted">Is this attribute text or a link?</small>
                  </div>
                  <div class="form-group fl-r pl-2 pt-4" style="position: relative;right: -2%;top: 11px;">
                    <label> </label>
                    <label class="delete">X</label>
                  </div>
                  <input name="attributes[`+attributeCnt+`][new]" type="hidden"  class="new" value="true" >
              </div>
              
            </div>              
        
      `;
      console.log("attributes length",$( "#"+id+"-attributes .attributes" ).length );
      $( "#"+id+"-attributes .attributes" ).append( attributeObj );
      console.log("add attributes component ",attributeObj);
      this.activateDelete();


    },
  }

});

});

