/**
 * <info>
 * -----------------------------------------------------------------------------
 * info.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */
 jQuery(document).ready(function( $ ) {


	Vue.component('info', {
  

    //  ╔═╗╦═╗╔═╗╔═╗╔═╗
    //  ╠═╝╠╦╝║ ║╠═╝╚═╗
    //  ╩  ╩╚═╚═╝╩  ╚═╝
    props: [
      // 'markets',// « The JS timestamp to format
      // 'buyCurrency',
      // 'type',
    ],

    //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
    //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
    //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
    data: function (){
      return {
            loadingComponent:true,
            
        
            // Main syncing/loading state for this page.
            syncing: false,

            // Form data
            formData: { /* … */ },

            // For tracking client-side validation errors in our form.
            // > Has property set to `true` for each invalid property in `formData`.
            formErrors: { /* … */ },

            // Server error state for the form
            cloudError: '',
            
      };
    },

    /*
                    (type && market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
                  || (type && market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
    */

    //  ╦ ╦╔╦╗╔╦╗╦
    //  ╠═╣ ║ ║║║║
    //  ╩ ╩ ╩ ╩ ╩╩═╝

    template: `
    <div class="info-component">
        <div v-if="loadingComponent" class="text-center">

            <h1>Your account is being loaded...</h1>
            <ajax-button type="submit" :syncing="loadingComponent" class="btn btn-primary mint">Refesh</ajax-button>


        </div>
        <div v-else="" id="edit-profile" v-cloak>
            <div class="container">
              <h1>Update personal info</h1>
              <hr/>
              <ajax-form action="updateProfile" :syncing.sync="syncing" :cloud-error.sync="cloudError" @submitted="submittedForm()" :handle-parsing="handleParsingForm">
                <div class="row">
                  <div class="col-md-6">
                      <div class="form-group required-field">
                          <label class="control-label" for="username">Your Username</label>
                          <input class="form-control" :class="[formErrors.username ? 'is-invalid' : '']" required id="username" name="username" type="text" v-model.trim="formData.username"  aria-describedby="usernameHelp"   >
                          <div class="invalid-feedback" v-if="formErrors.usernameTaken">This username is already taken, please enter another username.</div>
                          <div class="invalid-feedback" v-else-if="formErrors.username">Please enter your username.</div>
                          <small id="usernameHelp" class="form-text text-muted">This is an abbreviation for your coin name. </small>
                      </div>
                  </div>
                  <div class="col-sm-6">
                      <div v-if="!formData.avatar" class="form-group">
                          <label class="control-label" for="images">Profile Photo</label><br>
                          <input type="hidden" v-model.trim="formData.avatar"  class="src">
                          <img v-bind:class="{ 'd-none': noAvatarImage }" v-bind:src="formData.avatar" height="200" alt="Image preview...">
                          <div class="invalid-feedback" v-if="formErrors.avatar">Please upload profile image.</div>
                          <input id="avatar" name="avatar" type="file"  @change="previewFile($event)"><br>
                      </div> 
                      <div v-else="" class="form-group">
                          <label class="control-label" for="images">Profile Photo</label><br>
                          <img v-bind:src="formData.avatar" height="200" alt="Image preview...">
                          <input type="hidden" v-model.trim="formData.avatar"  class="src">
                          <input id="avatar" name="avatar" type="file"  @change="previewFile($event)"><br>

                      </div> 
                  </div>
                </div>
                <div class="row">
                  <div class="col-sm-6">
                    <div class="form-group">
                      <label for="first-name">First name</label>
                      <input class="form-control" id="first-name" name="first-name" type="text"  :class="[formErrors.firstName ? 'is-invalid' : '']" v-model.trim="formData.firstName" placeholder="Sturgis" autocomplete="name" focus-first>
                      <div class="invalid-feedback" v-if="formErrors.firstName">Please enter your first name.</div>
                    </div>
                  </div>
                  <div class="col-sm-6">
                    <div class="form-group">
                      <label for="last-name">Last name</label>
                      <input class="form-control" id="last-name" name="last-name" type="text"  :class="[formErrors.lastName ? 'is-invalid' : '']" v-model.trim="formData.lastName" placeholder="Sturgeon" autocomplete="name" focus-last>
                      <div class="invalid-feedback" v-if="formErrors.lastName">Please enter your last name.</div>
                    </div>
                  </div>
                  <div class="col-sm-6">
                    <div class="form-group">
                      <label for="email-address">Email address</label>
                      <input class="form-control" id="email-address" name="email-address" type="email"  :class="[formErrors.emailAddress ? 'is-invalid' : '']" v-model.trim="formData.emailAddress" placeholder="sturgeon@example.com" autocomplete="email">
                      <div class="invalid-feedback" v-if="formErrors.emailAddress">Please enter a valid email address.</div>
                    </div>
                  </div>
                </div>
                <div class="row">
                  <div class="col-sm-6">
                    <div class="form-group">
                      <label for="phoneCountryCode">Mobile Number Country Code</label>
                      <select class="form-control" id="phoneCountryCode" :class="[formErrors.phoneCountryCode ? 'is-invalid' : '']" v-model.trim="formData.phoneCountryCode" autocomplete="phoneCountryCode" >
                        <option data-countryCode="GB" value="44" Selected>UK (+44)</option>
                        <option data-countryCode="US" value="1">USA (+1)</option>
                        <optgroup label="Other countries">
                          <option data-countryCode="DZ" value="213">Algeria (+213)</option>
                          <option data-countryCode="AD" value="376">Andorra (+376)</option>
                          <option data-countryCode="AO" value="244">Angola (+244)</option>
                          <option data-countryCode="AI" value="1264">Anguilla (+1264)</option>
                          <option data-countryCode="AG" value="1268">Antigua &amp; Barbuda (+1268)</option>
                          <option data-countryCode="AR" value="54">Argentina (+54)</option>
                          <option data-countryCode="AM" value="374">Armenia (+374)</option>
                          <option data-countryCode="AW" value="297">Aruba (+297)</option>
                          <option data-countryCode="AU" value="61">Australia (+61)</option>
                          <option data-countryCode="AT" value="43">Austria (+43)</option>
                          <option data-countryCode="AZ" value="994">Azerbaijan (+994)</option>
                          <option data-countryCode="BS" value="1242">Bahamas (+1242)</option>
                          <option data-countryCode="BH" value="973">Bahrain (+973)</option>
                          <option data-countryCode="BD" value="880">Bangladesh (+880)</option>
                          <option data-countryCode="BB" value="1246">Barbados (+1246)</option>
                          <option data-countryCode="BY" value="375">Belarus (+375)</option>
                          <option data-countryCode="BE" value="32">Belgium (+32)</option>
                          <option data-countryCode="BZ" value="501">Belize (+501)</option>
                          <option data-countryCode="BJ" value="229">Benin (+229)</option>
                          <option data-countryCode="BM" value="1441">Bermuda (+1441)</option>
                          <option data-countryCode="BT" value="975">Bhutan (+975)</option>
                          <option data-countryCode="BO" value="591">Bolivia (+591)</option>
                          <option data-countryCode="BA" value="387">Bosnia Herzegovina (+387)</option>
                          <option data-countryCode="BW" value="267">Botswana (+267)</option>
                          <option data-countryCode="BR" value="55">Brazil (+55)</option>
                          <option data-countryCode="BN" value="673">Brunei (+673)</option>
                          <option data-countryCode="BG" value="359">Bulgaria (+359)</option>
                          <option data-countryCode="BF" value="226">Burkina Faso (+226)</option>
                          <option data-countryCode="BI" value="257">Burundi (+257)</option>
                          <option data-countryCode="KH" value="855">Cambodia (+855)</option>
                          <option data-countryCode="CM" value="237">Cameroon (+237)</option>
                          <option data-countryCode="CA" value="1">Canada (+1)</option>
                          <option data-countryCode="CV" value="238">Cape Verde Islands (+238)</option>
                          <option data-countryCode="KY" value="1345">Cayman Islands (+1345)</option>
                          <option data-countryCode="CF" value="236">Central African Republic (+236)</option>
                          <option data-countryCode="CL" value="56">Chile (+56)</option>
                          <option data-countryCode="CN" value="86">China (+86)</option>
                          <option data-countryCode="CO" value="57">Colombia (+57)</option>
                          <option data-countryCode="KM" value="269">Comoros (+269)</option>
                          <option data-countryCode="CG" value="242">Congo (+242)</option>
                          <option data-countryCode="CK" value="682">Cook Islands (+682)</option>
                          <option data-countryCode="CR" value="506">Costa Rica (+506)</option>
                          <option data-countryCode="HR" value="385">Croatia (+385)</option>
                          <option data-countryCode="CU" value="53">Cuba (+53)</option>
                          <option data-countryCode="CY" value="90392">Cyprus North (+90392)</option>
                          <option data-countryCode="CY" value="357">Cyprus South (+357)</option>
                          <option data-countryCode="CZ" value="42">Czech Republic (+42)</option>
                          <option data-countryCode="DK" value="45">Denmark (+45)</option>
                          <option data-countryCode="DJ" value="253">Djibouti (+253)</option>
                          <option data-countryCode="DM" value="1809">Dominica (+1809)</option>
                          <option data-countryCode="DO" value="1809">Dominican Republic (+1809)</option>
                          <option data-countryCode="EC" value="593">Ecuador (+593)</option>
                          <option data-countryCode="EG" value="20">Egypt (+20)</option>
                          <option data-countryCode="SV" value="503">El Salvador (+503)</option>
                          <option data-countryCode="GQ" value="240">Equatorial Guinea (+240)</option>
                          <option data-countryCode="ER" value="291">Eritrea (+291)</option>
                          <option data-countryCode="EE" value="372">Estonia (+372)</option>
                          <option data-countryCode="ET" value="251">Ethiopia (+251)</option>
                          <option data-countryCode="FK" value="500">Falkland Islands (+500)</option>
                          <option data-countryCode="FO" value="298">Faroe Islands (+298)</option>
                          <option data-countryCode="FJ" value="679">Fiji (+679)</option>
                          <option data-countryCode="FI" value="358">Finland (+358)</option>
                          <option data-countryCode="FR" value="33">France (+33)</option>
                          <option data-countryCode="GF" value="594">French Guiana (+594)</option>
                          <option data-countryCode="PF" value="689">French Polynesia (+689)</option>
                          <option data-countryCode="GA" value="241">Gabon (+241)</option>
                          <option data-countryCode="GM" value="220">Gambia (+220)</option>
                          <option data-countryCode="GE" value="7880">Georgia (+7880)</option>
                          <option data-countryCode="DE" value="49">Germany (+49)</option>
                          <option data-countryCode="GH" value="233">Ghana (+233)</option>
                          <option data-countryCode="GI" value="350">Gibraltar (+350)</option>
                          <option data-countryCode="GR" value="30">Greece (+30)</option>
                          <option data-countryCode="GL" value="299">Greenland (+299)</option>
                          <option data-countryCode="GD" value="1473">Grenada (+1473)</option>
                          <option data-countryCode="GP" value="590">Guadeloupe (+590)</option>
                          <option data-countryCode="GU" value="671">Guam (+671)</option>
                          <option data-countryCode="GT" value="502">Guatemala (+502)</option>
                          <option data-countryCode="GN" value="224">Guinea (+224)</option>
                          <option data-countryCode="GW" value="245">Guinea - Bissau (+245)</option>
                          <option data-countryCode="GY" value="592">Guyana (+592)</option>
                          <option data-countryCode="HT" value="509">Haiti (+509)</option>
                          <option data-countryCode="HN" value="504">Honduras (+504)</option>
                          <option data-countryCode="HK" value="852">Hong Kong (+852)</option>
                          <option data-countryCode="HU" value="36">Hungary (+36)</option>
                          <option data-countryCode="IS" value="354">Iceland (+354)</option>
                          <option data-countryCode="IN" value="91">India (+91)</option>
                          <option data-countryCode="ID" value="62">Indonesia (+62)</option>
                          <option data-countryCode="IR" value="98">Iran (+98)</option>
                          <option data-countryCode="IQ" value="964">Iraq (+964)</option>
                          <option data-countryCode="IE" value="353">Ireland (+353)</option>
                          <option data-countryCode="IL" value="972">Israel (+972)</option>
                          <option data-countryCode="IT" value="39">Italy (+39)</option>
                          <option data-countryCode="JM" value="1876">Jamaica (+1876)</option>
                          <option data-countryCode="JP" value="81">Japan (+81)</option>
                          <option data-countryCode="JO" value="962">Jordan (+962)</option>
                          <option data-countryCode="KZ" value="7">Kazakhstan (+7)</option>
                          <option data-countryCode="KE" value="254">Kenya (+254)</option>
                          <option data-countryCode="KI" value="686">Kiribati (+686)</option>
                          <option data-countryCode="KP" value="850">Korea North (+850)</option>
                          <option data-countryCode="KR" value="82">Korea South (+82)</option>
                          <option data-countryCode="KW" value="965">Kuwait (+965)</option>
                          <option data-countryCode="KG" value="996">Kyrgyzstan (+996)</option>
                          <option data-countryCode="LA" value="856">Laos (+856)</option>
                          <option data-countryCode="LV" value="371">Latvia (+371)</option>
                          <option data-countryCode="LB" value="961">Lebanon (+961)</option>
                          <option data-countryCode="LS" value="266">Lesotho (+266)</option>
                          <option data-countryCode="LR" value="231">Liberia (+231)</option>
                          <option data-countryCode="LY" value="218">Libya (+218)</option>
                          <option data-countryCode="LI" value="417">Liechtenstein (+417)</option>
                          <option data-countryCode="LT" value="370">Lithuania (+370)</option>
                          <option data-countryCode="LU" value="352">Luxembourg (+352)</option>
                          <option data-countryCode="MO" value="853">Macao (+853)</option>
                          <option data-countryCode="MK" value="389">Macedonia (+389)</option>
                          <option data-countryCode="MG" value="261">Madagascar (+261)</option>
                          <option data-countryCode="MW" value="265">Malawi (+265)</option>
                          <option data-countryCode="MY" value="60">Malaysia (+60)</option>
                          <option data-countryCode="MV" value="960">Maldives (+960)</option>
                          <option data-countryCode="ML" value="223">Mali (+223)</option>
                          <option data-countryCode="MT" value="356">Malta (+356)</option>
                          <option data-countryCode="MH" value="692">Marshall Islands (+692)</option>
                          <option data-countryCode="MQ" value="596">Martinique (+596)</option>
                          <option data-countryCode="MR" value="222">Mauritania (+222)</option>
                          <option data-countryCode="YT" value="269">Mayotte (+269)</option>
                          <option data-countryCode="MX" value="52">Mexico (+52)</option>
                          <option data-countryCode="FM" value="691">Micronesia (+691)</option>
                          <option data-countryCode="MD" value="373">Moldova (+373)</option>
                          <option data-countryCode="MC" value="377">Monaco (+377)</option>
                          <option data-countryCode="MN" value="976">Mongolia (+976)</option>
                          <option data-countryCode="MS" value="1664">Montserrat (+1664)</option>
                          <option data-countryCode="MA" value="212">Morocco (+212)</option>
                          <option data-countryCode="MZ" value="258">Mozambique (+258)</option>
                          <option data-countryCode="MN" value="95">Myanmar (+95)</option>
                          <option data-countryCode="NA" value="264">Namibia (+264)</option>
                          <option data-countryCode="NR" value="674">Nauru (+674)</option>
                          <option data-countryCode="NP" value="977">Nepal (+977)</option>
                          <option data-countryCode="NL" value="31">Netherlands (+31)</option>
                          <option data-countryCode="NC" value="687">New Caledonia (+687)</option>
                          <option data-countryCode="NZ" value="64">New Zealand (+64)</option>
                          <option data-countryCode="NI" value="505">Nicaragua (+505)</option>
                          <option data-countryCode="NE" value="227">Niger (+227)</option>
                          <option data-countryCode="NG" value="234">Nigeria (+234)</option>
                          <option data-countryCode="NU" value="683">Niue (+683)</option>
                          <option data-countryCode="NF" value="672">Norfolk Islands (+672)</option>
                          <option data-countryCode="NP" value="670">Northern Marianas (+670)</option>
                          <option data-countryCode="NO" value="47">Norway (+47)</option>
                          <option data-countryCode="OM" value="968">Oman (+968)</option>
                          <option data-countryCode="PK" value="92">Pakistan (+92)</option>
                          <option data-countryCode="PW" value="680">Palau (+680)</option>
                          <option data-countryCode="PA" value="507">Panama (+507)</option>
                          <option data-countryCode="PG" value="675">Papua New Guinea (+675)</option>
                          <option data-countryCode="PY" value="595">Paraguay (+595)</option>
                          <option data-countryCode="PE" value="51">Peru (+51)</option>
                          <option data-countryCode="PH" value="63">Philippines (+63)</option>
                          <option data-countryCode="PL" value="48">Poland (+48)</option>
                          <option data-countryCode="PT" value="351">Portugal (+351)</option>
                          <option data-countryCode="PR" value="1787">Puerto Rico (+1787)</option>
                          <option data-countryCode="QA" value="974">Qatar (+974)</option>
                          <option data-countryCode="RE" value="262">Reunion (+262)</option>
                          <option data-countryCode="RO" value="40">Romania (+40)</option>
                          <option data-countryCode="RU" value="7">Russia (+7)</option>
                          <option data-countryCode="RW" value="250">Rwanda (+250)</option>
                          <option data-countryCode="SM" value="378">San Marino (+378)</option>
                          <option data-countryCode="ST" value="239">Sao Tome &amp; Principe (+239)</option>
                          <option data-countryCode="SA" value="966">Saudi Arabia (+966)</option>
                          <option data-countryCode="SN" value="221">Senegal (+221)</option>
                          <option data-countryCode="CS" value="381">Serbia (+381)</option>
                          <option data-countryCode="SC" value="248">Seychelles (+248)</option>
                          <option data-countryCode="SL" value="232">Sierra Leone (+232)</option>
                          <option data-countryCode="SG" value="65">Singapore (+65)</option>
                          <option data-countryCode="SK" value="421">Slovak Republic (+421)</option>
                          <option data-countryCode="SI" value="386">Slovenia (+386)</option>
                          <option data-countryCode="SB" value="677">Solomon Islands (+677)</option>
                          <option data-countryCode="SO" value="252">Somalia (+252)</option>
                          <option data-countryCode="ZA" value="27">South Africa (+27)</option>
                          <option data-countryCode="ES" value="34">Spain (+34)</option>
                          <option data-countryCode="LK" value="94">Sri Lanka (+94)</option>
                          <option data-countryCode="SH" value="290">St. Helena (+290)</option>
                          <option data-countryCode="KN" value="1869">St. Kitts (+1869)</option>
                          <option data-countryCode="SC" value="1758">St. Lucia (+1758)</option>
                          <option data-countryCode="SD" value="249">Sudan (+249)</option>
                          <option data-countryCode="SR" value="597">Suriname (+597)</option>
                          <option data-countryCode="SZ" value="268">Swaziland (+268)</option>
                          <option data-countryCode="SE" value="46">Sweden (+46)</option>
                          <option data-countryCode="CH" value="41">Switzerland (+41)</option>
                          <option data-countryCode="SI" value="963">Syria (+963)</option>
                          <option data-countryCode="TW" value="886">Taiwan (+886)</option>
                          <option data-countryCode="TJ" value="7">Tajikstan (+7)</option>
                          <option data-countryCode="TH" value="66">Thailand (+66)</option>
                          <option data-countryCode="TG" value="228">Togo (+228)</option>
                          <option data-countryCode="TO" value="676">Tonga (+676)</option>
                          <option data-countryCode="TT" value="1868">Trinidad &amp; Tobago (+1868)</option>
                          <option data-countryCode="TN" value="216">Tunisia (+216)</option>
                          <option data-countryCode="TR" value="90">Turkey (+90)</option>
                          <option data-countryCode="TM" value="7">Turkmenistan (+7)</option>
                          <option data-countryCode="TM" value="993">Turkmenistan (+993)</option>
                          <option data-countryCode="TC" value="1649">Turks &amp; Caicos Islands (+1649)</option>
                          <option data-countryCode="TV" value="688">Tuvalu (+688)</option>
                          <option data-countryCode="UG" value="256">Uganda (+256)</option>
                          <option data-countryCode="UA" value="380">Ukraine (+380)</option>
                          <option data-countryCode="AE" value="971">United Arab Emirates (+971)</option>
                          <option data-countryCode="UY" value="598">Uruguay (+598)</option>
                          <option data-countryCode="UZ" value="7">Uzbekistan (+7)</option>
                          <option data-countryCode="VU" value="678">Vanuatu (+678)</option>
                          <option data-countryCode="VA" value="379">Vatican City (+379)</option>
                          <option data-countryCode="VE" value="58">Venezuela (+58)</option>
                          <option data-countryCode="VN" value="84">Vietnam (+84)</option>
                          <option data-countryCode="VG" value="84">Virgin Islands - British (+1284)</option>
                          <option data-countryCode="VI" value="84">Virgin Islands - US (+1340)</option>
                          <option data-countryCode="WF" value="681">Wallis &amp; Futuna (+681)</option>
                          <option data-countryCode="YE" value="969">Yemen (North)(+969)</option>
                          <option data-countryCode="YE" value="967">Yemen (South)(+967)</option>
                          <option data-countryCode="ZM" value="260">Zambia (+260)</option>
                          <option data-countryCode="ZW" value="263">Zimbabwe (+263)</option>
                        </optgroup>
                      </select>
                      <div class="invalid-feedback" v-if="formErrors.phoneCountryCode">Please enter a valid mobileCountryCode.</div>
                    </div>
                  </div>
                  <div class="col-sm-6">
                    <div class="form-group">
                      <label for="phone">Mobile Number</label>
                      <input class="form-control" id="phone" type="tel"  :class="[formErrors.phone ? 'is-invalid' : '']" v-model.trim="formData.phone" autocomplete="phone" >
                      <div class="invalid-feedback" v-if="formErrors.phone">Please enter a valid phone.</div>
                    </div>
                  </div>
            
                </div>
                <div class="row">
                  <div class="col-sm-6">
                    <p class="text-danger" v-if="cloudError === 'emailAlreadyInUse'">There is already an account using that email address.</p>
                    <p class="text-danger" v-else-if="cloudError">An error occured while processing your request. Please check your information and try again, or <a href="/contact">contact support</a> if the error persists.</p>
                  </div>
                  <div class="col-sm-6">
                    <div class="form-group text-right">
                      <router-link class="btn " to="/profile">Cancel</router-link>
                      <ajax-button type="submit" :syncing="syncing" class="btn btn-dark">Save changes</ajax-button>
                    </div>
                  </div>
                </div>
              </ajax-form>
            </div>
          </div>

    

    </div>
      
    `,
    // <tr v-for="market in markets" :id="market.id" v-if="market && market.sellCurrencyId && !market.sellCurrencyId.buyCurrency && market.sellCurrencyId.icoOrder && (!market.sellCurrencyIndexToken && !type || market.sellCurrencyIndexToken && type) && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" >
    //
    //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
    //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
    //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
    beforeMount: async function() {
        // Attach any initial data from the server.
        this.action = this.$route.params.action;
        this.userType = this.$route.params.userType;
        this.subaction = this.$route.params.subaction;

          // _.extend(this, YOH_SHOW_LOCALS);
          _.extend(this, YOH_SHOW_LOCALS);

          

        await this.listen();  

    },
    mounted: async function() {


    
       
      },



    //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
    //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
    //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
    methods: {

      init: function () {
         // Set the form data.
         var Account = this;
        this.formData.username = this.me.username;
        this.formData.avatar = this.avatar;
        this.formData.firstName = this.me.firstName;
        this.formData.lastName = this.me.lastName;
        this.formData.phoneCountryCode = this.me.mobileCountryCode;
        this.formData.phone = this.me.mobileNumber;
        this.formData.emailAddress = this.me.emailChangeCandidate ? this.me.emailChangeCandidate : this.me.emailAddress;

        this.noAvatarImage = this.formData.avatar == '' || this.formData.avatar == undefined;


        setTimeout(function() { 
          $("#phoneCountryCode").val(Account.me.mobileCountryCode);

      }, 1000);
        
      },
      
      listen: async function() {
        // The auto-connecting socket is exposed as `io.socket`.
  
        // Use `io.socket.on()` to listen for the 'hello' event:
        // io.socket.on(this.market.id, function (data) {
        //   console.log('Socket `' + data.id + '` joined the party!');
        // });
        var Account = this;
      
        //show loading// syincing
        this.loadingComponent = true;
        // $(".market .market-pg").hide().addClass("d-none");
        // $(".market .loading").show().removeClass("d-none");
        // get market 
        
        // var data =  await Cloud.getAccount.with({tradeType:this.tradeType,symbol:this.symbol})
        // .tolerate(()=>{
        //   this.cloudLoadingError = true;
        // });
  
        // if(data.flag){
        //   _.extend(this, data);
        //   this.loadingComponent = false;
  
        // }else if(data.mustLogin){
        //   window.location.href = data.redirect;
        // } else{
        //   this.loadingComponent = false;
        // }

        // var csrf = await CSRF.token();
        // var apiRequestHeader = {
        //     'X-CSRF-Token':csrf._csrf,
        //       // 'cookie':cookie
        //   };
        $.ajax({
              type: "POST",
            //   url: this.refreshUrl+"/markets/orders/cancel",
            // url: '/api/account',
            url: '/wp-json/yohshow/api/v1/profile',

            data: {userType:this.userType,action:this.action,subaction:this.subaction},
              // headers:apiRequestHeader,
              success:  function(resData, textStatus, request)
              {
                  resData = JSON.parse(resData);

                  if(resData.flag){
                      _.extend(Account, resData);
                      Account.loadingComponent = false;
                      Account.init();
          
                    }else if(resData.mustLogin){
                      // window.location.href = resData.redirect;
                    } else{
                      Account.loadingComponent = false;
                    }
  
              }
            });

  
      },
      submittedForm: async function() {
        // Redirect to the account page on success.
        // > (Note that we re-enable the syncing state here.  This is on purpose--
        // > to make sure the spinner stays there until the page navigation finishes.)
        this.syncing = true;
        // window.location = '/account';
        var uploadResult = await this.uploadFiles();
        this.$router.push("/profile");

      },
      previewFile: async function(e) {
        console.log('event',e);
        // var preview = document.querySelector('img');
        // var file    = document.querySelector('input[type=file]').files[0];
        // var preview = document.querySelector('img');
        var parent = $(e.target).parent();
        var image = parent.find('img');
        var src = parent.find('.src');
        
        // var preview    = $(e.target).parent().find('img');
        var file    = e.target.files[0];
        // console.log(preview,file);
        var reader  = new FileReader();
      
        reader.addEventListener("load", function () {
          if(reader.result){
            console.log(reader.result,reader.result);
            image.attr('src',reader.result);
            src.attr('value',reader.result);
            // src.val(reader.result);
            src.text(reader.result);
            src.change();
            image.removeClass('d-none');
          }
          
        }, false);
        if (file) {
          reader.readAsDataURL(file);
        }
  
      },
      uploadFiles: async function() {
        let formData = new FormData();

        let avatar = document.getElementById("avatar") ? document.getElementById("avatar").files : false;

        if(avatar){
            formData.append("avatar", avatar[0]);
        }



        var response = await fetch('/wp-json/yohshow/api/v1/account/upload', {method: "POST", body: formData});
        var myJson = await response.json();
        myJson = JSON.parse(myJson);
        if(myJson.success){
  
        }

        return {
            success:myJson.success,
        }
      },
  
      handleParsingForm: function() {
        // Clear out any pre-existing error messages.
        this.formErrors = {};
  
        var argins = this.formData;
  
        // Validate name:
        if(!argins.firstName) {
          this.formErrors.firstName = true;
        }
  
        // Validate email:
        if(!argins.emailAddress) {
          this.formErrors.emailAddress = true;
        }
  
        // If there were any issues, they've already now been communicated to the user,
        // so simply return undefined.  (This signifies that the submission should be
        // cancelled.)
        if (Object.keys(this.formErrors).length > 0) {
          return;
        }
  
        return argins;
      },


      }



  });

});

