/**
 * <mint>
 * -----------------------------------------------------------------------------
 * mint.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */
jQuery(document).ready(function( $ ) {


	Vue.component('mint', {
  

    //  ╔═╗╦═╗╔═╗╔═╗╔═╗
    //  ╠═╝╠╦╝║ ║╠═╝╚═╗
    //  ╩  ╩╚═╚═╝╩  ╚═╝
    props: [
      // 'markets',// « The JS timestamp to format
      // 'buyCurrency',
      // 'type',
    ],

    //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
    //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
    //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
    data: function (){
      return {
            loadingComponent:true,
            
        
            // Main syncing/loading state for this page.
            syncing: false,

            // Form data
            formData: { /* … */ },

            // For tracking client-side validation errors in our form.
            // > Has property set to `true` for each invalid property in `formData`.
            formErrors: { /* … */ },

            // Server error state for the form
            cloudError: '',
            baseCharge:10,
      };
    },

    /*
                    (type && market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
                  || (type && market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
    */

    //  ╦ ╦╔╦╗╔╦╗╦
    //  ╠═╣ ║ ║║║║
    //  ╩ ╩ ╩ ╩ ╩╩═╝

    template: `
    <div class="mint-component">
        <div v-if="loadingComponent" class="text-center">

            <h1>Your account is being loaded...</h1>
            <ajax-button type="submit" :syncing="loadingComponent" class="btn btn-primary mint">Refesh</ajax-button>


        </div>

        <div v-else="" id="mint" v-cloak>
            <div class="container">
                <h2 class="text-center">Create</h2>
                <!-- {{appToken}} -->
                <!-- {{stableToken}} -->
                <!-- {{newToken}} -->
                <!-- {{formData.tokenId}} -->
                    <div class="row">
                        <div class="col-md-12 text-center">
                            <p>Coins are used to transparently track authenticity, funding, spending and profitablity while allowing members to receive rewards for thier contribution.</p>
                        </div>
                        <div class="col-md-12">
                            <div class="row" >
                                <form class="col-12" id="updateToken" method="POST" enctype="multipart/form-data"  action="/updateToken" :syncing.sync="syncing" :cloud-error.sync="cloudError" @submitted="submittedForm($event)" :handle-parsing="handleParsingForm">
                                <!-- <form enctype="multipart/form-data"  action="updateToken" :syncing.sync="syncing" :cloud-error.sync="cloudError" @submitted="submittedForm($event)" :handle-parsing="handleParsingForm"> -->
                                    <!--  need info for 
                                        tether book
                                        name
                                        symbly
                                        is stable token
                                        token book
                                        description

                                        stable token needs
                                        description
                                        name
                                        symobol
                                        how much do you want to back the token by
                
                
                                    -->
                                    <div class="row">
                                        
                                        <div class="col-md-6">

                                            <div class="form-group required-field">
                                                <label class="control-label" for="name">Project Name </label>
                                                <input class="form-control" :class="[formErrors.name ? 'is-invalid' : '']"  required id="name" name="name" type="text" v-model.trim="formData.name"  aria-describedby="nameHelp"   >
                                                <div class="invalid-feedback" v-if="formErrors.name">Please enter a project name.</div>
                                                <small id="adminHelp" class="form-text text-muted">What would you like to call this project?</small>
                                            </div>
                                            <!-- <div class="form-group required-field">
                                                <label class="control-label"  for="category">Category</label>
                                                <select class="form-control category-select" required :class="[formErrors.category ? 'is-invalid' : '']" v-model.trim="formData.category"  name="category" >
                                                <option>Select Category</option>
                                                <option v-for="category in categories" :value="category.id">
                                                    {{category.name}}
                                                </option>
                                                </select>
                                                <div class="invalid-feedback" v-if="formErrors.category">Please select your project's category.</div>
                                                <small id="categoryHelp" class="form-text text-muted">Please select a category.</small>
                                            </div>
                                            <div class="form-group subcategory-box" style="display: none">
                                                <label class="control-label"  for="subcategory">Subcategory</label>
                                                <select class="form-control subcategory-select subcategory" v-model.trim="formData.subcategory"  name="subcategory">
                                                <optgroup v-for="category in categories" :class="category.id + ' category-group'">
                                                    <option v-for="subcategory in category.children" :value="subcategory.id">
                                                        {{subcategory.name}}
                                                    </option>
                                                </optgroup>
                                                </select>
                                                <div class="invalid-feedback" v-if="formErrors.subcategory">Please select your coins subcategory.</div>
                                                <small id="subcategoryHelp" class="form-text text-muted">Please select a subcategory for this project</small>
                                            </div> -->
                                            
                                        </div>
                                        <div class="col-md-6">
                                            <div v-if="formData.tokenId == null" class="form-group required-field">
                                                <label class="control-label" for="images">Featured Image</label><br>
                                                <input type="hidden" v-model.trim="formData.logo"  class="src">
                                                <img v-bind:class="{ 'd-none': noLogoImage }" v-bind:src="formData.logo" height="200" alt="Image preview...">
                                                <input id="logo" :class="[formErrors.logo ? 'is-invalid form-control' : '']"  name="logo" type="file"  @change="previewFile($event)"><br>
                                                <div class="invalid-feedback" v-if="formErrors.logo">Please upload an image.</div>

                                            </div> 
                                            <div v-else="" class="form-group">
                                                <label class="control-label" for="images">Featured Image</label><br>
                                                <img v-bind:src="formData.logo" height="200" alt="Image preview...">
                                            </div> 
                                        </div>
                                        <div class="col-md-6">
                                            
                                            <div class="form-group required-field">
                                                <label class="control-label" for="symbol">Symbol</label>
                                                <input class="form-control" v-if="newToken" :class="[formErrors.symbol ? 'is-invalid' : '']" required id="symbol" name="symbol" type="text" v-model.trim="formData.symbol"  aria-describedby="symbolHelp"   >
                                                <input class="form-control" v-else disabled="disabled"  :class="[formErrors.symbol ? 'is-invalid' : '']" required id="symbol" name="symbol" type="text" v-model.trim="formData.symbol"  aria-describedby="symbolHelp"   >
                                                <div class="invalid-feedback" v-if="formErrors.symbolTaken">This symbol is already taken, please enter another symbol.</div>
                                                <div class="invalid-feedback" v-else-if="formErrors.symbol">Please enter your symbol.</div>
                                                <small id="symbolHelp" class="form-text text-muted">This is an abbreviation for your project name. </small>
                                            </div>
                                            <!-- <div class="form-group">
                                                <label class="control-label" for="website">Website</label>
                                                <input class="form-control" id="website" name="website" type="text" v-model.trim="formData.website"  aria-describedby="websiteHelp"   >
                                                <div class="invalid-feedback" v-if="formErrors.website">Please a coin city.</div>
                                                <small id="adminHelp" class="form-text text-muted">What would you like to call this?</small>
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label" for="twitter">Twitter</label>
                                                <input class="form-control" id="twitter" name="twitter" type="text" v-model.trim="formData.twitter"  aria-describedby="twitterHelp"   >
                                                <div class="invalid-feedback" v-if="formErrors.twitter">Please a coin city.</div>
                                                <small id="adminHelp" class="form-text text-muted">What would you like to call this?</small>
                                            </div> -->
                                            
                                        
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group required-field">
                                                <label class="control-label" for="description">Description</label>
                                                <textarea class="form-control" :class="[formErrors.description ? 'is-invalid' : '']" required id="description" name="description"  v-model.trim="formData.description"  aria-describedby="descriptionHelp" ></textarea>
                                                <div class="invalid-feedback" v-if="formErrors.description">Please enter your description.</div>
                                                <small id="descriptionHelp" class="form-text text-muted">Please add a description for this project.</small>
                                            </div>
                                        </div>
                        
                                    </div>
                                    <div class="row">
                                        
                                        <div class="col-md-6">
                                            <div class="form-group required-field">
                                                <label class="control-label" for="ownershipForSell">Sell Ownership? </label>

                                                <select class="form-control ownershipForSell-select" required :class="[formErrors.ownershipForSell ? 'is-invalid' : '']" v-model.trim="formData.ownershipForSell"  name="ownershipForSell" >
                                                    <option value="yes">
                                                        Yes 
                                                    </option>
                                                    <option value="no">
                                                        No 
                                                    </option>

                                                </select>
                                                

                                                <div class="invalid-feedback" v-if="formErrors.ownershipForSell">Please clarify if this project is for sale.</div>
                                                <small id="adminHelp" class="form-text text-muted">Would you sell this project?</small>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group required-field">
                                                <label class="control-label" for="ownershipPrice">Price </label>
                                                <input class="form-control" :class="[formErrors.ownershipPrice ? 'is-invalid' : '']"  required id="ownershipPrice" name="ownershipPrice" type="number" step=".01" v-model.trim="formData.ownershipPrice"  aria-describedby="ownershipPriceHelp"   >
                                                <div class="invalid-feedback" v-if="formErrors.ownershipPrice">Please a project ownershipPrice.</div>
                                                <small id="adminHelp" class="form-text text-muted">How much would you sell this project for?</small>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    

                                    <!--

                                    <div class="row">

                    

                                        <div class="col-md-6">
                                            <div class="form-group required-field">
                                                <label class="control-label" for="tags">Tags</label>
                                                <textarea class="form-control" :class="[formErrors.tags ? 'is-invalid' : '']" required id="tags" name="tags"  v-model.trim="formData.tags"  aria-describedby="tagsHelp" ></textarea>
                                                <div class="invalid-feedback" v-if="formErrors.tags">Please enter your tags.</div>
                                                <small id="tagsHelp" class="form-text text-muted">Please add a tags for this project.</small>
                                            </div>
                                        </div>

                                        

                                        <div class="col-md-6">
                                            <div class="form-group required-field">
                                                <label class="control-label" for="tags">Tags</label>
                                                <textarea class="form-control" :class="[formErrors.tags ? 'is-invalid' : '']" required id="tags" name="tags"  v-model.trim="formData.tags"  aria-describedby="tagsHelp" ></textarea>
                                                <div class="invalid-feedback" v-if="formErrors.tags">Please enter your tags.</div>
                                                <small id="tagsHelp" class="form-text text-muted">Please add a tags for this project.</small>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group required-field">
                                                <label class="control-label" for="accessMessage">Access Message</label>
                                                <textarea class="form-control" :class="[formErrors.accessMessage ? 'is-invalid' : '']" required id="accessMessage" name="accessMessage"  v-model.trim="formData.accessMessage"  aria-describedby="accessMessageHelp" ></textarea>
                                                <div class="invalid-feedback" v-if="formErrors.accessMessage">Please enter your accessMessage.</div>
                                                <small id="accessMessageHelp" class="form-text text-muted">Please add a accessMessage for this project.</small>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group required-field">
                                                <label class="control-label" for="accessDescription">Access Description</label>
                                                <textarea class="form-control" :class="[formErrors.accessDescription ? 'is-invalid' : '']" required id="accessDescription" name="accessDescription"  v-model.trim="formData.accessDescription"  aria-describedby="accessDescriptionHelp" ></textarea>
                                                <div class="invalid-feedback" v-if="formErrors.accessDescription">Please enter your accessDescription.</div>
                                                <small id="accessDescriptionHelp" class="form-text text-muted">Please add a accessDescription for this project.</small>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group required-field">
                                                <label class="control-label" for="accessPrice">Access Price </label>
                                                <input class="form-control" :class="[formErrors.accessPrice ? 'is-invalid' : '']"  required id="accessPrice" name="accessPrice" type="number" step=".01" v-model.trim="formData.accessPrice"  aria-describedby="accessPriceHelp"   >
                                                <div class="invalid-feedback" v-if="formErrors.accessPrice">Please a project accessPrice.</div>
                                                <small id="adminHelp" class="form-text text-muted">What would you like to call this?</small>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group required-field">
                                                <label class="control-label" for="accessSupply">Access Supply </label>
                                                <input class="form-control" :class="[formErrors.accessSupply ? 'is-invalid' : '']"  required id="accessSupply" name="accessSupply" type="number" step="1" v-model.trim="formData.accessSupply"  aria-describedby="accessSupplyHelp"   >
                                                <div class="invalid-feedback" v-if="formErrors.accessSupply">Please a project accessSupply.</div>
                                                <small id="adminHelp" class="form-text text-muted">What would you like to call this?</small>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group required-field">
                                                <label class="control-label" for="categories">Categories </label>
                                                <input class="form-control" :class="[formErrors.categories ? 'is-invalid' : '']"  required id="categories" name="categories" type="text" v-model.trim="formData.categories"  aria-describedby="categoriesHelp"   >
                                                <div class="invalid-feedback" v-if="formErrors.categories">Please a project categories.</div>
                                                <small id="adminHelp" class="form-text text-muted">What would you like to call this?</small>
                                            </div>
                                        </div>


                                    </div>
                                    
                                    -->
                                    
                                    <div class="row">
                                        <h4 class="col-12">Social Media (How do we get in contact with you?) </h4>
                
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label class="control-label" for="twitter">Twitter</label>
                                                <input class="form-control" :class="[formErrors.twitter ? 'is-invalid' : '']"  id="twitter" name="twitter" type="text" v-model.trim="formData.twitter"  aria-describedby="twitterHelp"   >
                                                <div class="invalid-feedback" v-if="formErrors.twitter">Please a project city.</div>
                                                <!-- <small id="adminHelp" class="form-text text-muted">What would you like to call this?</small> -->
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label class="control-label" for="facebook">Facebook</label>
                                                    <input class="form-control" :class="[formErrors.facebook ? 'is-invalid' : '']"  id="facebook" name="facebook" type="text" v-model.trim="formData.facebook"  aria-describedby="facebookHelp"   >
                                                    <div class="invalid-feedback" v-if="formErrors.facebook">Please a faebook.</div>
                                                    <!-- <small id="adminHelp" class="form-text text-muted">What would you like to call this?</small> -->
                                                </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label class="control-label" for="instagram">Instagram</label>
                                                <input class="form-control" id="instagram" name="instagram" type="text" v-model.trim="formData.instagram"  aria-describedby="instagramHelp"   >
                                                <div class="invalid-feedback" v-if="formErrors.instagram">Please a coin city.</div>
                                                <!-- <small id="adminHelp" class="form-text text-muted">What is instagram for this</small> -->
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group required-field">
                                                <label class="control-label" for="phone">Phone</label>
                                                <input class="form-control" required :class="[formErrors.phone ? 'is-invalid' : '']" id="phone" name="phone" type="text" v-model.trim="formData.phone"  aria-describedby="phoneHelp"   >
                                                <div class="invalid-feedback" v-if="formErrors.phone">Please a valid phone number.</div>
                                                <small id="adminHelp" class="form-text text-muted">What number should your project memebers call/text if they have any questions?</small>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label class="control-label" for="website">Website</label>
                                                <input class="form-control" id="website" name="website" type="text" v-model.trim="formData.website"  aria-describedby="websiteHelp"   >
                                                <div class="invalid-feedback" v-if="formErrors.website">Please a coin city.</div>
                                                <!-- <small id="adminHelp" class="form-text text-muted">What would you like to call this?</small> -->
                                            </div>
                                        </div>
                                    </div>
                                    <div v-if="true" class="row">
                                        <h4 class="col-12">Attributes</h4>
                                        <attribute-table  id="publicAttributes" label="publicAttribute" :attributes="formData.publicAttributes" type="edit"></attribute-table>
                                    </div>
                                    <div class="row">
                                        <h4 class="col-12">Private Attributes</h4>
                                        <attribute-table  id="privateAttributes" label="privateAttribute" :attributes="formData.privateAttributes" type="edit"></attribute-table>
                                    </div>
                                    <div v-if="me.isSuperAdmin" class="row">
                                        <h4 class="col-12">Unite this coin (Connect this project to a token on specific econmoic networks.) </h4>

                                        <!--


                                        mint/update token form
                                            network //
                                            token symbol //
                                            deposit phone number or address //
                                            tether commission //
                                            exchange commission  //
                                            owner commission - remining amount //

                                        -->
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label" for="symbol">Would you like to connect this project to a token on a specific econmoic network?</label><br>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <div class="btn-group btn-group-toggle" data-toggle="buttqons">
                                                <label class="btn btn-secondary ":class="[formData.networkCurrency ? 'active' : '']">
                                                    <input  @click="networkCurrency()" type="radio" name="networkCurrency" value="true" v-model.trim="formData.networkCurrency"  id="networkCurrency"  > Yes
                                                </label>
                                                <label class="btn btn-secondary ":class="[!formData.networkCurrency ? 'active' : '']">
                                                    <input @click="networkCurrency()" type="radio" name="networkCurrency" value="false" v-model.trim="formData.networkCurrency"  id="isNotNetworkCurrency"  > No
                                                </label>
                                                </div>
                                                <div class="invalid-feedback" v-if="formErrors.networkCurrency">Please select an option.</div>
                                                <small id="networkCurrencyHelp" class="form-text text-muted">Do you want this coin to be backed by the US Dollar?</small>
                                            </div>
                                        </div>
                
                                        <div class="col-sm-6 networkCurrency">
                                            <div class="form-group required-field">
                                                <label class="control-label" for="tetherNetwork">Network</label>
                                                <select class="form-control tetherNetwork-select" required :class="[formErrors.tetherNetwork ? 'is-invalid' : '']" v-model.trim="formData.tetherNetwork"  name="tetherNetwork" >
                                                <option>Select Network</option>
                                                <option value="stellar">
                                                    Stellar 
                                                </option>
                                                <option value="ethereum">
                                                    Ethereum 
                                                </option>
                                                <option value="bitmart">
                                                    Bitmart 
                                                </option>
                                                <!-- <option v-for="tetherNetwork in tetherNetworks" :value="tetherNetwork.id">
                                                    {{tetherNetwork.name}}
                                                </option> -->
                                                </select>
                                                <div class="invalid-feedback" v-if="formErrors.tetherNetwork">Please select your project's tetherNetwork.</div>
                                                <small id="tetherNetworkHelp" class="form-text text-muted">Please select a tetherNetwork.</small>
                                            </div>
                                            
                                        </div>
                                        <div class="col-sm-6 networkCurrency">
                                            <div class="form-group">
                                                <label class="control-label" for="tetherTokenSymbol">Network Token Symbol</label>
                                                <input class="form-control" :class="[formErrors.tetherTokenSymbol ? 'is-invalid' : '']"  id="tetherTokenSymbol" name="tetherTokenSymbol" type="text" v-model.trim="formData.tetherTokenSymbol"  aria-describedby="tetherTokenSymbolHelp"   >
                                                <div class="invalid-feedback" v-if="formErrors.tetherTokenSymbol">Please a coin city.</div>
                                                <!-- <small id="adminHelp" class="form-text text-muted">What would you like to call this?</small> -->
                                            </div>
                                        </div>
                                        <div class="col-sm-6 networkCurrency">
                                            <div class="form-group">
                                                <label class="control-label" for="tetherTokenTotalSupply">Network Token Total Supply</label>
                                                <input class="form-control" :class="[formErrors.tetherTokenTotalSupply ? 'is-invalid' : '']"  id="tetherTokenTotalSupply" name="tetherTokenTotalSupply" type="text" v-model.trim="formData.tetherTokenTotalSupply"  aria-describedby="tetherTokenTotalSupplyHelp"   >
                                                <div class="invalid-feedback" v-if="formErrors.tetherTokenTotalSupply">Please a coin city.</div>
                                                <!-- <small id="adminHelp" class="form-text text-muted">What would you like to call this?</small> -->
                                            </div>
                                        </div>
                                        <div class="col-sm-6 networkCurrency">
                                        <div class="form-group required-field">
                                            <label class="control-label" for="tetherCommission">What percentage of your project revenue do you want to connect to this newtwork token? </label>
                                            <h3 v-if="formData.tetherCommission" for="tetherCommission"> {{formData.tetherCommission * 100}}%  </h3>
                                            <select v-else="" class="form-control tetherCommission-select" required :class="[formErrors.tetherCommission ? 'is-invalid' : '']" v-model.trim="formData.tetherCommission"  name="tetherCommission" >
                                            <option>Select Percentage</option>
                                            <option value=".01">1%</option>
                                            <option value=".05">5%</option>
                                            <option value=".1">10%</option>
                                            <option value=".15">15%</option>
                                            <option value=".2">20%</option>
                                            <option value=".25">25%</option>
                                            <option value=".3">30%</option>
                                            <option value=".35">35%</option>
                                            <option value=".4">40%</option>
                                            <option value=".45">45%</option>
                                            <option value=".5">50%</option>

                                            </select>
                                            <div class="invalid-feedback" v-if="formErrors.tetherCommission">Please enter your inital commission offering</div>
                                            <small id="tetherCommissionHelp" class="form-text text-muted">What is the maximum sales commission you want to give to your project promoters?</small>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 networkCurrency">
                                        <div class="form-group required-field">
                                            <label class="control-label" for="tetherDepositPhoneOrAddress">Deposit Phone Number Or Address</label>
                                            <input class="form-control" required :class="[formErrors.tetherDepositPhoneOrAddress ? 'is-invalid' : '']" id="tetherDepositPhoneOrAddress" name="tetherDepositPhoneOrAddress" type="text" v-model.trim="formData.tetherDepositPhoneOrAddress"  aria-describedby="tetherDepositPhoneOrAddressHelp"   >
                                            <div class="invalid-feedback" v-if="formErrors.tetherDepositPhoneOrAddress">Please a valid phone number.</div>
                                            <small id="adminHelp" class="form-text text-muted">What number should your coin holders call/text if they have any questions?</small>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        
                                    </div>
                                    </div>
                                    <div class="row d-none">
                                        <!-- <h4 class="col-12">Promotion</h4>
                
                                        <div class="col-sm-6">
                                            <div class="form-group required-field">
                                                <label class="control-label" for="promoterCommission">Maximum sales commission? </label>
                                                <input class="form-control" required :class="[formErrors.promoterCommission ? 'is-invalid' : '']" id="promoterCommission" name="promoterCommission" type="number"  min="5" value="5" v-model.trim="formData.promoterCommission"  aria-describedby="promoterCommissionHelp"   >
                                                <div class="invalid-feedback" v-if="formErrors.promoterCommission">Please enter your inital commission offering</div>
                                                <small id="promoterCommissionHelp" class="form-text text-muted">What is the maximum sales commission you want to give to your project promoters?</small>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group required-field">
                                                <label class="control-label" for="promoterCharge">Maximum sales commission charge?</label>
                                                <input class="form-control" required :class="[formErrors.promoterCharge ? 'is-invalid' : '']" id="promoterCharge" name="promoterCharge" type="number" min="0"   v-model.trim="formData.promoterCharge"  aria-describedby="promoterChargeHelp"   >
                                                <div class="invalid-feedback" v-if="formErrors.promoterCharge">Please enter your projects promoter charge</div>
                                                <small id="promoterChargeHelp" class="form-text text-muted">How much money would you like to charge your project promoters for recieving the maximum sales commission on all the sales they bring you?</small>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label class="control-label" for="promoterDesciption">How would you describe this promotional opportunity to potential promoters of this project?</label>
                                                <textarea class="form-control" id="promoterDesciption" name="promoterDesciption"  v-model.trim="formData.promoterDesciption"  aria-describedby="promoterDesciptionHelp" ></textarea>
                                                <div class="invalid-feedback" v-if="formErrors.promoterDesciption">Please enter your promoter description</div>
                                                <small id="promoterDesciptionHelp" class="form-text text-muted"></small>
                                            </div>
                                        </div> -->
                                        <!-- <div class="col-sm-6">
                                            <div class="form-group">
                                            <label class="control-label" for="images">Custom Promoter Agreement</label><br>
                                            <input type="hidden" v-model.trim="formData.promoterAgreement"  class="src">
                                            <a v-bind:class="{ 'd-none': nopromoterAgreementImage }" v-bind:href="formData.promoterAgreement" > Promoter Agreement </a>
                                            <div class="invalid-feedback" v-if="formErrors.promoterAgreement">Please upload Promoter image.</div>
                                            <input id="promoterAgreement" name="promoterAgreement" type="file"  @change="previewFile($event)"><br>
                                            </div>
                                        </div> -->
                                    </div>
                                    <div class="row d-none">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label" for="symbol">Would you like a debit card for this project?</label><br> 
                                                <div class="btn-group btn-group-toggle"  data-toggle="buttons">
                                                <label class="btn btn-secondary " :class="[formData.debitCard ? 'active' : '']">
                                                    <input  type="radio" name="debitCard" value="true" v-model.trim="formData.debitCard"  id="debitCard_true" > Yes
                                                </label>
                                                <label class="btn btn-secondary" :class="[!formData.debitCard ? 'active' : '']">
                                                    <input type="radio" name="debitCard" value="false" v-model.trim="formData.debitCard"  id="debitCard_false"  > No
                                                </label>
                                                </div>
                                                <div class="invalid-feedback" v-if="formErrors.debitCard">Please select an option.</div>
                                                <small id="debitCardHelp" class="form-text text-muted">Would you like a debit card linked to this coin's bank account?</small>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="control-label" for="symbol">Would you like a website for this project?</label><br>
                                                <div class="btn-group btn-group-toggle" data-toggle="buttons">
                                                <label class="btn btn-secondary ":class="[formData.websiteSubscription ? 'active' : '']">
                                                    <input  type="radio" name="websiteSubscription" value="true" v-model.trim="formData.websiteSubscription"  id="true"  > Yes
                                                </label>
                                                <label class="btn btn-secondary ":class="[!formData.websiteSubscription ? 'active' : '']">
                                                    <input type="radio" name="websiteSubscription" value="false" v-model.trim="formData.websiteSubscription"  id="false"  > No
                                                </label>
                                                </div>
                                                <div class="invalid-feedback" v-if="formErrors.websiteSubscription">Please select an option.</div>
                                                <small id="websiteSubscriptionHelp" class="form-text text-muted">Do you want this coin to be backed by the US Dollar?</small>
                                            </div>
                                        </div>

                                    </div>
                                    <div v-if="newToken" >
                                        <div class="row d-none">
                                            
                                            
                                            <!-- <div class="col-md-6">
                                                <div class="form-group">
                                                    <label class="control-label" for="symbol">Is this a Stable Coin?</label><br>
                                                    <div class="btn-group btn-group-toggle" data-toggle="buttons">
                                                        <label class="btn btn-secondary active">
                                                        <input  type="radio" name="stableToken" value="true" v-model.trim="formData.stableToken"  id="true" autocomplete="off" checked> Yes
                                                        </label>
                                                        <label class="btn btn-secondary">
                                                        <input type="radio" name="stableToken" value="false" v-model.trim="formData.stableToken"  id="fa" autocomplete="one"> No
                                                        </label>
                                                    </div>
                                                    <div class="invalid-feedback" v-if="formErrors.isStableToken">Please select an option.</div>
                                                    <small id="isStableTokenHelp" class="form-text text-muted">Do you want this coin to be backed by the US Dollar?</small>
                                                </div>
                                            </div>
                                            <div class="col-md-6 stableToken">
                                                <div class="form-group">
                                                    <label class="control-label" for="stableFund">How much would you like to deposit to stabilize your coin?</label>
                                                    <input class="form-control" :class="[formErrors.stableFund ? 'is-invalid' : '']" id="stableFund" name="stableFund" type="number"   v-model.trim="formData.stableFund"  aria-describedby="stableFundHelp" min="10"  >
                                                    <div class="invalid-feedback" v-if="formErrors.stableFund">How much would you like to deposit to stabilize your coin?</div>
                                                    <small id="stableFundHelp" class="form-text text-muted">How much would you like to deposit to stabilize your coin?</small>
                                                </div>
                                            </div> -->
                                
                                        </div>
                                        <div class="row d-none">
                                            <!-- <div class="col-md-6">
                                                <div class="form-group">
                                                    <label class="control-label" for="symbol">Is this a Reward Coin?</label><br>
                                                    <div class="btn-group btn-group-toggle" data-toggle="buttons">
                                                        <label class="btn btn-secondary active">
                                                        <input  type="radio" name="revenueToken" value="true" v-model.trim="formData.revenueToken" id="true" autocomplete="off" checked> Yes
                                                        </label>
                                                        <label class="btn btn-secondary">
                                                        <input type="radio" name="revenueToken" value="false" v-model.trim="formData.revenueToken"  id="fa" autocomplete="one"> No
                                                        </label>
                                                    </div>
                                                    <div class="invalid-feedback" v-if="formErrors.isStableToken">Please select an option.</div>
                                                    <small id="isStableTokenHelp" class="form-text text-muted">Do you want this coin to distribute rewards?</small>
                                                </div>
                                            </div> -->
                                            <div class="col-md-6 revenueToken">
                                                <div class="form-group">
                                                    <label class="control-label" for="icoTargetGoal">How much money would you like to raise?</label>
                                                    <input class="form-control" :class="[formErrors.icoTargetGoal ? 'is-invalid' : '']"  id="icoTargetGoal" name="icoTargetGoal" type="number"   v-model.trim="formData.icoTargetGoal"  aria-describedby="icoTargetGoalHelp"   >
                                                    <div class="invalid-feedback" v-if="formErrors.icoTargetGoal">Please enter  how much money you would like to raise. </div>
                                                    <small id="icoTargetGoalHelp" class="form-text text-muted">How much money would you like to raise?</small>
                                                </div>
                                            </div>
                                            <div class="col-md-6 revenueToken">
                                                <div class="form-group">
                                                    <label class="control-label" for="commission">What percent of future revenue do you want to sell?</label>
                                                    <input class="form-control" :class="[formErrors.commission ? 'is-invalid' : '']"  id="commission" name="commission" type="number"  min="10"  max="100"  v-model.trim="formData.commission"  aria-describedby="commissionHelp"   >
                                                    <div class="invalid-feedback" v-if="formErrors.commission">Please enter your inital profit offering</div>
                                                    <small id="commissionHelp" class="form-text text-muted">What percentage of revenue that goes through this coin's account do you want to give to your investors?</small>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- {{formData}}
                                        test
                                        {{formErrors}} -->
                                        <google-address :form-errors="formErrors" :form-data="formData" ></google-address>


                                        <!-- <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group required-field">
                                                    <label class="control-label" for="country">Country</label>
                                                    <select class="form-control" required name="country" :class="[formErrors.country ? 'is-invalid' : '']" v-model.trim="formData.country">
                                                        <option value="AFG">Afghanistan</option>
                                                        <option value="ALA">Åland Islands</option>
                                                        <option value="ALB">Albania</option>
                                                        <option value="DZA">Algeria</option>
                                                        <option value="ASM">American Samoa</option>
                                                        <option value="AND">Andorra</option>
                                                        <option value="AGO">Angola</option>
                                                        <option value="AIA">Anguilla</option>
                                                        <option value="ATA">Antarctica</option>
                                                        <option value="ATG">Antigua and Barbuda</option>
                                                        <option value="ARG">Argentina</option>
                                                        <option value="ARM">Armenia</option>
                                                        <option value="ABW">Aruba</option>
                                                        <option value="AUS">Australia</option>
                                                        <option value="AUT">Austria</option>
                                                        <option value="AZE">Azerbaijan</option>
                                                        <option value="BHS">Bahamas</option>
                                                        <option value="BHR">Bahrain</option>
                                                        <option value="BGD">Bangladesh</option>
                                                        <option value="BRB">Barbados</option>
                                                        <option value="BLR">Belarus</option>
                                                        <option value="BEL">Belgium</option>
                                                        <option value="BLZ">Belize</option>
                                                        <option value="BEN">Benin</option>
                                                        <option value="BMU">Bermuda</option>
                                                        <option value="BTN">Bhutan</option>
                                                        <option value="BOL">Bolivia, Plurinational State of</option>
                                                        <option value="BES">Bonaire, Sint Eustatius and Saba</option>
                                                        <option value="BIH">Bosnia and Herzegovina</option>
                                                        <option value="BWA">Botswana</option>
                                                        <option value="BVT">Bouvet Island</option>
                                                        <option value="BRA">Brazil</option>
                                                        <option value="IOT">British Indian Ocean Territory</option>
                                                        <option value="BRN">Brunei Darussalam</option>
                                                        <option value="BGR">Bulgaria</option>
                                                        <option value="BFA">Burkina Faso</option>
                                                        <option value="BDI">Burundi</option>
                                                        <option value="KHM">Cambodia</option>
                                                        <option value="CMR">Cameroon</option>
                                                        <option value="CAN">Canada</option>
                                                        <option value="CPV">Cape Verde</option>
                                                        <option value="CYM">Cayman Islands</option>
                                                        <option value="CAF">Central African Republic</option>
                                                        <option value="TCD">Chad</option>
                                                        <option value="CHL">Chile</option>
                                                        <option value="CHN">China</option>
                                                        <option value="CXR">Christmas Island</option>
                                                        <option value="CCK">Cocos (Keeling) Islands</option>
                                                        <option value="COL">Colombia</option>
                                                        <option value="COM">Comoros</option>
                                                        <option value="COG">Congo</option>
                                                        <option value="COD">Congo, the Democratic Republic of the</option>
                                                        <option value="COK">Cook Islands</option>
                                                        <option value="CRI">Costa Rica</option>
                                                        <option value="CIV">Côte d'Ivoire</option>
                                                        <option value="HRV">Croatia</option>
                                                        <option value="CUB">Cuba</option>
                                                        <option value="CUW">Curaçao</option>
                                                        <option value="CYP">Cyprus</option>
                                                        <option value="CZE">Czech Republic</option>
                                                        <option value="DNK">Denmark</option>
                                                        <option value="DJI">Djibouti</option>
                                                        <option value="DMA">Dominica</option>
                                                        <option value="DOM">Dominican Republic</option>
                                                        <option value="ECU">Ecuador</option>
                                                        <option value="EGY">Egypt</option>
                                                        <option value="SLV">El Salvador</option>
                                                        <option value="GNQ">Equatorial Guinea</option>
                                                        <option value="ERI">Eritrea</option>
                                                        <option value="EST">Estonia</option>
                                                        <option value="ETH">Ethiopia</option>
                                                        <option value="FLK">Falkland Islands (Malvinas)</option>
                                                        <option value="FRO">Faroe Islands</option>
                                                        <option value="FJI">Fiji</option>
                                                        <option value="FIN">Finland</option>
                                                        <option value="FRA">France</option>
                                                        <option value="GUF">French Guiana</option>
                                                        <option value="PYF">French Polynesia</option>
                                                        <option value="ATF">French Southern Territories</option>
                                                        <option value="GAB">Gabon</option>
                                                        <option value="GMB">Gambia</option>
                                                        <option value="GEO">Georgia</option>
                                                        <option value="DEU">Germany</option>
                                                        <option value="GHA">Ghana</option>
                                                        <option value="GIB">Gibraltar</option>
                                                        <option value="GRC">Greece</option>
                                                        <option value="GRL">Greenland</option>
                                                        <option value="GRD">Grenada</option>
                                                        <option value="GLP">Guadeloupe</option>
                                                        <option value="GUM">Guam</option>
                                                        <option value="GTM">Guatemala</option>
                                                        <option value="GGY">Guernsey</option>
                                                        <option value="GIN">Guinea</option>
                                                        <option value="GNB">Guinea-Bissau</option>
                                                        <option value="GUY">Guyana</option>
                                                        <option value="HTI">Haiti</option>
                                                        <option value="HMD">Heard Island and McDonald Islands</option>
                                                        <option value="VAT">Holy See (Vatican City State)</option>
                                                        <option value="HND">Honduras</option>
                                                        <option value="HKG">Hong Kong</option>
                                                        <option value="HUN">Hungary</option>
                                                        <option value="ISL">Iceland</option>
                                                        <option value="IND">India</option>
                                                        <option value="IDN">Indonesia</option>
                                                        <option value="IRN">Iran, Islamic Republic of</option>
                                                        <option value="IRQ">Iraq</option>
                                                        <option value="IRL">Ireland</option>
                                                        <option value="IMN">Isle of Man</option>
                                                        <option value="ISR">Israel</option>
                                                        <option value="ITA">Italy</option>
                                                        <option value="JAM">Jamaica</option>
                                                        <option value="JPN">Japan</option>
                                                        <option value="JEY">Jersey</option>
                                                        <option value="JOR">Jordan</option>
                                                        <option value="KAZ">Kazakhstan</option>
                                                        <option value="KEN">Kenya</option>
                                                        <option value="KIR">Kiribati</option>
                                                        <option value="PRK">Korea, Democratic People's Republic of</option>
                                                        <option value="KOR">Korea, Republic of</option>
                                                        <option value="KWT">Kuwait</option>
                                                        <option value="KGZ">Kyrgyzstan</option>
                                                        <option value="LAO">Lao People's Democratic Republic</option>
                                                        <option value="LVA">Latvia</option>
                                                        <option value="LBN">Lebanon</option>
                                                        <option value="LSO">Lesotho</option>
                                                        <option value="LBR">Liberia</option>
                                                        <option value="LBY">Libya</option>
                                                        <option value="LIE">Liechtenstein</option>
                                                        <option value="LTU">Lithuania</option>
                                                        <option value="LUX">Luxembourg</option>
                                                        <option value="MAC">Macao</option>
                                                        <option value="MKD">Macedonia, the former Yugoslav Republic of</option>
                                                        <option value="MDG">Madagascar</option>
                                                        <option value="MWI">Malawi</option>
                                                        <option value="MYS">Malaysia</option>
                                                        <option value="MDV">Maldives</option>
                                                        <option value="MLI">Mali</option>
                                                        <option value="MLT">Malta</option>
                                                        <option value="MHL">Marshall Islands</option>
                                                        <option value="MTQ">Martinique</option>
                                                        <option value="MRT">Mauritania</option>
                                                        <option value="MUS">Mauritius</option>
                                                        <option value="MYT">Mayotte</option>
                                                        <option value="MEX">Mexico</option>
                                                        <option value="FSM">Micronesia, Federated States of</option>
                                                        <option value="MDA">Moldova, Republic of</option>
                                                        <option value="MCO">Monaco</option>
                                                        <option value="MNG">Mongolia</option>
                                                        <option value="MNE">Montenegro</option>
                                                        <option value="MSR">Montserrat</option>
                                                        <option value="MAR">Morocco</option>
                                                        <option value="MOZ">Mozambique</option>
                                                        <option value="MMR">Myanmar</option>
                                                        <option value="NAM">Namibia</option>
                                                        <option value="NRU">Nauru</option>
                                                        <option value="NPL">Nepal</option>
                                                        <option value="NLD">Netherlands</option>
                                                        <option value="NCL">New Caledonia</option>
                                                        <option value="NZL">New Zealand</option>
                                                        <option value="NIC">Nicaragua</option>
                                                        <option value="NER">Niger</option>
                                                        <option value="NGA">Nigeria</option>
                                                        <option value="NIU">Niue</option>
                                                        <option value="NFK">Norfolk Island</option>
                                                        <option value="MNP">Northern Mariana Islands</option>
                                                        <option value="NOR">Norway</option>
                                                        <option value="OMN">Oman</option>
                                                        <option value="PAK">Pakistan</option>
                                                        <option value="PLW">Palau</option>
                                                        <option value="PSE">Palestinian Territory, Occupied</option>
                                                        <option value="PAN">Panama</option>
                                                        <option value="PNG">Papua New Guinea</option>
                                                        <option value="PRY">Paraguay</option>
                                                        <option value="PER">Peru</option>
                                                        <option value="PHL">Philippines</option>
                                                        <option value="PCN">Pitcairn</option>
                                                        <option value="POL">Poland</option>
                                                        <option value="PRT">Portugal</option>
                                                        <option value="PRI">Puerto Rico</option>
                                                        <option value="QAT">Qatar</option>
                                                        <option value="REU">Réunion</option>
                                                        <option value="ROU">Romania</option>
                                                        <option value="RUS">Russian Federation</option>
                                                        <option value="RWA">Rwanda</option>
                                                        <option value="BLM">Saint Barthélemy</option>
                                                        <option value="SHN">Saint Helena, Ascension and Tristan da Cunha</option>
                                                        <option value="KNA">Saint Kitts and Nevis</option>
                                                        <option value="LCA">Saint Lucia</option>
                                                        <option value="MAF">Saint Martin (French part)</option>
                                                        <option value="SPM">Saint Pierre and Miquelon</option>
                                                        <option value="VCT">Saint Vincent and the Grenadines</option>
                                                        <option value="WSM">Samoa</option>
                                                        <option value="SMR">San Marino</option>
                                                        <option value="STP">Sao Tome and Principe</option>
                                                        <option value="SAU">Saudi Arabia</option>
                                                        <option value="SEN">Senegal</option>
                                                        <option value="SRB">Serbia</option>
                                                        <option value="SYC">Seychelles</option>
                                                        <option value="SLE">Sierra Leone</option>
                                                        <option value="SGP">Singapore</option>
                                                        <option value="SXM">Sint Maarten (Dutch part)</option>
                                                        <option value="SVK">Slovakia</option>
                                                        <option value="SVN">Slovenia</option>
                                                        <option value="SLB">Solomon Islands</option>
                                                        <option value="SOM">Somalia</option>
                                                        <option value="ZAF">South Africa</option>
                                                        <option value="SGS">South Georgia and the South Sandwich Islands</option>
                                                        <option value="SSD">South Sudan</option>
                                                        <option value="ESP">Spain</option>
                                                        <option value="LKA">Sri Lanka</option>
                                                        <option value="SDN">Sudan</option>
                                                        <option value="SUR">Suriname</option>
                                                        <option value="SJM">Svalbard and Jan Mayen</option>
                                                        <option value="SWZ">Swaziland</option>
                                                        <option value="SWE">Sweden</option>
                                                        <option value="CHE">Switzerland</option>
                                                        <option value="SYR">Syrian Arab Republic</option>
                                                        <option value="TWN">Taiwan, Province of China</option>
                                                        <option value="TJK">Tajikistan</option>
                                                        <option value="TZA">Tanzania, United Republic of</option>
                                                        <option value="THA">Thailand</option>
                                                        <option value="TLS">Timor-Leste</option>
                                                        <option value="TGO">Togo</option>
                                                        <option value="TKL">Tokelau</option>
                                                        <option value="TON">Tonga</option>
                                                        <option value="TTO">Trinidad and Tobago</option>
                                                        <option value="TUN">Tunisia</option>
                                                        <option value="TUR">Turkey</option>
                                                        <option value="TKM">Turkmenistan</option>
                                                        <option value="TCA">Turks and Caicos Islands</option>
                                                        <option value="TUV">Tuvalu</option>
                                                        <option value="UGA">Uganda</option>
                                                        <option value="UKR">Ukraine</option>
                                                        <option value="ARE">United Arab Emirates</option>
                                                        <option value="GBR">United Kingdom</option>
                                                        <option value="USA">United States</option>
                                                        <option value="UMI">United States Minor Outlying Islands</option>
                                                        <option value="URY">Uruguay</option>
                                                        <option value="UZB">Uzbekistan</option>
                                                        <option value="VUT">Vanuatu</option>
                                                        <option value="VEN">Venezuela, Bolivarian Republic of</option>
                                                        <option value="VNM">Viet Nam</option>
                                                        <option value="VGB">Virgin Islands, British</option>
                                                        <option value="VIR">Virgin Islands, U.S.</option>
                                                        <option value="WLF">Wallis and Futuna</option>
                                                        <option value="ESH">Western Sahara</option>
                                                        <option value="YEM">Yemen</option>
                                                        <option value="ZMB">Zambia</option>
                                                        <option value="ZWE">Zimbabwe</option>
                                                    </select>
                                                    <div class="invalid-feedback" v-if="formErrors.country">Please a country.</div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group required-field">
                                                    <label class="control-label" for="city">City</label>
                                                    <input class="form-control" :class="[formErrors.city ? 'is-invalid' : '']"  required id="city" name="city" type="text" v-model.trim="formData.city"  aria-describedby="cityHelp"   >
                                                    <div class="invalid-feedback" v-if="formErrors.city">Please a city.</div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group required-field">
                                                    <label class="control-label" for="state">State</label>
                                                    <input class="form-control" :class="[formErrors.state ? 'is-invalid' : '']"  required id="city" name="state" type="text" v-model.trim="formData.state"  aria-describedby="stateHelp"   >
                                                    <div class="invalid-feedback" v-if="formErrors.state">Please a state.</div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group required-field">
                                                    <label class="control-label" for="zip">Zip Code</label>
                                                    <input class="form-control" :class="[formErrors.zip ? 'is-invalid' : '']"  required id="zip" name="zip" type="text" v-model.trim="formData.zip"  aria-describedby="zipHelp"   >
                                                    <div class="invalid-feedback" v-if="formErrors.zip">Please a zip.</div>
                                                </div>
                                            </div>
                                        </div>  -->
                                    </div>
                                    <div class="row">
                                        <h4 class="col-12">Collection </h4>
                                        <div v-if="this.newToken" class="col-sm-6">
                                            <div class="form-group required-field newTokenInput">
                                                <label class="control-label"  for="collection">Collection</label>
                                                <select @change="collectionSelect($event)" id="collection" class="form-control collection-select" required :class="[formErrors.collection ? 'is-invalid' : '']" v-model.trim="formData.collection"  name="collection" >
                                                <option value="makeNewCollection" selected="selected">New Collection</option>
                                                <option v-for="collection in collections" :value="collection">
                                                    {{collection}}
                                                </option>
                                                </select>
                                                <div class="invalid-feedback" v-if="formErrors.collection">Please select your project's collection.</div>
                                                <small id="collectionHelp" class="form-text text-muted">Please select a collection.</small>
                                            </div>
                                        </div>
                
                                        <div v-if="this.newToken" class="col-sm-6 collectionInput">
                                            <div class="form-group">
                                                <label class="control-label" for="collection">Collection Name</label>
                                                <input class="form-control" :class="[formErrors.collectionName ? 'is-invalid' : '']"  id="collectionName" name="collectionName" type="text" v-model.trim="formData.collectionName"  aria-describedby="collectionNameHelp"   >
                                                <div class="invalid-feedback" v-if="formErrors.collectionName">Please your collection's name.</div>
                                                <!-- <small id="adminHelp" class="form-text text-muted">What would you like to call this?</small> -->
                                            </div>
                                        </div>
                                        <div v-else="" class="col-sm-6 collectionInput">
                                            <div class="form-group">
                                                <label class="control-label" for="collection">Collection Name</label>

                                                <h3  for="collection">{{formData.collectionName}} </h3>
                                            </div>
                                        </div>
                                        <div class="col-sm-6 collectionInput">
                                            <div v-if="!formData.collectionPhoto" class="form-group required-field">
                                                <label class="control-label" for="images">Collection Photo</label><br>
                                                <input type="hidden" v-model.trim="formData.collectionPhoto"  class="src">
                                                <img v-bind:class="{ 'd-none': noCollectionImage }" v-bind:src="formData.collectionPhoto" height="200" alt="Image preview...">
                                                <input id="collectionPhoto" :class="[formErrors.collectionPhoto ? 'is-invalid form-control' : '']" name="collectionPhoto" type="file"  @change="previewFile($event)"><br>
                                                <div class="invalid-feedback" v-if="formErrors.collectionPhoto">Please upload a collection image.</div>

                                            </div> 
                                            <div v-else="" class="form-group">
                                                <label class="control-label" for="images">Collection Photo</label><br>
                                                <img v-bind:src="formData.collectionPhoto" height="200" alt="Image preview...">
                                                <input type="hidden" v-model.trim="formData.collectionPhoto"  class="src">
                                                <input id="collectionPhoto" name="collectionPhoto" type="file"  @change="previewFile($event)"><br>
                                            </div> 
                                        </div>
                            
                             
                                  
                                    </div>
                                    <div class="row">
                                        <h4 class="col-12">Owner </h4>
                                        <div class="col-md-6">
                                            <div class="form-group required-field">
                                                <label class="control-label" for="username">Your Username</label>
                                                <input class="form-control" :class="[formErrors.username ? 'is-invalid' : '']" required id="username" name="username" type="text" v-model.trim="formData.username"  aria-describedby="usernameHelp"   >
                                                <div class="invalid-feedback" v-if="formErrors.usernameTaken">This username is already taken, please enter another username.</div>
                                                <div class="invalid-feedback" v-else-if="formErrors.username">Please enter your username.</div>
                                                <small id="usernameHelp" class="form-text text-muted">This will be your public username. </small>
                                            </div>
                                        </div>

                                        <div class="col-sm-6">
                                            <div v-if="!formData.avatar" class="form-group">
                                                <label class="control-label" for="images">Profile Photo</label><br>
                                                <input type="hidden" v-model.trim="formData.avatar"  class="src">
                                                <img v-bind:class="{ 'd-none': noAvatarImage }" v-bind:src="formData.avatar" height="200" alt="Image preview...">
                                                <input id="avatar" name="avatar":class="[formErrors.avatar ? 'is-invalid form-control' : '']"  type="file"  @change="previewFile($event)"><br>
                                                <div class="invalid-feedback" v-if="formErrors.avatar">Please upload profile image.</div>
                                            </div> 
                                            <div v-else="" class="form-group">
                                                <label class="control-label" for="images">Profile Photo</label><br>
                                                <img v-bind:src="formData.avatar" height="200" alt="Image preview...">
                                                <input type="hidden" v-model.trim="formData.avatar"  class="src">
                                                <input id="avatar" name="avatar" type="file"  @change="previewFile($event)"><br>

                                            </div> 
                                        </div>
                                    </div>


                                    <div v-if="!this.newToken" class="row">

                                        <h4 class="col-12">Api Keys </h4>
                                        <div class="col-md-6">
                                            <div class="form-group required-field">
                                                <label class="control-label" for="apiKey">Api Public Key</label>
                                                <input class="form-control" :class="[formErrors.apiKey ? 'is-invalid' : '']" required id="apiKey" name="apiKey" type="text" v-model.trim="formData.apiKey"  aria-describedby="apiKeyHelp"   >
                                                <div class="invalid-feedback" v-if="formErrors.apiKeyTaken">This apiKey is already taken, please enter another apiKey.</div>
                                                <div class="invalid-feedback" v-else-if="formErrors.apiKey">Please enter your apiKey.</div>
                                                <small id="apiKeyHelp" class="form-text text-muted">This is an abbreviation for your coin name. </small>
                                            </div>
                                        </div>

                                        <div class="col-sm-6">
                                            <div class="form-group required-field">
                                                <label class="control-label" for="apiSecret">Api Secret Key</label>
                                                <input class="form-control" :class="[formErrors.apiSecret ? 'is-invalid' : '']" required id="apiSecret" name="apiSecret" type="password" v-model.trim="formData.apiSecret"  aria-describedby="apiSecretHelp"   >
                                                <br/>
                                                <input type="checkbox" @click="showPassword()" class="mr-2">Show Password
                                                <div class="invalid-feedback" v-if="formErrors.apiSecret">Please enter your apiSecret.</div>
                                                <small id="apiSecretHelp" class="form-text text-muted">This is an abbreviation for your coin name. </small>
                                            </div>
                                        </div>
                                    </div>
                                    <deploy v-if="!this.newToken" id="deploy" label="deploy" :networkLabelList="networkLabelList" :networks="formData.networks" :token-symbol="formData.symbol" :token-id="formData.tokenId"></deploy>


                                    
                            
                                    <div class="row" v-if="formData.tokenId == null">
                                        <div class="col-12-md">
                                            <div class="form-group d-none">
                                                <p>
                                                Every token that's created in the UnitedCoin Network 5% goes to Global UNITS and the UnitedCoin Reserve and adds value to UNITS.


                                                </p>
                                        
                                            </div>
                                            <div class="form-group form-check">
                                            <input class="form-check-input" id="terms-agreement" type="checkbox" v-model="formData.agreed">
                                            <label for="terms-agreement" class="form-check-label" :class="[formErrors.agreed ? 'text-danger' : '']">All NFT initial exchange listings allow you to sell your NFT tokens for $1,000,000 for 10% of the NFT. 50% is sent to the NFT creator's spending account. 25% is sent to the NFT reserve account to provide NFT holders with royalties, and 25% is sent to the NFT exchange account to provide liquidity for the NFT market and an ever increasing ownershipPrice floor.</label>
                                            </div>
                                            <div class="form-group form-check">
                                            <input class="form-check-input" id="terms-agreement" type="checkbox" v-model="formData.agreed2">
                                            <label for="terms-agreement" class="form-check-label" :class="[formErrors.agreed2 ? 'text-danger' : '']">Every token that’s created in the UnitedCoin Network 5% goes to Global UNITS and the UnitedCoin Reserve and adds value to UNITS.</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                        <h3 class="charge">Total: $<span class="value">{{parseFloat(mintPrice).toFixed(2)}}</span></h3>
                                        <!-- <p class="text-danger" >An error occured while processing your request. Please check your information and try again, or <a href="/contact">contact support</a> if the error persists.</p> -->
                                        </div>
                                        <div class="col-md-6">
                                        <div class="form-group text-left">
                                            <!-- <a class="btn " href="/account/tokens">Create Revenue Token</a> -->
                                            <button id="submit" v-if="formData.tokenId == null" type="button" class="btn btn-primary"  @click="createToken('new')">
                                            <!-- <button v-if="formData.tokenId == null" type="button" class="btn btn-primary" data-toggle="modal" data-target="#newTokenModal" @click="clickCreateToken()"> -->
                                                Create Coin
                                            </button>
                                            <ajax-button id="submit" v-else type="button" :syncing="syncing" class="btn submit btn-dark" @click="createToken('update')">Save changes</ajax-button>
                                                <input  type="hidden" name="tokenId" v-model="formData.tokenId">
                                                <!-- <input id="tokenId" type="hidden" name="tokenId" > -->
                                                <input type="hidden" name="_csrf" value="<%= _csrf %>" />
                
                                        </div>
                                        </div>
                                    </div>
                            
                                </form>
                                <!-- </form> -->
                                <!-- <div :class="'united-product mint-token '+appToken.shopifyMintProductHandle"> -->

                                <!-- <div :class="'united-token-product mint-token '+appToken.shopifyMintProductHandle">
                                    <div class="  cart"></div>
                                    <input type="hidden" class="shopifyVariantId" value="" >
                                    <input type="hidden" class="productId" value="" >
                                    <input type="hidden" class="title" value="" >
                                    <input type="hidden" class="img" value="" >
                                    <input type="hidden" class="shopifyHandle" value="unitedcoin-61-mint" >
                                    <input type="hidden" class="variantPrice" value="" >
                                    <input type="hidden" class="quantity" value="1" > 
                                </div> -->
                                <div :class="'united-token-product stable-token '+stableToken.shopifyBuyProductHandle">
                                <!-- <div :class="'united-product stable-token '+stableToken.shopifyBuyProductHandle"> -->
                                        <div class="  cart"></div>
                                        <input type="hidden" class="shopifyVariantId" value="" >
                                        <input type="hidden" class="title" value="" >
                                        <input type="hidden" class="img" value="" >
                                        <!-- <input type="hidden" class="shopifyHandle" value="unitedcoin-61-mint" > -->
                                        <input type="hidden" class="variantPrice" value="" >
                                        <input type="hidden" class="quantity" value="10" > 

                                        <input type="hidden" class="tokenId" :value="stableToken.id" >
                                        <input type="hidden" class="productId" :value="stableToken.buyProductId" >
                                        <!-- <input type="hidden" class="accountId" :value="balance.id" > -->
                                        <input type="hidden" class="ownershipPrice" :value="stableToken.ownershipPrice" >
                                        <input type="hidden" class="market" :value="stableToken.market" >
                                        <input type="hidden" class="title" :value="stableToken.name" >
                                        <input type="hidden" class="img" :value="stableToken.logo" >
                                        <input type="hidden" class="shopifyHandle" :value="stableToken.shopifyBuyProductHandle" >
                                        <input type="hidden" class="variantPrice" :value="stableToken.ownershipPrice" >
                                        <input type="hidden" class="type" value="token" >

                                    </div>
                                    <!-- {{defaultCheckout}} -->
                                <!-- <cart-modal id="cart" :environment="environment" checkout-action="mint" :default-checkout="defaultCheckout" product-class="united-product" shop-slug="unitedcoin"  shop="unitedcoin.myshopify.com" storefront-access-token="57eb127019ea45acfe87f917fe00ac3f"></cart-modal> -->
                                <token-cart-modal id="token-cart" :environment="environment" checkout-action="mint" :default-checkout="defaultCheckout"  :payment-methods="[]" product-class="united-token-product" shop="unitedcoin.myshopify.com" storefront-access-token="57eb127019ea45acfe87f917fe00ac3f"></token-cart-modal>

                                
                                <ajax-form action="createToken" :syncing.sync="syncing" :cloud-error.sync="cloudError" @submitted="createdToken($event)" :handle-parsing="createToken">
                                <!-- Modal -->
                                <div class="modal fade" id="newTokenModal" tabindex="-1" role="dialog" aria-labelledby="newTokenModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="newTokenModalLabel">Create Coin</h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <div class="modal-body">
                                            <!-- <form action="createToken" :syncing.sync="syncing" :cloud-error.sync="cloudError" @submitted="submittedForm($event)" :handle-parsing="handleParsingForm"> -->
                                                <div class="form-group name">
                                                    <label class="control-label" for="name">Name</label>
                                                    <h4 class="value">{{formData.name}}</h4>
                                                    <input type="hidden" name="name" v-model="formData.name">
                                                </div>
                                                <div class="form-group symbol">
                                                    <label class="control-label" for="symbol">Symbol</label>
                                                    <h4 class="value">{{formData.symbol}}</h4>
                                                    <input type="hidden" name="symbol"v-model="formData.symbol" >
                                                </div>
                                                <div class="form-group description">
                                                    <label class="control-label" for="description">Description</label>
                                                    <h4 class="value">{{formData.description}}</h4>
                                                    <input type="hidden" name="description" v-model="formData.description">
                                                </div>
                                                <div class="form-group revenueToken icoTargetGoal">
                                                    <label class="control-label" for="commission">Crowdfunding Goal</label>
                                                    <h4 class="value">$ {{formData.icoTargetGoal.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",")}}</h4>
                                                    <input type="hidden" name="icoTargetGoal" v-model="formData.icoTargetGoal">
                                                </div>
                                                <div class="form-group revenueToken commission">
                                                    <label class="control-label" for="commission">Initial Revenue Offering</label>
                                                    <h4 ><span class="value">{{formData.commission}}</span>% of Revenue</h4>
                                                    <input type="hidden" name="commission" v-model="formData.commission">
                                                </div>
                                                <div class="form-group stableToken stableFund">
                                                    <label class="control-label" for="commission">Stable Coin Backing</label>
                                                    <h4><span class="value">{{formData.stableFund}}</span> USD</h4>
                                                    <input type="hidden" name="commission" v-model="formData.commission">
                                                </div>
                                                <div class="form-group">
                                                    <label class="control-label" for="charge">Total Charge</label>
                                                    <h4 class="charge">$<span class="value">{{parseFloat(mintPrice).toFixed(2)}}</span></h4>
                                                </div>
                                                <!-- <input type="hidden" name="tokenId" v-model="formData.tokenId"> -->
                                            
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                            <!-- <button type="button" class="btn btn-primary">Deploy Token</button> -->
                                            <!-- {{syncing}} -->
                                            <ajax-button type="button" :syncing="syncing" class="btn btn-primary mint" @click="mint('create')">Create Coin</ajax-button>

                                            <input type="hidden" name="_csrf" value="<%- _csrf %>" />
                                            

                
                                        </div>
                                        </div>
                                    </div>
                                    </div>
                                </ajax-form>
                
                            </div>
                            
                                
                            
                                
                                
                        </div>
                
                    </div>
                </div>
                
                
                </div>
        

    

    </div>
      
    `,
    // <tr v-for="market in markets" :id="market.id" v-if="market && market.sellCurrencyId && !market.sellCurrencyId.buyCurrency && market.sellCurrencyId.icoOrder && (!market.sellCurrencyIndexToken && !type || market.sellCurrencyIndexToken && type) && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" >
    //
    //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
    //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
    //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
    beforeMount: async function() {
        // Attach any initial data from the server.
        this.tokenId = this.$route.params.tokenId;
        this.userType = this.$route.params.userType;
        this.subaction = this.$route.params.subaction;

          // _.extend(this, YOH_SHOW_LOCALS);
          _.extend(this, YOH_SHOW_LOCALS);

          

        await this.listen();  
        

    },
    mounted: async function() {


    
       
      },



    //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
    //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
    //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
    methods: {
        networkCurrency : function() {
            var networkCurrency =  $("#networkCurrency").attr("selected");
            if(networkCurrency){
                $(".networkCurrency").show();
            }else {
                $(".networkCurrency").hide();
            }

        },
        
        
        showPassword : function () {
            var x = document.getElementById("apiSecret");
            if (x.type === "password") {
              x.type = "text";
            } else {
              x.type = "password";
            }
        },

      init: function () {
         // Set the form data.
        // Set the form data.
        // this.formData.address = this.token.contract.id;
        var Mint = this;
        var appToken =  this.appToken;
        console.log("appToken",appToken);
        this.formData.tokenId = this.exchangeToken ? this.exchangeToken.id : null ;
        this.formData.default_account = this.default_account;
        // this.formData.tokenId = 11;
        this.formData.libraryId = this.token.libraryId;
        this.formData.networks = this.token.tokenBookConfigs;
        this.formData.name = this.token.name;
        this.formData.symbol = this.token.symbol;
        this.formData.description = this.token.description;
        this.formData.stableToken = this.token.stableToken;
        this.formData.icoTargetGoal = this.token.icoTargetGoal? this.token.icoTargetGoal:10000;
        this.formData.commission = this.token.commission? this.token.commission : 10;
        this.formData.green = this.token.green;
        this.formData.logo = this.token.logo;
        this.formData.twitter = this.token.twitter;
        this.formData.website = this.token.website;
        this.formData.phone = this.token.phone;
        this.formData.instagram = this.token.instagram;
        this.formData.phone = this.token.phone;

        this.formData.tetherTokenSymbol = this.token.tetherTokenSymbol;
        this.formData.tetherCommission = this.token.tetherCommission;
        this.formData.tetherNetwork = this.token.tetherNetwork;
        this.formData.tetherTokenTotalSupply = this.token.tetherTokenTotalSupply;
        this.formData.tetherDepositPhoneOrAddress = this.token.tetherDepositPhoneOrAddress;
        this.formData.networkCurrency = this.token.networkCurrency;
        
        this.formData.username = this.username;
        this.formData.collection = this.token.collection ? this.token.collection : this.collection;
        this.formData.collectionPhoto = this.token.collectionPhoto ? this.token.collectionPhoto : this.collectionPhoto;
        this.formData.logo = this.token.logo;
        this.formData.ownershipPrice = this.token.ownershipPrice;
        this.formData.ownershipForSell = this.token.ownershipForSell;

        this.formData.websiteSubscription = this.token.websiteSubscription;
        this.formData.debitCard = this.token.debitCard;

        this.formData.avatar = this.avatar;
        this.noAvatarImage = this.formData.avatar == '' || this.formData.avatar == undefined;


        
        
        this.noLogoImage = this.token.logo == '' || this.token.logo == undefined;
        this.noCollectionImage = this.formData.collectionPhoto == '' || this.formData.collectionPhoto == undefined;
        
        this.formData.stableFund = 10;

        this.formData.stableToken = true;
        this.formData.revenueToken = true;
        this.newToken = this.formData.tokenId ? false: true;

        this.formData.publicAttributes = this.token.publicAttributes ? JSON.parse(this.token.publicAttributes) : [];
        this.formData.privateAttributes = this.token.privateAttributes ? JSON.parse(this.token.privateAttributes) : [];

        this.formData.apiKey = this.app ? this.app.apiKey : "";
        this.formData.apiSecret = this.app ? this.app.apiSecret: "";


        if(this.newToken){
            this.formData.collection = "makeNewCollection";
        }else{
            this.formData.collectionName = this.token.collection ? this.token.collection : this.collection ;

            $(".newTokenInput").hide();
        }
        

        
        console.log("this.token.logo ",this.token.logo );
        console.log("this.noLogoImage ",this.noLogoImage );
        setTimeout(function(){ 
            Mint.bindUIAction();
        }, 30);

        

        
      },
      listen: async function() {
        // The auto-connecting socket is exposed as `io.socket`.
  
        // Use `io.socket.on()` to listen for the 'hello' event:
        // io.socket.on(this.market.id, function (data) {
        //   console.log('Socket `' + data.id + '` joined the party!');
        // });
        var Account = this;
      
        //show loading// syincing
        this.loadingComponent = true;
        // $(".market .market-pg").hide().addClass("d-none");
        // $(".market .loading").show().removeClass("d-none");
        // get market 
        
        // var data =  await Cloud.getAccount.with({tradeType:this.tradeType,symbol:this.symbol})
        // .tolerate(()=>{
        //   this.cloudLoadingError = true;
        // });
  
        // if(data.flag){
        //   _.extend(this, data);
        //   this.loadingComponent = false;
  
        // }else if(data.mustLogin){
        //   window.location.href = data.redirect;
        // } else{
        //   this.loadingComponent = false;
        // }

        // var csrf = await CSRF.token();
        // var apiRequestHeader = {
        //     'X-CSRF-Token':csrf._csrf,
        //       // 'cookie':cookie
        //   };
        $.ajax({
              type: "POST",
            //   url: this.refreshUrl+"/markets/orders/cancel",
            // url: '/api/account',
            url: '/wp-json/yohshow/api/v1/mint/overview',

            data: {tokenId:this.tokenId,action:this.action,subaction:this.subaction},
            //   headers:apiRequestHeader,
              success:  function(resData, textStatus, request)
              {
                  resData = JSON.parse(resData);

                  if(resData.flag){
                      _.extend(Account, resData);
                      Account.loadingComponent = false;
                      Account.init();
          
                    }else if(resData.mustLogin){
                      // window.location.href = resData.redirect;
                      Account.$router.push(resData.redirect);

                    } else{
                      Account.loadingComponent = false;
                    }
  
              }
            });

  
      },
      bindUIAction: async function(e) {
        this.categorySelect();
        var baseCharge = this.baseCharge;
        // $(".stableToken").hide();
        // $(".revenueToken").hide();
        var Mint = this;
        $('input[type=radio][name=revenueToken]').change(function() {
            if (this.value == 'true') {
                $(".revenueToken").css("display","block");
  
            }
            else if (this.value == 'false') {
                $(".revenueToken").css("display","none");
            }
        });
        $('input[type=radio][name=stableToken]').change(function() {
          if (this.value == 'true') {
              $(".stableToken").css("display","block");
  
          }
          else if (this.value == 'false') {
              $(".stableToken").css("display","none");
  
              $(".charge .value").html(baseCharge.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ","));
          }
        });
        jQuery('input[type=radio][name=networkCurrency]').change(function() {
            // alert("test");
            if (this.value == 'true') {
                jQuery(".networkCurrency").css("display","block");
                Mint.formData.networkCurrency = true;
  
            }
            else if (this.value == 'false') {
                jQuery(".networkCurrency").css("display","none");
                Mint.formData.networkCurrency = false;

            }
        });
        $(".mint").off("click").on("click", async function(event) {
          //set action
          event.preventDefault();
          Mint.syncing = true;
          console.log("mint click Mint.syncing ",Mint.syncing);
          $(".mint").attr("disabled","disabled");
        //   Mint.mint("#updateToken");
            await Mint.mint("create");

        });
  
        $('#stableFund').change(function() {
          var stableFund = parseFloat(this.value);
          var totalCharge = baseCharge + stableFund;
          totalCharge = totalCharge.toFixed(2);
          console.log("totalCharge",totalCharge);
          $(".charge .value").html(totalCharge.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ","));
        });
        
          
  
  
      },
      createdToken: async function(resData){
        // resData = JSON.parse(resData);
          var Mint = this;
        //   // var token =  $(form_id).serializeArray();
        //   // token = CSRF.objectifyForm(token);
        //   var token = Mint.formData;
        //   // var isStableToken = $("input[name='stableToken']:checked"). val();
        //   var isStableToken = token.stableToken;
        //   console.log("mint isStableToken",isStableToken)
        //   if(isStableToken == "true"){
        //     // var stableFund =  $("#stableFund").val();
        //     var stableFund =  token.stableFund;
        //   }else{
        //     var stableFund = 0;
        //   }
        //   console.log("mint pre parse stableFund",stableFund);
  
        //   stableFund = parseFloat(stableFund);
        //   console.log("mint post parse stableFund",stableFund);
  
        //   if(stableFund < 10){
        //     stableFund = 10;
        //   }
        //   console.log("mint stableFund",stableFund);
        //   $(".stable-token .quantity").val(stableFund);
        //   $(form_id+" .submit").attr("disabled","disabled");

        //   if(resData.flag){
          if(resData.success){
            // $(".stable-token .cart").click();
            // $(".mint-token .cart").click();
            var token = resData.token;
            console.log("mint token",token);
            console.log("mint token.id",token.id);
            $(".checkout-external-token-id").val(token.id);
            // window.location.href = "/markets/"+token.market;
            var uploadResult = await this.uploadFiles();
            Mint.syncing = true;
            // if(false){
            // // if(uploadResult.success){
            //     setTimeout(function(){ $(".stable-token .cart" ).click(); }, 10);
            //     setTimeout(function(){ $(".checkout").click(); }, 30);
            //     Mint.syncing = true;
            // }else{
            //     Mint.cloudError = "Error uploading file.";
            //     Mint.syncing = false;
            // }
            
            
            

  
          // 
          }else if(resData.symbolTaken){
            $("#newTokenModal").modal("hide");
            Mint.formErrors.symbolTaken = true;
            Mint.formErrors.symbol = true;
            Mint.syncing = false;
            $([document.documentElement, document.body]).animate({
                scrollTop: $("#symbol").offset().top -200
            }, 2000);
            $(".mint").removeAttr("disabled");
  
  
  
          }else if(resData.usernameTaken){
            $("#newTokenModal").modal("hide");
            Mint.formErrors.usernameTaken = true;
            Mint.formErrors.username = true;
            Mint.syncing = false;
            $([document.documentElement, document.body]).animate({
                scrollTop: $("#username").offset().top -200
            }, 2000);
            $(".mint").removeAttr("disabled");
  
  
  
          }
         

  
  
      },
      uploadFiles: async function(action = "create") {
        let formData = new FormData();
        let photo = document.getElementById("logo") ? document.getElementById("logo").files : false;
        if(photo){
            formData.append("photo", photo[0]);
        }

        let collectionPhoto = document.getElementById("collectionPhoto") ? document.getElementById("collectionPhoto").files : false;

        if(collectionPhoto){
            formData.append("collectionPhoto", collectionPhoto[0]);
        }

        let avatar = document.getElementById("avatar") ? document.getElementById("avatar").files : false;
        if(avatar){
            formData.append("avatar", avatar[0]);
        }

        // fetch('/wp-json/yohshow/api/v1/mint/upload', {method: "POST", body: formData}).then((response) => {
        //     return response.json();
        //   })
        //   .then((myJson) => {
        //     // console.log(myJson);
        //     myJson = JSON.parse(myJson);
        //     if(myJson.success){
        //         if(action == "create"){
        //             setTimeout(function(){ $(".stable-token .cart" ).click(); }, 10);
        //             setTimeout(function(){ $(".checkout").click(); }, 30);
        //             // setTimeout(function(){ $("#newTokenModal").modal("hide"); }, 30000);

        //         }
                


        //     }
            
        //   });

        var response = await fetch('/wp-json/yohshow/api/v1/mint/upload', {method: "POST", body: formData});
        var myJson = await response.json();
        myJson = JSON.parse(myJson);
        if(myJson.success){
            if(action == "create"){
                setTimeout(function(){ $(".stable-token .cart" ).click(); }, 10);
                setTimeout(function(){ $(".checkout").click(); }, 30);
                // setTimeout(function(){ $("#newTokenModal").modal("hide"); }, 30000);

            }
        }


        


        // var file = document.getElementById('logo').files[0]; //Files[0] = 1st file
        // var reader = new FileReader();
        // reader.readAsText(file, 'UTF-8');
        // reader.onload = this.shipOff;

        // reader.onloadstart = ...
        // reader.onprogress = ... <-- Allows you to update a progress bar.
        // reader.onabort = ...
        // reader.onerror = ...
        // reader.onloadend = ...
        return {
            success:true,
        }
      },

      shipOff:  function(event) {
        var Mint = this;
        var result = event.target.result;
        var fileName = document.getElementById('logo').files[0].name; //Should be 'picture.jpg'
        $.post('/wp-json/yohshow/api/v1/mint/upload', { data: result, name: fileName }, Mint.continueSubmission);
      },
      continueSubmission:  function(event) {
        return event;
      },
      previewFile: async function(e) {
        console.log('event',e);
        // var preview = document.querySelector('img');
        // var file    = document.querySelector('input[type=file]').files[0];
        // var preview = document.querySelector('img');
        var parent = $(e.target).parent();
        var image = parent.find('img');
        var src = parent.find('.src');
        console.log('parent',parent);
        console.log('image',image);
        console.log('src',src);
        
        // var preview    = $(e.target).parent().find('img');
        var file    = e.target.files[0];
        // console.log(preview,file);
        var reader  = new FileReader();
      
        reader.addEventListener("load", function () {
          if(reader.result){
            console.log(reader.result,reader.result);
            image.attr('src',reader.result);
            src.attr('value',reader.result);
            // src.val(reader.result);
            src.text(reader.result);
            src.change();
            image.removeClass('d-none');
          }
          
        }, false);
        if (file) {
          reader.readAsDataURL(file);
        }
  
      },
      collectionSelect: async function(e) {
  
        //   $('#collection').change(function() {
                var collectionName = $(e.target).val();

            if(collectionName == "makeNewCollection"){
                $(".collectionInput").show();
            }else{
                $(".collectionInput").hide();
            }

        //   });
  
  
        
      },
      categorySelect: async function() {
  
        $( ".category-select" ).change(function(e) {
          var catergoryId = $(e.target).val();
          console.log("catergoryId",catergoryId);
          $(".subcategory-select .category-group").css("display","none");
          $(".subcategory-select ."+catergoryId).css("display","block");
          $(".subcategory-select").val("");
          var length = $(".subcategory-select ."+catergoryId +" option").length;
          console.log("catergoryId length",length);
  
          if(length > 0){
            $(".subcategory-box").css("display","block");
          }else{
            $(".subcategory-box").css("display","none");
          }
  
  
  
        });
        
      },
      clickCreateToken: async function() {
  
        // Redirect to the account page on success.
        // > (Note that we re-enable the syncing state here.  This is on purpose--
        // > to make sure the spinner stays there until the page navigation finishes.)
        console.log('test submittedForm');
        var name = $("#name").val();
        console.log('test submittedForm name',name);
  
        var symbol = $("#symbol").val();
        var description = $("#description").val();
        var stableFund = $("#stableFund").val();
        var icoTargetGoal = $("#icoTargetGoal").val();
        var commission = $("#commission").val();
        $("#newTokenModal .name input").val(name);
        $("#newTokenModal .name .value").html(name);
        $("#newTokenModal .symbol input").val(symbol);
        $("#newTokenModal .symbol .value").html(symbol);
        $("#newTokenModal .description input").val(description);
        $("#newTokenModal .description .value").html(description);
  
        $("#newTokenModal .stableFund input").val(stableFund);
        $("#newTokenModal .stableFund .value").html(stableFund);
        $("#newTokenModal .icoTargetGoal input").val(icoTargetGoal);
        $("#newTokenModal .icoTargetGoal .value").html(icoTargetGoal);
        $("#newTokenModal .commission input").val(commission);
        $("#newTokenModal .commission .value").html(commission);
        console.log("commission",commission);
        // this.syncing = true;
        // window.location = '/account';
      },
      submittedForm: async function(data) {
        // Redirect to the account page on success.
        // > (Note that we re-enable the syncing state here.  This is on purpose--
        // > to make sure the spinner stays there until the page navigation finishes.)
        console.log('test submittedForm',data);
        window.location = "/account/tokens/"+this.formData.tokenId;
        // window.location = '/account';
      },
      createdToken_old: async function(data) {
        /*
            save token id with checkout form and then checkout
            aka just call mint
        */
        console.log('test createToken',data);
        if(data.success){
          // window.location = "/account/tokens/"+data.token.id;
        this.syncing = true;
          console.log("upload images");
          this.uploadImages(data.token);
        }
        // this.syncing = true;
        // window.location = '/account';
      },
      uploadImages: async function(token) {
        $("#tokenId").val(token.id);
        $("#updateToken").attr("action","/token/upload/"+token.id);
        document.getElementById("updateToken").submit();
        return ;
        var formData = new FormData();
  
        formData.append("token", token.id); // number 123456 is immediately converted to a string "123456"
  
        // HTML file input, chosen by user
        formData.append("userfile", $("#logo").files[0]);
  
  
        var request = new XMLHttpRequest();
        request.open("POST", "/token/upload");
        request.send(formData);
      },
      createToken: async function(state) {
        // Clear out any pre-existing error messages.
        this.formErrors = {};
        this.handleParsingAddressForm();
  
  
        var argins = this.formData;
        /*
            add...
            sellOwnership //
                if yes  //
                ownershipPrice //
            collection 
                if collection == "makeNewCollection"
                    collectionName
                    collectionPhoto
            photo
        */
       var logo = $("#logo").val();
       var collectionPhoto = $("#collectionPhoto").val();
       
       if(!argins.ownershipForSell){
        this.formErrors.ownershipForSell = true;
       }
       if(argins.ownershipForSell == "yes"){
        if(!argins.ownershipPrice){
            this.formErrors.ownershipPrice = true;
        }
       }

       
  
        // // Validate address:
        if(!argins.description) {
          this.formErrors.description = true;
        }
        // // Validate symbol:
        if(!argins.symbol) {
          this.formErrors.symbol = true;
        }
        // // Validate symbol:
        if(!argins.name) {
          this.formErrors.name = true;
        }

        if(!argins.tokenId){
            if(!logo){
                this.formErrors.logo = true;
            }
            if(!argins.collection){
                this.formErrors.collection = true;
            }
            if(argins.collection == "makeNewCollection"){
                if(!argins.collectionName){
                    this.formErrors.collectionName = true;
                }
                if(!collectionPhoto){
                    this.formErrors.collectionPhoto = true;
                }
            }
            // Validate country:
         if(!argins.country) {
            this.formErrors.country = true;
          }
          // Validate address:
          if(!argins.address) {
            this.formErrors.address = true;
          }
          // Validate city:
          if(!argins.city) {
            this.formErrors.city = true;
          }
          // Validate state:
          if(!argins.state) {
            this.formErrors.state = true;
          }
          // Validate zip:
          if(!argins.zip) {
            this.formErrors.zip = true;
          }
    
          // Validate street_number:
          if(!argins.street_number) {
            this.formErrors.street_number = true;
          }
          // Validate route:
          if(!argins.route) {
            this.formErrors.route = true;
          }
          // Validate locality:
          if(!argins.locality) {
            this.formErrors.locality = true;
          }
          // Validate administrative_area_level_1:
          if(!argins.administrative_area_level_1) {
            this.formErrors.administrative_area_level_1 = true;
          }
          // Validate postal_code:
          if(!argins.postal_code) {
            this.formErrors.postal_code = true;
          }
    
          // Validate agreed:
          if(!argins.agreed) {
            this.formErrors.agreed = true;
          }
    
          // Validate agreed2:
          if(!argins.agreed2) {
            this.formErrors.agreed2 = true;
          }
        //   //other validation
          if(!$( "#logo" ).val()) {
            this.formErrors.logo = true;
          }
          if(!$( "#avatar" ).val() && !argins.avatar) {
            this.formErrors.avatar = true;
          }
          if(argins.collection == "makeNewCollection" && !$( "#collectionPhoto" ).val()) {
            this.formErrors.collection = true;
          }


        }
  
         

         // get attrributes:
        //  if(false) {
         if(true) {
            var publicAttributes = [];
            $( "#publicAttributes-attributes .attribute .value" ).each(function() {
                var key =  $( this ).find( ".key" ).val();
                var meta =  $( this ).find( ".meta" ).val();
                var metaType =  $( this ).find( ".metaType" ).val();
                var publicAttribute = {};
                publicAttribute[key] = meta;
                publicAttribute['meta'] = meta;
                publicAttribute['key'] = key;
                publicAttribute['metaType'] = metaType;
                publicAttributes.push(publicAttribute);
              });
            argins.publicAttributes = publicAttributes;
            this.formData.publicAttributes = JSON.stringify(publicAttributes);
            
            var privateAttributes = [];
            $( "#privateAttributes-attributes .attribute .value" ).each(function() {
                var key =  $( this ).find( ".key" ).val();
                var meta =  $( this ).find( ".meta" ).val();
                var metaType =  $( this ).find( ".metaType" ).val();
                var privateAttribute = {};
                privateAttribute[key] = meta;
                privateAttribute['meta'] = meta;
                privateAttribute['key'] = key;
                privateAttribute['metaType'] = metaType;
                privateAttributes.push(privateAttribute);
              });
            argins.privateAttributes = privateAttributes;
            this.formData.privateAttributes = JSON.stringify(privateAttributes);
              
          }
  
        console.log("createToken this.formErrors",this.formErrors);
        // // If there were any issues, they've already now been communicated to the user,
        // // so simply return undefined.  (This signifies that the submission should be
        // // cancelled.)
        if (Object.keys(this.formErrors).length > 0) {
          return;
        }else{
            if(!argins.tokenId){
        //   if(state == "new"){
                $("#newTokenModal").modal("show");
            }else{
                // $("#submit").click();
                await this.updateToken();
    
            }
        }
  
        return argins;
      },
      updateToken: async function() {
            var Mint = this;

            await Mint.mint("update");

  
      },
      mint: async function(action) {
        // The auto-connecting socket is exposed as `io.socket`.
  
        // Use `io.socket.on()` to listen for the 'hello' event:
        // io.socket.on(this.market.id, function (data) {
        //   console.log('Socket `' + data.id + '` joined the party!');
        // });
        var Account = this;
        Account.syncing = true;
      
        //show loading// syincing
        // this.loadingComponent = true;
        // $(".market .market-pg").hide().addClass("d-none");
        // $(".market .loading").show().removeClass("d-none");
        // get market 
        
        // var data =  await Cloud.getAccount.with({tradeType:this.tradeType,symbol:this.symbol})
        // .tolerate(()=>{
        //   this.cloudLoadingError = true;
        // });
  
        // if(data.flag){
        //   _.extend(this, data);
        //   this.loadingComponent = false;
  
        // }else if(data.mustLogin){
        //   window.location.href = data.redirect;
        // } else{
        //   this.loadingComponent = false;
        // }
        var theData = this.formData;

        if(action == "create"){
            var url = '/wp-json/yohshow/api/v1/mint';
        }else if(action == "update"){
            var url = '/wp-json/yohshow/api/v1/mint/update';
        }

        // var csrf = await CSRF.token();
        // var apiRequestHeader = {
        //     'X-CSRF-Token':csrf._csrf,
        //       // 'cookie':cookie
        //   };
        $.ajax({
              type: "POST",
            //   url: this.refreshUrl+"/markets/orders/cancel",
            // url: '/api/account',
            url: url,

            data: theData,
            //   headers:apiRequestHeader,
              success: async function(resData, textStatus, request)
              {
                  resData = JSON.parse(resData);

                  if(resData.success){
                    if(action == "create"){
                        await Account.createdToken(resData);
                    }else if(action == "update"){
                        //   _.extend(Account, resData);
                      Account.cloudError =  "";
                      var uploadResult = await Account.uploadFiles(action);
                      Account.syncing = true;
                      location.href = resData.redirectUrl;
                    }
                    


          
                    }else {
                        Account.cloudError =  resData.error;
                    }
  
              }
            });

  
      },
      handleParsingAddressForm: function() {
  
        this.formData.address = this.formData.street_number + " "+this.formData.route;
        this.formData.city = this.formData.locality;
        this.formData.state = this.formData.administrative_area_level_1;
        this.formData.zip = this.formData.postal_code;
        this.formData.unit = this.formData.address2;
  
      },
      handleParsingForm: function() {
        // Clear out any pre-existing error messages.
        this.formErrors = {};
        // this.handleParsingAddressForm();
  
  
        var argins = this.formData;
  
        var commission = argins.commission;
        if(commission > 100 || commission <= 10){
            return false;
            this.formErrors.commission = true;
        }
       
        // // Validate name:
        // if(!argins.fullName) {
        //   this.formErrors.fullName = true;
        // }
  
        // // Validate email:
        // if(!argins.emailAddress) {
        //   this.formErrors.emailAddress = true;
        // }
  
        // // If there were any issues, they've already now been communicated to the user,
        // // so simply return undefined.  (This signifies that the submission should be
        // // cancelled.)
        if (Object.keys(this.formErrors).length > 0) {
          return;
        }
  
        return argins;
      },


      }



  });

});

