/**
 * <orders>
 * -----------------------------------------------------------------------------
 * orders.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */
 jQuery(document).ready(function( $ ) {


	Vue.component('orders', {
  

    //  ╔═╗╦═╗╔═╗╔═╗╔═╗
    //  ╠═╝╠╦╝║ ║╠═╝╚═╗
    //  ╩  ╩╚═╚═╝╩  ╚═╝
    props: [
      // 'markets',// « The JS timestamp to format
      // 'buyCurrency',
      // 'type',
    ],

    //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
    //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
    //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
    data: function (){
      return {
        // Main syncing/loading state for this page.
        syncing: false,

        // Form data
        formData: { /* … */ },

        // For tracking client-side validation errors in our form.
        // > Has property set to `true` for each invalid property in `formData`.
        formErrors: { /* … */ },

        // A set of validation rules for our form.
        // > The form will not be submitted if these are invalid.
        formRules: {
        },

        // Server error state for the form
        cloudError: '',

        isSuperAdmin:'',
        exchangeError:'',
        error:{},
        shareLink:"",
        orders:[],
        pendings:[],
        closedCheckouts:[],
        checkoutsWithQuotes:[],
        assets:[],
        openCheckouts:[],
        openTrades:[],
        trades:[],
        referrals:[],
        payments : [],
        deposits : [],
        unpaidWithdrawPayments : [],
        unpaidWithdrawPaymentsCrypto : [],
        paidWithdrawPayments : [],
        paidWithdrawPaymentsCrypto : [],
        redeemedCheckouts : [],
        unRedeemedCheckouts : [],


        loadingOrders: true,
        cloudLoadingError: '',
      };
    },

    /*
                    (type && market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
                  || (type && market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
    */

    //  ╦ ╦╔╦╗╔╦╗╦
    //  ╠═╣ ║ ║║║║
    //  ╩ ╩ ╩ ╩ ╩╩═╝
    template: `
    <div class="orders-component">
        <div v-if="loadingOrders" class="text-center">
            <h1>Your orders are being loaded...</h1>
            <ajax-button type="submit" :syncing="loadingOrders" class="btn btn-primary mint">Refesh</ajax-button>
        </div>
        <div v-else="">
            <div class="container">
                <!-- {{orders}}   -->
                <!-- {{referrals}}   -->
                <!-- {{shareLink}} -->
                <!-- {{pendings}} -->
                <div class="row mb-3">
                <div class="col-md-12 mb-5">
                    <h2 class="text-center mb-3 ">My Orders</h2>
                </div>
                <div class="col-md-12 mb-5">
                    <ajax-form action="refreshPayments" :syncing.sync="syncing" :cloud-error.sync="cloudError" :form-data="formData" :form-rules="formRules" :form-errors.sync="formErrors" @submitted="submittedForm($event)">

                    <ajax-button v-if="isSuperAdmin"  :syncing="syncing" class="btn-danger btn-lg btn-block submit-btn"  >Refresh</ajax-button>

                    </ajax-form>
                </div>


                <div class="col-md-12">
                    <div class="col-md-12">
                            <ul class="nav nav-tabs mb-0" id="myTab" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link active" id="open-trades-tab" data-toggle="tab" href="#open-trades" role="tab" aria-controls="open-orders" aria-selected="true">Open Orders</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" id="all-trades-tab" data-toggle="tab" href="#all-trades" role="tab" aria-controls="all-trades" aria-selected="true">Trade History</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" id="closed-orders-tab" data-toggle="tab" href="#closed-orders" role="tab" aria-controls="closed-orders" aria-selected="true">Closed Orders</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" id="subscriptions-tab" data-toggle="tab" href="#subscriptions" role="tab" aria-controls="subscriptions" aria-selected="true">Subscriptions</a>
                                </li>
                                <!-- <li class="nav-item">
                                    <a class="nav-link" id="all-schedules-tab" data-toggle="tab" href="#all-schedules" role="tab" aria-controls="all-schedules" aria-selected="true">Debit Card</a>
                                </li> -->
                                <!-- <li class="nav-item">
                                    <a class="nav-link" id="my-schedules-tab" data-toggle="tab" href="#my-schedules" role="tab" aria-controls="my-schedules" aria-selected="true">Referrals</a>
                                </li> -->
                                <li v-if="isSuperAdmin" class="nav-item">
                                    <a class="nav-link" id="payments-tab" data-toggle="tab" href="#payments" role="tab" aria-controls="payments" aria-selected="true">Payments</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" id="deposits-tab" data-toggle="tab" href="#deposits" role="tab" aria-controls="deposits" aria-selected="true">Deposits</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" id="withdrawPayments-tab" data-toggle="tab" href="#withdrawPayments" role="tab" aria-controls="withdrawPayments" aria-selected="true">Withdraws</a>
                                </li>
                                <!-- <li class="nav-item">
                                    <a class="nav-link" id="withdrawPaymentsCrypto-tab" data-toggle="tab" href="#withdrawPaymentsCrypto" role="tab" aria-controls="withdrawPaymentsCrypto" aria-selected="true">Withdraw Crypto Payments</a>
                                </li> -->
                                <li v-if="isSuperAdmin" class="nav-item">
                                    <a class="nav-link" id="checkouts-tab" data-toggle="tab" href="#checkouts" role="tab" aria-controls="checkouts" aria-selected="true">Checkouts</a>
                                </li>

                                <li v-if="isSuperAdmin" class="nav-item">
                                    <a class="nav-link" id="kyc-info-tab" data-toggle="tab" href="#kyc-info" role="tab" aria-controls="kyc-info" aria-selected="true">Checkouts</a>
                                </li>
                                
                            
                                
                                
                            </ul>
                            <div class="tab-content" id="myTabContent">
                                <div class="tab-pane  show active" id="open-trades" role="tabpanel" aria-labelledby="open-trades-tab">
                                    <br>
                                    <!-- {{openCheckouts}} -->
                                    <h3 class="">Open Checkouts</h3>
                                    <checkouts-table  :checkouts="openCheckouts"></checkouts-table>
                                    <h3 class="">Open Trades</h3>
                                    <open-orders-table  :orders="openTrades"></open-orders-table>
                                </div>
                                <div class="tab-pane " id="all-trades" role="tabpanel" aria-labelledby="all-trades-tab">
                                    <br>
                                    <trade-history-table :market-filter="[]"  :trades="trades" tradeType="order"> </trade-history-table>
                                </div>
                                <div class="tab-pane " id="closed-orders" role="tabpanel" aria-labelledby="closed-orders-tab">
                                    <br>
                                    <h3 class="">Closed Orders</h3>
                                    <checkouts-table  :checkouts="closedCheckouts"></checkouts-table>
                                </div>
                                <div class="tab-pane " id="subscriptions" role="tabpanel" aria-labelledby="subscriptions-tab">
                                    <br>
                                        <h3>Active</h3>
                                        <subscription-table :subscriptions="subscriptions" status="active" ></subscription-table>
                                        <h3>Paused</h3>
                                        <subscription-table :subscriptions="subscriptions" status="paused" ></subscription-table>
                                </div>

                                <div class="tab-pane " id="all-schedules" role="tabpanel" aria-labelledby="all-schedules-tab">
                                    <br>
                                    <card-order-table  id="card-orders" :orders="orders" viewType="approve" ></card-order-table>
                                </div>
                                <div class="tab-pane " id="my-schedules" role="tabpanel" aria-labelledby="my-schedules-tab">
                                    <br>
                                    <referral-table  id="referrals-orders" :referrals="referrals" viewType="approve" ></referral-table>
                                </div>
                                <div class="tab-pane " id="payments" role="tabpanel" aria-labelledby="payments-tab">
                                    <br>
                                        <h3>Pendings</h3>
                                        <payment-table :payments="pendings" :assets="assets" ></payment-table>
                                        <h3>Complete</h3>
                                        <payment-table :payments="payments" :assets="assets" ></payment-table>
                                </div>
                                <div class="tab-pane " id="deposits" role="tabpanel" aria-labelledby="deposits-tab">
                                    <br>
                                        <h3>Pendings</h3>
                                        <payment-table :payments="[]" :assets="assets" ></payment-table>
                                        <h3>Complete</h3>
                                        <payment-table :payments="deposits" :assets="assets" ></payment-table>
                                </div>
                                <div class="tab-pane " id="withdrawPayments" role="tabpanel" aria-labelledby="withdrawPayments-tab">
                                    <br>
                                        <h3>Crypto</h3>
                                        <payment-table :payments="paidWithdrawPaymentsCrypto" :assets="assets" ></payment-table>
                                        <h3>Fiat</h3>
                                        <payment-table :payments="paidWithdrawPayments" :assets="assets" ></payment-table>
                                        <h3>Pendings</h3>
                                        <payment-table :payments="unpaidWithdrawPayments" :assets="assets" ></payment-table>
                                </div>
                                <div class="tab-pane " id="withdrawPaymentsCrypto" role="tabpanel" aria-labelledby="withdrawPaymentsCrypto-tab">
                                    <br>
                                        <!-- <h3>Unpaid</h3> -->
                                        <!-- <payment-table :payments="unpaidWithdrawPaymentsCrypto" :assets="assets" ></payment-table> -->
                                        <!-- <h3>Paid</h3> -->
                                        <payment-table :payments="paidWithdrawPaymentsCrypto" :assets="assets" ></payment-table>

                                </div>
                                <div class="tab-pane " id="checkouts" role="tabpanel" aria-labelledby="checkouts-tab">
                                    <br>
                                    <!-- <checkouts-table  :checkouts="checkoutsWithQuotes"></checkouts-table> -->
                                    <h3>Unredeemed</h3>
                                    <checkout-table :checkouts="checkoutsWithQuotes" :assets="assets" ></checkout-table>
                                    <!-- <checkout-table :checkouts="unRedeemedCheckouts" :assets="assets" ></checkout-table> -->
                                    <h3>Redeemed</h3>
                                    <div class="row mb-3 checkouts">
                                    <div class="col-md-12">
                                        <table class="table table-striped" align="center">
                                            <thead>
                                                <tr>
                                                    <th>Type</th>
                                                    <!--  <th>Total</th> -->
                                                    <th>User</th>
                                                    <th>Status</th>
                                                    <th>Updated</th>
                                                    <th>Created</th>
                                                    <th>Total</th>
                                                    <th></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                            <tr v-for="checkout in redeemedCheckouts"   class="checkout">
                                                <td v-if="checkout.action == 'mint' " >
                                                    Mint Token
                                                </td>
                                                <td v-else-if="checkout.action == 'buyCard' " >
                                                    Debit Card
                                                </td>
                                                <td v-else="checkout.action == 'buyUnits' || checkout.action == 'buy' || checkout.action == 'sellUnits' || checkout.action == 'sell' " >
                                                    {{ checkout.title == 'Checkout'? 'Buy Units' : checkout.title}}
                                                </td>
                                                <td v-else>
                                                    Purchase
                                                </td>
                                                <!--
                                                <td >
                                                    {{checkout.price}}
                                                </td>
                                                -->
                                                <td >
                                                    {{checkout.user_id.fullName}}
                                                </td>
                                                <td v-if="checkout.processing">
                                                    Processing test
                                                </td>
                                                <td v-else>
                                                    Complete test
                                                </td>
                                                <td >
                                                    <js-timestamp :at="checkout.updatedAt" format="timeago" short="false"></js-timestamp> 
                                                </td>
                                                <td >
                                                    <js-timestamp :at="checkout.createdAt" format="timeago" short="false"></js-timestamp> 
                                                </td>
                                                <td v-if="checkout.action == 'sellUnits' || checkout.action == 'sell' ">
                                                    $ <span class="total">{{parseFloat(checkout.sub_total).toFixed(2) }}</span>
                                                </td>
                                                <td v-else="">
                                                    $ <span class="total">{{parseFloat(checkout.total_charge).toFixed(2) }}</span>
                                                </td>
                                                <td class="checkout-action" >
                                                    <ajax-form action="cancelCheckout" :syncing.sync="syncing" :cloud-error.sync="cloudError" :form-data="formData" :form-rules="formRules" :form-errors.sync="formErrors" @submitted="submittedForm($event)">

                                                        <router-link v-if="checkout.proccessing" class="refresh btn btn-primary btn-sm p-4" :to="'/orders/checkout/refresh/'+checkout.id">Refresh</router-link>
                                                        <button v-else="" :syncing="syncing" class="btn-danger btn-lg btn-block cancel-checkout"  :id="checkout.id">Cancel</button>
                                                        <ajax-button style="display: none;" :syncing="syncing" class="btn-danger btn-lg btn-block submit-btn"  >Cancel</ajax-button>

                                                        <!-- <router-link v-else="" class="refresh btn btn-primary btn-sm p-4" :to="'/orders/checkout/refresh/'+checkout.id">View</router-link> -->
                                                    </ajax-form>
                                                </td>
                                            </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                    </div>

                                </div>

                                <div class="tab-pane " id="kyc-info" role="tabpanel" aria-labelledby="kyc-info-tab">
                                    <br>
                                        <h3>No Kyc</h3>
                                        <kyc-table :users="noKycUsers" user-type="noKyc" ></kyc-table>
                                        <h3>Unclear</h3>
                                        <kyc-table :users="kycUnclearUsers" user-type="kycUnclear" ></kyc-table>
                                        <h3>Clear </h3>
                                        <kyc-table :users="kycClearUsers" user-type="kycClear"  ></kyc-table>
                                </div>
                            </div>
                    
                    </div>
                
                </div>
                </div> 
            </div>
            <!-- Share modal -->
            <div class="modal  shareModal" id="shareModal" tabindex="-1" role="dialog" aria-labelledby="shareModalLabel" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="shareModalLabel">Share Debit Card</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body" style="margin-left: auto;margin-right: auto;">
                        <!-- <div style="margin-left: auto;margin-right: auto;display: inline-block;"> -->

                            <div class="a2a_kit a2a_kit_size_32 a2a_default_style text-center share-box" :data-a2a-url="shareLink" data-a2a-title="UnitedCoin Debit Card" style="margin-left: auto;margin-right: auto;display: inline-block;">
                                    <!-- <a class="a2a_dd" href="https://www.addtoany.com/share"></a> -->
                                    <a :href="shareLink" class="a2a_button_facebook"></a>
                                    <a :href="shareLink" class="a2a_button_twitter"></a>
                                    <a :href="shareLink" class="a2a_button_email"></a>
                                    <a :href="shareLink" class="a2a_button_linkedin"></a>
                                    <a :href="shareLink" class="a2a_button_telegram"></a>
                                    <a :href="shareLink" class="a2a_button_reddit"></a>
                            <!-- </div> -->
                        </div>

                        
                        
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    </div>
                    </div>
                </div>
            </div>
        </div>


    </div>
      
    `,
    // <tr v-for="market in markets" :id="market.id" v-if="market && market.sellCurrencyId && !market.sellCurrencyId.buyCurrency && market.sellCurrencyId.icoOrder && (!market.sellCurrencyIndexToken && !type || market.sellCurrencyIndexToken && type) && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" >
    //
    //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
    //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
    //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
    beforeMount: async function() {
        // Attach any initial data from the server.
        this.currency = this.$route.params.id;

          // _.extend(this, YOH_SHOW_LOCALS);
          _.extend(this, YOH_SHOW_LOCALS);

        await this.listen();  

    },
    mounted: async function() {

    
       
      },



    //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
    //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
    //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
    methods: {
        listen: async function() {
          // The auto-connecting socket is exposed as `io.socket`.
    
          // Use `io.socket.on()` to listen for the 'hello' event:
          // io.socket.on(this.market.id, function (data) {
          //   console.log('Socket `' + data.id + '` joined the party!');
          // });
          var Orders = this;
        
          //show loading// syincing
          this.loadingOrders = true;
          // $(".market .market-pg").hide().addClass("d-none");
          // $(".market .loading").show().removeClass("d-none");
          // get market 
          
          // var data =  await Cloud.getOrders.with({tradeType:this.tradeType,symbol:this.symbol})
          // .tolerate(()=>{
          //   this.cloudLoadingError = true;
          // });
    
          // if(data.flag){
          //   _.extend(this, data);
          //   this.loadingOrders = false;
    
          // }else if(data.mustLogin){
          //   window.location.href = data.redirect;
          // } else{
          //   this.loadingOrders = false;
          // }

        //   var csrf = await CSRF.token();
        //   var apiRequestHeader = {
        //       'X-CSRF-Token':csrf._csrf,
        //         // 'cookie':cookie
        //     };
          $.ajax({
                type: "POST",
              //   url: this.refreshUrl+"/markets/orders/cancel",
              url: '/wp-json/yohshow/api/v1/orders',
              data: {userType:this.userType,accountId:this.accountId},
                // headers:apiRequestHeader,
                success: function(resData, textStatus, request)
                {
                    resData = JSON.parse(resData);
                    if(resData.flag){
                        _.extend(Orders, resData);
                        Orders.loadingOrders = false;
            
                      }else if(resData.mustLogin){
                        window.location.href = resData.redirect;
                      } else{
                        Orders.loadingOrders = false;
                      }
    
                }
              });
    
    
        //   var csrf = await CSRF.token();
        //     console.log('csrf',csrf);
        //     var apiRequestHeader = {
        //       'X-CSRF-Token':csrf._csrf,
        //         // 'cookie':cookie
        //     };
        //   io.socket.request({
        //       method: 'post',
        //       url: '/api/orders',
        //       data: {userType:this.userType,accountId:this.accountId},
        //       headers: apiRequestHeader
        //     }, function (resData, jwres) {
    
        //       if(resData.flag){
        //         _.extend(Orders, resData);
        //         Orders.loadingOrders = false;
    
        //       }else if(resData.mustLogin){
        //         window.location.href = resData.redirect;
        //       } else{
        //         Orders.loadingOrders = false;
        //       }
              
        //       if (jwres.error) {
        //         console.log(jwres.statusCode); // => e.g. 403
        //         this.cloudLoadingError = true;
    
        //         return;
        //       }
            
        //       console.log(jwres.statusCode); // => e.g. 200
            
        //   });
    
        },
    
        submittedForm: async function(data) {
          // Redirect to the logged-in dashboard on success.
          // > (Note that we re-enable the syncing state here.  This is on purpose--
          // > to make sure the spinner stays there until the page navigation finishes.)
          this.syncing = true;
        
    
          var id = data.id;
    
          if(data.flag){
            window.location.reload();
          }
        
          
        },
      }



  });

});

