/**
 * <otc>
 * -----------------------------------------------------------------------------
 * otc.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */
 jQuery(document).ready(function( $ ) {


	Vue.component('otc', {
  

    //  ╔═╗╦═╗╔═╗╔═╗╔═╗
    //  ╠═╝╠╦╝║ ║╠═╝╚═╗
    //  ╩  ╩╚═╚═╝╩  ╚═╝
    props: [
      // 'markets',// « The JS timestamp to format
      // 'buyCurrency',
      // 'type',
    ],

    //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
    //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
    //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
    data: function (){
      return {
            loadingComponent:true,
            
        
            // Main syncing/loading state for this page.
            syncing: false,

            // Form data
            formData: { /* … */ },

            // For tracking client-side validation errors in our form.
            // > Has property set to `true` for each invalid property in `formData`.
            formErrors: { /* … */ },

            // A set of validation rules for our form.
            // > The form will not be submitted if these are invalid.
            formRules: {
              emailAddress: { required: true, isEmail: true },
              password: { required: true },
            },

            // Server error state for the form
            cloudError: '',
            
      };
    },

    /*
                    (type && market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
                  || (type && market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
    */

    //  ╦ ╦╔╦╗╔╦╗╦
    //  ╠═╣ ║ ║║║║
    //  ╩ ╩ ╩ ╩ ╩╩═╝

    template: `
    <div class="login-component">
        <div v-if="loadingComponent" class="text-center">

            <h1>Your account is being loaded...</h1>
            <ajax-button type="submit" :syncing="loadingComponent" class="btn btn-primary mint">Refesh</ajax-button>


        </div>

        <div v-else="" id="login" v-cloak>
          <div class="">
            <h1 class="text-center">Sign in to your account</h1>
            <div class="login-form-container">
              <hr/>
              
              <ajax-form action="login" :syncing.sync="syncing" :cloud-error.sync="cloudError" :form-data="formData" :form-rules="formRules" :form-errors.sync="formErrors" @submitted="submittedForm($event)">
              <!-- <form id="loginForm" action="/login" method="POST"> -->
                <div class="form-group">
                  <input type="email" class="form-control" placeholder="Email address" :class="[formErrors.emailAddress ? 'is-invalid' : '']" v-model.trim="formData.emailAddress" autocomplete="email" focus-first>
                  <div class="invalid-feedback" v-if="formErrors.emailAddress">Please provide a valid email address.</div>
                </div>
                <div class="form-group">
                  <input type="password" class="form-control" placeholder="Password" :class="[formErrors.password ? 'is-invalid' : '']" v-model.trim="formData.password" autocomplete="current-password">
                  <div class="invalid-feedback" v-if="formErrors.password">Please enter your password.</div>
                </div>
                <div class="form-group form-check">
                  <input class="form-check-input" type="checkbox" id="remember" name="rememberMe" v-model="formData.rememberMe"/>
                  <label class="form-check-label" for="remember">Remember me</label>
                </div>
                <p class="text-danger" v-if="cloudError==='badCombo'"><small>The credentials you entered are not associated with an account. Please check your email and/or password and try again.</small></p>
                <p class="text-danger" v-else-if="cloudError"><small>An error occured while processing your request. Please check your information and try again, or <a href="/contact">contact support</a> if the error persists.</small></p>
                <div class="form-group">
                  <ajax-button :syncing="syncing" class="btn-dark btn-lg btn-block">Sign in</ajax-button>
                </div>
              <!-- </form> -->
              </ajax-form>
              <p class="text-center"><router-link to="/password/forgot">Forgot your password?</router-link></p>
            </div>
          </div>
        </div>
        
         

    

    </div>
      
    `,
    // <tr v-for="market in markets" :id="market.id" v-if="market && market.sellCurrencyId && !market.sellCurrencyId.buyCurrency && market.sellCurrencyId.icoOrder && (!market.sellCurrencyIndexToken && !type || market.sellCurrencyIndexToken && type) && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" >
    //
    //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
    //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
    //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
    beforeMount: async function() {
        // Attach any initial data from the server.
        this.action = this.$route.params.action;
        this.userType = this.$route.params.userType;
        this.subaction = this.$route.params.subaction;
        this.subactionId = this.$route.params.subactionId;
        
        if(this.subactionId && this.subaction && this.action ){
          this.redirectLink = "/"+this.action+"/"+this.subaction+"/"+this.subactionId;
        }else if(this.subaction && this.action ){
          this.redirectLink = "/"+this.action+"/"+this.subaction;
        }else if(this.action ){
          this.redirectLink = "/"+this.action;
        }else{
          this.redirectLink = "";
        }

          // _.extend(this, YOH_SHOW_LOCALS);
          _.extend(this, YOH_SHOW_LOCALS);

          

        await this.listen();  

    },
    mounted: async function() {


    
       
      },



    //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
    //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
    //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
    methods: {

      init: function () {
        var page = this;
        $( "#loginForm" ).submit(function( event ) {
          event.preventDefault();
          page.syncing = true;
          page.login();
        });
        
      },
      listen: async function() {
        // The auto-connecting socket is exposed as `io.socket`.
  
        // Use `io.socket.on()` to listen for the 'hello' event:
        // io.socket.on(this.market.id, function (data) {
        //   console.log('Socket `' + data.id + '` joined the party!');
        // });
        var Account = this;
      
        //show loading// syincing
        this.loadingComponent = true;
        // $(".market .market-pg").hide().addClass("d-none");
        // $(".market .loading").show().removeClass("d-none");
        // get market 
        
        // var data =  await Cloud.getAccount.with({tradeType:this.tradeType,symbol:this.symbol})
        // .tolerate(()=>{
        //   this.cloudLoadingError = true;
        // });
  
        // if(data.flag){
        //   _.extend(this, data);
        //   this.loadingComponent = false;
  
        // }else if(data.mustLogin){
        //   window.location.href = data.redirect;
        // } else{
        //   this.loadingComponent = false;
        // }

        // var csrf = await CSRF.token();
        // var apiRequestHeader = {
        //     'X-CSRF-Token':csrf._csrf,
        //       // 'cookie':cookie
        //   };
        $.ajax({
              type: "POST",
            //   url: this.refreshUrl+"/markets/orders/cancel",
            // url: '/api/account',
            // url: '/wp-json/yohshow/api/v1/login',
            url: '/wp-json/yohshow/api/v1/login/overview',

            data: {userType:this.userType,action:this.action,subaction:this.subaction},
              // headers:apiRequestHeader,
              success:  function(resData, textStatus, request)
              {
                  resData = JSON.parse(resData);

                  if(resData.flag){
                      _.extend(Account, resData);
                      Account.loadingComponent = false;
                      Account.init();
          
                    }else if(resData.mustLogin){
                      // window.location.href = resData.redirect;
                    } else{
                      Account.loadingComponent = false;
                    }
  
              }
            });

  
      },
      submittedForm: async function(data) {
        data = JSON.parse(data);
        // Redirect to the logged-in dashboard on success.
        // > (Note that we re-enable the syncing state here.  This is on purpose--
        // > to make sure the spinner stays there until the page navigation finishes.)
        this.syncing = true;
        var redirectLink = this.redirectLink;
        if(data.success){
          this.cloudError = ""; 
          if(redirectLink && redirectLink !=="/"){
            // window.location = redirectLink;
            this.$router.push(redirectLink);
  
          }else{
            window.location = '/';
            // this.$router.push("/");
  
          }

        }else{
         this.cloudError = data.error 
         this.syncing = false;
        }
        
      },
      activateLogin: async function() {
        // Redirect to the logged-in dashboard on success.
        // > (Note that we re-enable the syncing state here.  This is on purpose--
        // > to make sure the spinner stays there until the page navigation finishes.)
        var page = this;
        $( "#loginForm" ).submit(function( event ) {
          event.preventDefault();
          page.syncing = true;
          page.login();
  
  
        });
  
      },
      login: async function() {
        var page = this;
        var form = $("#loginForm");
        var url = form.attr('action');
  
        $.ajax({
              type: "POST",
              url: url,
              data: form.serialize(), // serializes the form's elements.
              success: function(data, textStatus, request)
              {
                  console.log(data); // show response from the php script.
                  console.log(textStatus); // show response from the php script.
                  console.log(request); // show response from the php script.
                  var getAllResponseHeaders = request.getAllResponseHeaders();
                  console.log(getAllResponseHeaders); // show response from the php script.
                  var cookie = request.getResponseHeader('Set-Cookie');
                  console.log(cookie); // show response from the php script.
                  console.log($.cookie() );
                  page.balance();
  
  
              }
            });
        // window.location = '/';
      },
      balance: async function() {
        var page = this;
        // var form = $("#loginForm");
        // var url = form.attr('action');
  
        $.ajax({
              type: "GET",
              url: 'https://exchange.unitedcoin.org/api/v2/peatio/account/balances/btc',
              // data: form.serialize(), // serializes the form's elements.
              success: function(data, textStatus, request)
              {
                  console.log(data); // show response from the php script.
                  console.log(textStatus); // show response from the php script.
                  console.log(request); // show response from the php script.
                  var getAllResponseHeaders = request.getAllResponseHeaders();
                  console.log(getAllResponseHeaders); // show response from the php script.
                  var cookie = request.getResponseHeader('Set-Cookie');
                  console.log(cookie); // show response from the php script.
                  console.log($.cookie() );
  
              }
            });
        // window.location = '/';
      },


      }



  });

});

