/**
 * <payment-methods>
 * -----------------------------------------------------------------------------
 * paymentMethods.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */
 jQuery(document).ready(function( $ ) {


	Vue.component('paymentMethods', {
  

    //  ╔═╗╦═╗╔═╗╔═╗╔═╗
    //  ╠═╝╠╦╝║ ║╠═╝╚═╗
    //  ╩  ╩╚═╚═╝╩  ╚═╝
    props: [
      // 'markets',// « The JS timestamp to format
      // 'buyCurrency',
      // 'type',
    ],

    //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
    //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
    //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
    data: function (){
      return {
        // Main syncing/loading state for this page.
        loadingComponent: false,

        isBillingEnabled: false,

        hasBillingCard: false,

        // Syncing/loading states for this page.
        syncingOpenCheckout: false,
        syncingUpdateCard: false,
        syncingRemoveCard: false,

        // Form data
        formData: { /* … */ },

        // Server error state for the form
        cloudError: '',

        // For the Stripe checkout window
        checkoutHandler: undefined,

        // For the confirmation modal:
        removeCardModalVisible: false,
      };
    },

    /*
                    (type && market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
                  || (type && market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
    */

    //  ╦ ╦╔╦╗╔╦╗╦
    //  ╠═╣ ║ ║║║║
    //  ╩ ╩ ╩ ╩ ╩╩═╝
    template: `
    <div class="paymentMethods-component">
        <div v-if="loadingComponent" class="text-center">
            <h1>Your orders are being loaded...</h1>
            <ajax-button type="submit" :syncing="loadingComponent" class="btn btn-primary mint">Refesh</ajax-button>
        </div>
        <div v-else="" id="payment-methods" v-cloak>
            <div class="" >
                <h1>Payment Methods</h1>
                <hr/>

                <!-- <div class="payment-options payment-method-box">
                    <div class="row card-method">
                        <div class="col-xs-3 icon-box">
                            <i class="fa fa-credit-card-alt" aria-hidden="true"></i>
                        </div>
                        <div class="col-xs-9 info">
                            <button class="add-card-btn">Add Card</button>
                        </div>
                    </div>
                    <div class="row bank-bank">
                        <div class="col-xs-3 icon-box">
                            <i class="fa fa-university" aria-hidden="true"></i>
                        </div>
                        <div class="col-xs-9 info">
                            <button class="add-bank-btn">Add Bank</button>
                        </div>
                    </div>

                </div> -->
                <!-- <div style="display: none;" class="add-card payment-method-box"> -->
                <div v-if="me.primeTrustUserId || primeTrustForcePayment" class="add-card payment-method-box">
                    <div class="row">
                        <div class="col-xs-12 ">
                            <!-- {{creditCardResourceToken}} -->
                            <add-prime-trust-card v-if="creditCardResourceToken"
                            :credit-card-resource-token="creditCardResourceToken" 
                            :prime-trust-billing-card-brand="me.primeTrustBillingCardBrand" 
                            :prime-trust-billing-card-last4="me.primeTrustBillingCardLast4" 
                            :prime-trust-billing-card-exp-month="me.primeTrustBillingCardExpMonth" 
                            :prime-trust-billing-card-exp-year="me.primeTrustBillingCardExpYear" 
                            :payment-methods="paymentMethods" 
                            :prime-trust-force-payment="primeTrustForcePayment" 
                            :redirect="redirect" 
                            ></add-prime-trust-card>
                        </div>
                    </div>
                </div>
                <div v-else="" class="register payment-method-box">
                    <div class="row">
                        <div class="col-xs-12 ">
                            <!-- {{creditCardResourceToken}} -->
                            <a href="/cards/register"class="col-12 btn btn-primary">Register</a>
                            
                        </div>
                    </div>
                </div>
                <!-- <div style="display: none;" class="add-bank payment-method-box">
                    <div class="row">
                        <div class="col-xs-12 ">
                            {{creditCardResourceToken}}
                            <add-prime-trust-card v-if="creditCardResourceToken"
                            :credit-card-resource-token="creditCardResourceToken" 
                            :prime-trust-billing-card-brand="me.primeTrustBillingCardBrand" 
                            :prime-trust-billing-card-last4="me.primeTrustBillingCardLast4" 
                            :prime-trust-billing-card-exp-month="me.primeTrustBillingCardExpMonth" 
                            :prime-trust-billing-card-exp-year="me.primeTrustBillingCardExpYear" 
                            ></add-prime-trust-card>
                        </div>
                    </div>
                </div> -->
            
                <div class="alert alert-secondary" v-if="!me.primeTrustBillingCardBrand">
                    You have not linked a payment source to your account. In order to access paid features, you'll need to provide your credit card information. (Don't worry: you will only be charged when you've reached the limit of your free plan.)
                </div>
            </div>
            


        </div>


    </div>
      
    `,
    // <tr v-for="market in markets" :id="market.id" v-if="market && market.sellCurrencyId && !market.sellCurrencyId.buyCurrency && market.sellCurrencyId.icoOrder && (!market.sellCurrencyIndexToken && !type || market.sellCurrencyIndexToken && type) && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" >
    //
    //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
    //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
    //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
    beforeMount: async function() {
        // Attach any initial data from the server.
        this.currency = this.$route.params.id;

          // _.extend(this, YOH_SHOW_LOCALS);
          _.extend(this, YOH_SHOW_LOCALS);

        await this.listen();  

    },
    mounted: async function() {

        this.activate_btns();
    
       
      },



    //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
    //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
    //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
    methods: {
        listen: async function() {
          // The auto-connecting socket is exposed as `io.socket`.
    
          // Use `io.socket.on()` to listen for the 'hello' event:
          // io.socket.on(this.market.id, function (data) {
          //   console.log('Socket `' + data.id + '` joined the party!');
          // });
          var Orders = this;
        
          //show loading// syincing
          this.loadingComponent = true;
          // $(".market .market-pg").hide().addClass("d-none");
          // $(".market .loading").show().removeClass("d-none");
          // get market 
          
          // var data =  await Cloud.getOrders.with({tradeType:this.tradeType,symbol:this.symbol})
          // .tolerate(()=>{
          //   this.cloudLoadingError = true;
          // });
    
          // if(data.flag){
          //   _.extend(this, data);
          //   this.loadingComponent = false;
    
          // }else if(data.mustLogin){
          //   window.location.href = data.redirect;
          // } else{
          //   this.loadingComponent = false;
          // }

          // var csrf = await CSRF.token();
          // var apiRequestHeader = {
          //     'X-CSRF-Token':csrf._csrf,
          //       // 'cookie':cookie
          //   };
          $.ajax({
                type: "POST",
              //   url: this.refreshUrl+"/markets/orders/cancel",
              url: '/wp-json/yohshow/api/v1/paymentMethods',
              data: {userType:this.userType,accountId:this.accountId},
                // headers:apiRequestHeader,
                success: function(resData, textStatus, request)
                {
                    resData = JSON.parse(resData);
                    if(resData.flag){
                        _.extend(Orders, resData);
                        Orders.loadingComponent = false;
            
                      }else if(resData.mustLogin){
                        window.location.href = resData.redirect;
                      } else{
                        Orders.loadingComponent = false;
                      }
    
                }
              });
    
    
        //   var csrf = await CSRF.token();
        //     console.log('csrf',csrf);
        //     var apiRequestHeader = {
        //       'X-CSRF-Token':csrf._csrf,
        //         // 'cookie':cookie
        //     };
        //   io.socket.request({
        //       method: 'post',
        //       url: '/api/orders',
        //       data: {userType:this.userType,accountId:this.accountId},
        //       headers: apiRequestHeader
        //     }, function (resData, jwres) {
    
        //       if(resData.flag){
        //         _.extend(Orders, resData);
        //         Orders.loadingComponent = false;
    
        //       }else if(resData.mustLogin){
        //         window.location.href = resData.redirect;
        //       } else{
        //         Orders.loadingComponent = false;
        //       }
              
        //       if (jwres.error) {
        //         console.log(jwres.statusCode); // => e.g. 403
        //         this.cloudLoadingError = true;
    
        //         return;
        //       }
            
        //       console.log(jwres.statusCode); // => e.g. 200
            
        //   });
    
        },
    
        activate_btns: function  () {
            var Cart = this;
            var id = this.id;
        $( ".add-card-btn" ).off("click").on( "click", function(e) {
          e.preventDefault();
          $(".payment-method-box").hide();
          $(".add-card").show();
        });
        $( ".add-bank-btn" ).off("click").on( "click", function(e) {
          e.preventDefault();
          $(".payment-method-box").hide();
          $(".add-bank").show();
        });
      },
      }



  });

});

