/**
 * <cart-Modal>
 * -----------------------------------------------------------------------------
 * Transaction Modal.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */

 jQuery(document).ready(function( $ ) {

	Vue.component('cartModal', {

		//  ╔═╗╦═╗╔═╗╔═╗╔═╗
		//  ╠═╝╠╦╝║ ║╠═╝╚═╗
		//  ╩  ╩╚═╚═╝╩  ╚═╝
		props: [
			'syncing',
			'orderId',
			'id',// « The JS timestamp to format
			'shop',// « Whether to shorten the formatted date by not including the time of day (may only be used with timeago, and even then only applicable in certain situations)
			'shopSlug',// « Whether to shorten the formatted date by not including the time of day (may only be used with timeago, and even then only applicable in certain situations)
			'storefrontAccessToken',// « one of: 'calendar', 'timeago' (defaults to 'timeago'.  Otherwise, the "calendar" format displays data as US-style calendar dates with a four-character year, separated by dashes.  In other words: "MM-DD-YYYY")
			'productClass',// « one of: 'calendar', 'timeago' (defaults to 'timeago'.  Otherwise, the "calendar" format displays data as US-style calendar dates with a four-character year, separated by dashes.  In other words: "MM-DD-YYYY")
			'checkoutRedirect',// « one of: 'calendar', 'timeago' (defaults to 'timeago'.  Otherwise, the "calendar" format displays data as US-style calendar dates with a four-character year, separated by dashes.  In other words: "MM-DD-YYYY")
			'checkoutAction',// « one of: 'calendar', 'timeago' (defaults to 'timeago'.  Otherwise, the "calendar" format displays data as US-style calendar dates with a four-character year, separated by dashes.  In other words: "MM-DD-YYYY")
			'checkoutSession',// « one of: 'calendar', 'timeago' (defaults to 'timeago'.  Otherwise, the "calendar" format displays data as US-style calendar dates with a four-character year, separated by dashes.  In other words: "MM-DD-YYYY")
			'defaultCheckout',
			'toAccountId',
			'sellCurrencyId',
			'environment',
		],

		//  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
		//  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
		//  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
		data: function (){
			return {
			formatType: undefined,
			formattedTimestamp: '',
			interval: undefined,
			test:"test", 
			variantIds:[], 
			_defaultCheckout:[], 
			};
		},

		//  ╦ ╦╔╦╗╔╦╗╦
		//  ╠═╣ ║ ║║║║
		//  ╩ ╩ ╩ ╩ ╩╩═╝
		template: `
		<div :id="id+'-cart-modals'" class="row mb-3 cart-modals">
			<!-- Trade Modal -->
			<div class="modal  cartModal" :id="id+'-cartModal'" tabindex="-1" role="dialog" :aria-labelledby="id+'-cartModalLabel'" aria-hidden="true">
				<div class="modal-dialog" role="document">
				<div class="modal-content">
					<div class="modal-header">
					<h5 class="modal-title"  :id="id+'-cartModalLabel'" >Cart</h5>
					<!--  
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
					-->
					</div>
					<form class="modal-body cart-form content p-4">
						<div class="items mb-5">
						</div>
						<div class="empty mb-5">
							<h3>Your cart is empty</h3>
						</div>
						<div class="total">
							<h5>Total Charge: <span class="totalPrice"></span> USD </h5>
						</div>
					
					</form>
					<div class="modal-footer border-0">
					<button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
					<ajax-button type="submit" :syncing="syncing" class="btn btn-primary checkout">Checkout</ajax-button>
					
						<!-- 
							<button type="button" class="btn btn-primary checkout " data-dismiss="modal" >Checkout</button>
						
						<button type="button" class="btn btn-primary checkout " data-dismiss="modal" data-toggle="modal" :data-target="'#'+id+'-checkoutModal'">Checkout</button> 
						-->
					</div>
				</div>
				</div>
			</div>
			<!-- end Trade Modal -->

			<!-- Confrim Modal -->
			<div class="modal  checkoutModal" :id="id+'-checkoutModal'"  tabindex="-1" role="dialog" :aria-labelledby="id+'checkoutModalLabel'" aria-hidden="true">
				<div class="modal-dialog" role="document">
				<div class="modal-content">
					<div class="modal-header">
					<h5 class="modal-title" :id="id+'-checkoutModalLabel'" >Check Out</h5>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
					</div>
					<div class="modal-body">
						<iframe class="iframe"></iframe>
					
					</div>
					<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-dismiss="modal" data-toggle="modal" data-target="#'+id+'-cartModalModal" >Back</button>
					<ajax-button type="submit" :syncing="syncing" class="btn btn-primary checkout">Confirm & Pay</ajax-button>
					<!-- 
					<button type="button" class="btn btn-primary submit submit-cart" data-dismiss="modal">Confirm & Pay</button>
					-->
					</div>
				</div>
				</div>
			</div>
			<input type="hidden" class="checkout-token-id"> 
			<!-- end Confrim Modal -->


		</div>
			
		`,

		//  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
		//  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
		//  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
		beforeMount: function() {

		},
		mounted: async function() {
			console.log("carts",this.carts);
			console.log('beforeMount pre this',this);
			console.log('beforeMount pre this.storefrontAccessToken',this.storefrontAccessToken);
			console.log('beforeMount pre this.productClass',this.productClass);
			console.log('beforeMount pre this.shop',this.shop);
			this._defaultCheckout = this.defaultCheckout ? this.defaultCheckout : [];
			console.log("_defaultCheckout",this._defaultCheckout);
			

			this.restartCheckout = this.checkoutSession == "keep"? false:true;
			

			var shop =  this.shop;
			var storefrontAccessToken =  this.storefrontAccessToken;
			var productClass =  this.productClass;
			this.init(shop,storefrontAccessToken,productClass);
			
			console.log('beforeMount pre this',this);


		},



		//  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
		//  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
		//  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
		methods: {
			init: function(shop,storefrontAccessToken, productClass) {
				console.log('init this',this);

				var Cart = this;
				var id = this.id;
				Cart.allLineItems = [];
				Cart.formatDefaultCheckout(Cart._defaultCheckout);
				
				Cart =  Cart.copyInstance(Cart);
				console.log('shop',shop);
				// Cart = {};
				Cart.shop  = shop;
				Cart.productClass  = productClass;
				Cart.storefrontAccessToken  = storefrontAccessToken;
				console.log('init this',this);
				console.log('shop',shop);
				console.log('storefrontAccessToken',storefrontAccessToken);
				Cart = Cart.activate(shop,storefrontAccessToken,productClass);
				return Cart;
			},
			formatDefaultCheckout: function(_defaultCheckout) {
				var Cart = this;
				Cart._defaultCheckoutDict = {};
				
				for (let i = 0; i < _defaultCheckout.length; i++) {
					const _defaultCheckoutItem = _defaultCheckout[i];
					Cart._defaultCheckoutDict[_defaultCheckoutItem.shopifyHandle] = {
						handle : _defaultCheckoutItem.shopifyHandle,
						quantity : _defaultCheckoutItem.quantity
					};

					
				}
			},
			getDefaultCheckout: function() {
				var Cart = this;
				var variantIds = Cart.variantIds;
				var defautCheoutItmes = [];
				console.log("getDefaultCheckout variantIds",variantIds);
				$.each( Cart._defaultCheckoutDict, function( handle, _defaultCheckoutItem ) {
					console.log("getDefaultCheckout _defaultCheckoutItem", handle + ": " + _defaultCheckoutItem );
					var line_item = {
						variantId:_defaultCheckoutItem.variantId,
						quantity:_defaultCheckoutItem.quantity,
					}
					defautCheoutItmes.push(line_item); 
				});


				console.log("getDefaultCheckout defautCheoutItmes",defautCheoutItmes);

				return defautCheoutItmes;

			},


			copyInstance: function(original) {
			var copied = Object.assign(
				Object.create(
				Object.getPrototypeOf(original)
				),
				original
			);
			return copied;
			},
			activate: function() {
				var Cart = this;
				var id = this.id;
				console.log("active Cart", Cart);
				Cart.products = {};
				
				
				
				this.load_store();
				// $("#"+id+"-cartModal").modal({width:"100%"});
				Cart.activate_checkout();
				Cart.activate_btns();
				return Cart;

			},
			activate_checkout: function  () {
				var Cart = this;
				var id = this.id;
				console.log("activate_checkout checkout click activated");
				$( "#"+id+"-cartModal .checkout").on( "click", async function(e) {
					console.log("activate_checkout checkout clicked");
					e.preventDefault();
					await Cart.checkoutClick();
				});
				$( "."+id+"-view-cart-button" ).on( "click", function(e) {
					e.preventDefault();
					Cart.open_cart();
				});
				
			},
			activate_btns: function  () {
				var Cart = this;
				var id = this.id;
				$( "#"+id+"-cartModal .update" ).off("click").on( "click", function(e) {
					e.preventDefault();
					Cart.update_cart();
				});
				$( "#"+id+"-cartModal .continue" ).off("click").on( "click", function(e) {
					e.preventDefault();
					$("#"+id+"-cartModal").modal("hide");
				});
				$( ".open-cart" ).off("click").on( "click", function(e) {
					e.preventDefault();
					Cart.open_cart();
				});
				$( "#"+id+"-cartModal .remove" ).off("click").on( "click", function(e) {
					e.preventDefault();
					var line_item_id = $(this).attr("href");
					var line_items = [line_item_id];
					Cart.remove_from_cart(line_items);
				});

				$( "#"+id+"-cartModal .quantity input" ).off("change").on( "change", function(e) {
					e.preventDefault();
					Cart.update_cart();
				});

				
			},
			update_cart: function() {
				var Cart = this;
				var id  = this.id;
				var checkout = Cart.checkout;
				var checkoutId = Cart.checkout.id;
				var webUrl = checkout.webUrl;
				lineItemsToUpdate = [];
				$("#"+id+"-cartModal .line-item").each(function(e) {
					var quantity = $(this).find(".quantity input").val();
					var variant_id = $(this).find(".variant-id").val();
					var line_item_id = $(this).find(".line-item-id").val();
					quantity = parseInt(quantity);
					// quantity = 1;
					updated_item =  {id: line_item_id, quantity: quantity};
					lineItemsToUpdate.push(updated_item);
				});
				Cart.client.checkout.updateLineItems(checkoutId, lineItemsToUpdate).then((checkout) => {
				Cart.checkout = checkout;
				Cart.open_cart();
				});

			},
			remove_item: async function() {
				var Cart = this;
				var id = this.id;
				var variant = [{ variantId : variant_id, quantity: 1 }];
					await Cart.add_to_cart(variant);
			},
			save_checkout: async function(checkout){
				var Cart = this;
				var id = this.id;
				var csrf = await CSRF.token();
				console.log('csrf',csrf);
				var checkoutAction = Cart.checkoutAction;
				var checkoutRedirect = Cart.checkoutRedirect;
				var toAccountId = Cart.toAccountId;
				var orderId = Cart.orderId;
				var sellCurrencyId = Cart.sellCurrencyId;

				checkout.redirect = checkoutRedirect;
				checkout.orderId = orderId;
				checkout.order_id = orderId;
				checkout.action = checkoutAction;
				checkout.toAccountId = toAccountId;
				checkout.to_account_id = toAccountId;
				checkout.toAccountId = toAccountId;
				checkout.sell_currency_exchange_token_id = sellCurrencyId;
				checkout.checkout_type =  "shopify";
				
				

				
				checkout.checkout_token = csrf._csrf;
				checkout.tokenId = $("#"+id+"-cart-modals .checkout-token-id").val();
				checkout.tokenId = $("#"+id+"-cart-modals .checkout-token-id").val();
				checkout.token_id = $("#"+id+"-cart-modals .checkout-token-id").val();
				console.log("save checkout checkout",checkout);
				console.log("save checkout Cart.environment",Cart.environment);
				const input = {customAttributes: [
					{key: "checkout_token", value: csrf._csrf},
					{key: "environment", value: Cart.environment},
				]};

				var updated_checkout = await Cart.client.checkout.updateAttributes(checkout.id, input).then((checkout) => {
					// Do something with the updated checkout
					Cart.checkout = checkout; 
					console.log("saved checkout updated attribues checkout",checkout);
					return checkout;

				});
				console.log("saved checkout updated attribues updated_checkout",updated_checkout);
				Cart.checkout_token = csrf._csrf;

				
				// var apiRequestHeader = {
				// 'X-CSRF-Token':csrf._csrf,
				// };
			var result = await  io.socket.request({
				method: 'post',
				url: '/checkout/save',
				data: {checkout:checkout},
				// headers: apiRequestHeader
			}, function (resData, jwres) {
				console.log("save checkout resData",resData); // => e.g. 403
				if(resData.flag){
					// location.reload();
					var saved_checkout = resData.checkout;
					console.log("saved checkout saved_checkout",saved_checkout);

					
				}
				return resData;
				// $(form_id+" .submit").removeAttr("disabled");
				// Cart.syncing = true;



				if (jwres.error) {
				console.log(jwres.statusCode); // => e.g. 403
				return;
				}
			
				console.log(jwres.statusCode); // => e.g. 200
			
			});
			console.log("save checkout result",result);
			return result;

			},
			checkoutClick: async function() {
				var Cart = this;
				var id = this.id;
				$("#"+id+"-cartModal").modal("hide");
				// $("#"+id+"-checkoutModal").modal({
				// 	iframe: true,
				// 	iframeHeight: 400,
				// 	iframeURL: webUrl,
				// });
				var _defaultCheckoutItems =  this.getDefaultCheckout();
				console.log("checkout click  _defaultCheckoutItems",_defaultCheckoutItems);

				await Cart.add_to_cart(_defaultCheckoutItems);
				var checkout = Cart.checkout;
				var webUrl = checkout.webUrl;




			

				// this.syncing =  true;
				var saved_checkout = await Cart.save_checkout(checkout);

				console.log("checkout saved_checkout",saved_checkout);
				console.log("checkout webUrl",webUrl);
				var checkoutModalId = "#"+id+"-checkoutModal";
				console.log("checkout checkoutModalId",checkoutModalId);

				// var checkoutWindow = window.open(webUrl, "Checkout", "height=750,width=750");

				// var myWindow = window.open(webUrl, "_blank", "width=500,height=500");
				var myWindow = window.open(webUrl, "_parent");

				// $(checkoutModalId).modal("show");
				// Cart.checkoutListen(Cart.checkout_token,myWindow);

				
				// setTimeout(function(){ 
				// 	console.log("checkout show modal called checkoutModalId",checkoutModalId);
				// 	$("#"+id+"-checkoutModal .iframe").attr("src", webUrl);
					
				// }, 1000);
				console.log("checkout set time out called checkoutModalId",checkoutModalId);

			},
			checkoutListen: function(checkout_token,checkoutWindow) {

				var Cart = this;
				io.socket.get("/checkout/listen", function gotResponse(data, jwRes) {
				console.log('Server responded with status code ' + jwRes.statusCode + ' and data: ', data);
				});
				io.socket.on(checkout_token, function (checkoutResult){
					console.log("checkoutResult",checkoutResult);
					if(checkoutResult.paid){
						var checkoutRedirect = Cart.checkoutRedirect;
						console.log("checkoutResult",checkoutResult);
						
						if(checkoutRedirect){
							window.location.href = checkoutRedirect;

						}else{
							window.location.reload();
						}
					}
					// => 'hi there!'
					// Market.refresh(market);
				});
				
		
		
			},
			load_products: function(products) {
				var Cart = this;
				var id = this.id;
				var productClass = this.productClass;
				for (var i = 0; i < products.length; i++) {
					var product = products[i];
					var variant = product.variants[0];
					var handle = product.handle;
					console.log("load_products handle",handle);
					console.log("load_products product",product);
					console.log("load_products variant",variant.id);
					if(Cart._defaultCheckoutDict[handle]){
						console.log("load_products default handle",handle);
						Cart._defaultCheckoutDict[handle].variantId = variant.id;  
						Cart._defaultCheckoutDict[handle].variant_id = variant.id;  
					}else{

					}
					Cart.variantIds.push(variant.id);
					var productDom = $("."+handle);
					console.log("load_products productDom",productDom.length);

					productDom.find(".shopifyVariantId").val(variant.id);
					productDom.find(".price").html(variant.price);
					Cart.products[variant.id] = variant;
					
				}
				console.log("load_products Cart.products",Cart.products);
				return Cart.products;
			},
			activate_variants: function() {
				var Cart = this;
				var id = this.id;
				var productClass = Cart.productClass;
				$( "."+ productClass  ).each(function( i ) {
					// var product_dom = $(this).parents(".shopify");
					var product_dom = $(this);
					console.log("activate_variants product_dom",product_dom);
					Cart.activate_variant(product_dom);
				});
			},
			activate_variant: function(variant_dom) {
				var Cart = this;
				var id = this.id;
				var buy_btn = variant_dom.find(".cart");
				var fast_buy_btn = variant_dom.find(".fast-cart");
				var variant_id = variant_dom.find(".shopifyVariantId").val();
				
				buy_btn.off("click");
				buy_btn.click(function(e) {
					e.preventDefault();
					var product_box = $(e.target).parents(".united-product")
					var quantity = product_box.find(".quantity").val();
					console.log("cart clicked pre parse quantity",quantity);
					quantity = parseInt(quantity);
					console.log("cart clicked quantity",quantity);
					//add varint to cart and bring up cart modal 
					console.log("activate_variant buy_btn click variant_id",variant_id);
					Cart.load_checkout().then(function() {
						var variant = [{ variantId : variant_id, quantity: quantity }];
						Cart.add_to_cart(variant);
					
					});
				});

				fast_buy_btn.off("click");
				fast_buy_btn.click(function(e) {
					e.preventDefault();
					var product_box = $(e.target).parents(".united-product")
					var quantity = product_box.find(".quantity").val();
					console.log("cart clicked pre parse quantity",quantity);
					quantity = parseInt(quantity);
					console.log("cart clicked quantity",quantity);
					//add varint to cart and bring up cart modal 
					console.log("activate_variant buy_btn click variant_id",variant_id);
					Cart.load_checkout().then(async function() {
						var variant = [{ variantId : variant_id, quantity: quantity }];
						await Cart.add_to_cart(variant,true);
					
					});
				});


			},
			add_to_cart: async function  (lineItemsToAdd, fastCheckout = false) {
				var Cart = this;
				var id = this.id;
				var checkoutId = Cart.checkout.id;
				console.log("add_to_cart lineItemsToAdd",lineItemsToAdd);
				console.log("add_to_cart checkoutId",checkoutId);
				for (let i = 0; i < lineItemsToAdd.length; i++) {
					const lineItemToAdd = lineItemsToAdd[i];
					Cart.allLineItems.push(lineItemToAdd);
				}
				console.log("add_to_cart Cart.allLineItems",Cart.allLineItems);

				return Cart.client.checkout.addLineItems(checkoutId, lineItemsToAdd).then((checkout) => {
					Cart.checkout = checkout;
					if(fastCheckout){
						Cart.open_cart();
						Cart.update_cart();
						// await Cart.checkoutClick();
						return Cart.checkoutClick();
					}else{
						Cart.open_cart();
					}
				});

				

				
			},
			remove_from_cart: function  (lineItemIdsToRemove) {
				var Cart = this;
				var id = this.id;
				var checkoutId = Cart.checkout.id;
				Cart.client.checkout.removeLineItems(checkoutId, lineItemIdsToRemove).then((checkout) => {
				// Do something with the updated checkout
				console.log("remove from cart",checkout.lineItems); // Array with one additional line item
				Cart.checkout = checkout;
				Cart.open_cart();
				// $("#"+id+"-cartModal").modal("setZindex", 99999);
					// $("#"+id+"-cartModal").modal("open", { zindex: 99999 });
				});
			},
			load_cart: function  () {
				var Cart = this;
				var id = this.id;
				checkout = Cart.checkout;
				checkout.lineItems ;
				$("#"+id+"-cartModal .content .items").html("");
				var item_length = checkout.lineItems.length;
				if (item_length == 0 ) {
					$("#"+id+"-cartModal .content .empty").show();
					$("#"+id+"-cartModal .content .total").hide();
				}else{
					$("#"+id+"-cartModal .content .empty").hide();
					$("#"+id+"-cartModal .content .total").show();

				}
				$(checkout.lineItems).each(function() {
				// $( this ).addClass( "foo" );
				var line_item = this;
				console.log("load",line_item);
				Cart.load_item(line_item);
				});
				checkout.lineItems;
				$("#"+id+"-cartModal .totalPrice").html(checkout.totalPrice);
				Cart.activate_btns();
			},
			load_item: function  (line_item) {
				var Cart = this;
				var id = this.id;
				var row = $("<div></div>").addClass("line-item row");
				var title = $("<label></label>").html(line_item.title).addClass("col-4");
				var price = $("<label></label>").html(line_item.variant.price);
				var src = line_item.variant.image ? line_item.variant.image.src : "";
				var img = $("<img/>").attr("src",src).addClass("");
				var quantity = $("<input></input>").val(line_item.quantity);
				quantity.attr("type","number");
				quantity.addClass("form-control");
				var variant_id = $("<input></input>").val(line_item.variant.id);
				variant_id.attr("type","hidden").addClass("variant-id");
				var line_item_id = $("<input></input>").val(line_item.id);
				line_item_id.attr("type","hidden").addClass("line-item-id");
				var btn = $("<a>X</a>").addClass("remove").attr("href",line_item.id);
				var img_box = $("<div></div>").addClass("col-2").append(img);
				var number_box = $("<div></div>").addClass("quantity col-2").append(quantity);
				var price_box = $("<div></div>").addClass("price col-2").append(price);
				var remove_box = $("<div></div>").addClass("remove col-1").append(btn);
				row.append(line_item_id);
				row.append(variant_id);
				row.append(img_box);
				row.append(title);
				row.append(price_box);
				row.append(number_box);
				row.append(remove_box);
				$("#"+id+"-cartModal .content .items").append(row);

			},
			open_cart: function  () {
				var Cart = this;
				var id = this.id;
				Cart.load_cart();
				$("#"+id+"-cartModal").modal("show");

			},
			load_store: function() {
				var Cart = this;
				var id = this.id;
				storefrontAccessToken = Cart.storefrontAccessToken;
				domain = Cart.shop; 
				var cart = this;
				
				
				$.getScript( "https://sdks.shopifycdn.com/js-buy-sdk/v2/latest/index.umd.min.js", function( data, textStatus, jqxhr ) {
					console.log( ShopifyBuy ); // Success
					
					// $.getScript( "http://sdks.shopifycdn.com/buy-button/1.0.0/buybutton.js", function( data, textStatus, jqxhr ) {
					console.log( ShopifyBuy ); // Success
					console.log( textStatus ); // Success
					console.log( jqxhr.status ); // 200
					console.log( jqxhr ); // 200
					console.log( "Cart Load was performed." );
						const client = ShopifyBuy.buildClient({
						domain: domain,
						storefrontAccessToken: storefrontAccessToken
						});
						Cart.client = client;
							Cart.load_checkout().then(function() {
								console.log( "Cart Load was performed. inside load_check project" );

								Cart.get_products();
							
							});
						// var ui = ShopifyBuy.UI.init(client);
						// console.log("load_store ShopifyBuy.UI" ,ui);
						// ShopifyBuy.UI.onReady(client).then(function (ui) {
						// 		ui.createComponent('product', {
						// 		id: '4364604440629',
						// 		node: document.getElementById('product-component-1575250675382'),
						// 		moneyFormat: '%24%7B%7Bamount%7D%7D',
						// 		options: {
						// 			"product": {
						// 			"styles": {
						// 				"product": {
						// 				"@media (min-width: 601px)": {
						// 					"max-width": "calc(25% - 20px)",
						// 					"margin-left": "20px",
						// 					"margin-bottom": "50px"
						// 				}
						// 				}
						// 			},
						// 			"text": {
						// 				"button": "Add to cart"
						// 			}
						// 			},
						// 			"productSet": {
						// 			"styles": {
						// 				"products": {
						// 				"@media (min-width: 601px)": {
						// 					"margin-left": "-20px"
						// 				}
						// 				}
						// 			}
						// 			},
						// 			"modalProduct": {
						// 			"contents": {
						// 				"img": false,
						// 				"imgWithCarousel": true,
						// 				"button": false,
						// 				"buttonWithQuantity": true
						// 			},
						// 			"styles": {
						// 				"product": {
						// 				"@media (min-width: 601px)": {
						// 					"max-width": "100%",
						// 					"margin-left": "0px",
						// 					"margin-bottom": "0px"
						// 				}
						// 				}
						// 			},
						// 			"text": {
						// 				"button": "Add to cart"
						// 			}
						// 			},
						// 			"cart": {
						// 			"text": {
						// 				"total": "Subtotal",
						// 				"button": "Checkout"
						// 			}
						// 			}
						// 		},
						// 		});
						// 	});

					// });
				});
			
			},
			load_checkout: function  () {
				var Cart = this;
				var id = this.id;
				var productClass = Cart.productClass;
				var checkout_name = productClass+"_checkout_id";
				console.log("load checkout checkout_name",checkout_name);
				var checkout_id = $.cookie(checkout_name);
				console.log("load checkout checkout_id",checkout_id);
				var restartCheckout = this.restartCheckout;
				console.log("load checkout pre if restartCheckout",restartCheckout);

				// if (checkout_id !== undefined || checkout_id !== null) {
				if (restartCheckout || checkout_id == undefined || checkout_id == null) {
					console.log("load checkout new checkout checkout_id",checkout_id);
					this.restartCheckout = false;
					console.log("load checkout post if this.restartCheckout",this.restartCheckout);

					return Cart.new_checkout();
				}else{
					console.log("load_checkout checkout_id",checkout_id);
					return Cart.client.checkout.fetch(checkout_id).then((checkout) => {
					// Do something with the checkout
					console.log("checkout",checkout);
					if (checkout.order !== null){
						return Cart.new_checkout();
					}else{
							Cart.checkout = checkout; 
							// $.removeCookie(checkout_name);
							$.cookie(checkout_name, checkout.id);
					}

					});

				}
			},
			new_checkout: function  () {
				var Cart = this;
				var id = this.id;
				var productClass = Cart.productClass;
				var checkout_name = productClass+"_checkout_id";
				console.log("new checkout checkout_name",checkout_name);
				return Cart.client.checkout.create().then((checkout) => {
				// Do something with the checkout
				console.log("checkout",checkout);
				Cart.checkout = checkout; 
				$.cookie(checkout_name, checkout.id);
				});
			},
			get_products: function  () {
				var Cart = this;
				var id = this.id;
				// // 	// Fetch all products in your shop
				console.log("cart get_products pre fetch products");
				var encodedData = window.btoa('gid://shopify/Product/4364604440629'); // encode a string
				encodedData += "==";
				console.log("cart get_products pre fetch encodedData",encodedData);


				// return Cart.client.product.fetch([encodedData]).then((products) => {
				// 	// Do something with the products
				// 	console.log("cart products",products);
				//   });
				return Cart.client.product.fetchAll().then((products) => {
				// Do something with the products
				console.log(" cart products",products);
					Cart.load_products(products);
					Cart.activate_variants();
					
				});
			},


			

		}

	});

});
