/**
 * <card-order-table>
 * -----------------------------------------------------------------------------
 * Transaction table.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */

 jQuery(document).ready(function( $ ) {

	Vue.component('cardOrderTable', {

    //  ╔═╗╦═╗╔═╗╔═╗╔═╗
    //  ╠═╝╠╦╝║ ║╠═╝╚═╗
    //  ╩  ╩╚═╚═╝╩  ╚═╝
    props: [
      'orders',// « orders
      'type',// « bids or asks
    ],
  
    //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
    //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
    //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
    data: function (){
      return {
        formatType: undefined,
        formattedTimestamp: '',
        interval: undefined,
        totalBuy: 0,
        totalSell: 0,
      };
    },
  
    //  ╦ ╦╔╦╗╔╦╗╦
    //  ╠═╣ ║ ║║║║
    //  ╩ ╩ ╩ ╩ ╩╩═╝
    template: `
    <div class="row p-0 orders">
      <div class="col-md-12">
          <table class="table table-striped" align="center">
              <thead>
              <tr>
                  <th>Type</th>
                  <th>Name</th>
                  <th>Ship To</th>
                  <th>Total Charge</th>
                  <th class="">Status</th>
                  <th class="">Order Date</th>
              </tr>
              </thead>
              <tbody>
                  <tr v-for="order in orders" >
                       
                      <td>
                          <span class="type ticker-type">{{ order.type }} </span>
                      </td>
                      <td>
                          <span class="name">{{ order.firstName }} {{ order.lastName}} </span>
                      </td>
                      <td>
                          <span class="ship" v-if="order.shopOrderId && order.shopOrderId.country">{{ order.shopOrderId.country }}<br> {{ order.shopOrderId.address }}, {{order.shopOrderId.city }}, {{order.shopOrderId.state }}, {{order.shopOrderId.zip }} </span>
                          <span class="cardLocation" v-else >{{ order.country }}<br> {{ order.address }}, {{order.city }}, {{order.state }}, {{order.zip }} </span>


                      </td>
                      <td>
                          <span class="totalCharge" v-if="order.shopOrderId">{{ order.shopOrderId.total_price_usd }} {{ order.paymentCurrency }} </span>
                          <span class="totalCharge" v-else>{{ order.totalCharge }} {{ order.paymentCurrency }} </span>
                      </td>
                      <td>
                          <span class="status">{{ order.status }} </span>
                      </td>
                      <td>
                          <span class="status"> 
                                <js-timestamp :at="order.createdAt"></js-timestamp>
                          </span>
                      </td>
                      
                  </tr>
              </tbody>
          </table>
      </div>
    </div>
      
    `,
  
    //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
    //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
    //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
    beforeMount: function() {
        console.log("orders",this.orders);
        console.log("buyCurrency",this.buyCurrency);
        console.log("sell",this.sell);
        console.log("this.buy",this.buy);
        console.log("this",this);
  
    },
  
  
  
    //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
    //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
    //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
    methods: {
  
    }
  
  });
});

  