/**
 * <checkout-table>
 * -----------------------------------------------------------------------------
 * Transaction table.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */

 jQuery(document).ready(function( $ ) {

	Vue.component('checkoutTable', {

  //  ╔═╗╦═╗╔═╗╔═╗╔═╗
  //  ╠═╝╠╦╝║ ║╠═╝╚═╗
  //  ╩  ╩╚═╚═╝╩  ╚═╝
  props: [
    'checkouts',// « The JS timestamp to format
    'assets',// « Whether to shorten the formatted date by not including the time of day (may only be used with timeago, and even then only applicable in certain situations)
  ],

  //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
  //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
  //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
  data: function (){
    return {
        // Main syncing/loading state for this page.
        syncing: false,

        // Form data
        formData: { /* … */ },

        // For tracking client-side validation errors in our form.
        // > Has property set to `true` for each invalid property in `formData`.
        formErrors: { /* … */ },

        // A set of validation rules for our form.
        // > The form will not be submitted if these are invalid.
        formRules: {
        checkoutId: { required: true },
        },

        // Server error state for the form
        cloudError: '',
    };
  },

  //  ╦ ╦╔╦╗╔╦╗╦
  //  ╠═╣ ║ ║║║║
  //  ╩ ╩ ╩ ╩ ╩╩═╝
  template: `
  <div class="row mb-3 checkouts">
                              <div class="col-md-12">
                                  <table class="table table-striped" align="center">
                                      <thead>
                                          <tr>
                                              <th>Type</th>
                                            <!--  <th>Total</th> -->
                                              <th>User</th>
                                              <th>Status</th>
                                              <th>Updated</th>
                                              <th>Created</th>
                                              <th>Total</th>
                                              <th>Portfolio</th>
                                              <th></th>
                                          </tr>
                                      </thead>
                                      <tbody>
                                      <tr v-for="checkout in checkouts"   class="checkout">
                                          <td v-if="checkout.action == 'mint' " >
                                              Mint Token
                                          </td>
                                          <td v-else-if="checkout.action == 'buyCard' " >
                                              Debit Card
                                          </td>
                                          <td v-else="checkout.action == 'buyUnits' || checkout.action == 'buy' || checkout.action == 'sellUnits' || checkout.action == 'sell' " >
                                             {{ checkout.title == 'Checkout'? 'Buy Units' : checkout.title}}
                                          </td>
                                          <td v-else>
                                             Purchase
                                          </td>
                                          <!--
                                          <td >
                                              {{checkout.price}}
                                          </td>
                                          -->
                                          <td >
                                              {{checkout.user_id.fullName}}
                                          </td>
                                          <td v-if="checkout.processing">
                                              Processing test
                                          </td>
                                          <td v-else>
                                              Complete test
                                          </td>
                                          <td >
                                            <js-timestamp :at="checkout.updatedAt" format="timeago" short="false"></js-timestamp> 
                                          </td>
                                          <td >
                                            <js-timestamp :at="checkout.createdAt" format="timeago" short="false"></js-timestamp> 
                                          </td>
                                          <td v-if="checkout.action == 'sellUnits' || checkout.action == 'sell' ">
                                            $ <span class="total">{{parseFloat(checkout.sub_total).toFixed(2) }}</span>
                                          </td>
                                          <td v-else="">
                                            $ <span class="total">{{parseFloat(checkout.total_charge).toFixed(2) }}</span>
                                          </td>
                                          <td >
                                            {{checkout.portfolioId ? checkout.portfolioId.name : "None"}}
                                          </td>
                                          <td class="checkout-action" >
                                          <!--  <ajax-form action="cancelCheckout" :syncing.sync="syncing" :cloud-error.sync="cloudError" :form-data="formData" :form-rules="formRules" :form-errors.sync="formErrors" @submitted="submittedForm($event)"> -->

                                                <router-link v-if="checkout.proccessing" class="refresh btn btn-primary btn-sm p-4" :to="'/checkout/refresh/'+checkout.id">Refresh</router-link>
                                                <button v-else=""  :class="checkout.id + ' btn-danger btn-lg btn-block cancel-checkout btn-action-checkout'"  :id="checkout.id">Cancel</button>
                                                <button  :class="checkout.id + ' btn-primary btn-lg btn-block refresh-checkout btn-action-checkout'"  :id="checkout.id">Refresh</button>
                                                <ajax-button style="display: none;" :syncing="syncing" class="btn-primary btn-lg btn-block submit-btn"  >Cancel</ajax-button>

                                                <!-- <router-link v-else="" class="refresh btn btn-primary btn-sm p-4" :to="'/checkout/refresh/'+checkout.id">View</router-link> -->
                                           <!--  </ajax-form> -->
                                          </td>
                                      </tr>
                                      </tbody>
                                  </table>
                              </div>
                            </div>
    
  `,

  //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
  //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
  //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
  beforeMount: function() {
      console.log("this.at",this.totals);

  },
  mounted: async function() {
    //…
    this.activateCancelCheckout()
  },



  //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
  //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
  //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
  methods: {
    activateCancelCheckout: function() {
        var Orders = this;
        $(".cancel-checkout").off("click").on("click", async function(event) {
          var cancelButton = event.target;
          var id = $(event.target).attr("id");
        //   $(event.target).hide().addClass("d-none").removeClass("d-block");
          // var id = $(event.target).attr("id");
          Orders.formData.checkoutId = id;
          Orders.syncing = true;

          var submitBtn = $(event.target).parents(".checkout").find(".submit-btn");
          var actionBtns = $(event.target).parents(".checkout").find(".btn-action-checkout");
        //   submitBtn.click().show().addClass("d-block");
            actionBtns.hide().addClass("d-none").removeClass("d-block");

          submitBtn.show().addClass("d-block").removeClass("d-none");

          var chargeInfo = {
            checkoutId:id,
          }
    
          var data =  await Cloud.cancelCheckout.with(chargeInfo)
          .tolerate(()=>{
            this.cloudError = true;
          });
    
            var id = data.id;
            // $(cancelButton).show().addClass("d-block").removeClass("d-none");
            if(data.flag){
            // $(cancelButton).attr("disabled","disabled");
            }
            // var id = $(cancelButton).attr("id");
    
            // var submitBtn = $(cancelButton).parents(".checkout").find(".submit-btn");
            submitBtn.hide().addClass("d-none").removeClass("d-block");
            var refreshBtn = $(event.target).parents(".checkout").find(".refresh-checkout");
            refreshBtn.show().addClass("d-block").removeClass("d-none");

  
          
          
  
       });
       $(".refresh-checkout").off("click").on("click", async function(event) {
        var refreshButton = event.target;
        var id = $(event.target).attr("id");
      //   $(event.target).hide().addClass("d-none").removeClass("d-block");
        // var id = $(event.target).attr("id");
        Orders.formData.checkoutId = id;
        Orders.syncing = true;

        var submitBtn = $(event.target).parents(".checkout").find(".submit-btn");
        var actionBtns = $(event.target).parents(".checkout").find(".btn-action-checkout");
      //   submitBtn.click().show().addClass("d-block");
          actionBtns.hide().addClass("d-none").removeClass("d-block");

        submitBtn.show().addClass("d-block").removeClass("d-none");

        var chargeInfo = {
          checkoutId:id,
        }
  
        var data =  await Cloud.refreshCheckout.with(chargeInfo)
        .tolerate(()=>{
          this.cloudError = true;
        });
  
          var id = data.id;
          // $(refreshButton).show().addClass("d-block").removeClass("d-none");
          if(data.flag){
          // $(refreshButton).attr("disabled","disabled");
          }
          // var id = $(refreshButton).attr("id");
  
          // var submitBtn = $(refreshButton).parents(".checkout").find(".submit-btn");
          submitBtn.hide().addClass("d-none").removeClass("d-block");
        //   var refreshBtn = $(event.target).parents(".checkout").find(".refresh-checkout");
          actionBtns.show().addClass("d-block").removeClass("d-none");

     });
      },
      submittedForm: async function(data) {
        // Redirect to the logged-in dashboard on success.
        // > (Note that we re-enable the syncing state here.  This is on purpose--
        // > to make sure the spinner stays there until the page navigation finishes.)
        this.syncing = true;
      
  
        var id = data.id;
        var cancelButton = $(".checkout-action ."+id);
        $(cancelButton).show().addClass("d-block");
        if(data.flag){
          $(cancelButton).attr("disabled","disabled");
        }
        // var id = $(cancelButton).attr("id");
  
        var submitBtn = $(cancelButton).parents(".checkout").find(".submit-btn");
        submitBtn.hide().addClass("d-none");
        
      },

  }

});
});
