/**
 * <checkouts-table>
 * -----------------------------------------------------------------------------
 * Transaction table.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */

 jQuery(document).ready(function( $ ) {

	Vue.component('checkoutsTable', {

  //  ╔═╗╦═╗╔═╗╔═╗╔═╗
  //  ╠═╝╠╦╝║ ║╠═╝╚═╗
  //  ╩  ╩╚═╚═╝╩  ╚═╝
  props: [
    'checkouts',// « checkouts
  ],

  //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
  //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
  //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
  data: function (){
    return {
      formatType: undefined,
      formattedTimestamp: '',
      interval: undefined,
      totalBuy: 0,
      totalSell: 0,
    };
  },

  //  ╦ ╦╔╦╗╔╦╗╦
  //  ╠═╣ ║ ║║║║
  //  ╩ ╩ ╩ ╩ ╩╩═╝
  template: `
  <div class="row mb-3 checkouts">
    <div class="col-md-12">
        <table class="table table-striped" align="center">
            <thead>
                <tr>
                    <th>Type</th>
                  <!--  <th>Total</th> -->
                    <th>Status</th>
                    <th>Updated</th>
                    <th>Created</th>
                    <th>Total</th>
                    <th>Portfolio</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
            <tr v-for="checkout in checkouts"  :id="checkout.id">
                <td v-if="checkout.action == 'mint' " >
                    Mint Token
                </td>
                <td v-else-if="checkout.action == 'buyCard' " >
                    Debit Card
                </td>
                <td v-else="checkout.action == 'buyUnits' || checkout.action == 'buy' || checkout.action == 'sellUnits' || checkout.action == 'sell' " >
                   {{ checkout.title == 'Checkout'? 'Buy Units' : checkout.title}}
                </td>
                <td v-else>
                   Purchase
                </td>
                <!--
                <td >
                    {{checkout.price}}
                </td>
                -->
                <td v-if="checkout.processing">
                    Processing
                </td>
                <td v-else>
                    Complete
                </td>
                <td >
                  <js-timestamp :at="checkout.updatedAt" format="timeago" short="false"></js-timestamp> 
                </td>
                <td >
                  <js-timestamp :at="checkout.createdAt" format="timeago" short="false"></js-timestamp> 
                </td>
                <td v-if="checkout.action == 'sellUnits' || checkout.action == 'sell' ">
                  $ <span class="total">{{parseFloat(checkout.sub_total).toFixed(2) }}</span>
                </td>
                <td v-else="">
                  $ <span class="total">{{parseFloat(checkout.total_charge).toFixed(2) }}</span>
                </td>
                <td >
                  {{checkout.portfolioId ? checkout.portfolioId.name : "None"}}
                </td>
                <td >
                    <router-link v-if="checkout.proccessing" class="refresh btn btn-primary btn-sm p-4" :htoref="'/orders/checkout/refresh/'+checkout.id">Refresh</router-link>
                    <router-link v-else="" class="refresh btn btn-primary btn-sm p-4" :to="'/orders/checkout/refresh/'+checkout.id">View</router-link>
                </td>
                
            </tr>
            </tbody>
        </table>
    </div>
  </div>
    
  `,

  //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
  //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
  //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
  beforeMount: function() {
    //   console.log("checkouts",this.checkouts);
  },
  mounted: function() {
      console.log("mounted checkouts",this.checkouts);
      this.bindUIActions();


  },



  //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
  //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
  //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
  methods: {
    bindUIActions: function() {
      var checkouts = this;
      $(".refresh").on("click", function(event) {
         //set action
         $("body .loading").show(); 
         $("#page-wrap").hide(); 
       });
    },
    cancel: async function (id) {
        var page = this;
        console.log("cancel checkout",id);
        // var csrf = await CSRF.token();
        // var apiRequestHeader = {
        //     'X-CSRF-Token':csrf._csrf,
        //       // 'cookie':cookie
        //   };
        $.ajax({
              type: "POST",
            //   url: this.refreshUrl+"/markets/checkouts/cancel",
              url: "/markets/checkouts/cancel",
              data: {checkoutId:id}, // serializes the form's elements.
              // headers:apiRequestHeader,
              success: function(data, textStatus, request)
              {
                  console.log('got the data!!!',data); // show response from the php script.
                  if(data.flag){
                      $("#"+id).hide();
                  }
                //   var balances = data.balances;
                //   page.render(balances);
  
              }
            });
        // window.location = '/';
      },

  }

});
});
