/**
 * <referral-table>
 * -----------------------------------------------------------------------------
 * Transaction table.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */

 jQuery(document).ready(function( $ ) {

	Vue.component('referralTable', {

    //  ╔═╗╦═╗╔═╗╔═╗╔═╗
    //  ╠═╝╠╦╝║ ║╠═╝╚═╗
    //  ╩  ╩╚═╚═╝╩  ╚═╝
    props: [
      'referrals',// « referrals
      'type',// « bids or asks
    ],
  
    //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
    //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
    //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
    data: function (){
      return {
        formatType: undefined,
        formattedTimestamp: '',
        interval: undefined,
        totalBuy: 0,
        totalSell: 0,
      };
    },
  
    //  ╦ ╦╔╦╗╔╦╗╦
    //  ╠═╣ ║ ║║║║
    //  ╩ ╩ ╩ ╩ ╩╩═╝
    template: `
    <div class="row p-0 referrals">
      <div class="col-md-12">
          <table class="table table-striped" align="center">
              <thead>
              <tr>
                  <th>Type</th>
                  <th>Name</th>
                  <th>Commission</th>
                  <th class="">Status</th>
                  <th class="">Order Date</th>
              </tr>
              </thead>
              <tbody>
                  <tr v-for="referral in referrals" >
                       
                      <td>
                          <span class="type ticker-type">{{ referral.orderId.type }} </span>
                      </td>
                      <td>
                          <span class="name">{{ referral.orderId.firstName }} {{ referral.orderId.lastName}} </span>
                      </td>
                      <td>
                          <span class="payment">{{ referral.payment }} {{ referral.paymentCurrency }} </span>
                      </td>
                      <td>
                          <span class="status">{{ referral.status }} </span>
                      </td>
                      <td>
                          <span class="status"> 
                                <js-timestamp :at="referral.createdAt"></js-timestamp>
                          </span>
                      </td>
                      
                  </tr>
              </tbody>
          </table>
      </div>
    </div>
      
    `,
  
    //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
    //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
    //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
    beforeMount: function() {
        console.log("referrals",this.referrals);
        console.log("buyCurrency",this.buyCurrency);
        console.log("sell",this.sell);
        console.log("this.buy",this.buy);
        console.log("this",this);
  
    },
  
  
  
    //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
    //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
    //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
    methods: {
  
    }
  
  });
});
  