/**
 * <subscription-table>
 * -----------------------------------------------------------------------------
 * Transaction table.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */

 jQuery(document).ready(function( $ ) {

	Vue.component('subscriptionTable', {

  //  ╔═╗╦═╗╔═╗╔═╗╔═╗
  //  ╠═╝╠╦╝║ ║╠═╝╚═╗
  //  ╩  ╩╚═╚═╝╩  ╚═╝
  props: [
    'subscriptions',// « subscriptions
    'status',// « status
  ],

  //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
  //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
  //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
  data: function (){
    return {
      formatType: undefined,
      formattedTimestamp: '',
      interval: undefined,
      totalBuy: 0,
      totalSell: 0,
    };
  },

  //  ╦ ╦╔╦╗╔╦╗╦
  //  ╠═╣ ║ ║║║║
  //  ╩ ╩ ╩ ╩ ╩╩═╝
  /*

                  title //
                totalt cost //

                pause/activate //

                check out total // fuck this too
                order cont/trades // fuck this 
*/
  template: `
  <div class="row mb-3 subscription">
    <div class="col-md-12">
        <table class="table table-striped" align="center">
            <thead>
                <tr>
                <th>Subscription</th>
                <th>Frequency</th>
                <th>Portfolio</th>
                <th>Cost</th>
                <th>Last Payment</th>
                <th>Next Payment</th>
                <th> </th>

                </tr>
            </thead>
            <tbody>
            <tr v-for="subscription in subscriptions" class="subscription" v-if="subscription.status == status "  :id="subscription.id">
                <td >
                    {{subscription.checkoutId.title}}
                </td>
                 <td >
                    <span style="text-transform: capitalize;"> {{subscription.frequency}} </span>
                </td>
                <td >
                    <span style="text-transform: capitalize;"> {{subscription.portfolioId ? subscription.portfolioId.name : "None"}} </span>
                </td>
            

                <td >
                    {{subscription.checkoutId.total_charge}}
                </td>
                <td >
                    <js-timestamp :at="subscription.lastPaymentAt" format="timeago" short="false"></js-timestamp>
                </td>
                <td >
                    <js-timestamp :at="subscription.nextPaymentAt" format="timeago" short="false"></js-timestamp>
                </td>
            

                <td v-if="subscription.status == 'paused' " >
                    <a class="activate btn btn-success" :href="subscription.id">Activate </a>
                    <a class="pause btn btn-danger d-none" :href="subscription.id">Pause </a>
                </td>
                <td v-else="" >
                    <a class="activate btn btn-success d-none" :href="subscription.id">Activate </a>
                    <a class="pause btn btn-danger" :href="subscription.id">Pause </a>
                </td>
            </tr>
            </tbody>
        </table>
    </div>
  </div>
    
  `,

  //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
  //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
  //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
  beforeMount: function() {
    //   console.log("subscriptions",this.subscriptions);
  },
  mounted: function() {
      console.log("mounted subscriptions",this.subscriptions);
      this.bindUIActions();


  },



  //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
  //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
  //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
  methods: {
    bindUIActions: function() {
      var Orders = this;
      $(".activate").off("click").on("click", function(event) {
         //set action
         event.preventDefault();
         var id = $(event.target).attr("href");
         $(event.target).attr("disabled","disabled");
         Orders.pause(id,false);
       });
       $(".pause").off("click").on("click", function(event) {
         //set action
         event.preventDefault();
         var id = $(event.target).attr("href");
         $(event.target).attr("disabled","disabled");
         Orders.pause(id,true);
       });
    },
    pause: async function (id,pause) {
        var page = this;
        console.log("pause subscription",id);
        // var csrf = await CSRF.token();
        // var apiRequestHeader = {
        //     'X-CSRF-Token':csrf._csrf,
        //       // 'cookie':cookie
        //   };
        $.ajax({
              type: "POST",
            //   url: this.refreshUrl+"/subscriptions/pause",
              // url: '/wp-json/yohshow/api/v1/orders',
              url: "/wp-json/yohshow/api/v1/subscriptions/pause",
              data: {subscriptionId:id,pause:pause}, // serializes the form's elements.
              // headers:apiRequestHeader,
              success: function(data, textStatus, request)
              {
                data = JSON.parse(data);
                //   console.log('got the data!!!',data); // show response from the php script.
                  if(data.flag){
                      if(pause){
                        $("#"+id).find(".pause").addClass("d-none").removeAttr("disabled");
                        $("#"+id).find(".activate").removeClass("d-none").removeAttr("disabled");
                      }else{
                        $("#"+id).find(".pause").removeClass("d-none").removeAttr("disabled");
                        $("#"+id).find(".activate").addClass("d-none").removeAttr("disabled");
                      }
                  }else{
                    $("#"+id).find(".pause").removeAttr("disabled");
                    $("#"+id).find(".activate").removeAttr("disabled");
                    $("#"+id).find(".pause").removeAttr("disabled");
                    $("#"+id).find(".activate").removeAttr("disabled");
                  }
                //   var balances = data.balances;
                //   page.render(balances);
  
              }
            });
        // window.location = '/';
      },

  }

});
});
