/**
 * <trade-history-table>
 * -----------------------------------------------------------------------------
 * Transaction table.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */

jQuery(document).ready(function( $ ) {

	Vue.component('tradeHistoryTable', {

  //  ╔═╗╦═╗╔═╗╔═╗╔═╗
  //  ╠═╝╠╦╝║ ║╠═╝╚═╗
  //  ╩  ╩╚═╚═╝╩  ╚═╝
  props: [
    'trades',// « trades
    'marketFilter',// « marketFilter
    'tradeType',// « marketFilter
  ],

  //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
  //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
  //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
  data: function (){
    return {
      formatType: undefined,
      formattedTimestamp: '',
      interval: undefined,
      totalBuy: 0,
      totalSell: 0,
    };
  },

  //  ╦ ╦╔╦╗╔╦╗╦
  //  ╠═╣ ║ ║║║║
  //  ╩ ╩ ╩ ╩ ╩╩═╝
  template: `
  <div class="row mb-3 trade-history">
    <div class="col-md-12">
        <table class="table table-striped" align="center">
            <thead>
                <tr>
                <th>Market</th>
                <th>Type</th>
                <th>Status</th>
                <th>Price/Share</th>
                <th>Amount</th>
                <!-- <th>Fee</th> -->
                <th>Total</th>
                
                <th>Portfolio</th>
                <th>Updated Last</th>
                <th>Transaction Date</th>
                </tr>
            </thead>
            <tbody>
               <!-- <tr v-for="trade in trades"  v-if="trade.state == 'done' "  :class="trade.market"> -->
                <tr v-for="trade in trades" v-if="marketFilter.length == 0 || marketFilter.includes(trade.market)"   :class="trade.market">
                    <td >
                        {{trade.market}} 
                    </td>
                    <td >
                        <span :class="trade.side">{{trade.side}}</span>
                    </td>
                    <td >
                        {{trade.state}} 
                    </td>
                    <td >
                        {{trade.price}}
                    </td>
                    <td v-if="tradeType == 'order' " >
                      {{trade.executedVolume}}

                    </td>
                    <td v-else >
                        {{trade.amount}}
                    </td>
                    <!-- <td >
                        {{trade.fee}}
                    </td> -->
                    <td v-if="tradeType == 'order' ">
                      {{trade.price * trade.executedVolume }}
                        
                    </td>
                    <td v-else>
                        {{trade.price * trade.amount }}
                    </td>
          
                    
                    <td >
                      {{trade.portfolioId ? trade.portfolioId.name : "None"}}
                    </td>
                    <td >
                      <js-timestamp :at="trade.updatedAt" format="timeago" short="false"></js-timestamp>
                    </td>
                    <td >
                      <js-timestamp :at="trade.createdAt" format="timeago" short="false"></js-timestamp>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
  </div>
    
  `,

  //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
  //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
  //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
  beforeMount: function() {
    //   console.log("trades",this.trades);
  },
  mounted: function() {
      // console.log("mounted trades",this.trades);
      this.bindUIActions();


  },



  //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
  //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
  //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
  methods: {
    bindUIActions: function() {

    },
 

  }

});
});

