jQuery(function($) {
  if(jQuery(".yoh-balances").length > 0){

    // 0. If using a module system (e.g. via vue-cli), import Vue and VueRouter
    // and then call `Vue.use(VueRouter)`.

    // 1. Define route components.
    // These can be imported from other files
    // const Foo = { template: '<div>foo</div>' }
    // const Bar = { template: '<div>bar</div>' }

    // 2. Define some routes
    // Each route should map to a component. The "component" can
    // either be an actual component constructor created via
    // `Vue.extend()`, or just a component options object.
    // We'll talk about nested routes later.
    const routes = [
      // { path: '/foo', component: Vue.component('markets') },
      // { path: '/bar', component: Bar },
      //markets
      { path: '/balances', component: Vue.component('balances') },
      { path: '/accounts', component: Vue.component('accounts') },
      { path: '/liquidity', component: Vue.component('liquidity') },
      { path: '/profile', component: Vue.component('profile') },
      { path: '/info', component: Vue.component('info') },
      { path: '/password', component: Vue.component('password') },
      { path: '/mint', component: Vue.component('mint') },
      { path: '/mint/:tokenId', component: Vue.component('mint') },

      { path: '/create', component: Vue.component('mint') },
      { path: '/create/:tokenId', component: Vue.component('mint') },

      { path: '/orders', component: Vue.component('orders') },
      { path: '/paymentMethods', component: Vue.component('paymentMethods') },


      { path: '/contact', component: Vue.component('contact') },
      { path: '/kyc', component: Vue.component('kyc') },
      { path: '/register', component: Vue.component('register') },
      { path: '/debitCards', component: Vue.component('debitCards') },
      { path: '/tokenomics', component: Vue.component('tokenomics') },
      { path: '/login', component: Vue.component('login') },
      { path: '/signup', component: Vue.component('signup') },
      { path: '/faq', component: Vue.component('faq') },
      { path: '/otc', component: Vue.component('otc') },

      { path: '/page', component: Vue.component('page') },

      { path: '/login/:action/:subaction/:subactionId', component: Vue.component('login') },
      { path: '/signup/:action/:subaction/:subactionId', component: Vue.component('signup') },

      { path: '/login/:action/:subaction', component: Vue.component('login') },
      { path: '/signup/:action/:subaction', component: Vue.component('signup') },

      { path: '/login/:action', component: Vue.component('login') },
      { path: '/signup/:action', component: Vue.component('signup') },

      

      
      
      
      { path: '/transfer', component: Vue.component('transfer') },
      { path: '/swap', component: Vue.component('transfer') },
      { path: '/account', component: Vue.component('account') },
      { path: '/account/:accountId', component: Vue.component('account') },
      { path: '/account/:userType/:accountId/:searchTokenId', component: Vue.component('account') },
      // { path: '/quote/:tradeType/:id', component: Vue.component('quote') },
      // { path: '/pay-now/:id', component: Vue.component('payNow') },
      { path: '/checkout/:id', component: Vue.component('checkout') },
      { path: '/checkout/refresh/:id', component: Vue.component('checkout') },
      { path: '/orders/checkout/refresh/:id', component: Vue.component('checkout') },
      // { path: '/orders', component: Vue.component('orders') },

      // //balances
      // { path: '/balances', component: Vue.component('balances') },
      // { path: '/accounts', component: Vue.component('accounts') },
      // { path: '/account', component: Vue.component('account') },
      // { path: '/transfer', component: Vue.component('transfer') },


      //markets
      { path: '/markets', component: Vue.component('markets') },
      { path: '/markets/:id', component: Vue.component('market') },
      { path: '/quote/:tradeType/:id', component: Vue.component('quote') },
      { path: '/pay-now/:id', component: Vue.component('payNow') },
      { path: '/checkout/:id', component: Vue.component('checkout') },
      // { path: '/orders', component: Vue.component('orders') },

      // //balances
      // { path: '/balances', component: Vue.component('balances') },
      // { path: '/accounts', component: Vue.component('accounts') },
      // { path: '/account', component: Vue.component('account') },
      // { path: '/transfer', component: Vue.component('transfer') },
    ]

    // 3. Create the router instance and pass the `routes` option
    // You can pass in additional options here, but let's
    // keep it simple for now.
    const router = new VueRouter({
      routes // short for `routes: routes`
    })

    var vm = new Vue({ 
        router:router,
        el: '.yoh-balances',
        //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
        //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
        //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
        data: {
          // exchangeError:"",
          // error:{},
          // markets:[],
          // appToken:{},
          // stableToken:{},
          // appTokenSymbol: "",
          // stableTokenSymbol: "",
          // baseUrl:"",
          // //…
          // refreshUrl:'',
          // loadingMarkets: true,
          // cloudLoadingError: '',
        },

        //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
        //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
        //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝

        beforeMount: async function() {
          // // Attach any initial data from the server.
          // // _.extend(this, YOH_SHOW_LOCALS);
          // _.extend(this, YOH_SHOW_LOCALS);
          // this.refreshUrl = this.baseUrl;
          // console.log("about to listen");
          // // this.watchMarkets();
          // // this.listen();
          // await this.listen();  

          // console.log("should listening");
      
        },
        mounted: async function() {
          // setTimeout(function(){ 
          //     $("body .loading").hide(); 
          //     $("#page-wrap").show(); 
          // } (), 501);
          // // this.refresh();
          await this.bindUIAction();
      
        },
        //  ╦  ╦╦╦═╗╔╦╗╦ ╦╔═╗╦    ╔═╗╔═╗╔═╗╔═╗╔═╗
        //  ╚╗╔╝║╠╦╝ ║ ║ ║╠═╣║    ╠═╝╠═╣║ ╦║╣ ╚═╗
        //   ╚╝ ╩╩╚═ ╩ ╚═╝╩ ╩╩═╝  ╩  ╩ ╩╚═╝╚═╝╚═╝
        // Configure deep-linking (aka client-side routing)
        virtualPagesRegExp: /^\/welcome\/?([^\/]+)?\/?/,
        afterNavigate: async function(virtualPageSlug){
          // `virtualPageSlug` is determined by the regular expression above, which
          // corresponds with `:unused?` in the server-side route for this page.
          switch (virtualPageSlug) {
            case 'hello':
              this.modal = 'example';
              break;
            default:
              this.modal = '';
          }
        },

        //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
        //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
        //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
        methods: {
          bindUIAction: async function(e) {
            var Mint = this;
            $('.exchange-link').click(function(evt) {
              /*
                if has the class//
                preventDefualt //
                get href //
                do router push to //
              */
                evt.preventDefault();
                
                
                var href = $(evt.target).attr("href");
                if(!href){
                  var href = $(evt.target).parents("a").attr("href");

                }
                var hrefList = href.split("#");
                var link = hrefList[1];
                Mint.$router.push(link);
                $('.exchange-link, .exchange-link a').removeClass("exchange-link-active");
                $('.exchange-link').removeClass("exchange-link-active");
                $(evt.target).addClass("exchange-link-active");
                $(evt.target).parent(".exchange-link").addClass("exchange-link-active");



            });
      
      
          },

        }
      });


}
    
});