/**
 * <market-table>
 * -----------------------------------------------------------------------------
 * Transaction table.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */

Vue.component('marketTable', {

  //  ╔═╗╦═╗╔═╗╔═╗╔═╗
  //  ╠═╝╠╦╝║ ║╠═╝╚═╗
  //  ╩  ╩╚═╚═╝╩  ╚═╝
  props: [
    'markets',// « The JS timestamp to format
    'label',// « Whether to shorten the formatted date by not including the time of day (may only be used with timeago, and even then only applicable in certain situations)
    'format',// « one of: 'calendar', 'timeago' (defaults to 'timeago'.  Otherwise, the "calendar" format displays data as US-style calendar dates with a four-character year, separated by dashes.  In other words: "MM-DD-YYYY")
  ],

  //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
  //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
  //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
  data: function (){
    return {
      formatType: undefined,
      formattedTimestamp: '',
      interval: undefined
    };
  },

  //  ╦ ╦╔╦╗╔╦╗╦
  //  ╠═╣ ║ ║║║║
  //  ╩ ╩ ╩ ╩ ╩╩═╝
  template: `
  <div class="row mb-3 markets">
    <div class="col-md-12">
        <table class="table" align="center">
            <thead>
            <tr>
                <th>ASSET</th>
                <th>LAST PRICE</th>
                <th class="">24H CHANGE</th>
                <th class="">24H HIGH</th>
                <th>24H LOW</th>
                <th>24H VOLUME</th>
                <th></th>
                <th></th>
            </tr>
            </thead>
            <tbody class="tickers">
                
                

            </tbody>
        </table>
    </div>
  </div>
    
  `,

  //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
  //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
  //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
  beforeMount: function() {
      console.log("markets",this.markets);

  },



  //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
  //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
  //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
  methods: {

  }

  /*
    <tr v-for="market in markets">
        <td>
            <a :href="'/account/markets/'" >
                <div class="symbol">{{ market.symbol }}</div>
                <div class="name">{{ market.name }}</div>
            </a>
        </td>
        <td>
            <span class="lastPrice">{{ market.lastPrice }} </span>
        </td>
        <td>
            <span class="change">{{ market.change }}</span>
        </td>
        <td>
            <span class="high">{{ market.high }}</span>
        </td>
        <td>
            <span class="low">{{ market.low }}</span>
        </td>
        <td>
            <span class="volume">{{ market.volume }}</span>
        </td>
    </tr>
  */

});
