/**
 * <order-table>
 * -----------------------------------------------------------------------------
 * Transaction table.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */

Vue.component('orderTable', {

  //  ╔═╗╦═╗╔═╗╔═╗╔═╗
  //  ╠═╝╠╦╝║ ║╠═╝╚═╗
  //  ╩  ╩╚═╚═╝╩  ╚═╝
  props: [
    'orders',// « orders
    'sell',// « sell currency
    'buy',// « buy currency
    'type',// « bids or asks
  ],

  //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
  //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
  //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
  data: function (){
    return {
      formatType: undefined,
      formattedTimestamp: '',
      interval: undefined,
      totalBuy: 0,
      totalSell: 0,
    };
  },

  //  ╦ ╦╔╦╗╔╦╗╦
  //  ╠═╣ ║ ║║║║
  //  ╩ ╩ ╩ ╩ ╩╩═╝
  template: `
  <div class="row mb-3 orders">
    <div class="col-md-12">
        <table class="table table-striped" align="center">
            <thead>
            <tr>
                <th>Price</th>
                <th>{{sell}}</th>
                <th class="">{{buy}}</th>
                <th class="">SUM ({{buy}})</th>
            </tr>
            </thead>
            <tbody>
                <tr v-for="order in orders" >
                    <td>
                        <span class="price ticker-price">{{ order.price }} </span>
                    </td>
                    <td>
                        <span class="amount">{{ order.remainingVolume }} </span>
                    </td>
                    <td>
                        <span class="total">{{ order.price * order.remainingVolume }}</span>
                    </td>
                    <td>
                        <span class="total">{{ order.price * order.remainingVolume }}</span>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
  </div>
    
  `,

  //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
  //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
  //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
  beforeMount: function() {
      console.log("orders",this.orders);
      console.log("buyCurrency",this.buyCurrency);
      console.log("sell",this.sell);
      console.log("this.buy",this.buy);
      console.log("this",this);

  },



  //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
  //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
  //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
  methods: {

  }

});
