jQuery(function() {
  var vm = new Vue({ 
      el: '.yoh-accounts',
    //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
    //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
    //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
    data: {
      // Form data
      formData: { 
        type: "personal"
      },

      // For tracking client-side validation errors in our form.
      // > Has property set to `true` for each invalid property in `formData`.
      formErrors: { /* … */ },

      // Syncing / loading state
      syncing: false,

      // Server error state
      cloudError: '',

      // Success state when form has been submitted
      cloudSuccess: false,
    },

    //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
    //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
    //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
    beforeMount: function() {
      // Attach any initial data from the server.
      _.extend(this, YOH_SHOW_LOCALS);
    },
    mounted: async function() {
      //…
    },

    //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
    //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
    //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
    methods: {
      submittedForm: async function() {
        console.log("submittedForm");
        window.location = '/cards';
      },

      handleParsingForm: function() {
        // Clear out any pre-existing error messages.
        this.formErrors = {};

        var argins = this.formData;

        // Validate type:
        if(!argins.type) {
          this.formErrors.type = true;
        }
        // Validate name:
        if(!argins.name) {
          this.formErrors.name = true;
        }
        // Validate description:
        if(!argins.description) {
          this.formErrors.description = true;
        }


        // If there were any issues, they've already now been communicated to the user,
        // so simply return undefined.  (This signifies that the submission should be
        // cancelled.)
        if (Object.keys(this.formErrors).length > 0) {
          return;
        }

        return argins;
      },
    }
  });
});
