jQuery(function() {
    var vm = new Vue({ 
        el: '.yoh-transfer',
    //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
    //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
    //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
    data: {
      isBillingEnabled: false,

      hasBillingCard: false,

      // Syncing/loading states for this page.
      syncingOpenCheckout: false,
      syncingUpdateCard: false,
      syncingRemoveCard: false,
      // Form data
      formData: { 
        transferType: "internal"
      },

      // For tracking client-side validation errors in our form.
      // > Has property set to `true` for each invalid property in `formData`.
      formErrors: { /* … */ },

      // Syncing / loading state
      syncing: false,

      // Server error state
      cloudError: '',

      // Success state when form has been submitted
      cloudSuccess: false,
    },

    //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
    //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
    //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
    beforeMount: function() {
      // Attach any initial data from the server.
      _.extend(this, YOH_SHOW_LOCALS);
    },
    mounted: async function() {
      //…
    },

    //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
    //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
    //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
    methods: {
      changeTransferType: async function(e) {
        var type = $("#transferType").val();
        // var isFreeze = $(e.target).hasClass("freeze");
        // var isClose = $(e.target).hasClass("close");
        // var isView = $(e.target).hasClass("view");
        // var isOpen = $(e.target).hasClass("open");
        $(".nav-transfers .transferType").hide();
        $(".nav-transfers ."+type).show();
      },
      submittedForm: async function() {
        console.log("submittedForm");
        window.location = '/cards';
      },

      handleParsingForm: function() {
        // Clear out any pre-existing error messages.
        this.formErrors = {};

        var argins = this.formData;

        // Validate type:
        if(!argins.transferType) {
          this.formErrors.transferType = true;
        }
        
        // Validate description:
        if(!argins.amount) {
          this.formErrors.amount = true;
        }
        if(argins.transferType == "payment"){
          var validToPayment = this.validPhoneOrEmail(argins.toPayment);
          console.log("validToPayment",validToPayment);
          if(!validToPayment){
            this.formErrors.toPayment = true;
          }
        }else{
          
        }
        
        // Validate name:
        if(argins.transferType == "deposit"){
          if(!argins.toDeposit) {
            this.formErrors.toDeposit = true;
          }
        }else if(argins.transferType == "internal"){
          if(!argins.toInternal) {
            this.formErrors.toInternal = true;
          }
        }else if(!argins.fromAccountId) {
          this.formErrors.fromAccountId = true;
        }


        // If there were any issues, they've already now been communicated to the user,
        // so simply return undefined.  (This signifies that the submission should be
        // cancelled.)
        if (Object.keys(this.formErrors).length > 0) {
          return;
        }

        return argins;
      },
      validPhoneOrEmail: function(phoneOrEmail){
        var validEmail = false;
        var validPhone = false;
        //validate email
        phoneOrEmail =  phoneOrEmail.toLowerCase();
        var emailReg = /^\b[A-Z0-9._%-]+@[A-Z0-9.-]+\.[A-Z]{2,4}\b$/i;
        if(!emailReg.test(phoneOrEmail) || phoneOrEmail == '')
        {
          console.log('Please enter a valid email address.');
          validEmail = false;
        }else{
          validEmail = true;
          this.formData.toPaymentMethod = "email";
          console.log('valid email address.');

        }

        //validate phone
        var intRegex = /[0-9 -()+]+$/;
        if((phoneOrEmail.length < 6) || (!intRegex.test(phoneOrEmail)))
        {
          console.log('Please enter a valid phone number.');
          validPhone = false;
        }else{
          validPhone = true;
          this.formData.toPaymentMethod = "phone";
          console.log('valid phone.');
        }

        if(!validPhone && !validEmail){
          this.formData.toPaymentMethod = undefined;
          return false;
        }else{
          this.formData.fromAccountId = this.formData.fromSpendAccountId;
          return true;
        }
        
      },
    }
  });
});
