<?php
/**
 * Creates the yohshow item for the plugin.
 *
 * @package YohShow
 */
 

class YohShow_WP Extends YohShow_Utils {

    /**
     * A reference the class responsible for rendering the submenu page.
     *
     * @$   YohShow_API
     * @access private
     */
    private $yohshow_api;
 
    /**
     * Initializes all of the partial classes.
     *
     * @param YohShow_API $yohshow_api A reference to the class that renders the
     *                                                                   page for the plugin.
     */
    /**
     * Yoh show api key
     *
     * @var    yohshow_api_key
     * @access private
     */
    private $yohshow_api_key =  '';

    /**
     * Yoh show api secret
     *
     * @var    yohshow_api_secret
     * @access private
     */
    private $yohshow_api_secret =  '';

    /**
     * Account list to filter accounts by thier bank account ids
     *
     * @$   YohShow_API
     * @access private
     */
    private $accountIdFilter = [0,1,5,4];

    /**
     * Account list to filter send accounts by thier bank account ids
     *
     * @$   YohShow_API
     * @access private
     */
    private $spendAccountIdFilter = [1];
 

    public function __construct($yohshow_api) {
        $this->yohshow_api = $yohshow_api;
    }

    

    public function account($request){
            $accountId = $request->accountId? $request->accountId:"" ;
            $apiKey = $this->yohshow_api_key;
            $accountIdFilter = $this->accountIdFilter;
            $accounts = (object) $this->yohshow_api->request("get","/accounts/",[]);
            print_r("veiw account just got accounts",$accounts);
            $accounts = $accounts->accounts;
            print_r("veiw account accounts",$accounts);

            if($accountId){
                $data['accountId'] = $accountId;
                $account = (object) $this->yohshow_api->request("get","/accounts/".$accountId,$data);
                print_r("veiw account accountId just got account",$account);
                $account = $account->account;
                $transactions = $account->transactionHistory;
                print_r("veiw account accountId account",$account);
                print_r("veiw account accountId transactions",$transactions);
            }else{
                $account = $accounts[0];
                $transactions = $account->transactionHistory;
                print_r("veiw account no accountId account",$account);
                print_r("veiw account no accountId transactions",$transactions);
            }
            $accountId  = $account->id;
            $appTokenData['apiKey'] = $apiKey;
            $appTokenResult = (object) $this->yohshow_api->request("get","/appToken/".$apiKey,$appTokenData);
            $appToken = $appTokenResult->appToken;
            $stableToken = $appTokenResult->stableToken;


            $result['accountIdFilter'] = $accountIdFilter;
            $result['accountId'] = $accountId;
            $result['account'] = $account;
            $result['accounts'] = $accounts;
            $result['transactions'] = $transactions;
            $result['appToken'] = $appToken;
            $result['stableToken'] = $stableToken;
            return $result;
    
    }
    public function wallets(){

        $wallets = (object) $this->yohshow_api->request("get","/wallets/",[]);
        $accountIdFilter = $this->accountIdFilter;
        $apiKey = $this->yohshow_api_key;

        print_r("veiw card wallets",$wallets);
    
        $appTokenData['apiKey'] = $apiKey;
        $appTokenResult = (object) $this->yohshow_api->request("get","/appToken/".$apiKey,$appTokenData);
        $appToken = $appTokenResult->appToken;
        $stableToken = $appTokenResult->stableToken;

        $result['accountIdFilter'] =  $accountIdFilter;
        $result['wallets'] =  $wallets;
        $result['appToken'] =  $appToken;
        $result['stableToken'] =  $stableToken;
        return $result;
    }
    public function place_order($request){
        //TODO convert to php 
        (object) $request;
        $market = $request->market;
        $user = $_SESSION["me"];
        $order['market'] = $market;
        $order['side'] = $request->side;
        $order['volume'] = $request->volume;
        $order['price'] = $request->price;

        $orderMeta = [
         'ownerType' => "token",
         'ownerId' =>  get_user_meta($toUser->id,"exchangeTokenId",true),
        ];

        $order['orderMeta'] = $orderMeta;

        //  {market:testMarket,side:"sell",volume:0.0571279,price:1};

        print_r("place order",$order);
        print_r("place session");
        $order = (object) $this->yohshow_api->request("post","/market/orders",$order);
        $flag = true;
        $msg = "Your order was placed successfully";
        print_r("placed order",$order);


        if($order == false){
            $flag = false;
            $msg = "There was an error placing your order";
        }
        /*
        TODO: v3 make sockets work
        print_r("this.req.isSocket",this.req.isSocket);
        if (this.req.isSocket) {
            $socket = "markets";
            sails.sockets.join(this.req, socket);
            if(flag){
                $marketUpdate = (object) $this->market($market);
                print_r("marketUpdate",$marketUpdate);
                print_r("marketUpdate market",$market);
                // sails.sockets.broadcast(socket, market, marketUpdate, this.req);
            }
        }
        */
        $marketUpdate->openOrders =  $this->yohshow_api->request("get","/market/orders/".market+"/wait",[]);
        $marketUpdate->tradeHistory =  $this->yohshow_api->request("get","/market/orders/".market+"/done",[]);
        print_r("place orders marketUpdate.openOrders",$marketUpdate->openOrders);
        print_r("place orders marketUpdate.tradeHistory",$marketUpdate->tradeHistory);
        $result = [
            'market' => $marketUpdate,
            'order' => $order,
            'flag' => $flag,
            'msg' => $msg,
        ];
        return $result;
    }

    

    





 

 

}