<?php
/**
 * Creates the yohshow item for the plugin.
 *
 * @package YohShow
 */
 

class YohShow {

    /**
     * A reference the class responsible for rendering the submenu page.
     *
     * @var    YohShow_API
     * @access private
     */
    private $yohshow_api;

    /**
     * A reference the class responsible for rendering the submenu page.
     *
     * @var    YohShow_WP
     * @access private
     */
    private $yohshow_wp;

    /**
     * api apiKey
     *
     * @var    apiKey
     * @access private
     */
    private $apiKey;
    /**
     * api apiSecret
     *
     * @var    apiSecret
     * @access private
     */
    private $apiSecret;
 
    /**
     * Initializes all of the partial classes.
     *
     * @param YohShow_API $yohshow_api A reference to the class that renders the
     *                                                                   page for the plugin.
     */
 

    public function __construct($apiKey,$apiSecret) {
        $this->apiKey = $apiKey;
        $this->apiSecret = $apiSecret;
        $this->yohshow_api = new Yohshow_API($apiKey,$apiSecret);
        $this->yohshow_wp = new Yohshow_WP($this->yohshow_api);

        $fullName = "tony test";
        $emailAddress = "tony207@yohshow.com";
        // $signup = $this->yohshow_api->signup($fullName,$emailAddress);
        //echo '<pre>'; 
        // var_dump("signup result",$signup);
        //echo '</pre>';
        $login = $this->yohshow_api->login($emailAddress);
        //echo '<pre>'; 
        // var_dump("login result",$login);
        //echo '</pre>';

    }

    /**
     * Adds a submenu for this plugin to the 'Tools' menu.
     */
    public function init() {
            // register shortcodes
            add_shortcode('balances', array($this,'balances_shortcode') );
            $this->enqueue_scripts();
            $this->register_scripts();
            $this->create_endpoints();
            $this->add_actions();
            // $this->tokenize_app();


    }

    
    
    public function register_scripts(){
        // wp_register_script('vue', 'https://cdn.jsdelivr.net/npm/vue@2.5.17/dist/vue.js', [], '2.5.17');
    }

    

    /**
    * Displays account of current user.
    *
    * @since 1.0.0
    */
    // function that runs when shortcode is called
    public function account_shortcode($atts = []) { 
        $yohshow_api =  $this->yohshow_api;
        $yohshow_wp =  $this->yohshow_wp;
        // $fullName = "tony test";
        $emailAddress = "tony207@yohshow.com";
        $signup = $yohshow_api->signup($fullName,$emailAddress);
        //echo '<pre>'; 
        //var_dump("signup result",$signup);
        //echo '</pre>';
        $login = $yohshow_api->login($emailAddress);
        //echo '<pre>'; 
        //var_dump("login result",$login);
        //echo '</pre>';

        $accountRequest["accountId"] =  $atts["accountId"] ?$atts["accountId"]:"";
        //echo '<pre>'; 
        //var_dump("accountRequest result",$accountRequest);
        //echo '</pre>';

        // //get balances based off login user

        $accountResult = $yohshow_wp->account($accountRequest);
        //echo '<pre>'; 
        //var_dump("balances result",$accountResult);
        //echo '</pre>';
        // exit;

        $GLOBALS['YOH_SHOW_LOCALS'] = json_encode($accountResult) ;
        include_once( 'views/account.php' );
    }

    /**
    * Displays wallets of current user.
    *
    * @since 1.0.0
    */
    // function that runs when shortcode is called
    public function wallets_shortcode($atts = []) { 
        $yohshow_api =  $this->yohshow_api;
        $yohshow_wp =  $this->yohshow_wp;
        // $fullName = "tony test";
        $emailAddress = "tony207@yohshow.com";
        $signup = $yohshow_api->signup($fullName,$emailAddress);
        //echo '<pre>'; 
        //var_dump("signup result",$signup);
        //echo '</pre>';
        $login = $yohshow_api->login($emailAddress);
        //echo '<pre>'; 
        //var_dump("login result",$login);
        //echo '</pre>';

        // $walletsRequest["tokenId"] =  $atts["tokenId"] ?$atts["tokenId"]:"";
        //echo '<pre>'; 
        //var_dump("walletsRequest result",$walletsRequest);
        //echo '</pre>';

        // //get balances based off login user

        // $walletsResult = $yohshow_wp->wallets($walletsRequest);
        $walletsResult = $yohshow_wp->wallets();
        //echo '<pre>'; 
        //var_dump("balances result",$walletsResult);
        //echo '</pre>';
        // exit;

        $GLOBALS['YOH_SHOW_LOCALS'] = json_encode($walletsResult) ;
        include_once( 'views/accounts.php' );
    }

    /**
    * Displays transfer of current user.
    *
    * @since 1.0.0
    */
    // function that runs when shortcode is called
    public function transfer_shortcode($atts = []) { 
        $yohshow_api =  $this->yohshow_api;
        $yohshow_wp =  $this->yohshow_wp;
        // $fullName = "tony test";
        $emailAddress = "tony207@yohshow.com";
        $signup = $yohshow_api->signup($fullName,$emailAddress);
        //echo '<pre>'; 
        //var_dump("signup result",$signup);
        //echo '</pre>';
        $login = $yohshow_api->login($emailAddress);
        //echo '<pre>'; 
        //var_dump("login result",$login);
        //echo '</pre>';

        $accountIdFilter = $yohshow_api->accountIdFilter;
        $spendAccountIdFilter = $yohshow_api->spendAccountIdFilter;
        $apiKey = $yohshow_api->apiKey;

        // $userId = this.req.me.id;
        // $cards = await Card.find({userId:userId}).populate("tokenId").populate("walletId");
        // $tokens = await Token.find({userId:userId});
        // $stripePublishableKey = sails.config.custom.enableBillingFeatures? sails.config.custom.stripePublishableKey : undefined;
    //   print_r("veiw transfer stripePublishableKey",$stripePublishableKey);

        $accounts = $yohshow_api->request("get","/accounts/",[]);
        $spendAccounts = $yohshow_api->request("get","/accounts/admin",[]);
    //   print_r("view transfer accounts",$accounts);
    //   print_r("view transfer spendAccounts",$spendAccounts);

        $appTokenResult = (object) $yohshow_api->request("get","/appToken/$apiKey",array("apiKey"=>$apiKey));
        $appToken = $appTokenResult->appToken;
        $stableToken = $appTokenResult->stableToken;

        // Respond with view.
        $transferResult = array(
            $spendAccountIdFilter => $spendAccountIdFilter,
            $accountIdFilter => $accountIdFilter,
            $tokens => [],
            $spendAccounts => $spendAccounts->accounts,
            $accounts => $accounts->accounts,
            $stripePublishableKey => "",
            $appToken => $appToken,
            $stableToken => $stableToken,
        );


        //echo '<pre>'; 
        //var_dump("balances result",$transferResult);
        //echo '</pre>';
        // exit;

        $GLOBALS['YOH_SHOW_LOCALS'] = json_encode($transferResult) ;
        include_once( 'views/transfer.php' );
    }
  
    

    public function create_endpoints(){
        $register_result = add_action( 'rest_api_init', function () {
            register_rest_route( 'yohshow/api/v1', '/csrfToken', array(
              'methods' => 'GET',
              'callback' => array($this->yohshow_wp,"csrfToken")
            ) );
          } );
        $register_result = add_action( 'rest_api_init', function () {
            register_rest_route( 'yohshow/api/v1', '/balances/send', array(
              'methods' => 'POST',
              'callback' => array($this->yohshow_wp,"transfer")
            ) );
          } );
        $register_result = add_action( 'rest_api_init', function () {
            register_rest_route( 'yohshow/api/v1', '/account', array(
                'methods' => 'POST',
                'callback' => array($this->yohshow_wp,"account")
            ) );
        } );
        $register_result = add_action( 'rest_api_init', function () {
            register_rest_route( 'yohshow/api/v1', '/wallets', array(
                'methods' => 'POST',
                'callback' => array($this->yohshow_wp,"wallets")
            ) );
        } );
        //   var_dump("create endpoint",$register_result);
    }





    //scripts 
    public function enqueue_scripts(){
        // wp_enqueue_script('latest-posts', plugin_dir_url( __FILE__ ) . 'latest-posts.js', [], '1.0', true);
        // echo plugin_dir_path( __FILE__ ) . 'assets/dependencies/*.js' ;
        // exit;
        wp_enqueue_script('vue', 'https://cdn.jsdelivr.net/npm/vue@2.5.17/dist/vue.js', [], '2.5.17');
        wp_enqueue_script('vueRouter', 'https://unpkg.com/vue-router@4', [], '2.5.17');
        // wp_enqueue_script('lodash.js', 'https://cdnjs.cloudflare.com/ajax/libs/lodash.js/4.17.11/lodash.core.min.js', [], '4.17.11');
        
        // $jquery_url = plugin_dir_url( __FILE__ )."assets/dependencies/jquery.min.js";
        //echo '<pre>';
        //var_dump("jquery_url",$jquery_url);
        //echo '</pre>';

        // wp_enqueue_script( "jquery", $jquery_url );

        $jquery_cookie_url = plugin_dir_url( __FILE__ )."assets/dependencies/jquery.cookie.js";
        //echo '<pre>'; 
        //var_dump("jquery.cookie.js",$jquery_cookie_url);
        //echo '</pre>';

        wp_enqueue_script( "jquery.cookie.js", $jquery_cookie_url,array("jquery") );
        
        $lodash_url = plugin_dir_url( __FILE__ )."assets/dependencies/lodash.js";
        //echo '<pre>'; 
        //var_dump("lodash_url",$lodash_url);
        //echo '</pre>';
        wp_enqueue_script( "lodash.js", $lodash_url );

        $cloud_url = plugin_dir_url( __FILE__ )."assets/dependencies/cloud.js";
        //echo '<pre>'; 
        //var_dump("cloud_url",$cloud_url);
        //echo '</pre>';
        wp_enqueue_script( "cloud.js", $cloud_url );

        $this->enqueue_scripts_folder("assets/dependencies");
        $this->enqueue_scripts_folder("assets/dependencies/exchange");
        $this->enqueue_scripts_folder("assets/dependencies/bootstrap-4");
        $this->enqueue_scripts_folder("assets/js");

        $this->enqueue_scripts_folder("assets/js/components");
        $this->enqueue_scripts_folder("assets/js/components/tokens");
        $this->enqueue_scripts_folder("assets/js/pages");
    }
    public function enqueue_scripts_folder($path){
        foreach( glob( plugin_dir_path( __FILE__ ) . "$path/*.js" ) as $file ) {
            // $file contains the name and extension of the file
            $file_name = basename($file);
            $file_url = plugin_dir_url( __FILE__ )."$path/".$file_name;
            //echo '<pre>'; 
            //var_dump("file_url",$file_url);
            //echo '</pre>';
            // exit;
            wp_enqueue_script( $file_name, $file_url,array("jquery"));
        }
        // var_dump("$path/*.css" );

        foreach( glob( plugin_dir_path( __FILE__ ) . "$path/*.css" ) as $file ) {
            // $file contains the name and extension of the file
            $file_name = basename($file);
            $file_url = plugin_dir_url( __FILE__ )."$path/".$file_name;
            // echo '<pre>'; 
            // var_dump("file_url",$file_url);
            // echo '</pre>';
            // exit;
            wp_enqueue_style( $file_name, $file_url);
        }
        foreach( glob( plugin_dir_path( __FILE__ ) . "$path/*.less" ) as $file ) {
            // $file contains the name and extension of the file
            $file_name = basename($file);
            $file_url = plugin_dir_url( __FILE__ )."$path/".$file_name;
            // echo '<pre>'; 
            // var_dump("file_url",$file_url);
            // echo '</pre>';
            // exit;
            wp_enqueue_style( $file_name, $file_url,array("jquery"));
        }
    }
 

 

}