<?php
/**
 * Creates the yohshow api item for the plugin.
 *
 * @package YohShow
 */
 

class Yohshow_Includes {
    /**
     * A reference the class responsible for rendering the submenu page.
     *
     * @$   YohShow_API
     * @access private
     */
    private $yohshow_api;
 


    public function __construct($yohshow_api) {
        // // var_dump("test includes");
        $this->yohshow_api = $yohshow_api;
        // // var_dump("test yohshow_api",$this->yohshow_api );

        $this->init();
        
    }
    function init(){
        // // var_dump("test includes init");
        // add_shortcode('balances', array($this,'balances_shortcode') );
        $this->enqueue_scripts();
        // $this->register_scripts();
        $this->create_endpoints();
        // $this->add_actions();
            // $this->tokenize_app();

    }

    public function create_endpoints(){
        $register_result = add_action( 'rest_api_init', function () {
            register_rest_route( 'yohshow/api/v1', '/csrfToken', array(
              'methods' => 'GET',
              'callback' => array($this->yohshow_api,"csrfToken")
            ) );
          } );

    }





    //scripts 
    public function enqueue_scripts(){

        // wp_enqueue_script('vue', 'https://cdn.jsdelivr.net/npm/vue@2.5.17/dist/vue.js', [], '2.5.17');
        // wp_enqueue_script('lodash.js', 'https://cdnjs.cloudflare.com/ajax/libs/lodash.js/4.17.11/lodash.core.min.js', [], '4.17.11');
        
        
        // wp_enqueue_script('vue', "https://unpkg.com/vue@3", [], '2.5.17');
        // wp_enqueue_script('vueRouter', 'https://unpkg.com/vue-router@4', [], '2.5.17');


        // wp_enqueue_script('vue', "https://unpkg.com/vue@3", [], '2.5.17');
        wp_enqueue_script('vue', 'https://cdn.jsdelivr.net/npm/vue@2.5.17/dist/vue.js', [], '2.5.17');
        wp_enqueue_script('vueRouter', 'https://unpkg.com/vue-router@3.0.0/dist/vue-router.js', [], '2.5.17');


        // wp_enqueue_script('googleMaps', 'https://maps.googleapis.com/maps/api/js?key=AIzaSyAurokSPgscsxAvBijUMH3wCkua-QIav7I&libraries=places&callback=initAutocomplete', array('jquery'));
        // wp_enqueue_script('googleMaps', 'https://maps.googleapis.com/maps/api/js?key=AIzaSyAurokSPgscsxAvBijUMH3wCkua-QIav7I&libraries=places&callback=initAutocomplete', array());
        // wp_enqueue_script('googleMaps', 'https://maps.googleapis.com/maps/api/js?key=AIzaSyAurokSPgscsxAvBijUMH3wCkua-QIav7I&libraries=places', array('jquery'));

        
        // wp_deregister_script('jquery');
        // $jquery_url = plugin_dir_url( __FILE__ )."assets/dependencies/jquery.min.js";
        // wp_enqueue_script( "jquery", $jquery_url );

        $jquery_cookie_url = plugin_dir_url( __FILE__ )."assets/dependencies/jquery.cookie.js";
        //echo '<pre>'; 
        //// var_dump("jquery.cookie.js",$jquery_cookie_url);
        //echo '</pre>';

        // wp_enqueue_script( "jquery.cookie.js", $jquery_cookie_url,array("jquery") );

        // $sails_url = plugin_dir_url( __FILE__ )."assets/dependencies/sails.io.js";
        // //echo '<pre>'; 
        // //// var_dump("sails_url",$sails_url);
        // //echo '</pre>';
        // wp_enqueue_script( "sails.io.js", $sails_url, array('jquery') );

        

        
        $lodash_url = plugin_dir_url( __FILE__ )."assets/dependencies/lodash.js";
        //echo '<pre>'; 
        //// var_dump("lodash_url",$lodash_url);
        //echo '</pre>';
        wp_enqueue_script( "lodash.js", $lodash_url, array('jquery') );

        $cloud_url = plugin_dir_url( __FILE__ )."assets/dependencies/cloud.js";
        //echo '<pre>'; 
        //// var_dump("cloud_url",$cloud_url);
        //echo '</pre>';
        wp_enqueue_script( "cloud.js", $cloud_url, array('jquery',"lodash.js") );



      

        $this->enqueue_scripts_folder("assets/dependencies");
        $this->enqueue_scripts_folder("assets/dependencies/exchange");
        $this->enqueue_scripts_folder("assets/dependencies/bootstrap-4");
        $this->enqueue_scripts_folder("assets/js");

        $this->enqueue_scripts_folder("assets/js/components");
        $this->enqueue_scripts_folder("assets/js/pages");
    }
    public function enqueue_scripts_folder($path){
        foreach( glob( plugin_dir_path( __FILE__ ) . "$path/*.js" ) as $file ) {
            // $file contains the name and extension of the file
            $file_name = basename($file);
            $file_url = plugin_dir_url( __FILE__ )."$path/".$file_name;
            //echo '<pre>'; 
            // // var_dump("file_url",$file_url);
            //echo '</pre>';
            // exit;
            wp_enqueue_script( $file_name, $file_url,array("jquery", "cloud.js","lodash.js"));
        }
        // // var_dump("$path/*.css" );

        foreach( glob( plugin_dir_path( __FILE__ ) . "$path/*.css" ) as $file ) {
            // $file contains the name and extension of the file
            $file_name = basename($file);
            $file_url = plugin_dir_url( __FILE__ )."$path/".$file_name;
            // echo '<pre>'; 
            // // var_dump("file_url",$file_url);
            // echo '</pre>';
            // exit;
            wp_enqueue_style( $file_name, $file_url);
        }
        foreach( glob( plugin_dir_path( __FILE__ ) . "$path/*.less" ) as $file ) {
            // $file contains the name and extension of the file
            $file_name = basename($file);
            $file_url = plugin_dir_url( __FILE__ )."$path/".$file_name;
            // echo '<pre>'; 
            // // var_dump("file_url",$file_url);
            // echo '</pre>';
            // exit;
            wp_enqueue_style( $file_name, $file_url,array("jquery"));
        }
    }


}