/**
 * <checkout>
 * -----------------------------------------------------------------------------
 * checkout.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */
 jQuery(document).ready(function( $ ) {


	Vue.component('checkout', {
  

    //  ╔═╗╦═╗╔═╗╔═╗╔═╗
    //  ╠═╝╠╦╝║ ║╠═╝╚═╗
    //  ╩  ╩╚═╚═╝╩  ╚═╝
    props: [
      // 'markets',// « The JS timestamp to format
      // 'buyCurrency',
      // 'type',
    ],

    //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
    //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
    //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
    data: function (){
      return {
         //…
        checkoutId:"",
        expired:"",
        redirectLink:"",
        transactionType:"",
        quoteValid:"",
        checkout:{},
        primeTrustForcePayment:"",
        paymentMethodType:"",
        amount:0,
        paid:"",
        fundsTransferMethodId:"",

        loadingCheckout: true,
        cloudLoadingError: '',
      };
    },

    /*
                    (type && market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
                  || (type && market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
    */

    //  ╦ ╦╔╦╗╔╦╗╦
    //  ╠═╣ ║ ║║║║
    //  ╩ ╩ ╩ ╩ ╩╩═╝
    template: `
    <div class="checkout-component">
        <div v-if="loadingCheckout" class="text-center">
            <h1>Your checkout is being loaded...</h1>
            <ajax-button type="submit" :syncing="loadingCheckout" class="btn btn-primary mint">Refesh</ajax-button>
        </div>
        <div v-else="">
            <div v-if="!expired" :class="[(transactionType == 'sell' || paymentMethod.name == 'internal' || primeTrustForcePayment || paid) ? '' : 'd-none']" class="text-center msg processing">

                <h1>We are processing your order now</h1>
                <ajax-button type="submit" :syncing="true" onClick="window.location.reload();" class="btn btn-primary mint">Refesh</ajax-button>

            
            </div>
            <div v-if="!expired" class="text-center msg d-none paymentError">

                <h1>There was an error processing your order. Please refresh and try again.</h1>
                <button type="button"  onClick="window.location.reload();" class="btn btn-primary">Refesh</button>

            
            </div>
            <div v-if="!expired" class="text-center msg d-none pending">

                <h1>Your payment is pending and this order should be fully processed with in 24 hours.</h1>
                <a   href="/orders" class="btn btn-primary">View Orders</a>

            
            </div>
            <div :class="[expired ? '' : 'd-none']" class="text-center msg  expired pl-3 pr-3">

                <h1>This quote has expired. Please refesh to get a new price continue.</h1>
                <a :href="redirectLink" id="newQuote" class="btn btn-primary newQuoteBtn text-white">Refesh Quote</a>
                <!-- <a :href="redirectLink" id="refreshQuote" onClick="window.location.reload();" class="btn btn-primary newQuoteBtn text-white">Refesh Quote</a> -->
                <a :href="redirectLink" id="refreshQuote"  class="btn btn-primary newQuoteBtn text-white">Refesh Quote</a>

            
            </div>
            <div v-if="!expired"  class="text-center msg  unfunded pl-3 pr-3 d-none">

                <h2>There was an error processing your payment. Please try again or use a different payment method.</h2>
                <a :href="'/pay-now/'+checkout.checkout_token_base" id="payNow" class="btn btn-primary  text-white">Try Again</a>

            
            </div>
            <div v-if="!expired && transactionType !== 'sell' && paymentMethod.name !== 'internal' && !primeTrustForcePayment && !paid " class="contribution msg text-center pl-3 pr-3">
                <h3 v-if="paymentMethod">{{paymentMethod.name}}</h3>
                <div id="contribution"></div>

            </div>

        </div>


    </div>
      
    `,
    // <tr v-for="market in markets" :id="market.id" v-if="market && market.sellCurrencyId && !market.sellCurrencyId.buyCurrency && market.sellCurrencyId.icoOrder && (!market.sellCurrencyIndexToken && !type || market.sellCurrencyIndexToken && type) && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" >
    //
    //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
    //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
    //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
    beforeMount: async function() {
        // Attach any initial data from the server.
        this.checkoutId = this.$route.params.id;

          // _.extend(this, YOH_SHOW_LOCALS);
          _.extend(this, YOH_SHOW_LOCALS);

        await this.listen();  

    },
    mounted: async function() {

    
       
      },



    //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
    //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
    //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
    methods: {
        listen: async function() {
          var Checkout = this;
          //show loading// syincing
          this.loadingCheckout = true;

          // var csrf = await CSRF.token();
          // var apiRequestHeader = {
          //     'X-CSRF-Token':csrf._csrf,
          //       // 'cookie':cookie
          //   };
          $.ajax({
                type: "POST",
              //   url: this.refreshUrl+"/markets/orders/cancel",
              url: '/wp-json/yohshow/api/v1/checkout',
              data: {checkoutId:this.checkoutId},
                // headers:apiRequestHeader,
                success: function(resData, textStatus, request)
                {
                    resData = JSON.parse(resData);

                    if(resData.flag){
                        _.extend(Checkout, resData);
                        
                        Checkout.loadingCheckout = false;
                        var primeTrustForcePayment = Checkout.primeTrustForcePayment;
                        var paid = Checkout.paid;
                        var checkout = Checkout.checkout;
                        var transactionType = Checkout.transactionType;
                        // var paymentMethod = Checkout.paymentMethod.name;
                        var paymentMethod = "";
            
                        setTimeout(() => {
                          if(transactionType == "sell"){
                            $(".processing").removeClass("d-none");
                            $(".contribution").addClass("d-none");
                            Checkout.activateTestCheckout();
                          }else if(checkout.financial_status == 'paid'){
                            // user should have paid via woocommcerce checkout so redirect to checkout redirect
                            $(".processing").removeClass("d-none");
                            $(".contribution").addClass("d-none");
                            // Checkout.activateTestCheckout();
                            if(checkout.redirect){
                              Checkout.$router.push(checkout.redirect);
                            }else{
                              Checkout.$router.push("/balances/");

                            }
                          }else if(primeTrustForcePayment){
                            $(".processing").removeClass("d-none");
                            $(".contribution").addClass("d-none");
                            Checkout.activateTestCheckout();
                          }else{
                            Checkout.activateCheckout();
                          }
                          if(paymentMethod == "internal" || primeTrustForcePayment || paid || transactionType == "sell" ){
                            $(".msg").addClass("d-none").hide() ;
                            $(".processing").removeClass("d-none").show();
                          }
                          // $("#page-wrap").css("display","none");
                        }, 1000);
                        
                        
            
            
                      }else if(resData.mustLogin){
                        window.location.href = resData.redirect;
                      } else{
                        Checkout.loadingCheckout = false;
                      }
    
                }
              });
    
        //   var csrf = await CSRF.token();
        //     console.log('csrf',csrf);
        //     var apiRequestHeader = {
        //       'X-CSRF-Token':csrf._csrf,
        //         // 'cookie':cookie
        //     };
        //   io.socket.request({
        //       method: 'post',
        //       url: '/api/checkout',
        //       data: {checkoutId:this.checkoutId},
        //       // data: {},
        //       headers: apiRequestHeader
        //     }, function (resData, jwres) {
    
        //       if(resData.flag){
        //         _.extend(Checkout, resData);
                
        //         Checkout.loadingCheckout = false;
        //         var primeTrustForcePayment = Checkout.primeTrustForcePayment;
        //         var paid = Checkout.paid;
        //         var transactionType = Checkout.transactionType;
        //         var paymentMethod = Checkout.paymentMethod.name;
    
        //         setTimeout(() => {
        //           if(primeTrustForcePayment || paid || transactionType == "sell"){
        //             $(".processing").removeClass("d-none");
        //             $(".contribution").addClass("d-none");
        //             Checkout.activateTestCheckout();
        //           }else{
        //             Checkout.activateCheckout();
        //           }
        //           if(paymentMethod == "internal" || primeTrustForcePayment || paid || transactionType == "sell" ){
        //             $(".msg").addClass("d-none").hide() ;
        //             $(".processing").removeClass("d-none").show();
        //           }
        //           // $("#page-wrap").css("display","none");
        //         }, 1000);
                
                
    
    
        //       }else if(resData.mustLogin){
        //         window.location.href = resData.redirect;
        //       } else{
        //         Checkout.loadingCheckout = false;
        //       }
              
        //       if (jwres.error) {
        //         console.log(jwres.statusCode); // => e.g. 403
        //         this.cloudLoadingError = true;
    
        //         return;
        //       }
            
        //       console.log(jwres.statusCode); // => e.g. 200
            
        //   });
    
        },
        activateTestCheckout: async function() {
          var Checkout = this;
    
          var amount = this.amount;
          var fundsTransferMethodId = this.fundsTransferMethodId;
          var checkoutId = this.checkoutId;
          var paymentMethodType = this.paymentMethodType;
          const start = Date.now();
          var challengeId = "testChallengeId";
          var contributionId = "testContributionId_"+start;
          console.log("amount",amount);
          console.log("fundsTransferMethodId",fundsTransferMethodId);
          console.log("checkoutId",checkoutId);
    
          console.log("3ds successfulid: ", challengeId);
          var forterTokenCookie = $.cookie("forter-token-cookie");
          var forterTokenCookie = "testForterTokenCookie";
          var chargeInfo = {
            checkoutId:checkoutId,
            contributionId:contributionId,
            challengeId:challengeId,
            forterTokenCookie:forterTokenCookie,
          }
    
          // var chargeResult =  await Cloud.payCheckout.with(chargeInfo)
          // .tolerate(()=>{
          //   this.cloudError = true;
          // });

          // var csrf = await CSRF.token();
          // var apiRequestHeader = {
          //     'X-CSRF-Token':csrf._csrf,
          //       // 'cookie':cookie
          //   };
          $.ajax({
                type: "POST",
              //   url: this.refreshUrl+"/markets/orders/cancel",
              url: '/wp-json/yohshow/api/v1/pay-now',
              data: chargeInfo,
                // headers:apiRequestHeader,
                success: function(resData, textStatus, request)
                {
                    var chargeResult = resData;
                console.log("chargeResult",chargeResult);
                Checkout.syncing = true;
                console.log("chargeResult",chargeResult);
                console.log("chargeResult.flag",chargeResult.flag);
                if(chargeResult.flag){
                  console.log("chargeResult.redirect",chargeResult.redirect);
                  // window.location.href = chargeResult.redirect;
                  if(chargeResult.redirect){
                    Checkout.$router.push(chargeResult.redirect);
                  }else{
                    Checkout.$router.push("/balances");
                  }

                }else{
                  if(chargeResult.expired){
                    $(".msg,.newQuoteBtn").addClass("d-none").hide() ;
                    $(".expired").removeClass("d-none").show();
                    $("#newQuote").attr("href",chargeResult.redirect);
                    $("#refreshQuote").attr("href",chargeResult.redirect);
    
                    if(chargeResult.paid){
                      $(".expired #refreshQuote").removeClass("d-none").show();
                    }else{
                      $(".expired #newQuote").removeClass("d-none").show();
                    }
    
                  }else if(!chargeResult.paid){
                    $(".msg").addClass("d-none").hide() ;
                    $(".unfunded").removeClass("d-none").show();
                    // $("#newQuote").attr("href",chargeResult.redirect);
                  }else if(chargeResult.pending){
                    $(".msg").addClass("d-none").hide() ;
                    $(".pending").removeClass("d-none").show();
                    // $("#newQuote").attr("href",chargeResult.redirect);
                  }else {
                    $(".msg").addClass("d-none").hide() ;
                    $(".paymentError").removeClass("d-none").show();
                    // $("#newQuote").attr("href",chargeResult.redirect);
                  }
                }
    
                }
              });
    
        //   var csrf = await CSRF.token();
        //     console.log('csrf',csrf);
        //     var apiRequestHeader = {
        //       'X-CSRF-Token':csrf._csrf,
        //         // 'cookie':cookie
        //     };
        //     io.socket.request({
        //         method: 'post',
        //         url: '/wp-json/yohshow/api/v1/pay-now',
        //         data: chargeInfo,
        //         headers: apiRequestHeader
        //       }, function (resData, jwres) {
        //         var chargeResult = resData;
        //         console.log("chargeResult",chargeResult);
        //         Checkout.syncing = true;
        //         console.log("chargeResult",chargeResult);
        //         console.log("chargeResult.flag",chargeResult.flag);
        //         if(chargeResult.flag){
        //           console.log("chargeResult.redirect",chargeResult.redirect);
        //           window.location.href = chargeResult.redirect;
        //         }else{
        //           if(chargeResult.expired){
        //             $(".msg,.newQuoteBtn").addClass("d-none").hide() ;
        //             $(".expired").removeClass("d-none").show();
        //             $("#newQuote").attr("href",chargeResult.redirect);
        //             $("#refreshQuote").attr("href",chargeResult.redirect);
    
        //             if(chargeResult.paid){
        //               $(".expired #refreshQuote").removeClass("d-none").show();
        //             }else{
        //               $(".expired #newQuote").removeClass("d-none").show();
        //             }
    
        //           }else if(!chargeResult.paid){
        //             $(".msg").addClass("d-none").hide() ;
        //             $(".unfunded").removeClass("d-none").show();
        //             // $("#newQuote").attr("href",chargeResult.redirect);
        //           }else if(chargeResult.pending){
        //             $(".msg").addClass("d-none").hide() ;
        //             $(".pending").removeClass("d-none").show();
        //             // $("#newQuote").attr("href",chargeResult.redirect);
        //           }else {
        //             $(".msg").addClass("d-none").hide() ;
        //             $(".paymentError").removeClass("d-none").show();
        //             // $("#newQuote").attr("href",chargeResult.redirect);
        //           }
        //         }
             
    
        //         if (jwres.error) {
        //           console.log(jwres.statusCode); // => e.g. 403
        //           Checkout.cloudError = true;
    
        //           return;
        //         }
              
        //         console.log(jwres.statusCode); // => e.g. 200
              
        //     });
    
          
    
    
    
        },
        activateCheckout: async function() {
          var Checkout = this;
          var amount = this.amount;
          var fundsTransferMethodId = this.fundsTransferMethodId;
          var checkoutId = this.checkoutId;
          var paymentMethodType = this.paymentMethodType;
          var primeTrustCardToken = this.primeTrustCardToken;
          console.log("amount",amount);
          console.log("fundsTransferMethodId",fundsTransferMethodId);
    
          if(paymentMethodType =="bank"){
            $(".loading").hide();
            $(".msg").addClass("d-none").hide() ;
            $(".processing").removeClass("d-none").show();
    
            var chargeInfo = {
              checkoutId:checkoutId,
              challengeId:"bank",
              forterTokenCookie:"bank",
            }
            // var chargeResult = await Cloud.payCheckout.with(chargeInfo);

            // var csrf = await CSRF.token();
            // var apiRequestHeader = {
            //     'X-CSRF-Token':csrf._csrf,
            //       // 'cookie':cookie
            //   };
            $.ajax({
                  type: "POST",
                //   url: this.refreshUrl+"/markets/orders/cancel",
                url: '/wp-json/yohshow/api/v1/pay-now',
                data: chargeInfo,
                  // headers:apiRequestHeader,
                  success: function(resData, textStatus, request)
                  {
                    var chargeResult = resData;
                    console.log("chargeResult",chargeResult);
                    Checkout.syncing = true;
                    console.log("chargeResult",chargeResult);
                    console.log("chargeResult.flag",chargeResult.flag);
                    if(chargeResult.flag){
                      console.log("chargeResult.redirect",chargeResult.redirect);
                      // window.location.href = chargeResult.redirect;
                      Checkout.$router.push(chargeResult.redirect);

                    }else{
                      if(chargeResult.expired){
                        $(".msg").addClass("d-none").hide() ;
                        $(".expired").removeClass("d-none").show();
              
                        $("#newQuote").attr("href",chargeResult.redirect);
                      }else if(!chargeResult.paid){
                        $(".msg").addClass("d-none").hide() ;
                        $(".unfunded").removeClass("d-none").show();
                        // $("#newQuote").attr("href",chargeResult.redirect);
                      }else if(chargeResult.pending){
                        $(".msg").addClass("d-none").hide() ;
                        $(".pending").removeClass("d-none").show();
                        // $("#newQuote").attr("href",chargeResult.redirect);
                      }else {
                        $(".msg").addClass("d-none").hide() ;
                        $(".paymentError").removeClass("d-none").show();
                        // $("#newQuote").attr("href",chargeResult.redirect);
                      }
                    }
      
                  }
                });
    
            // var csrf = await CSRF.token();
            // console.log('csrf',csrf);
            // var apiRequestHeader = {
            //   'X-CSRF-Token':csrf._csrf,
            //     // 'cookie':cookie
            // };
            // io.socket.request({
            //     method: 'post',
            //     url: '/wp-json/yohshow/api/v1/pay-now',
            //     data: chargeInfo,
            //     headers: apiRequestHeader
            //   }, function (resData, jwres) {
            //     var chargeResult = resData;
            //     console.log("chargeResult",chargeResult);
            //     Checkout.syncing = true;
            //     console.log("chargeResult",chargeResult);
            //     console.log("chargeResult.flag",chargeResult.flag);
            //     if(chargeResult.flag){
            //       console.log("chargeResult.redirect",chargeResult.redirect);
            //       window.location.href = chargeResult.redirect;
            //     }else{
            //       if(chargeResult.expired){
            //         $(".msg").addClass("d-none").hide() ;
            //         $(".expired").removeClass("d-none").show();
          
            //         $("#newQuote").attr("href",chargeResult.redirect);
            //       }else if(!chargeResult.paid){
            //         $(".msg").addClass("d-none").hide() ;
            //         $(".unfunded").removeClass("d-none").show();
            //         // $("#newQuote").attr("href",chargeResult.redirect);
            //       }else if(chargeResult.pending){
            //         $(".msg").addClass("d-none").hide() ;
            //         $(".pending").removeClass("d-none").show();
            //         // $("#newQuote").attr("href",chargeResult.redirect);
            //       }else {
            //         $(".msg").addClass("d-none").hide() ;
            //         $(".paymentError").removeClass("d-none").show();
            //         // $("#newQuote").attr("href",chargeResult.redirect);
            //       }
            //     }
                
            //     if (jwres.error) {
            //       console.log(jwres.statusCode); // => e.g. 403
            //       Checkout.cloudError = true;
    
            //       return;
            //     }
              
            //     console.log(jwres.statusCode); // => e.g. 200
              
            // });
            
          }else if(paymentMethodType =="card"){
            //TODO update payment processing flow here
            console.log("[primetrust] 1. Loading Prime Trust Embedding API");
            // var getAndSaveUserId = false;
            window.onPurchaseProtectionReady = async function (purchaseProtection) {
    
              pt.launchCreditCard({
                  amount: amount,
                  target: document.getElementById("contribution"),
                  hideAmount: true,
                  resourceTokenHash: primeTrustCardToken,
                  events:{
                    onContribution: async function (contributionId, fundsTransferMethodId){
                            //contribution was successful
                            console.log("[primetrust] 5. Contribution created with ID:", contributionId);
                            console.log("[primetrust] 5. Contribution using FTM ID:", fundsTransferMethodId);
                            $(".processing").removeClass("d-none");
                            $(".contribution").addClass("d-none");
                            var chargeInfo = {
                              checkoutId:checkoutId,
                              contributionId:contributionId,
                              fundsTransferMethodId:fundsTransferMethodId,
                            }
                            $(".loading").hide();
                            $(".msg").addClass("d-none").hide() ;
                            $(".processing").removeClass("d-none").show();
                            // var chargeResult = await Cloud.payCheckout.with(chargeInfo)
                            //   .tolerate(()=>{
                            //     Checkout.cloudError = true;
                            //     $(".loading").css("display","none");
                            //   });

                            // var csrf = await CSRF.token();
                            // var apiRequestHeader = {
                            //     'X-CSRF-Token':csrf._csrf,
                            //       // 'cookie':cookie
                            //   };
                            $.ajax({
                                  type: "POST",
                                //   url: this.refreshUrl+"/markets/orders/cancel",
                                url: '/wp-json/yohshow/api/v1/pay-now',
                                data: chargeInfo,
                                  // headers:apiRequestHeader,
                                  success: function(resData, textStatus, request)
                                  {
                                    var chargeResult = resData;
                                    console.log("chargeResult",chargeResult);
                                    Checkout.syncing = true;
                                    console.log("chargeResult",chargeResult);
                                    console.log("chargeResult.flag",chargeResult.flag);
                                    if(chargeResult.flag){
                                      console.log("chargeResult.redirect",chargeResult.redirect);
                                      // window.location.href = chargeResult.redirect;
                                      Checkout.$router.push(chargeResult.redirect);

                                    }else{
                                      if(chargeResult.expired){
                                        $(".msg").addClass("d-none").hide() ;
                                        $(".expired").removeClass("d-none").show();
                              
                                        $("#newQuote").attr("href",chargeResult.redirect);
                                      }else if(!chargeResult.paid){
                                        $(".msg").addClass("d-none").hide() ;
                                        $(".unfunded").removeClass("d-none").show();
                                        // $("#newQuote").attr("href",chargeResult.redirect);
                                      }else if(chargeResult.pending){
                                        $(".msg").addClass("d-none").hide() ;
                                        $(".pending").removeClass("d-none").show();
                                        // $("#newQuote").attr("href",chargeResult.redirect);
                                      }else {
                                        $(".msg").addClass("d-none").hide() ;
                                        $(".paymentError").removeClass("d-none").show();
                                        // $("#newQuote").attr("href",chargeResult.redirect);
                                      }
                                    }
                                    
                                    // else{
                                    //   $(".loading").css("display","none");
                                    //   $(".paymentError").removeClass("d-none");
                                    //   $(".contribution,.processing").addClass("d-none");
        
                                    // }
                      
                                  }
                                });


                            // var csrf = await CSRF.token();
                            // console.log('csrf',csrf);
                            // var apiRequestHeader = {
                            //   'X-CSRF-Token':csrf._csrf,
                            //     // 'cookie':cookie
                            // };
                            // io.socket.request({
                            //     method: 'post',
                            //     url: '/wp-json/yohshow/api/v1/pay-now',
                            //     data: chargeInfo,
                            //     headers: apiRequestHeader
                            //   }, function (resData, jwres) {
                            //     var chargeResult = resData;
                            //     console.log("chargeResult",chargeResult);
                            //     Checkout.syncing = true;
                            //     console.log("chargeResult",chargeResult);
                            //     console.log("chargeResult.flag",chargeResult.flag);
                            //     if(chargeResult.flag){
                            //       console.log("chargeResult.redirect",chargeResult.redirect);
                            //       window.location.href = chargeResult.redirect;
                            //     }else{
                            //       if(chargeResult.expired){
                            //         $(".msg").addClass("d-none").hide() ;
                            //         $(".expired").removeClass("d-none").show();
                          
                            //         $("#newQuote").attr("href",chargeResult.redirect);
                            //       }else if(!chargeResult.paid){
                            //         $(".msg").addClass("d-none").hide() ;
                            //         $(".unfunded").removeClass("d-none").show();
                            //         // $("#newQuote").attr("href",chargeResult.redirect);
                            //       }else if(chargeResult.pending){
                            //         $(".msg").addClass("d-none").hide() ;
                            //         $(".pending").removeClass("d-none").show();
                            //         // $("#newQuote").attr("href",chargeResult.redirect);
                            //       }else {
                            //         $(".msg").addClass("d-none").hide() ;
                            //         $(".paymentError").removeClass("d-none").show();
                            //         // $("#newQuote").attr("href",chargeResult.redirect);
                            //       }
                            //     }
                                
                            //     // else{
                            //     //   $(".loading").css("display","none");
                            //     //   $(".paymentError").removeClass("d-none");
                            //     //   $(".contribution,.processing").addClass("d-none");
    
                            //     // }
                                
                            //     if (jwres.error) {
                            //       console.log(jwres.statusCode); // => e.g. 403
                            //       Checkout.cloudError = true;
    
                            //       return;
                            //     }
                              
                            //     console.log(jwres.statusCode); // => e.g. 200
                              
                            // });
                            
    
                    },
                    onContributionError: function (error){
                            //contribution failed
                            console.log("[primetrust] 5. Error:", error);
                    }
                  }
              });
    
    
              ///////////////////
              // old
              ////////////
              // console.log("[primetrust] 2. Loading embedded account creation...");
              // $("#page-wrap").css("display","none");
              // purchaseProtection.start3DS({
              //   amount: amount,
              //   fundsTransferMethodId: fundsTransferMethodId,
              // }).then(
              //   (challengeId) =>{
              //     console.log("3ds successfulid: ", challengeId);
              //     var forterTokenCookie = $.cookie("forterToken");
              //     var chargeInfo = {
              //       checkoutId:checkoutId,
              //       challengeId:challengeId,
              //       forterTokenCookie:forterTokenCookie,
              //     }
              //     $(".loading").css("display","block");
              //     return Cloud.payCheckout.with(chargeInfo)
              //       .tolerate(()=>{
              //         this.cloudError = true;
              //         $(".loading").css("display","none");
              //       });
              //   } 
              // ).then(
              //   (chargeResult) =>{
              //       console.log("chargeResult",chargeResult);
              //       this.syncing = true;
              //       console.log("chargeResult",chargeResult);
              //       console.log("chargeResult.flag",chargeResult.flag);
              //       if(chargeResult.flag){
              //         console.log("chargeResult.redirect",chargeResult.redirect);
              //         window.location.href = chargeResult.redirect;
              //       }
              //   } 
              // ).catch(
              //   (err) => console.log("Err: ", err)
              // );
            };
    
          }
    
    
          
    
        },
      }



  });

});

