/**
 * <holdings-table>
 * -----------------------------------------------------------------------------
 * Transaction table.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */
 jQuery(document).ready(function( $ ) {

    Vue.component('holdingsTable', {

    //  ╔═╗╦═╗╔═╗╔═╗╔═╗
    //  ╠═╝╠╦╝║ ║╠═╝╚═╗
    //  ╩  ╩╚═╚═╝╩  ╚═╝
    props: [
      'balances',// « The JS timestamp to format
      'cash',// « The JS timestamp to format
      'withdrawCommission',// « The JS timestamp to format
      'withdrawcommission',// « The JS timestamp to format
      'stabletokenbuyprice',// « The JS timestamp to format
      'formData',// « The JS timestamp to format
      'me',// « The JS timestamp to format
    ],

    //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
    //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
    //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
    data: function (){
      return {
        formatType: undefined,
        formattedTimestamp: '',
        interval: undefined,
        syncing: false,
        cloudError:false,
        totalUsdValue: 0,

      };
    },

    //  ╦ ╦╔╦╗╔╦╗╦
    //  ╠═╣ ║ ║║║║
    //  ╩ ╩ ╩ ╩ ╩╩═╝
    template: `
    <div class="row mb-3 tokens">
      <div class="col-md-12">
          <h4 class="text-center">Total Value: 	&#36;{{ totalUsdValue }} USD </h4>

          <table v-if="cash" class="table" align="center">
              <!--
              <thead>
              <tr>
                  <th>Currency</th>
                  <th>Available</th>
                
                  
                  <th>Pending</th>
                
                  <th>Commission %</th>
                  <th>Commission Payment</th>
                  <th></th>
              </tr>
              </thead>
              --> 

                  <tr v-for="balance in cash"  :class="balance.currency.symbol">
                      <td >
                        <img :src="balance.currency.logo" class="logo" />
                        <span class="currency">{{balance.currency.name}}</span>
                      </td>
                      <td>
                      <span class="available">{{balance.available + balance.spendingBalance}} </span> <span class="symbol">{{balance.currency.symbol}}</span>
                      </td>
            
                      <td>
                    
                      </td>
                      
                      <td>
                      </td>
                      <td>
                      </td>
                    
                      <td class="text-center" >
                      <ajax-form action="withdraw" :syncing.sync="syncing" :cloud-error.sync="cloudError" @submitted="gotBalances($event)" :form-data="balance" >
                          <button type="button" :syncing="syncing" class="btn btn-sm btn-outline-info payOwner" @click="clickExchange" data-toggle="modal" data-target="#exchangeModal">Withdrawl</button>
                          <input type="hidden" class="tokenId" name="tokenId" v-model="balance.currency.id"/>
                          <input type="hidden" class="basisPointsRate" name="basisPointsRate" v-model="balance.currency.tokenBaseRate"/>
                          <input type="hidden" class="owner" name="owner" v-model="balance.owner"/>
                          <input type="hidden" class="payment" name="payment" v-model="balance.payment"/>
                      </ajax-form>
                      </td>
                  </tr>
            </table>
            <table class="table" align="center">
              <thead>
              <tr>
                  <th>Name</th>
                  <!--
                  <th>Pending</th>
                  --> 
                  <th>Royalties Commission %</th>
                  

                  <th>Reserve</th>
                  <th>Available</th>
                  <th>Total</th>
                  <th>USD Value</th>
                  <!--
                  <th>Commission Payment</th>
                  --> 
                  <!--
                  <th></th>
                  --> 

              </tr>
              </thead>
              <tbody>
              <!--
              <tr v-for="balance in balances" v-if="!balance.currency.buyCurrency" :class="balance.currency.symbol">
              -->
              
              <tr v-for="balance in balances" v-if="balance.available + balance.spendingBalance  + balance.holdingBalance + balance.exchangeBalance > 0" :class="balance.currency.symbol">
                  <td >
                  <!--
                    <img :src="balance.currency.logo" class="logo" />
                  -->

                    <a :href="'/markets/'+balance.currency.market"><span class="">{{balance.currency.name}}</span></a>
                  
                  </td>
                  <!--
                  <td>
                  <span class="pending">{{balance.pending}} </span> <span class="symbol">{{balance.currency.symbol}}</span>
                  </td>
                  -->
                  <td>
                      <span class="ownershipPercent">{{balance.ownershipPercent * 100}}</span> %  <span class="symbol">{{balance.currency.symbol}}</span>
                  </td>
                  <td>
                  <span class="reserve">{{balance.holdingBalance + balance.exchangeBalance}} </span> <span class="symbol">{{balance.currency.symbol}}</span>
                  </td>
                  <td>
                  <span class="available">{{balance.available + balance.spendingBalance}} </span> <span class="symbol">{{balance.currency.symbol}}</span>
                  </td>
                  <td>
                  <span class="total">{{balance.available + balance.spendingBalance + balance.holdingBalance + balance.exchangeBalance}} </span> <span class="symbol">{{balance.currency.symbol}}</span>
                  </td>
                  <td>
                    <span class="usdValue">&#36;{{balance.currency.lastPrice ? (balance.currency.lastPrice * (balance.available + balance.spendingBalance + balance.holdingBalance + balance.exchangeBalance) ).toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",") : 0 }} USD </span>
                  </td>
                  <!--
                  <td>
                      <span class="payment">{{balance.payment}}</span>  <span class="paymentSymbol">{{balance.currency.paymentMethod.symbol}}</span>
                  </td>
                  
                  <td >
                  <ajax-form action="payOwner" :syncing.sync="syncing" :cloud-error.sync="cloudError" @submitted="gotBalances($event)" :form-data="balance" >
                      <ajax-button type="submit" :syncing="syncing" class="btn btn-sm btn-outline-info payOwner">Pay Out</ajax-button>
                      <input type="hidden" class="tokenId" name="tokenId" v-model="balance.currency.id"/>
                      <input type="hidden" class="basisPointsRate" name="basisPointsRate" v-model="balance.currency.tokenBaseRate"/>
                      <input type="hidden" class="owner" name="owner" v-model="balance.owner"/>
                      <input type="hidden" class="payment" name="payment" v-model="balance.payment"/>
                  </ajax-form>
                  </td>
                  -->

              </tr>
              
              </tbody>
          </table>
      </div>

      <!-- Modal -->
      <div id="exchangeModal" tabindex="-1" role="dialog" aria-labelledby="exchangeModalLabel" aria-hidden="true"
        class="example-modal exchangeModal modal fade">
        <div class="modal-dialog" role="document">
          <div class="modal-content">
            <div class="modal-header">
              <!-- {{formData.status}} -->
              <!-- {{formData.status == 'unpaid'}} -->
              <!-- <template v-if="formData && formData.status == 'unpaid'"> -->
              <template v-if="formData && formData.status == 'unpaid'">
                <h5 class="modal-title" id="exchangeModalLabel">Connect With Stripe </h5>
              </template>
              <template v-else-if="formData.status === 'approved'">
                <h5 class="modal-title" id="exchangeModalLabel">Cash Out</h5>
              </template>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <!-- 
                  TODO
                  if the person doesnt have a card linked to thier account 
                  give them link to account page and tell them to link the card do their account
                -->
              <template v-if="formData && formData.status === 'unpaid'">
                <div class="row">
                  <div class="col-sm-12">
                    <h4>You must connect your account with stripe to cash out.</h4>
                  </div>
                  
                </div>
              </template>
              <!--
                if web3.defaul.address is not a key in addresses
                  show stripe merchantSetUp page
                ="!sails.config.web3.owner  
                -->
              <template v-else-if="me && me.hadBillingCard && !formData.ethAddress">
                <div >
                  <p>It appears that you do not have a ETH address. Please visit the Merchant Setup page to troubleshoot.  </p>
                  <a type="button" class="btn btn-primary" href="http://localhost:1337/account/view-shops">Merchant Setup</a>
                </div>
              </template>
              <!--
                if web3.dfault address stat is u unpaid. show uit that tlels them they must pay 10 to exchange .
                the submit button shoul say somethign like pay or pay 10.
                ther needs to be a payment controller that add the stripe payment recipt to the address model stripePaymentId\
                sails.models.address.status == unpaid
                !me.hasBillingCard
                -->
              <!-- <template v-else-if="me && me.hasBillingCard && formData.status === 'unpaid'">
                <div class="form-group text-center merchantSetUp">
                  <h4>You must pay a $10.00 exchange fee and create a Stripe merchant account for this address in order
                    exchange stable tokens for fiat currency.</h4>
                  <h6>ETH Address:</h6>
                  <h6>{{formData.ethAddress}}</h6>
                </div>
                <div class="row">
                  <div class="col-sm-12">
                    <div class="form-group text-left">
                      <button type="submit" class="btn btn-primary" data-toggle="modal" data-target="#exchangeModal">
                        Create Shop Token
                      </button>
                    </div>
                  </div>
                </div>
              </template> -->
              <!--
                if the status is paid 
                  then show a pending verification screen for web3.dfault address
                  -->
              <template v-else-if="formData && formData.status === 'paid'">
                <div class="form-group text-center merchantSetUp">
                  <h4>Pending Verification for: </h4>
                  <h6>{{formData.ethAddress}}</h6>
                </div>
                <div class="row">
                  <div class="col-sm-12">
                    <div class="form-group text-left">
                      <button type="submit" class="btn btn-primary" data-toggle="modal" data-target="#exchangeModal">
                        Create Shop Token
                      </button>
                    </div>
                  </div>
                </div>
              </template>
              <!--
                if status is appoves 
                  present a form asking how much money from thier balance they want to exchange 
                  when they click submit 
                    show comfirmation page 
                    show fee 2%
                    when they click confirm 
                      excute payment function on sails.config.web3.shopTokeyAddress via web 3
                      this should brin up meta mask calls user will have to appove. 
                      done -->
              <template v-else="formData && formData.status === 'approved'">
                  <div class="form-group exchange">
                      <label for="quanity">Quanity</label>
                      <h4><span class="quanity">0.00473947</span> USD</h4>
                  </div>
                  <!--
                  <div class="form-group exchange">
                      <label for="price">Price</label>
                      <h4><span class="price">$9,193.01</span> per USD</h4>
                  </div>
                  -->
                  <div class="form-group">
                      <label for="payment">Pay Out</label>
                      <h4><span class="payment">$43.57</span> USD</h4>
                  </div>
                  <div class="form-group">
                      <label for="serviceFee">Service Fee</label>
                      <h4><span class="serviceFee">Revenue Token</span> USD</h4>
                  </div>
                  <div class="form-group">
                      <label for="totalPayment">Total Payout</label>
                      <h4><span class="totalPayment">Revenue Token</span> USD</h4>
                  </div>
                  <h6 class="text-center">Withdraws take 2 days to be processed.</h6>
                  
              </template>
            </div>
    
            <div v-if="formData && formData.status === 'unpaid'" class="modal-footer">
                <button type="button" class="btn btn-secondary close" data-dismiss="modal">Close</button>
                <a :href="'https://connect.stripe.com/express/oauth/authorize?client_id='+formData.clientId+'&redirect_uri='+formData.redirectURI+'&state='+formData.state+'&suggested_capabilities[0]=card_payments&suggested_capabilities[1]=transfers&suggested_capabilities[2]=tax_reporting_us_1099_k'"
                  class="connect-button btn btn-primary"><span>Connect with Stripe</span></a>
            </div>
            <div v-else-if="formData && formData.status === 'approved'" class="modal-footer withdraw">
                <ajax-form action="withdraw" :handle-parsing="withdraw" @submitted="gotBalances($event)">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                  <ajax-button :syncing="syncing" type="submit" class="btn btn-primary submit"  >Cash Out</ajax-button>
                  <input type="hidden" class="invoice_id" name="invoice_id" />
                </ajax-form>
              </div>
    
          </div>
        </div>
      </div>
      <!-- exchange modal end -->
    </div>
      
    `,

    //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
    //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
    //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
    beforeMount: function() {
        // console.log("holdings holdings component buyBalances",this.buyBalances);
        // console.log("holdings holdings component balances",this.balances);
        console.log("holdings holdings component cash",this.cash);
        // console.log("holdings holdings component balances",this.balances);
        console.log("holdings holdings component stabletokenbuyprice",this.stabletokenbuyprice);
        console.log("holdings holdings component withdrawcommission",this.withdrawcommission);
        console.log("holdings holdings component withdrawCommission",this.withdrawCommission);
        console.log("holdings holdings component formData",this.formData);
        this.calculateTotalUsdValue();

        

    },



    //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
    //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
    //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
    methods: {
      calculateTotalUsdValue:  function() {
        var Holdings = this;
        var balances = Holdings.balances;

        var totalUsdValue = 0;
        totalUsdValue = parseFloat(totalUsdValue);

        for (let i = 0; i < balances.length; i++) {
          const balance = balances[i];
          var usdValue = balance.currency.lastPrice ? (balance.currency.lastPrice * (balance.available + balance.spendingBalance + balance.holdingBalance + balance.exchangeBalance) ).toFixed(2) : 0 ;
          usdValue = parseFloat(usdValue);
          totalUsdValue += usdValue;
        }

        this.totalUsdValue = totalUsdValue.toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        
        
      },
      clickPayOwner: async function(event) {
        this.modal = 'example';
        var available = $(event.target).parents('tr').find('.available').html();
        var tokenFee = $(event.target).parents('tr').find('.tokenFee').html();
        var serviceFee = $(event.target).parents('tr').find('.serviceFee').html();
        var totalCharge = $(event.target).parents('tr').find('.totalCharge').html();

        $('.modal .available').html(available);
        $('.modal .cashOut').hide();
        $('.modal .exchange').show();
        $('.modal .serviceFee').html(serviceFee);
        $('.modal .totalCharge').html(totalCharge);
        $('.modal .submit').html("Pay Invoice");
        
      },
      clickExchange: async function(event) {
      console.log("holdings clickExchange");
      this.calcuateTransaction(event);
      this.formData.type = "exchange";
      console.log("balances click exchange this.formData.type",this.formData.type);

        // this.modal = 'example';     
        console.log("holdings holdings clickExchange");
        // $('.modal .submit').html("Cash Out");
        // $('#exchangeModalLabel').html("Conne");
        $('.modal .exchange').show();
      },
      clickCashOut: async function(event) {
        // this.modal = 'example';
      this.calcuateTransaction(event);
      this.formData.type = "withdraw";
        $('.modal .submit').html("Confirm Withdraw");
        $('#exchangeModalLabel').html("Withdraw Your USD");
        $('.modal .exchange').hide();
      },
      calcuateTransaction: async function(event){
        console.log("holdings this",this);


        var quanity = $(event.target).parents('tr').find('.available').html();
        var price = this.stabletokenbuyprice;
        var withdrawCommission = this.withdrawCommission;
        var payment = quanity * price;
        payment = payment.toFixed(2);
        var serviceFee = payment * withdrawCommission;
        serviceFee = serviceFee.toFixed(2);
        var totalPayment = payment - serviceFee;
        totalPayment = totalPayment.toFixed(2);


        console.log("holdings this",this);
        console.log("holdings quanity",quanity);
        console.log("holdings serviceFee",serviceFee);
        console.log("holdings totalPayment",totalPayment);
        console.log("holdings this.stabletokenbuyprice",this.stabletokenbuyprice);
        console.log("holdings withdrawCommission",withdrawCommission);
        
        
        $(".exchangeModal .quanity").html(quanity);
        $(".exchangeModal .price").html(price);
        $(".exchangeModal .payment").html(payment);
        $(".exchangeModal .serviceFee").html(serviceFee);
        $(".exchangeModal .totalPayment").html(totalPayment);
        // $(".exchangeModal .transferAmount").html(transferAmount);
        // $(".exchangeModal .tokenFee").html(tokenFee);
        // $(".exchangeModal .netTransferAmount").html(netTransferAmount);
      },

      closeExampleModal: async function() {``
        this.modal = '';
      
      },
      gotBalances: async function(data) {
        console.log('test gotBalances',data);
        var balances =  data.balances;
        this.renderBalances(balances);
        this.syncing = false; 
        $('.exchangeModal .close').click();
        
      },
      renderBalances: async function(balances) {
        for (let i = 0; i < balances.length; i++) {
          const balance = balances[i];
          this.renderBalance(balance);
        }
      },
      renderBalance: async function(balance) {
        var available =  balance.available;
        var payment =  balance.payment;
        var symbol =  balance.currency.symbol;
        if(symbol == "USDT"){
          $(".USD .available").html(available);
          $(".USD .payment").html(payment);
        }else{
          $("."+symbol+" .available").html(available);
          $("."+symbol+" .payment").html(payment);
        }
        
      },
      paidInvoice: async function(data) {
          // Redirect to the account page on success.
          // > (Note that we re-enable the syncing state here.  This is on purpose--
          // > to make sure the spinner stays there until the page navigation finishes.)
          console.log('test paidInvoice',data);
          if(data.success){
            location.reload();
          }
          // this.syncing = true;
          // window.location = '/account';
        },
        payInvoice: function() {
          // Clear out any pre-existing error messages.
          this.formErrors = {};
    
          var argins = this.formData;
          var argins = { invoice_id: $(".modal .invoice_id").val() };
    
          // // // Validate address:
          // if(!argins.admin_address) {
          //   this.formErrors.admin_address = true;
          // }
          // // // Validate symbol:
          // if(!argins.symbol) {
          //   this.formErrors.symbol = true;
          // }
          // // // Validate symbol:
          // if(!argins.name) {
          //   this.formErrors.name = true;
          // }
    
          // // Validate email:
          // if(!argins.emailAddress) {
          //   this.formErrors.emailAddress = true;
          // }
    
          // // If there were any issues, they've already now been communicated to the user,
          // // so simply return undefined.  (This signifies that the submission should be
          // // cancelled.)
          if (Object.keys(this.formErrors).length > 0) {
            return;
          }
    
          return argins;
        },
        handleParsingForm: function(data) {
          // Clear out any pre-existing error messages.
          console.log('submit data',data);
          console.log('submit data',data);
          this.formErrors = {};
    
          var argins = this.formData;
          if (Object.keys(this.formErrors).length > 0) {
            return;
          }
    
          return argins;
        },
        withdraw: function(data) {
          // Clear out any pre-existing error messages.
          console.log('submit data',data);
          console.log('submit data',data);
          this.formErrors = {};
          this.syncing = true; 

    
          var argins = this.formData;
          console.log('balances withraw  argins',argins);
          if (Object.keys(this.formErrors).length > 0) {
            return;
          }
    
          return argins;
        },
    }

  });
});

