/**
 * <market-table>
 * -----------------------------------------------------------------------------
 * Transaction table.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */
 jQuery(document).ready(function( $ ) {


	Vue.component('marketTable', {
  

    //  ╔═╗╦═╗╔═╗╔═╗╔═╗
    //  ╠═╝╠╦╝║ ║╠═╝╚═╗
    //  ╩  ╩╚═╚═╝╩  ╚═╝
    props: [
      'markets',// « The JS timestamp to format
      'buyCurrency',
      'type',
      'public',
    ],

    //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
    //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
    //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
    data: function (){
      return {
        formatType: undefined,
        formattedTimestamp: '',
        interval: undefined
      };
    },

    /*
                    (type && market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.sellCurrencyIndexToken && market.buyCurrencyPublic && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
                  || (type && market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.buyCurrencyIndexToken && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
    */

    //  ╦ ╦╔╦╗╔╦╗╦
    //  ╠═╣ ║ ║║║║
    //  ╩ ╩ ╩ ╩ ╩╩═╝
    template: `
    <div class="row mb-3 markets">
      <div class="col-md-12">
          <table class="table" align="center">
              <thead>
              <tr>
                  <th>ASSET</th>
                  <th>LAST PRICE</th>
                  <th class="">24H CHANGE</th>
                  <th class="">24H HIGH</th>
                  <th>24H LOW</th>
                  <th>24H VOLUME</th>
                  <th></th>
                  <th></th>
                  <th></th>
              </tr>
              </thead>
              <tbody class="tickers">
                <tr v-for="market in markets" :id="market.id" v-if="market.sellCurrencyNetworkCurrency && market.sellCurrencyBuyCurrency  && (market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() || market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                && ( 
                  (type && market.buyCurrencyIndexToken && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.buyCurrencyIndexToken && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
                  || (type && market.sellCurrencyIndexToken && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.sellCurrencyIndexToken && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
                )" 
                >
                  <td class='market'>
                    <router-link v-if="market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" :to="'/markets/'+market.id">{{market.sellCurrencyName}} </router-link>
                    <router-link v-else-if="market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" :to="'/markets/'+market.id">{{market.buyCurrencyName}} </router-link>
                  </td>
                  <td class='lastPrice'> {{market.last}} </td>
                  <td class='change'> {{market.change}} </td>
                  <td class='high'> {{market.high}} </td>
                  <td class='low'> {{market.low}} </td>
                  <td class='buyVolume'> {{market.buyVolume ? market.buyVolume : 0}} </td>

                  <td v-if="public" class='buy'>
                    <router-link v-if="market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" :to="'/login/quote/buy/' + market.sellCurrencySymbol" class='btn btn-sm btn-success cart'>BUY</router-link>
                    <router-link v-else-if="market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" :to="'/login/quote/buy/' + market.buyCurrencySymbol" class='btn btn-sm btn-success cart'>BUY</router-link>
                  </td>
                  <td v-else="" class='buy'>
                    <router-link v-if="market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" :to="'/quote/buy/' + market.sellCurrencySymbol" class='btn btn-sm btn-success cart'>BUY</router-link>
                    <router-link v-else-if="market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" :to="'/quote/buy/' + market.buyCurrencySymbol" class='btn btn-sm btn-success cart'>BUY</router-link>
                  </td>
                  <td v-if="public" class='sell'>
                    <router-link v-if="market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" :to="'/login/quote/sell/' + market.sellCurrencySymbol" class='btn btn-sm btn-danger cart'>SELL</router-link>
                    <router-link v-else-if="market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" :to="'/login/quote/sell/' + market.buyCurrencySymbol" class='btn btn-sm btn-danger cart'>SELL</router-link>
                  </td>
                  <td v-else="" class='sell'>
                    <router-link v-if="market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" :to="'/quote/sell/' + market.sellCurrencySymbol" class='btn btn-sm btn-danger cart'>SELL</router-link>
                    <router-link v-else-if="market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" :to="'/quote/sell/' + market.buyCurrencySymbol" class='btn btn-sm btn-danger cart'>SELL</router-link>
                  </td>
                  <td class='exchange'>
                    <router-link v-if="market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" :to="'/markets/' + market.id" class='btn btn-sm btn-primary cart'>MARKET</router-link>
                    <router-link v-else-if="market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" :to="'/markets/' + market.id" class='btn btn-sm btn-primary cart'>MARKET</router-link>
                  </td>


                </tr>
                <tr v-for="market in markets" :id="market.id" v-if="!market.sellCurrencyNetworkCurrency && market.sellCurrencyBuyCurrency  && (market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() || market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                && ( 
                  (type && market.buyCurrencyIndexToken && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.buyCurrencyIndexToken && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
                  || (type && market.sellCurrencyIndexToken && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.sellCurrencyIndexToken && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
                )" 
                >
                  <td class='market'>
                    <router-link v-if="market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" :to="'/markets/'+market.id">{{market.sellCurrencyName}} </router-link>
                    <router-link v-else-if="market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" :to="'/markets/'+market.id">{{market.buyCurrencyName}} </router-link>
                  </td>
                  <td class='lastPrice'> {{market.last}} </td>
                  <td class='change'> {{market.change}} </td>
                  <td class='high'> {{market.high}} </td>
                  <td class='low'> {{market.low}} </td>
                  <td class='buyVolume'> {{market.buyVolume ? market.buyVolume : 0}} </td>

                  <td v-if="public" class='buy'>
                    <router-link v-if="market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" :to="'/login/quote/buy/' + market.sellCurrencySymbol" class='btn btn-sm btn-success cart'>BUY</router-link>
                    <router-link v-else-if="market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" :to="'/login/quote/buy/' + market.buyCurrencySymbol" class='btn btn-sm btn-success cart'>BUY</router-link>
                  </td>
                  <td v-else="" class='buy'>
                    <router-link v-if="market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" :to="'/quote/buy/' + market.sellCurrencySymbol" class='btn btn-sm btn-success cart'>BUY</router-link>
                    <router-link v-else-if="market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" :to="'/quote/buy/' + market.buyCurrencySymbol" class='btn btn-sm btn-success cart'>BUY</router-link>
                  </td>
                  <td v-if="public" class='sell'>
                    <router-link v-if="market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" :to="'/login/quote/sell/' + market.sellCurrencySymbol" class='btn btn-sm btn-danger cart'>SELL</router-link>
                    <router-link v-else-if="market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" :to="'/login/quote/sell/' + market.buyCurrencySymbol" class='btn btn-sm btn-danger cart'>SELL</router-link>
                  </td>
                  <td v-else="" class='sell'>
                    <router-link v-if="market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" :to="'/quote/sell/' + market.sellCurrencySymbol" class='btn btn-sm btn-danger cart'>SELL</router-link>
                    <router-link v-else-if="market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" :to="'/quote/sell/' + market.buyCurrencySymbol" class='btn btn-sm btn-danger cart'>SELL</router-link>
                  </td>
                  <td class='exchange'>
                    <router-link v-if="market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" :to="'/markets/' + market.id" class='btn btn-sm btn-primary cart'>MARKET</router-link>
                    <router-link v-else-if="market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" :to="'/markets/' + market.id" class='btn btn-sm btn-primary cart'>MARKET</router-link>
                  </td>


                </tr>

                
                <tr v-for="market in markets" :id="market.id" v-if="!market.sellCurrencyBuyCurrency  && (market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() || market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                && ( 
                  (type && market.buyCurrencyIndexToken && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.buyCurrencyIndexToken && market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
                  || (type && market.sellCurrencyIndexToken  && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() ) 
                  ||  (!type && !market.sellCurrencyIndexToken  && market.sellCurrencyPublic && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase() )
                )" 
                >
                  <td class='market'>
                  
                    <router-link v-if="market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" :to="'/markets/'+market.id">{{market.sellCurrencyName}} </router-link>
                    <router-link v-else-if="market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" :to="'/markets/'+market.id">{{market.buyCurrencyName}}</router-link>
                  </td>
                  <td class='lastPrice'> {{market.last}} </td>
                  <td class='change'> {{market.change}} </td>
                  <td class='high'> {{market.high}} </td>
                  <td class='low'> {{market.low}} </td>
                  <td class='buyVolume'> {{market.buyVolume ? market.buyVolume : 0}} </td>


                  <td v-if="public" class='buy'>
                    <router-link v-if="market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" :to="'/login/quote/buy/' + market.sellCurrencySymbol" class='btn btn-sm btn-success cart'>BUY</router-link>
                    <router-link v-else-if="market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" :to="'/login/quote/buy/' + market.buyCurrencySymbol" class='btn btn-sm btn-success cart'>BUY</router-link>
                  </td>
                  <td v-else="" class='buy'>
                    <router-link v-if="market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" :to="'/quote/buy/' + market.sellCurrencySymbol" class='btn btn-sm btn-success cart'>BUY</router-link>
                    <router-link v-else-if="market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" :to="'/quote/buy/' + market.buyCurrencySymbol" class='btn btn-sm btn-success cart'>BUY</router-link>
                  </td>
                  <td v-if="public" class='sell'>
                    <router-link v-if="market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" :to="'/login/quote/sell/' + market.sellCurrencySymbol" class='btn btn-sm btn-danger cart'>SELL</router-link>
                    <router-link v-else-if="market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" :to="'/login/quote/sell/' + market.buyCurrencySymbol" class='btn btn-sm btn-danger cart'>SELL</router-link>
                  </td>
                  <td v-else="" class='sell'>
                    <router-link v-if="market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" :to="'/quote/sell/' + market.sellCurrencySymbol" class='btn btn-sm btn-danger cart'>SELL</router-link>
                    <router-link v-else-if="market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" :to="'/quote/sell/' + market.buyCurrencySymbol" class='btn btn-sm btn-danger cart'>SELL</router-link>
                  </td>
                  <td class='exchange'>
                    <router-link v-if="market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" :to="'/markets/' + market.id" class='btn btn-sm btn-primary cart'>MARKET</router-link>
                    <router-link v-else-if="market.sellCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" :to="'/markets/' + market.id" class='btn btn-sm btn-primary cart'>MARKET</router-link>
                  </td>
                  
                  
                </tr>

              </tbody>
          </table>
      </div>
    </div>
      
    `,
    // <tr v-for="market in markets" :id="market.id" v-if="market && market.sellCurrencySymbol && !market.sellCurrencySymbol.buyCurrency && market.sellCurrencySymbol.icoOrder && (!market.sellCurrencyIndexToken && !type || market.sellCurrencyIndexToken && type) && market.buyCurrencySymbol.toLowerCase() == buyCurrency.toLowerCase()" >
    //
    //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
    //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
    //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
    beforeMount: function() {
        console.log("markets",this.markets);

    },



    //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
    //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
    //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
    methods: {

    }

    /*
      <tr v-for="market in markets">
          <td>
              <router-link :to="'/account/markets/'" >
                  <div class="symbol">{{ market.symbol }}</div>
                  <div class="name">{{ market.name }}</div>
              </router-link>
          </td>
          <td>
              <span class="lastPrice">{{ market.lastPrice }} </span>
          </td>
          <td>
              <span class="change">{{ market.change }}</span>
          </td>
          <td>
              <span class="high">{{ market.high }}</span>
          </td>
          <td>
              <span class="low">{{ market.low }}</span>
          </td>
          <td>
              <span class="volume">{{ market.volume }}</span>
          </td>
      </tr>
    */

  });

});

