/**
 * <trade-table>
 * -----------------------------------------------------------------------------
 * Transaction table.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */

jQuery(document).ready(function( $ ) {

    Vue.component('payButton', {

        //  ╔═╗╦═╗╔═╗╔═╗╔═╗
        //  ╠═╝╠╦╝║ ║╠═╝╚═╗
        //  ╩  ╩╚═╚═╝╩  ╚═╝
        props: [
            'checkoutRedirect',
            'environment',// « environment
            'hasBillingCard',// « hasBillingCard
            'stableToken',// « stableToken
            'parentToken',// « parentToken
            'minOwnerPromoterCommission',// « minOwnerPromoterCommission
            'token',// « token 
            'paymentMethods',// « paymentMethods
            'label',// « label
            'orderId',
            'checkoutAction',
            'note',
            'amount',
            'fastCheckout',


        ],

        //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
        //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
        //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
        data: function (){
            return {
            syncing: false,
            
            // Form data
            formData: { },

            // For tracking client-side validation errors in our form.
            // > Has property set to `true` for each invalid property in `formData`.
            formErrors: { /* … */ },

            // Server error state for the form
            cloudError: '',

            };
        },

        //  ╦ ╦╔╦╗╔╦╗╦
        //  ╠═╣ ║ ║║║║
        //  ╩ ╩ ╩ ╩ ╩╩═╝
        template: `
        <span class="d-inline pay-button-box">
            <a class="btn btn-sm btn-primary" id="payment" @click="clickTransaction"  href="#pay"   data-toggle="modal" data-target="#transactionModal" >{{label ? label : "Pay Now" }}</a>
            <!-- transaction modals start -->
            <!-- added login action because i think this should not submit a create transaction post but really save cart to pay now flow-->

                <ajax-form style="position:absolute" action="login" :syncing.sync="syncing" :cloud-error.sync="cloudError" @submitted="createdTransaction($event)" :handle-parsing="createTransaction">

                <!-- Transaction modal -->
                <div class="modal fade transactionModal united-product united-token-product" id="transactionModal" tabindex="-1" role="dialog" aria-labelledby="transactionModalLabel" aria-hidden="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="transactionModalLabel"><span class="action"></span> {{parentToken.name}}</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body text-left">
                            <!-- <ajax-form action="createTransaction" :syncing.sync="syncing" :cloud-error.sync="cloudError" @submitted="submittedForm($event)" :handle-parsing="handleParsingForm"> -->
                            <div class="form-group d-none">
                                <label for="name">Payment Method</label>
                                <select id="fromBalanceId" class="form-control" v-model.trim="formData.from"  name="from" >
                                    <option selected="selected" v-for="paymentMethod in paymentMethods" :value="paymentMethod.id" >
                                        {{paymentMethod.name}}
                                    </option>
                                </select>
                                <div class="invalid-from" v-if="formErrors.from">Please enter your a valid payment method.</div>
                                <!-- <small id="adminHelp" class="form-text text-muted">How much of your net income form orders do you want to allocate to your shop token holders?</small> -->
                            </div>
                            
                            <!-- <div class="form-group promote">
                                <label for="name">Description</label>
                                <h4 class="promoterDesciption"> {{token.promoterDesciption}} </h4>
                            </div> -->
                            
                            <div class="form-group pay">
                                <label for="name">Amount</label>
                                <!-- {{maxPromoterCharge}} -->
                                <input @change="changeTransaction" class="form-control amount quantity" type="number" id="amount" min=".000001"  value="0"  name="amount" v-model="formData.amount">
                                <div class="invalid-amount" v-if="formErrors.amount">Please enter your a valid amount.</div>
                                <!-- <small id="adminHelp" class="form-text text-muted">How much of your net income form orders do you want to allocate to your shop token holders?</small> -->
                            </div>
                            <div class="form-group pay note">
                                <label for="name">Note</label>
                                <textarea @change="changeTransaction"  class="form-control orderNote note"  id="note" name="note"  v-model="formData.note"></textarea>
                                <div class="invalid-note" v-if="formErrors.note">Please enter your a valid note.</div>
                            </div>
                            <div v-if="token.promoterDesciption"class="form-group promote">
                                <!-- <label for="name">Note</label> -->
                                <div class="promoterDesciption description"> <input type="hidden" :value="token.promoterDesciption"/> </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label" for="total">Frequency</label>
                                <div>
                                    <select name="frequency" id="frequency" class="form-control frequency">
                                    <option value="once">One Time</option>
                                    <option value="hourly">Hourly</option>
                                    <option value="daily">Daily</option>
                                    <option value="weekly">Weekly</option>
                                    <option value="monthly">Monthly</option>
                                    </select>
                                </div>
                                <!-- <small id="priceHelp" class="form-text text-muted">How frequently do you want to make this payment</small> -->
                            </div>
                            <div class="row fund pt-5">
                                <!-- <h4 class="value col-md-12">You Pay...</h4> -->
                                <!-- <div class="form-group col-md-6">
                                    <label for="name">Commission Charge</label>
                                    <h4 class="value">{{ formData.amount}} USD</h4>
                                </div> -->
                                <!-- <h4 class="value col-md-12">You will recieve...</h4> -->
                                <h4 class="value col-md-12">Maximum Sales Commission</h4>
                                <!-- <div class="form-group col-md-6">
                                    <label for="name">Quantity of {{token.symbol}}</label>
                                    <h4 class="value"><span class="netTransferAmount"></span> {{token.symbol}}</h4>
                                </div> -->
                                <div class="form-group col-md-6">
                                    <!-- <label for="name">Sales Commission</label> -->
                                    <h4 class="value"><span class="maxCommission">{{ (parentToken.promoterCommission ).toFixed(2) * 100 }}</span>% for <span class="promoterCharge">{{ token.promoterCharge.toFixed(2) }}</span> USD </h4>
                                </div>
                            </div>
                            <div class="row fund pt-1">
                                <!-- <h4 class="value col-md-12">You Pay...</h4> -->
                                <!-- <div class="form-group col-md-6">
                                    <label for="name">Commission Charge</label>
                                    <h4 class="value">{{ formData.amount}} USD</h4>
                                </div> -->
                                <!-- <h4 class="value col-md-12">You will recieve...</h4> -->
                                <h4 class="value col-md-12">Your Sales Commission</h4>
                                <!-- <div class="form-group col-md-6">
                                    <label for="name">Quantity of {{token.symbol}}</label>
                                    <h4 class="value"><span class="netTransferAmount"></span> {{token.symbol}}</h4>
                                </div> -->
                                <div class="form-group col-md-6">
                                    <!-- <label for="name">Sales Commission</label> -->
                                    <h4 class="value"><span class="ownershipPercent">{{ (parentToken.promoterCommission - minOwnerPromoterCommission).toFixed(2) * 100 }}</span>% </h4>
                                </div>
                            </div>
                            <div class="row fund pt-1">
                                <h4 class="value col-md-12">Sales Commission Fee</h4>
                                <div class="form-group col-md-6">
                                    <h4 class="value"><span class="minOwnerPromoterCommission">{{ minOwnerPromoterCommission * 100 }}</span>% </h4>
                                </div>
                            </div>
                            <div class="row fund pt-1">
                                <h4 class="value col-md-12">Your Net Sales Commission</h4>
                                <div class="form-group col-md-6">
                                    <h4 class="value"><span class="netPromoterCommission">{{ (parentToken.promoterCommission - minOwnerPromoterCommission).toFixed(2) * 100 }}</span>% </h4>
                                </div>
                            </div>
                            <div class="row fund pt-1">
                                <!-- <h4 class="value col-md-12">You Pay...</h4> -->
                                <!-- <div class="form-group col-md-6">
                                    <label for="name">Commission Charge</label>
                                    <h4 class="value">{{ formData.amount}} USD</h4>
                                </div> -->
                                <!-- <h4 class="value col-md-12">You will recieve...</h4> -->
                                <h4 class="value col-md-12">You Pay</h4>
                                <!-- <div class="form-group col-md-6">
                                    <label for="name">Quantity of {{token.symbol}}</label>
                                    <h4 class="value"><span class="netTransferAmount"></span> {{token.symbol}}</h4>
                                </div> -->
                                <div class="form-group col-md-6">
                                    <!-- <label for="name">Sales Commission</label> -->
                                    <h4 class="value">$ <span class="charge">0.00</span> USD</h4>
                                </div>
                            </div>
                            
                            
                            
                            <input type="hidden" name="tokenId" v-model="formData.tokenId">
                            <!-- <input type="hidden" class="type" name="type" v-model="formData.type" > -->
                            
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                            <button type="button" class="btn btn-primary confirm-transaction" data-dismiss="modal" data-toggle="modal" data-target="#confirmModal" style="display:none">Send</button>
                            <!-- <button type="button" class="btn btn-primary validate-transaction fast-cart" >Pay</button> -->
                            <ajax-button type="button" :syncing="syncing" class="btn btn-primary validate-transaction fast-cart">Pay</ajax-button> 

                            
                            <!-- <ajax-button type="submit" :syncing="syncing" class="btn btn-primary">Submit</ajax-button> -->

                            <!-- <button class="col-12 btn btn-primary fast-cart">Buy Now</button> -->
                            <input type="hidden" class="shopifyVariantId" value="" >
                            <input type="hidden" class="productId" :value="stableToken.buyProductId" >
                            <input type="hidden" class="title" :value="stableToken.name" >
                            <input type="hidden" class="img" :value="stableToken.logo" >
                            <input type="hidden" class="shopifyHandle" :value="stableToken.shopifyBuyProductHandle" >
                            <input type="hidden" class="variantPrice" :value="stableToken.price" >
                            <input type="hidden" class="price" :value="stableToken.price" >
                            <input type="hidden" class="tokenId" :value="token.id" >
                            <input type="hidden" class="type" value="token" >
                            

                        </div>
                        </div>
                    </div>
                </div>
                <!-- Confirm Modal -->
                <div class="modal fade transactionModal confirmModal" id="confirmModal" tabindex="-1" role="dialog" aria-labelledby="confirmModalLabel" aria-hidden="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="confirmModalLabel"><span class="action"></span> {{parentToken.name}}</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body text-left">
                                <!-- <ajax-form action="createTransaction" :syncing.sync="syncing" :cloud-error.sync="cloudError" @submitted="submittedForm($event)" :handle-parsing="handleParsingForm"> -->
                                <div class="form-group">
                                    <label for="amount">Payment</label>
                                    <h4><span class="amount">0</span> USD</h4>
                                    <!-- <input type="hidden" name="name" v-model="formData.amount"> -->
                                </div>
                                <div class="form-group fund">
                                    <label for="price">Price</label>
                                    <h4><span class="price">0</span> {{token.paymentMethod.symbol}}</h4>
                                </div>
                                <div class="form-group">
                                    <label for="serviceFee">Service Fee</label>
                                    <h4><span class="serviceFee">0</span> USD</h4>
                                </div>
                                <!-- <div class="form-group">
                                    <label for="sendAmount">Send Amount</label>
                                    <h4><span class="sendAmount">0</span> {{token.paymentMethod.symbol}}</h4>
                                </div> -->
                                <!-- <div class="form-group">
                                    <label for="transferAmount">Transfer Amount</label>
                                    <h4><span class="transferAmount">0</span> {{token.symbol}}</h4>
                                </div> -->
                                <div class="form-group">
                                    <label for="tokenFee">Token Fee</label>
                                    <h4><span class="tokenFee">0</span> {{token.paymentMethod.symbol}}</h4>
                                </div>
                                <div class="form-group fund">
                                    <label for="netTransferAmount">Net Transfer Amount</label>
                                    <h4><span class="netTransferAmount">0</span> {{token.symbol}}</h4>
                                </div>
                                <div class="form-group fund">
                                    <label for="ownershipPercent">Ownership %</label>
                                    <h4><span class="ownershipPercent">0</span> % {{token.symbol}}</h4>
                                </div>
                                <div class="form-group pay ">
                                    <label for="note">Note</label>
                                    <h6 class="note">{{formData.note}}</h6>  
                                    <!-- <input type="hidden" name="name" v-model="formData.note"> -->
                                    <div class="invalid-from" v-if="formErrors.hasBillingCard">Please add your card.</div>

                                </div>
                                <input type="hidden" name="tokenId" v-model="formData.tokenId">
                                <input type="hidden" class="type" name="type" v-model="formData.type" >
                                
                            </div>
                            <div v-if="hasBillingCard" class="modal-footer">
                                <button type="button" class="btn btn-secondary back" data-dismiss="modal" data-toggle="modal" data-target="#transactionModal">Back</button>
                                
                                <!-- <button type="button" class="btn btn-primary">Deploy Token</button> -->
                                <ajax-button id="confirm" type="submit" :syncing="syncing" class="btn btn-primary confirm"></ajax-button>

                            </div>
                            <div v-else class="modal-footer">
                                <button type="button" class="btn btn-secondary back" data-dismiss="modal" data-toggle="modal" data-target="#transactionModal">Back</button>
                                
                                <!-- <button type="button" class="btn btn-primary">Deploy Token</button> -->
                                <!-- <ajax-button  type="button" :syncing="syncing" class="btn btn-primary" @click="payTransaction()">Confirm and Pay</ajax-button> -->
                                <ajax-button  id="confirm" type="submit" :syncing="syncing" class="btn btn-primary confirm"></ajax-button>

                            </div>
                            


                            
                        </div>
                    </div>
                </div>
                <!-- {{buyCurrency.price}} -->
                            <!-- <input type="hidden" class="quantity" value="1" > -->
                            <!-- <cart-modal id="cart" :environment="environment" :syncing="syncing" :sell-currency-id="sellCurrency.exchangeTokenId" :checkout-redirect="redirect" checkout-action="buyUnits" product-class="united-product" shop-slug="unitedcoin"  shop="unitedcoin.myshopify.com" storefront-access-token="57eb127019ea45acfe87f917fe00ac3f"></cart-modal> -->
                            <token-cart-modal :checkout-action="checkoutAction" :order-id="orderId" id="token-cart" :environment="environment" :syncing="syncing" :sell-currency-id="token.id" :checkout-redirect="checkoutRedirect" product-class="united-token-product" shop="unitedcoin.myshopify.com" storefront-access-token="57eb127019ea45acfe87f917fe00ac3f"></token-cart-modal>
            </ajax-form>

                <!-- transaction modals end -->


        </span>
            
        `,

        //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
        //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
        //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
        beforeMount: function() {
            this.formData.amount = this.amount;
            this.formData.note = this.note;
            Modal = this;
            setTimeout(function(){ 
                $(".fast-cart, .fast-sell-cart").on("click", function(event) {
                    Modal.syncing = true;
                    // console.log("payOrder.syncing",payOrder.syncing);
                });
            }, 1000);


        },



        //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
        //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
        //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
        methods: {
            changeTransaction: async function(e){
                var payment = $(".transactionModal #amount").val();
                console.log("pre fixed payment",payment);
                payment = parseFloat(payment);
                payment = payment.toFixed(2);
                console.log("post fixed payment",payment);
                $(".transactionModal .charge").html(payment);
                // this.formData.amount = payment.toFixed(2);
                console.log('changeTransaction called',e,payment);
                this.calcuatePromotion(payment);
                var note = $(".transactionModal #note").val();
                console.log("note",note);
                $("#confirmModal .note").html(note);
                // $("#transactionModal .type").val(id);
            },
            calcuatePromotion: async function(amount){
                var maxPromoterCharge = this.maxPromoterCharge;
                var actionLabel = $(".transactionModal .action").html();
                if(actionLabel == "Promote" && amount > maxPromoterCharge){
                $(".transactionModal #amount").val(maxPromoterCharge);
                amount = maxPromoterCharge;
                amount = amount.toFixed(2);
                $(".transactionModal .charge").html(amount);
        
                }
        
                var maxPromoterCommission = this.maxPromoterCommission;
                var minOwnerPromoterCommission = this.minOwnerPromoterCommission;
                
                
        
                var serviceCommission = 0;
                // var serviceCommission = this.serviceCommission;
                var minPromoterCommission = this.minPromoterCommission;
                var tokenCommission = this.minOwnerPromoterCommission ;
                var totalSupply = this.token.totalSupply;
                var price = this.token.price;
                
                var tokenFee = 0;
                var netTransferAmount = transferAmount - tokenFee;
                var ownershipPercent = netTransferAmount / totalSupply;
        
                var serviceFee = amount * serviceCommission;
                var sendAmount = amount - serviceFee;
        
        
                var maxPaidCommission =  maxPromoterCommission - minPromoterCommission; 
                var owedPaidpercentageOfMaxPaidCommission = sendAmount / maxPromoterCharge;
                var owedPaidCommission = owedPaidpercentageOfMaxPaidCommission * maxPaidCommission ;
                var totalCommission = owedPaidCommission + minPromoterCommission;
        
                var transferAmount = totalSupply * totalCommission;
                
        
                /*
                calculate differenc of minPromoterCommission commission and Max promotion commission
                var maxPaidCommission =  maxPromoterCommission - minPromoterCommission; 
                
                make sure maxcharge is max value for payment
        
                caclulate additonal percentage from payment
                owedPaidpercentageOfMaxPaidCommission = divided payment by max charge
        
                owedPaidCommission = owedPaidpercentageOfMaxPaidCommission * maxPaidCommission 
        
                totalCommission = owedPaidCommission + minCommission
        
                */
        
                console.log("amount",amount);
                console.log("price",price);
                console.log("maxPromoterCharge",maxPromoterCharge);
                
                console.log("owedPaidCommission",owedPaidCommission);
                console.log("minPromoterCommission",minPromoterCommission);
                console.log("serviceFee",serviceFee);
                console.log("sendAmount",sendAmount);
                console.log("transferAmount",transferAmount);
                console.log("tokenFee",tokenFee);
                console.log("netTransferAmount",netTransferAmount);
                console.log("totalCommission",totalCommission);
                totalCommission *= 100;
                minOwnerPromoterCommission *= 100;
                var netPromoterCommission = totalCommission - minOwnerPromoterCommission;
                console.log("totalCommission post * 100",totalCommission);
                
                
                $(".transactionModal .netPromoterCommission").html(netPromoterCommission);
                $(".transactionModal .amount").html(amount);
                $(".transactionModal .price").html(maxPromoterCharge);
                // $(".transactionModal .maxPromoterCharge").html(maxPromoterCharge);
                $(".transactionModal .serviceFee").html(serviceFee);
                $(".transactionModal .sendAmount").html(sendAmount);
                $(".transactionModal .transferAmount").html(transferAmount);
                $(".transactionModal .tokenFee").html(tokenFee);
                $(".transactionModal .netTransferAmount").html(transferAmount);
                $(".transactionModal .ownershipPercent").html(totalCommission);
            },
            calcuateInvestment: async function(amount){
                var serviceCommission = this.serviceCommission;
                var tokenCommission = this.token.basisPointsRate ;
                var totalSupply = this.token.totalSupply;
                var price = this.token.price;
                var serviceFee = amount * serviceCommission;
                var sendAmount = amount - serviceFee;
                var transferAmount = sendAmount / price;
                var tokenFee = transferAmount * tokenCommission;
                var netTransferAmount = transferAmount - tokenFee;
                var ownershipPercent = netTransferAmount / totalSupply;
        
                console.log("amount",amount);
                console.log("price",price);
                console.log("serviceFee",serviceFee);
                console.log("sendAmount",sendAmount);
                console.log("transferAmount",transferAmount);
                console.log("tokenFee",tokenFee);
                console.log("netTransferAmount",netTransferAmount);
                console.log("ownershipPercent",ownershipPercent);
                
                
                $(".transactionModal .amount").html(amount);
                $(".transactionModal .price").html(price);
                $(".transactionModal .serviceFee").html(serviceFee);
                $(".transactionModal .sendAmount").html(sendAmount);
                $(".transactionModal .transferAmount").html(transferAmount);
                $(".transactionModal .tokenFee").html(tokenFee);
                $(".transactionModal .netTransferAmount").html(netTransferAmount);
                $(".transactionModal .ownershipPercent").html(ownershipPercent);
            },
            createTransaction: async function() {
                // Clear out any pre-existing error messages.
                var Token = this;
                this.formErrors = {};
        
                var argins = this.formData;
        
                // // // Validate address:
                // if(!argins.admin_address) {
                //   this.formErrors.admin_address = true;
                // }
                // // // Validate symbol:
                // if(!argins.symbol) {
                //   this.formErrors.symbol = true;
                // }
                // // // Validate symbol:
                // if(!argins.name) {
                //   this.formErrors.name = true;
                // }
        
                // // Validate email:
                // if(!argins.emailAddress) {
                //   this.formErrors.emailAddress = true;
                // }
        
                // // Validate card:
                if(!Token.hasBillingCard) {
                if(argins.type == "promote" && 0 == this.token.promoterCharge ) {
                    //no card needed;
                    console.log("createTransaction no card needed");
                }else{
                    console.log("createTransaction argins.type",argins.type);
                    console.log("createTransaction this.promoterCharge",this.promoterCharge);
        
                    var addedCard = await Token.clickStripeCheckoutButton();
                    if(!addedCard){
                    this.formErrors.hasBillingCard = true;
                    }
                }
                
                }
                
                
        
                // // If there were any issues, they've already now been communicated to the user,
                // // so simply return undefined.  (This signifies that the submission should be
                // // cancelled.)
                console.log("createTransaction clicked argins",argins);
                if (Object.keys(this.formErrors).length > 0) {
                return;
                }
                
                return argins;
            },

            clickTransaction: async function(e){
                var id = e.target.id;
                var fastCheckout = this.fastCheckout;
                this.formData.type = id;
                if(id =="fund"){
                $(".transactionModal .action").html("Fund");
                $(".transactionModal .fund, .transactionModal .pay").show();
                $(".transactionModal .promote").hide();
                $(".transactionModal #confirm").html("Confirm and Pay");
                $(".transactionModal #amount").removeAttr("max");
                } else if(id =="payment"){
                $(".transactionModal .action").html("Pay");
                $(".transactionModal .fund, .transactionModal .promote").hide();
                $(".transactionModal .pay").show();
                $(".transactionModal #confirm").html("Confirm and Pay");
                $(".transactionModal #amount").removeAttr("max");
                } else if(id =="invoice"){
                $(".transactionModal .action").html("Invoice");
                $(".transactionModal .fund, .transactionModal .promote").hide();
                $(".transactionModal .pay").show();
                $(".transactionModal #confirm").html("Confirm Request");
                $(".transactionModal #amount").removeAttr("max");
                } else if(id =="promote"){
                $(".transactionModal .action").html("Promote");
                $(".transactionModal .fund, .transactionModal .pay").show();
                $(".transactionModal .promote").show();
                $(".transactionModal .note").hide();
                $(".confirmModal .fund").hide();
                
                $(".transactionModal #confirm").html("Confirm Request");
                $(".transactionModal #amount").attr("max",this.maxPromoterCharge);
                
                }
                console.log('clickTransaction called',e,id);
                $("#fromBalanceId option").removeAttr("selected");
                $("#fromBalanceId").val($("#fromBalanceId option:first").val());
                this.formData.from = $("#fromBalanceId option:first").val();
        
                // $("#transactionModal .type").val(id);
                if(fastCheckout){
                    $(".transactionModal .close, .transactionModal .btn-secondary").hide();
                    $(".transactionModal .fast-cart").click();
                }
            },

        }

        });

});
