/**
 * <transaction-feed>
 * -----------------------------------------------------------------------------
 * Transaction feed.
 *

 * @type {Component}
 *
 * @event close   [emitted when the closing process begins]
 * @event opened  [emitted when the opening process is completely done]
 * -----------------------------------------------------------------------------
 */
 jQuery(document).ready(function( $ ) {

    Vue.component('transactionFeed', {

    //  ╔═╗╦═╗╔═╗╔═╗╔═╗
    //  ╠═╝╠╦╝║ ║╠═╝╚═╗
    //  ╩  ╩╚═╚═╝╩  ╚═╝
    props: [
      'decimals',// « displayDecimals
      'round',// « round up or down defaults to down
      'token',// « The JS timestamp to format
      'transactions',// « The JS timestamp to format
      'label',// « Whether to shorten the formatted date by not including the time of day (may only be used with timeago, and even then only applicable in certain situations)
      'format',// « one of: 'calendar', 'timeago' (defaults to 'timeago'.  Otherwise, the "calendar" format displays data as US-style calendar dates with a four-character year, separated by dashes.  In other words: "MM-DD-YYYY")
    ],

    //  ╦╔╗╔╦╔╦╗╦╔═╗╦    ╔═╗╔╦╗╔═╗╔╦╗╔═╗
    //  ║║║║║ ║ ║╠═╣║    ╚═╗ ║ ╠═╣ ║ ║╣
    //  ╩╝╚╝╩ ╩ ╩╩ ╩╩═╝  ╚═╝ ╩ ╩ ╩ ╩ ╚═╝
    data: function (){
      return {
        factor: undefined,
        formatType: undefined,
        formattedTimestamp: '',
        interval: undefined
      };
    },

    //  ╦ ╦╔╦╗╔╦╗╦
    //  ╠═╣ ║ ║║║║
    //  ╩ ╩ ╩ ╩ ╩╩═╝
    template: `
      <div class="transactions">
          <div v-for="transaction in transactions" class="row mb-3 ">
            <div class="col-3 ">
              <img v-if="transaction.type == 'fund' || transaction.type == 'deposit' || transaction.type == 'reserve'" class="col-12" src="/images/fund.png">
              <img v-else-if="transaction.type == 'payment'" class="col-12" src="/images/profit.png">
              <img v-else-if="transaction.type == 'invoice' || transaction.type == 'payOut'" class="col-12" src="/images/invoice.png">
              <img v-else-if="transaction.type == 'transfer' || transaction.type == 'redeem' || transaction.type == 'withdraw' || transaction.type == 'external' || transaction.type == 'redeem'" class="col-12" src="/images/transfer.png">
              <img v-else-if="transaction.type == 'dividend' || transaction.type == 'royalty'" class="col-12" src="/images/dividend.png">
              <img v-else="" class="col-12" src="/images/transfer.png">
            </div>
            <div class="col-9 ">
              <div class="row ">
                  <div class="col-12">
                      <h5 class="float-left">
                        <!-- <b>{{transaction}}</b> -->
                        <span v-if="true" >{{token.name}} </span> 
                        <span v-else-if="transaction.type == 'withdraw' || transaction.type == 'external'" >{{transaction.tokenId.name}} </span> 
                        <a v-else >{{transaction.tokenId.name}} </a> 

                        <span v-if="transaction.fromOwnerId ==  token.id" >

                          <span v-if="transaction.type == 'fund' || transaction.type == 'deposit' || transaction.type == 'reserve'"  >Transfered</span>
                          <span v-else-if="transaction.type == 'payment'"  >Paid</span>
                          <span v-else-if="transaction.type == 'transfer' || transaction.type == 'redeem'"  >Transfered</span>
                          <span v-else-if="transaction.type == 'withdraw' || transaction.type == 'external'"  >Withdrew</span>
                          <span v-else-if="transaction.type == 'redeem'"  >Redeemed</span>
                          <span v-else-if="transaction.type == 'payOut' 
                            || transaction.type == 'invoice' 
                            || transaction.type == 'dividend' || transaction.type == 'royalty'" >Paid</span>
                          <span v-if="transaction.type == 'fund' || transaction.type == 'deposit' || transaction.type == 'reserve' ">Funding</span>
                          <span v-else-if="transaction.type == 'payment' && transaction.accountID == 0">Revenue</span>
                          <span v-else-if="transaction.type == 'payOut' || transaction.type == 'invoice' ">An Expense</span>
                          <span v-else-if="transaction.type == 'dividend' || transaction.type == 'royalty' ">Royalties</span>
                          <span v-else-if="transaction.type == 'transfer' || transaction.type == 'redeem' ">{{transaction.paymentMethod.symbol}} </span>
                          <span v-else-if="transaction.type == 'withdraw' || transaction.type == 'external' ">{{transaction.paymentMethod.symbol}} </span>
                          <span v-else-if="transaction.type == 'redeem' ">{{transaction.paymentMethod.symbol}} </span>
                        
                        </span>
                        <span v-else-if="transaction.toOwnerId ==  token.id" >

                          <span v-if="transaction.type == 'fund' || transaction.type == 'deposit' || transaction.type == 'reserve'"  >Recieved </span>
                          <span v-else-if="transaction.type == 'payment'"  >Recieved</span>
                          <span v-else-if="transaction.type == 'transfer' || transaction.type == 'redeem'"  >Recieved</span>
                          <span v-else-if="transaction.type == 'withdraw' || transaction.type == 'external'"  >Redeemed</span>
                          <span v-else-if="transaction.type == 'redeem'"  >Redeemed</span>
                          <span v-else-if="transaction.type == 'payOut' 
                            || transaction.type == 'invoice' 
                            || transaction.type == 'dividend' || transaction.type == 'royalty'" >Recieved</span>

                          <span v-if="transaction.type == 'fund' || transaction.type == 'deposit' || transaction.type == 'reserve' ">Funding</span>
                          <span v-else-if="transaction.type == 'payment' && transaction.accountID == 0">Revenue</span>
                          <span v-else-if="transaction.type == 'payOut' || transaction.type == 'invoice' ">Revenue</span>
                          <span v-else-if="transaction.type == 'dividend' || transaction.type == 'royalty' ">Royalties</span>
                          <span v-else-if="transaction.type == 'transfer' || transaction.type == 'redeem' ">{{transaction.paymentMethod.symbol}} </span>
                          <span v-else-if="transaction.type == 'withdraw' || transaction.type == 'external' ">{{transaction.paymentMethod.symbol}} </span>
                          <span v-else-if="transaction.type == 'redeem' ">{{transaction.paymentMethod.symbol}} </span>

                        </span> 

                      
                        
                        
                        
                      </h5>
                      <h5 class="float-right">
                          <js-timestamp :at="transaction.createdAt" format="calendar"></js-timestamp> 
                      </h5>
                  </div>
                  <div class="col-12">
                      <h6 v-if="transaction.type !== 'transfer' && transaction.type !== 'withdraw' && transaction.type !== 'redeem'">{{transaction.note}}</h6>
                      <h6 v-else> {{transaction.note}}   </h6>
                      <!--
                      {{transaction.type}} <br/>
                      from -{{transaction.fromOwnerId ==  token.id}}
                      to - {{transaction.toOwnerId ==  token.id}}
                      -->

                      
                  </div>
                  <div class="col-12">
                      
                      <span v-if="transaction.toOwnerId ==  token.id" >
                        <h5 v-if="transaction.type == 'payment' " class="float-right text-success">+ {{ round == "up" ? Math.ceil(transaction.totalAmount * factor) / factor : Math.floor(transaction.totalAmount * factor) / factor}} {{transaction.paymentMethod.symbol}}</h5>
                        <h5 v-else-if="(transaction.type == 'fund' || transaction.type == 'deposit' || transaction.type == 'reserve') && transaction.toOwnerId ==  token.id" class="float-right text-success">+ {{ round == "up" ? Math.ceil(transaction.totalAmount * factor) / factor : Math.floor(transaction.totalAmount * factor) / factor}} {{transaction.paymentMethod.symbol}}</h5>
                        <h5 v-else-if="(transaction.type == 'fund' || transaction.type == 'deposit' || transaction.type == 'reserve') && transaction.toOwnerId !==  token.id" class="float-right text-danger">- {{ round == "up" ? Math.ceil(transaction.totalAmount * factor) / factor : Math.floor(transaction.totalAmount * factor) / factor}} {{transaction.paymentMethod.symbol}}</h5>
                        <h5 v-else-if="transaction.type == 'transfer' || transaction.type == 'redeem' " class="float-right text-success">+ {{ round == "up" ? Math.ceil(transaction.totalAmount * factor) / factor : Math.floor(transaction.totalAmount * factor) / factor}} {{transaction.paymentMethod.symbol}}</h5>
                        <h5 v-else-if="transaction.type == 'dividend' || transaction.type == 'royalty' " class="float-right text-primary">+ {{ round == "up" ? Math.ceil(transaction.totalAmount * factor) / factor : Math.floor(transaction.totalAmount * factor) / factor}} {{transaction.paymentMethod.symbol}}</h5>
                        <h5 v-else-if="transaction.type == 'payOut' || transaction.type == 'invoice' || transaction.type == 'withdraw' || transaction.type == 'external' " class="float-right text-danger">+ {{ round == "up" ? Math.ceil(transaction.totalAmount * factor) / factor : Math.floor(transaction.totalAmount * factor) / factor}} {{transaction.paymentMethod.symbol}}</h5>
                        <h5 v-else="" class="float-right text-success">+ {{ round == "up" ? Math.ceil(transaction.totalAmount * factor) / factor : Math.floor(transaction.totalAmount * factor) / factor}} {{transaction.paymentMethod.symbol}}</h5>

                      </span>

                      <span v-else-if="transaction.fromOwnerId ==  token.id" >
                        <h5 v-if="transaction.type == 'payment' " class="float-right text-danger">- {{ round == "up" ? Math.ceil(transaction.totalAmount * factor) / factor : Math.floor(transaction.totalAmount * factor) / factor}} {{transaction.paymentMethod.symbol}}</h5>
                        <h5 v-else-if="transaction.type == 'fund' || transaction.type == 'deposit' || transaction.type == 'reserve'  " class="float-right text-danger">- {{ round == "up" ? Math.ceil(transaction.totalAmount * factor) / factor : Math.floor(transaction.totalAmount * factor) / factor}} {{transaction.paymentMethod.symbol}}</h5>
                        <h5 v-else-if="transaction.type == 'transfer' || transaction.type == 'redeem' " class="float-right text-danger">- {{ round == "up" ? Math.ceil(transaction.totalAmount * factor) / factor : Math.floor(transaction.totalAmount * factor) / factor}} {{transaction.paymentMethod.symbol}}</h5>
                        <h5 v-else-if="transaction.type == 'dividend' || transaction.type == 'royalty' " class="float-right text-primary">- {{ round == "up" ? Math.ceil(transaction.totalAmount * factor) / factor : Math.floor(transaction.totalAmount * factor) / factor}} {{transaction.paymentMethod.symbol}}</h5>
                        <h5 v-else-if="transaction.type == 'payOut' || transaction.type == 'invoice' || transaction.type == 'withdraw' || transaction.type == 'external' " class="float-right text-danger">- {{ round == "up" ? Math.ceil(transaction.totalAmount * factor) / factor : Math.floor(transaction.totalAmount * factor) / factor}} {{transaction.paymentMethod.symbol}}</h5>
                        <h5 v-else="" class="float-right text-danger">- {{ round == "up" ? Math.ceil(transaction.totalAmount * factor) / factor : Math.floor(transaction.totalAmount * factor) / factor}} {{transaction.paymentMethod.symbol}}</h5>
                      </span>




                      
                  </div>
              </div>
            </div>
            <div class="col-12">
                <hr>
            </div>
          </div>
      </div>
      
    `,

    //  ╦  ╦╔═╗╔═╗╔═╗╦ ╦╔═╗╦  ╔═╗
    //  ║  ║╠╣ ║╣ ║  ╚╦╝║  ║  ║╣
    //  ╩═╝╩╚  ╚═╝╚═╝ ╩ ╚═╝╩═╝╚═╝
    beforeMount: function() {
        
        this.factor =  Math.pow(10, this.decimals);

    },



    //  ╦╔╗╔╔╦╗╔═╗╦═╗╔═╗╔═╗╔╦╗╦╔═╗╔╗╔╔═╗
    //  ║║║║ ║ ║╣ ╠╦╝╠═╣║   ║ ║║ ║║║║╚═╗
    //  ╩╝╚╝ ╩ ╚═╝╩╚═╩ ╩╚═╝ ╩ ╩╚═╝╝╚╝╚═╝
    methods: {

    }

  });
});
