<?php
/**
 * Creates the yohshow api item for the plugin.
 *
 * @package YohShow
 */
require_once(ABSPATH . 'wp-admin/includes/screen.php');
 

class Yohshow_Markets extends Yohshow_WP {

   public $spendAccountId = 1;//spendAccountId;
   public $reserveAccountId = 4;//rese$reserveAccountId;
   public $accountIdFilter = [0,1,5,4];//accountIdFilter;
   public $internalAccountIdFilter = [1,2,5,4];//internalAccountIdFilter;
   public $spendAccountIdFilter = [1,4];//spendAccountIdFilter;
   public $reserveAccountIdFilter = [2,3,4];//reserveAccountIdFilter;


   public $excludeCurrencies = [];//excludeCurrencies;
   //public $excludeCurrencies = ["BTC","ETH","USDT","USDC"];//excludeCurrencies;

   public $promoterReferralCommission = 0.02;//promoterReferralCommission;
   public $minOwnerPromoterCommission = 0.02;//minOwnerPromoterCommission;
   public $exchangeFee = .005;//exchangeFee;
   public $minPromoterCommission = 0.05;//minPromoterCommission;
   public $paymentDecimal = 6;//paymentDecimal;





       

    public function __construct($yohshow_api) {
        parent::__construct($yohshow_api);
        $this->init();

        // // var_dump("test balances yohshow_api",$this->yohshow_api );

      
    }
    function init(){
        // // var_dump("test balances init");
        $this->enqueue_scripts();
        // // var_dump("test balances enqueue_scripts called");

        // $this->register_scripts();
        $this->rest_api_includes();
        $this->create_endpoints();
        $this->add_shortcodes();

        $this->add_actions();
            // $this->tokenize_app();
      

    }
    public function rest_api_includes() {
      require_once( WC_ABSPATH . 'includes/wc-cart-functions.php' );
      require_once( WC_ABSPATH . 'includes/wc-notice-functions.php' );
    }
    public function add_actions(){
      add_action(
        // 'woocommerce_add_order_item_meta', array( $this, 'checkout_data' ), 10, 3);
        'woocommerce_new_order', array( $this, 'checkout_data' ), 10, 3);
        
     
     
    }
    function checkout_data($order_id,$order) {
    // function checkout_data($item_id, $values, $cart_item_key) {
      if(WC()->session){

        // $order_id = $values["order_id"];
        $session_var  = 'exchange_order_product_ids_to_mint';
        $session_data = WC()->session->get($session_var);
        if(!empty($session_data)){
          //  wc_add_order_item_meta($item_id, $session_var, $session_data);
          update_post_meta($order_id, $session_var, $session_data);
        }

        $session_var  = 'exchange_order_checkout_id';
        $session_data = WC()->session->get($session_var);
        if(!empty($session_data)){
          //  wc_add_order_item_meta($item_id, $session_var, $session_data);
          update_post_meta($order_id, $session_var, $session_data);
        }
        // else
        //    error_log("no session data", 0);

      }
      
   }
    public function create_endpoints(){

      /*
      routes and pages that must exist 

      markets page
        'GET /markets': { action: 'view-markets' }, //
        'POST /api/markets': { action: 'exchange/markets' }, //  ..
 
      market page
        'GET /markets/:market?': { action: 'view-market' }, //
        'POST /api/market': { action: 'exchange/market' },  // ..
        'POST /place-orders': { action: 'exchange/place-orders' }, // ..


      buy quote page
        'GET /buyUnits': { action: 'view-buy-units' },
        'POST /api/getQuote': { action: 'exchange/get-quote' },  .. //
        'POST /exchange/checkout/save': { action: 'exchange/save-checkout' }, ..



      sell quote page
        'GET /sell/:symbol?': { action: 'view-sell-units' },
        'POST /api/getQuote': { action: 'exchange/get-quote' },  ..
        'POST /exchange/checkout/save': { action: 'exchange/save-checkout' }, ..


      pay now page
        'GET /pay-now/:checkoutId?': { action: 'view-pay-now' },
        'POST /api/payNow': { action: 'exchange/pay-now' }, 


        'POST /update-checkout-payment-method': { action: 'prime-trust/update-checkout-payment-method' }, ..

        


      checkout page
        'GET /checkout/:checkoutId?': { action: 'view-checkout' },
        'POST /pay-now': { action: 'prime-trust/pay-checkout' }, ..
        'POST /api/checkout': { action: 'exchange/checkout' }, ..



      orders page
        'GET /orders': { action: 'view-orders' },
        'POST /api/orders': { action: 'exchange/orders' }, ..
        'POST /subscriptions/pause': { action: 'exchange/pause-subscription' }, ..



      place order action
        'POST /place-orders': { action: 'exchange/place-orders' }, // ..

      referes market action 
              'POST /api/market': { action: 'exchange/market' },  ...


      cancel orders
        'POST /markets/orders/cancel': { action: 'exchange/cancel-order' }, ..


  */

        $register_result = add_action( 'rest_api_init', function () {
            register_rest_route( 'yohshow/api/v1', '/markets/orders/cancel', array(
              'methods' => 'POST',
              'callback' => array($this,"cancel_order")
            ) ); //

            register_rest_route( 'yohshow/api/v1', '/markets', array(
              'methods' => 'POST',
              'callback' => array($this,"markets")
            ) );  //
            register_rest_route( 'yohshow/api/v1', '/markets', array(
              'methods' => 'POST',
              'callback' => array($this,"markets")
            ) );  //

            register_rest_route( 'yohshow/api/v1', '/market', array(
              'methods' => 'POST',
              'callback' => array($this,"market")
            ) );//

            register_rest_route( 'yohshow/api/v1', '/place-orders', array(
              'methods' => 'POST',
              'callback' => array($this,"place_order")
            ) ); //
            register_rest_route( 'yohshow/api/v1', '/markets/orders', array(
              'methods' => 'POST',
              'callback' => array($this,"place_order")
            ) ); //

            register_rest_route( 'yohshow/api/v1', '/getQuote', array(
              'methods' => 'POST',
              'callback' => array($this,"get_quote")
            ) ); //

            register_rest_route( 'yohshow/api/v1', '/exchange/checkout/save', array(
              'methods' => 'POST',
              'callback' => array($this,"save_checkout")
            ) ); //


              // pay now page view
            register_rest_route( 'yohshow/api/v1', '/payNow', array(
              'methods' => 'POST',
              'callback' => array($this,"pay_now")
            ) ); //

            register_rest_route( 'yohshow/api/v1', '/update-checkout-payment-method', array(
              'methods' => 'POST',
              'callback' => array($this,"update_checkout_payment_method")
            ) );//
            // pay now checkout to lead to process checkout and such 
            register_rest_route( 'yohshow/api/v1', '/pay-now', array(
              'methods' => 'POST',
              'callback' => array($this,"pay_checkout")
            ) );//

            register_rest_route( 'yohshow/api/v1', '/checkout', array(
              'methods' => 'POST',
              'callback' => array($this,"checkout")
            ) );//

            // register_rest_route( 'yohshow/api/v1', '/orders', array(
            //   'methods' => 'POST',
            //   'callback' => array($this,"orders")
            // ) );

            register_rest_route( 'yohshow/api/v1', '/subscriptions/pause', array(
              'methods' => 'POST',
              'callback' => array($this,"pause_subscription")
            ) );




            

            

            

          } );
      
    }

    //scripts 
    
    public function get_market($currencyPair){
      session_start();
        global $current_user;
        // doesnt work
        // $is_user_logged_in = is_user_logged_in();


      $is_user_logged_in = isset($_SESSION["exchange_wp_user_id"]) && $_SESSION["exchange_wp_user_id"] ? true : false  ;
        // $user = wp_get_current_user();
      $me = array();
      if($is_user_logged_in){
        // $me["exchange_wp_user_id"] = $_SESSION["exchange_wp_user_id"];
        $me["exchangeUserId"] = $_SESSION["exchange_user_id"];
      }

      // var currencyPair = inputs.currencyPair;
      // var req = inputs.req;
      // var session = req.session;
      //if market dont exit and its uppost exist create it
      if($is_user_logged_in){
        // var market = await sails.helpers.exchange.request("post","/markets/"+currencyPair,{},session);
 

  
        $market = (object) $this->yohshow_api->request("post","/markets/".$currencyPair,[]);
      }else{
        $market = (object) $this->yohshow_api->request("get","/public/markets/".$currencyPair,[]);
        // var market = await sails.helpers.exchange.request("get","/public/markets/"+currencyPair,{},session);
    }
      //console.log('market helper return',market);
      // var currencyInfo = await sails.helpers.exchange.currencyPair(currencyPair);
      // market = Object.assign(market, currencyInfo);
      // var buyCurrency = market.buyCurrency;
      // var sellCurrency = market.sellCurrency;
      // market['depth'] = await sails.helpers.exchange.request("get","/public/markets/"+currencyPair+"/depth",{},session);
      // market['trades'] = await sails.helpers.exchange.request("get","/public/markets/"+currencyPair+"/trades",{},session);
      // market['orders'] = await sails.helpers.exchange.request("get","/public/markets/"+currencyPair+"/order-book",{},session);
      // market['kLine'] = await sails.helpers.exchange.request("get","/public/markets/"+currencyPair+"/k-line",{},session);
      // market[buyCurrency] = await sails.helpers.exchange.request("get","/account/balances/"+buyCurrency.toLowerCase(),{},session);
      // market[sellCurrency] = await sails.helpers.exchange.request("get","/account/balances/"+sellCurrency.toLowerCase(),{},session);
      // market.chartData = {};
      // market.chartData.trades = await sails.helpers.exchange.chartData("trades",market.trades);
      $market->orders = $this->format_orders($market->orders);
      $market->id  = strtolower($market->id);
      $market->loggedIn = $is_user_logged_in;
      $market->me = $me;
      return $market;
    }
    public function format_orders(&$orders){
      // $orders = inputs.orders;
      $total_asks_supply = 0;
      $total_asks_demand = 0;
      $total_bids_supply = 0;
      $total_bids_demand = 0;
      for ($i=0; $i < count($orders->asks) ; $i++) { 
        $ask = $orders->asks[$i];
        $price = floatval($ask->price);
        $remainingVolume = floatval($ask->remainingVolume);
        $total_asks_supply += $remainingVolume;
        $total_asks_demand += $remainingVolume * $price;
        $price = floatval($ask->price);
      }
      
      for ($i=0; $i < count($orders->bids) ; $i++) { 
        $bid = $orders->bids[$i];
        $price = floatval($bid->price);
        $remainingVolume = floatval($bid->remainingVolume);
        $total_bids_supply += $remainingVolume;
        $total_bids_demand += $remainingVolume * $price;
        $price = floatval($bid->price);
      }
      
      $orders->total_asks_supply = $total_asks_supply;
      $orders->total_asks_demand = $total_asks_demand;
      $orders->total_bids_supply = $total_bids_supply;
      $orders->total_bids_demand = $total_bids_demand;

      return $orders;

      // orders.asks.forEach(order => {
      //     //console.log('ask order',order);
      //     var price = parseFloat(order.price);
      //     var remainingVolume = parseFloat(order.remainingVolume);
      //     total_asks_supply += remainingVolume;
      //     total_asks_demand += remainingVolume * price;
      // });
      // orders.bids.forEach(order => {
      //     //console.log('bid order',order);
      //     var price = parseFloat(order.price);
      //     var remainingVolume = parseFloat(order.remainingVolume);
      //     total_bids_supply += remainingVolume;
      //     total_bids_demand += remainingVolume * price;
      // });
      // orders.total_asks_supply = total_asks_supply;
      // orders.total_asks_demand = total_asks_demand;
      // orders.total_bids_supply = total_bids_supply;
      // orders.total_bids_demand = total_bids_demand;
  
      // //console.log(orders);
      // return orders;
    }

    public function add_shortcodes(){
        add_shortcode('markets', array($this,'markets_shortcode') );
    }
    /**
    * Displays account of current user.
    *
    * @since 1.0.0
    */
    // function that runs when shortcode is called

    /**
    * Displays markets of current user.
    *
    * @since 1.0.0
    */
    // function that runs when shortcode is called
    public function markets_shortcode() { 
      $is_user_logged_in = is_user_logged_in();
      if($is_user_logged_in === false){
        // // var_dump("is_user_logged_in",$is_user_logged_in);
        $result["public"] = true;
        $result["accounts"] = [];
        $GLOBALS['YOH_SHOW_LOCALS'] = json_encode($result) ;
        return  "<h2>Please login or register</h2>";

        ob_start();
        include 'views/account.php';
        return ob_clean();

      }else{
        $result["public"] = false;
      }
      //is admin

    try {
      $yohshow_api =  $this->yohshow_api;
      $isSuperAdmin = is_super_admin();
      $apiKey =  $this->yohshow_api_key;
      $apiSecret =  $this->yohshow_api_secret;
      $userType =  $_GET["userType"];
      $accountId =  $_GET["accountId"];
      $accountIdFilter = $this->accountIdFilter;

      //markets
      $excludeCurrencies = $this->excludeCurrencies;
      $filteredMarkets = [];
      $filter["apiKey"] = $apiKey;


      $marketsFilter["filter"] = $filter;
      // $markets = (object)$yohshow_api->request("post","/markets",$marketsFilter);
      // print_r($markets);

//       $appToken = $markets->appToken;
//       $stableToken = $markets->stableToken;
// //      for ($i=0; $i < count($markets->markets) ; $i++) {
//         for ($i=0; $i < 80 ; $i++) {
//         # code...
//         $market = $markets->markets[$i];
//         // if(!in_array($market->sellCurrencySymbolBase,$excludeCurrencies)
//         // && !in_array($market->buyCurrencySymbolBase,$excludeCurrencies)
//         // ){
//           $filteredMarkets[] = $market;
//         // }
//       }
      




       $result['flag'] = true;

//         $result['markets'] = $filteredMarkets;
// //       $result['markets'] = $markets->markets;
// //       $result['filteredMarkets'] = $markets->markets;
// //       $result['filteredMarkets'] = $filteredMarkets;
// //       $result['markets'] = $markets->markets;
//        // $result['baseUrl'] = $baseUrl;
//        $result['appToken'] = $appToken;
//        $result['stableToken'] = $stableToken;

//        $result['appTokenSymbol'] = strtolower($appToken->symbol);
//        $result['stableTokenSymbol'] = strtolower($stableToken->symbol);


//      $result['flag'] = false;
     $result['markets'] = [];
      $result['filteredMarkets'] = [];
//      // $result['baseUrl'] = $baseUrl;
     $result['appToken'] = (object)[];
     $result['stableToken'] =(object)[];
//
     $result['appTokenSymbol'] = "";
     $result['stableTokenSymbol'] = "";
      
    } catch (\Throwable $error) {



      $result['flag'] = false;
      $result['markets'] = [];
      $result['filteredMarkets'] = [];
      // $result['baseUrl'] = $baseUrl;
      $result['appToken'] = (object)[];
      $result['stableToken'] =(object)[];

      $result['appTokenSymbol'] = "";
      $result['stableTokenSymbol'] = "";

      

        // return $result;      
    }

     
      // $test['test'] = "test";
        $result_json = json_encode($result) ;
      $GLOBALS['YOH_SHOW_LOCALS'] = $result_json;

        // return  "<h2>test 2</h2>";
        ob_start();
        include 'views/markets.php';
        // include_once('views/account.php');
        return ob_get_clean();

  }



  // methods

    public function cancel_order($request){
        $user = $_SESSION["me"];
        $yohshow_api =  $this->yohshow_api;

        $csrf = $request->get_header('X-CSRF-Token');
        // $inputs = $request['params']['POST'];
        // (object) $inputs;
        $orderId = $request['orderId'];

        // error_log("transfer orderId ".$orderId);
  
        $order = array(
          'id' => $orderId,
        );

  
        $order = (object) $this->yohshow_api->request("post","/markets/orders/cancel",$order);
        // error_log("order post call order order",$order);
  
        $flag = true;
        $msg = "Your order was canceled successfully";
        if($order == false){
            $flag = false;
            $msg = "There was an error canceling your order";
        }

        if($flag){
          $result = [
            'order' => $order,
            'flag' => $flag,
            'msg' => $msg,
          //   baseUrl:$this->baseUrl,
          ];
        }else{
          $result = [
            'order' => [],
            'exchangeError' => true,
            'flag' => $flag,
            'msg' => "Exchange Error",
          //   baseUrl:$this->baseUrl,
          ];
        }
        

        return json_encode($result);
        // return json_encode($data);
    
    }

    public function markets($request){



      try {
        $csrf = $request->get_header('X-CSRF-Token');
        $user = $_SESSION["me"];
        $yohshow_api =  $this->yohshow_api;
        $yohshow_api_key =  $yohshow_api->yohshow_api_key;
        $yohshow_api_secret =  $yohshow_api->yohshow_api_secret;
        $excludeCurrencies =  $this->excludeCurrencies;
        $filter = array(
          'apiKey' => $yohshow_api_key,
        );
        $marketsFilter = array(
          'filter' => json_encode($filter),
        );
  
        $markets = (object) $this->yohshow_api->request("post","/markets",$marketsFilter);
        $appToken = $markets->appToken;
        $stableToken = $markets->stableToken;
  
        $filteredMarkets = [];
        for ($i=0; $i < count($markets->markets) ; $i++) { 
          $market = $markets->markets[$i];
          if(!in_array($market->sellCurrencySymbolBase,$excludeCurrencies)
          && !in_array($market->buyCurrencySymbolBase,$excludeCurrencies)
          ){
            array_push($filteredMarkets,$market);
          }
  
        }
        //TODO add is user public?
        session_start();
        $exchange_wp_user_id = $_SESSION["exchange_wp_user_id"];
        $public = $exchange_wp_user_id ? false : true;
  
        $result = [
          // markets:[],
          'flag' => true,
          'public' => $public,
          'appToken' => $appToken,
          'stableToken' => $stableToken,
          'appTokenSymbol' => strtolower($appToken->symbol),
          'stableTokenSymbol' => strtolower($stableToken->symbol),
          'markets' => $markets->markets,
          'filteredMarkets' => $filteredMarkets,
          // 'baseUrl' => $this->baseUrl,
        ];

      } catch (\Throwable $th) {
        //throw $th;
        $result = [
          // markets:[],
          'flag' => false,
          'exchangeError' => true,
          'public' => true,
          'error' => $th,
          'appToken' => [],
          'stableToken' => [],
          'appTokenSymbol' => "",
          'stableTokenSymbol' => "",
          'markets' => [],
          'filteredMarkets' => [],
          // 'baseUrl' => $this->baseUrl,
        ];
      }
      return json_encode($result);
  
    }

    public function market($request){

      /*

      */



      try {
        $csrf = $request->get_header('X-CSRF-Token');
        $user = $_SESSION["me"];

        $currencyPair = $request['market'];

        // $signupLink = $this->baseUrl + '/register/markets/'+currencyPair;
        $signupLink = "";
        $promoterReferralCommission = $this->promoterReferralCommission;
        $minOwnerPromoterCommission = $this->minOwnerPromoterCommission;
        $exchangeFee = $this->exchangeFee;
        $minOwnerPromoterCommission = $minOwnerPromoterCommission + $promoterReferralCommission;
        $minPromoterCommission = $this->minPromoterCommission;
        $tokenComission = $this->minOwnerPromoterCommission ;
        $excludeCurrencies = $this->excludeCurrencies ;
        $paymentDecimal = $this->paymentDecimal ;
        $yohshow_api =  $this->yohshow_api;


        if($user){
          //NOTE TODO the following code should not be nesscary because the app
          // should confirm if someone is login in before this code get hit
          // if(!this.req.session.exchange){
          //   //must redirect to login or create account
          //   var redirect = '/cards/markets/'+currencyPair;
          //   return {
          //     flag:false,
          //     mustLogin:true,
          //     redirect:redirect,
          //   }
          // }
          //TODO figure out how share links work  
          // $shareLink = sails.config.custom.baseUrl + '/markets/'+currencyPair+"/referral/"+this.req.me.id;
          $shareLink = "";
          //TODO figure out what this limits
          // $hasBillingCard =  this.req.me.hasPrimeTrustBillingCard;
          $hasBillingCard = true;
          

        }else{
          $shareLink = $signupLink;
          $hasBillingCard =  false;
    
        }
        $sails_environment = $this->sails_environment ? $this->sails_environment : "staging";
          
        $session = $_SESSION;
          $apiKey =  $yohshow_api->yohshow_api_key;
          
          $currencyPair = strtolower($currencyPair);  
          //console.log("view marekt currencyPair",currencyPair);
          $market = $this->get_market($currencyPair);
          $me = $market->me;
//          $loggedIn = $user ? true:false;
          $loggedIn = isset($_SESSION["exchange_wp_user_id"]) && $_SESSION["exchange_wp_user_id"] ? true : false  ;
          //console.log("view sails_environment",sails_environment);
          //console.log("view market.exist",market.exist);
          //console.log("view market.processing",market.processing);

          if(!$market->exist && !$market->processing){
            $market->openOrders = [];
            $market->tradeHistory = [];
            $buyCurrency = [];
            $sellCurrency = [];
            
          }else{
            // $market->openOrders = await sails.helpers.exchange.request("get","/market/orders/"+currencyPair+"/wait",{},session);
            // $market->tradeHistory = await sails.helpers.exchange.request("get","/market/orders/"+currencyPair+"/done",{},session);
            
            
            $buyCurrency = $market->buyCurrencyId;
            $sellCurrency = $market->sellCurrencyId;
            

          }
          $appTokenInfo = array(
            'apiKey' => $apiKey,
          );
  

          $appTokenResult = (object) $this->yohshow_api->request("get","/appToken/".$apiKey,$appTokenInfo);
          //console.log("view appTokenResult ",appTokenResult );

          $appToken = $appTokenResult->appToken;
          $stableToken = $appTokenResult->stableToken;
          $paymentMethods = $appTokenResult->paymentMethods;
          $buyUnitsAction =  $buyCurrency->id == $stableToken->id  ? "stable": "units";
          $parentToken = $sellCurrency;
          $token = $sellCurrency;
          //current user info




          
        
          $result = [
            'flag' => true,
            'exchangeFee' => $exchangeFee,
            'excludeCurrencies' => $excludeCurrencies,
            'stableToken' => $stableToken,
            'paymentDecimal' => $paymentDecimal,
            'hasBillingCard' => $hasBillingCard,
            'minPromoterCommission' => $minPromoterCommission,
            'minOwnerPromoterCommission' => $minOwnerPromoterCommission,
            'tokenComission' => $tokenComission,
            'token' => $token,
            'parentToken' => $parentToken,
            'shareLink' => $shareLink,
            'signupLink' => $signupLink,
            'paymentMethods' => $paymentMethods,
            'loggedIn' => $loggedIn,
            'me' => $me,
            'market' => $market,
            'buyCurrency' => $buyCurrency,
            'sellCurrency' => $sellCurrency,
            'appToken' => $appToken,
            'buyUnitsAction' => $buyUnitsAction,
            'environment' => $sails_environment,
          ];
        } catch (\Throwable $th) {
          //throw $th;
          
          $result = [

            'flag' => false,
            'stableToken' => [],
            'exchangeFee' => $exchangeFee,
            'excludeCurrencies' => $excludeCurrencies,
            'hasBillingCard' => $hasBillingCard,
            'parentToken' => $parentToken,
            'shareLink' => $shareLink,
            'signupLink' => $signupLink,
            'exchangeError' => $th,
            'error' => $error,
            'paymentMethods' => [],
            'loggedIn' => false,
            'market' => [],
            'buyCurrency' => '',
            'appToken' => [],
            'buyUnitsAction' => $buyUnitsAction,
            'environment' => $sails_environment,
          ];
        }
        return json_encode($result);
    }

    public function place_order($request){

      $post = $request->get_params();

      try {
        $marketUpdate = array();
        $order = array();
        $market = $post['market'];
        $session = $_SESSION;
        $user = $_SESSION["me"];
        $order['market'] = $market;
        $order['side'] = $post['side'];
        $order['volume'] = $post['volume'];
        $order['price'] = $post['price'];

        //define appCommissionFee
        $costInfo = (object) $this->safe_cost($post['side'] ,$post['price'] ,$post['volume']);
        $appCommissionFee =  $costInfo->costFee;

        $orderMeta = array(
          // 'ownerType' => "token",
          // 'ownerId' => $user->exchangeTokenId,
          'appComission' => $this->exchangeFee,
          'appCommissionFee' => $appCommissionFee,
        );

        $order['orderMeta'] = json_encode($orderMeta);
        $order = (object) $this->yohshow_api->request("post","/market/orders",$order);
        $flag = true;
        $msg = "Your order was placed successfully";



        if($order == false){
            $flag = false;
            $msg = "There was an error placing your order";
        }else{

        }
        
        
        if($flag){
          $marketUpdate = $this->get_market($market);
        }
        $marketUpdate['openOrders'] = (object) $this->yohshow_api->request("get","/market/orders/".$market."/wait",[]);
        $marketUpdate['tradeHistory'] = (object) $this->yohshow_api->request("get","/market/orders/".$market."/done",[]);


        $result = [
          'flag' => $flag,
          'market' => $marketUpdate,
          'order' => $order,
          'msg' => $msg,
        ];


      } catch (\Throwable $th) {
        //throw $th;
        $result = [
          'exchangeError' => true,
          'error' => $th,
          'flag' => $flag,
          'market' => $marketUpdate,
          'order' => $order,
          'msg' => $msg,
        ];
      }
      return json_encode($result);
    }
    public function safe_cost($transactionType,$price,$quantity,$exchangeFee = false,$decimals = 6){
      /*
        $request['side'] ,$request['price'] ,$request['volume']
        cost:  function (transactionType,price,quantity,exchangeFee,decimals = 6) {
          // var action = inputs.action;
          // var a = inputs.a;
          // var b = inputs.b;
          // var decimals = inputs.decimals;
          exchangeFee = parseFloat(exchangeFee);

          var quantity = this.math("round",quantity,1,"down",decimals);
          var price = this.math("round",price,1,"down",decimals);
          if(transactionType == "buy"){
              var cost = this.math("mul",price,quantity,"up",decimals)
          }else if(transactionType == "sell"){
              var cost = this.math("mul",price,quantity,"down",decimals)
          }

          // var costFee = cost * exchangeFee;
          var costFee = this.math("mul",cost,exchangeFee,"up",decimals);

          if(transactionType == "buy"){
              // cost = cost + costFee;
              cost = this.math("add",cost,costFee,"up",decimals);
              cost = this.math("round",cost,1,"up",decimals);

          }else{
              // cost = cost - costFee;
              cost = this.math("sub",cost,costFee,"down",decimals);
              cost = this.math("round",cost,1,"down",decimals);


          }
          return cost;

      },
      */
          $exchangeFee =  $exchangeFee === false ?  $this->exchangeFee : $exchangeFee;
          $exchangeFee = floatval($exchangeFee);

          $quantity = $this->safe_math("round",$quantity,1,"down",$decimals);
          $price = $this->safe_math("round",$price,1,"down",$decimals);
          if($transactionType == "buy"){
              $cost = $this->safe_math("mul",$price,$quantity,"up",$decimals);
          }else if($transactionType == "sell"){
              $cost = $this->safe_math("mul",$price,$quantity,"down",$decimals);
          }

          // $costFee = cost * exchangeFee;
          $costFee = $this->safe_math("mul",$cost,$exchangeFee,"up",$decimals);

          if($transactionType == "buy"){
              // cost = cost + costFee;
              $cost = $this->safe_math("add",$cost,$costFee,"up",$decimals);
              $cost = $this->safe_math("round",$cost,1,"up",$decimals);

          }else{
              // $cost = $cost - $costFee;
              $cost = $this->safe_math("sub",$cost,$costFee,"down",$decimals);
              $cost = $this->safe_math("round",$cost,1,"down",$decimals);


          }
          return $cost;
    }

    public function safe_math($action,$a,$b = 1,$round = "down",$decimals = 6){
            $factor =  pow(10, $decimals);
            
            //console.log("safe math inputs",inputs);
            if($action == "mul"){
                if ($a == 0) {
                    return 0;
                }
                $c = $a * $b;
                // if(c / a == b){
                    
                    $c = $this->safe_math("round",$c,1,$round,$decimals);

                    return $c;
                // }else {
                //     $cResult = c/a;
                //     throw new Error('safe math error multiplication cResult '+cResult + " != b "+b);
                // }
            }
        
            else if($action == 'div') {
                if($b > 0){
                    // Solidity automatically throws when dividing by 0
                    $c = $a / $b;
                    // assert(a == b * c + a % b); // There is no case in which this doesn't hold
                    $c = floor($c* $factor) / $factor;
                    $c = $this->safe_math("round",$c,1,$round,$decimals);

        
                    return $c;
                }else{
                    throw new Exception('safe math division error');
                }
            }
            else if($action == 'round') {
                    // Solidity automatically throws when dividing by 0
                    // $c = a / b;
                    $c = $a ;
                    // decimals = b ? b : decimals;
                    $factor =  pow(10, $decimals);
                    // assert(a == b * c + a % b); // There is no case in which this doesn't hold
                    $c = $round == "up" ? ceil($c* $factor) / $factor : floor($c * $factor) / $factor;

        
                    return $c;
            
            }
            else if($action == 'sub') {
                if($b <= $a){
                    return $a - $b;
                }else{
                    throw new Exception('safe math subtraction error');
                }
            }
            else if($action == 'add') {
                $c = $a + $b;
                if($c >= $a){
                    return $c;
                }else{
                    throw new Exception('safe math adding error');
                }
            }
      /*
          math:  function (action,a,b = 1,round = "down",decimals = 6) {
            // var action = inputs.action;
            // var a = inputs.a;
            // var b = inputs.b;
            // var decimals = inputs.decimals;
            var factor =  Math.pow(10, decimals);
            
            //console.log("safe math inputs",inputs);
            if(action == "mul"){
                if (a == 0) {
                    return 0;
                }
                var c = a * b;
                // if(c / a == b){
                    
                    c = this.math("round",c,1,round,decimals);

                    return c;
                // }else {
                //     var cResult = c/a;
                //     throw new Error('safe math error multiplication cResult '+cResult + " != b "+b);
                // }
            }
        
            else if(action == 'div') {
                if(b > 0){
                    // Solidity automatically throws when dividing by 0
                    var c = a / b;
                    // assert(a == b * c + a % b); // There is no case in which this doesn't hold
                    c = Math.floor(c* factor) / factor;
                    c = this.math("round",c,1,round,decimals);

        
                    return c;
                }else{
                    throw new Error('safe math error');
                }
            }
            else if(action == 'round') {
                    // Solidity automatically throws when dividing by 0
                    // var c = a / b;
                    var c = a ;
                    // decimals = b ? b : decimals;
                    factor =  Math.pow(10, decimals);
                    // assert(a == b * c + a % b); // There is no case in which this doesn't hold
                    c = round == "up" ? Math.ceil(c* factor) / factor : Math.floor(c* factor) / factor;

        
                    return c;
            
            }
            else if(action == 'sub') {
                if(b <= a){
                    return a - b;
                }else{
                    throw new Error('safe math error');
                }
            }
            else if(action == 'add') {
                var c = a + b;
                if(c >= a){
                    return c;
                }else{
                    throw new Error('safe math error');
                }
            }
        
        }
      */
    }

    public function get_quote($request){

      /*

      */

      try {
        $session = $_SESSION;
        $user = $_SESSION["me"];
        $tradeType = $request['tradeType'];
        $symbol = $request['symbol'];
        $yohshow_api =  $this->yohshow_api;

        $apiKey =  $yohshow_api->yohshow_api_key;


        $sails_environment = $this->sails_environment ? $this->sails_environment : "staging";

        //TODO NOTE this code should not be neede because the user should be loggined before thsi code gets tran 
        // if (this.req.me) {

        //   //console.log("logged in");
        //   if(!this.req.session.exchange){
        //     var exchangeMeResult = await sails.helpers.exchange.me(this.req.session);
        //     //console.log('exchange login',exchangeMeResult );
        //     if(exchangeMeResult.session){
        //       this.req.session = exchangeMeResult.session;
        //     }else{
        //       //must login
        //     }
            
        //   }
    
    
        // }

      

          $tokenInfo = array();
       
          $tokenResult = (object) $this->yohshow_api->request("get","/tokens/$symbol",$tokenInfo);
          $token = $tokenResult->token;

          $isBuyCurrency = $token->buyCurrency;
          $sellCurrencySymbol = $token->symbolBase;

          $reserveQuote = !$isBuyCurrency;

          $quote_source_key = "exchange_quote_source";
          $quote_source = get_option( $quote_source_key );

          $quote_source_buy_currency_key = "exchange_quote_source_buy_currency";
          $quote_source_buy_currency = get_option( $quote_source_buy_currency_key );

          //

          $quote_source_api_key_key = "exchange_quote_source_api_key";
          $quote_source_api_key = get_option( $quote_source_api_key_key );

          $quote_source_api_secret_key = "exchange_quote_source_api_secret";
          $quote_source_api_secret = get_option( $quote_source_api_secret_key );

          $quote_source_api_memo_key = "exchange_quote_source_api_memo";
          $quote_source_api_memo = get_option( $quote_source_api_memo_key );

         

        //TODO plugin in bitmart api keys

        $network = $quote_source;
        $amount = 1;
        $buyCurrency = $quote_source_buy_currency;
        if(!$reserveQuote){
          $symbol =  $sellCurrencySymbol . "_" . $buyCurrency;
        }
        $symbol = strtoupper($symbol);
        $quoteInfo["reserveQuote"] = $reserveQuote;
        $quoteInfo["amount"] = $amount;
        $quoteInfo["apiKey"] = $apiKey;
        $quoteInfo["tradeType"] = $tradeType;
        $quoteInfo["symbol"] = $symbol;

        $quoteInfo["exchange"] = $network;
        $quoteInfo["exchangeApiKey"] = $quote_source_api_key;
        $quoteInfo["exchangeApiSecret"] = $quote_source_api_secret;
        $quoteInfo["exchangeApiMemo"] = $quote_source_api_memo;

        //  error_log("get quote symbol $symbol", 0);
        

        $quoteResult = (object) $this->yohshow_api->request("post","/market/quote",$quoteInfo);
        $quote = $quoteResult;


        // error_log( "get quote result quote". print_r( $quote, true ) );


   
       


      
        // $quoteInfo = array(
        //   'tradeType' => $tradeType,
        //   'symbol' => $symbol,
        //   'apiKey' => $apiKey,
        // );

        // $quote = (object) $this->yohshow_api->request("post","/market/quote/",$quoteInfo);


        $flag = true;
        $msg = "Your quote was placed successfully";



        if($quote == false){
            $flag = false;
            $msg = "There was an error placing your quote";
        }else{

        }
        
        
        if($flag){
          return $quote;
        }else{
          $result = [
            'exchangeError' => true,
            'error' => $msg,
            'flag' => false,
            'sellCurrency' => [],
            'stableToken' => [],
            'sellCurrency' => [],
            'paymentMethods' => [],
            'redirect' => '',
            'environment' => $sails_environment,
          ];

        }



      } catch (\Throwable $th) {
        //throw $th;
        $result = [
          'exchangeError' => true,
          'error' => $th,
          'flag' => false,
          'sellCurrency' => [],
          'stableToken' => [],
          'sellCurrency' => [],
          'paymentMethods' => [],
          'redirect' => '',
          'environment' => $sails_environment,
        ];


      }
      return json_encode($result);
    }

    

    public function save_checkout($request){

      /*
        just needs to take checkout request and pass it to api controller and return result

      */

      try {
        $session = $_SESSION;
        $user = $_SESSION["me"];
        $checkout = $request['checkout'];

        $quote_source_key = "exchange_quote_source";
          $quote_source = get_option( $quote_source_key );

          $quote_source_buy_currency_key = "exchange_quote_source_buy_currency";
          $quote_source_buy_currency = get_option( $quote_source_buy_currency_key );

          //

          $quote_source_api_key_key = "exchange_quote_source_api_key";
          $quote_source_api_key = get_option( $quote_source_api_key_key );

          $quote_source_api_secret_key = "exchange_quote_source_api_secret";
          $quote_source_api_secret = get_option( $quote_source_api_secret_key );

          $quote_source_api_memo_key = "exchange_quote_source_api_memo";
          $quote_source_api_memo = get_option( $quote_source_api_memo_key );
        
  

        $sails_environment = $this->sails_environment ? $this->sails_environment : "staging";
        $checkoutInfo = array(
            "exchange" => $quote_source,
            "exchangeBuyCurrency" => $quote_source_buy_currency,
            "exchangeApiKey" => $quote_source_api_key,
            "exchangeApiSecret" => $quote_source_api_secret,
            "exchangeApiMemo" => $quote_source_api_memo,


            "apiKey" => $this->yohshow_api_key,
            "apiSecret" => $this->yohshow_api_secret,
          'checkout' => json_encode($checkout),
        );

        $checkout = (object) $this->yohshow_api->request("post","/checkout/save",$checkoutInfo);
        $flag = true;
        $msg = "Your checkout was placed successfully";

        //NOTE get buy currency price form check out or update prices
        //save sell price

      //   $symbolKey = "exchange_product_symbol_".$symbol;
      //   $symbolBaseKey = "exchange_product_symbolBase_".$symbolBase;
      //   $token_name =  $token->name;
      

      

      // $symbolKey_product_id = get_option( $symbolKey );
      // $symbolBase_product_id = get_option( $symbolBaseKey );
 
        // $product = wc_get_product( $symbolBase_product_id );
        // $product = $product ? $product : new WC_Product_Simple();
      
   
        // $product->set_regular_price( $token->price );
        
      



        if($checkout == false){
            $flag = false;
            $msg = "There was an error placing your checkout";
        }else{

        }
        
        
        if($flag){
            $result = $checkout;
        }else{
          $result = [
            'exchangeError' => true,
            'error' => $msg,
            'flag' => false,
            'sellCurrency' => [],
            'stableToken' => [],
            'sellCurrency' => [],
            'paymentMethods' => [],
            'redirect' => '',
            'environment' => $sails_environment,
          ];

        }



      } catch (\Throwable $th) {
        //throw $th;
        $result = [
          'exchangeError' => true,
          'error' => $th,
          'flag' => false,
          'sellCurrency' => [],
          'stableToken' => [],
          'sellCurrency' => [],
          'paymentMethods' => [],
          'redirect' => '',
          'environment' => $sails_environment,
        ];


      }
      return json_encode($result);
    }


    
    public function pay_now($request){

      /*
        just needs to take checkout request and pass it to api controller and return result

        need to get checkout info //
        
        and create / load card in woocommcers.
        
        then this should rout to the chekcout page

      */

      try {


        $yohshow_api =  $this->yohshow_api;
        $apiKey =  $this->yohshow_api_key;

      


        $session = $_SESSION;
        $user = $_SESSION["me"];
        $checkoutToken = $request['checkoutToken'];

        $sails_environment = $this->sails_environment ? $this->sails_environment : "staging";

        $checkoutInfo = array(
          'checkoutToken' => $checkoutToken,
          'apiKey' => $apiKey,
        );

        $importCheckoutActions["addToCart"] = true;
        $importCheckoutResult = $this->import_checkout($checkoutInfo,$importCheckoutActions );
          $checkout_redirect = $importCheckoutResult["checkout_redirect"];
          $checkoutResult = $importCheckoutResult["checkoutResult"];


        //return checkout url 
        if($checkoutResult->checkoutAction == "sellUnits" || $checkoutResult->checkoutAction == "sell"){
          $checkout_url = "/checkout/".$checkoutResult->checkoutId;

        }else{
          $checkout_url = wc_get_checkout_url();

        }

        //add checkout page redirect to wc session data
        if(isset($checkout_redirect)){
          WC()->session->set('checkout_redirect',$checkout_redirect);
          //add action to extract redirect from cart add to ordert 
          add_action('woocommerce_add_order_item_meta', array( $this, 'hook_new_order_item_meta' ) , 10, 3);



        }




        $flag = $checkoutResult->success;
        $msg = "Your payNow was placed successfully";









        
        
        if($flag){
          // stableTokenLink:stableTokenLink,
          // checkoutToken:checkoutToken,
          // checkoutId:checkoutId,
          // displayPrice:displayPrice,
          // lineItem:lineItem,
          // transactionType:transactionType,
          // primeTrustForcePayment:primeTrustForcePayment,
          // externalPaymentMethods:externalPaymentMethods,
          // internalPaymentMethods:internalPaymentMethods,
          // externalBuyOk:externalBuyOk,
          // internalBuyOk:internalBuyOk,
          // checkoutAction:checkoutAction,
          // paymentMethods:paymentMethods,
          // checkout:checkout,
          // redirect:redirect,
          // stableToken:stableToken,
          // sellCurrency:sellCurrency,
          // isStableToken:isStableToken,
          // flag:true,
          // environment:sails_environment,

          $checkoutResult->checkout_url = $checkout_url;
          $result = $checkoutResult;
          // return $result = [
          //     'exchangeError' => false,
          //     // 'flag' => false,
          //     'flag' => true, // probably not correct and must be fslse
          //     'lineItem' => $checkout->line_items[0],
          //     'checkout' => $checkout,
          //     'sellCurrency' => $token,
          //     'stableToken' => $stableToken,
          //     'paymentMethods' => [],
          //     'redirect' => $checkout_redirect,
          //     'environment' => $sails_environment,
          //     "checkout_url" => $checkout_url,
          // ];
        }else{
          $result = [
            'exchangeError' => true,
            'error' => $msg,
            // 'flag' => false,
            'flag' => true, // probably not correct and must be fslse
            'lineItem' => [],
            'checkout' => [],
            'sellCurrency' => [],
            'stableToken' => [],
            'paymentMethods' => [],
            'redirect' => '',
            'environment' => $sails_environment,
            "checkout_url" => $checkout_url,
          ];

        }

      } catch (\Throwable $th) {
        //throw $th;
        $result = [
          'exchangeError' => true,
          'error' => $th,
          'flag' => false,
          'sellCurrency' => [],
          'stableToken' => [],
          'sellCurrency' => [],
          'paymentMethods' => [],
          'redirect' => '',
          'environment' => $sails_environment,
        ];


      }
      return json_encode($result);
    }
    public function hook_new_order_item_meta($item_id, $values, $cart_item_key) {
      $session_var  = 'checkout_redirect';
      $session_data = WC()->session->get($session_var);
      if(!empty($session_data))
         wc_add_order_item_meta($item_id, $session_var, $session_data);
      // else
        //  error_log("no session data", 0);
   }
   public function import_checkout($checkoutInfo,$importActions){
      /*
        processQuote

      */
       $woocommerce = WC();
       $woocommerce->session = new WC_Session_Handler();
       $woocommerce->session->init();
       $woocommerce->customer = new WC_Customer( );
       $woocommerce->cart = new WC_Cart();

       $apiKey =  $this->yohshow_api_key;
       $appTokenResult = (object) $this->yohshow_api->request("get","/appToken/$apiKey",array("apiKey"=>$apiKey));
       $appId = $appTokenResult->appId;
       $appToken = $appTokenResult->appToken;
       $stableToken = $appTokenResult->stableToken;
       $yohshow_tokenize = new Yohshow_Tokenize( $this->yohshow_api );
      
      $checkoutResult = (object) $this->yohshow_api->request("post","/checkout/get",$checkoutInfo);
      if($checkoutResult->success){
          $checkout = $checkoutResult->checkout;
          $checkoutId = $checkoutResult->checkout->id;
          $quoteId = $checkoutResult->checkout->quoteId;

          $checkoutExternalTokenId = $checkoutResult->checkout->external_token_id;
          $checkout_order_key = "exchange_checkout_order_id_".$checkoutId;

          $checkout_order_key_order_id = get_option( $checkout_order_key );
           $mustCreateOrder = $checkout_order_key_order_id == false;
//          $mustCreateOrder = true;


          $checkout_redirect = $checkout->redirect;
          if( (isset($importActions["createOrder"]) && $importActions["createOrder"]) || $mustCreateOrder){
            global $woocommerce;

            // $address = array(
            //     'first_name' => '111Joe',
            //     'last_name'  => 'Conlin',
            //     'company'    => 'Speed Society',
            //     'email'      => 'joe@testing.com',
            //     'phone'      => '760-555-1212',
            //     'address_1'  => '123 Main st.',
            //     'address_2'  => '104',
            //     'city'       => 'San Diego',
            //     'state'      => 'Ca',
            //     'postcode'   => '92121',
            //     'country'    => 'US'
            // );

            if($mustCreateOrder){
              // Now we create the order
                if($importActions["createOrder"]){
                    $order = wc_create_order();
                    $checkout_order_key_order_id = $order->get_id();
                    $checkout_order_key_order_id_updated = update_option($checkout_order_key, $checkout_order_key_order_id);
                    $order->update_meta_data( 'exchange_checkout_id', $checkoutId );
                    $order->update_meta_data( 'exchange_order_checkout_id', $checkoutId );

                }



            }else{
                // Now we create the order
                $order = wc_get_order($checkout_order_key_order_id);
                $order->update_meta_data( 'exchange_checkout_id', $checkoutId );
                $order->update_meta_data( 'exchange_order_checkout_id', $checkoutId );
            }


            
            //add order meta data
            WC()->session->set('exchange_order_checkout_id',$checkoutId);
            if($checkoutExternalTokenId){
              

              if( isset($importActions['addToCart']) && $importActions['addToCart'] && $token->action !== "sell" ){

                WC()->session->set('exchange_order_product_ids_to_mint',$checkoutExternalTokenId);
                
                

              }

              if(isset($importActions["createOrder"]) && $importActions["createOrder"]){
                $exchange_order_product_ids_to_mint = add_post_meta($checkout_order_key_order_id,"exchange_order_product_ids_to_mint",$checkoutExternalTokenId);
                $exchange_order_product_ids_to_mints = get_post_meta($checkout_order_key_order_id,"exchange_order_product_ids_to_mint");
              }
            }
            //
            

            // The add_product() function below is located in /plugins/woocommerce/includes/abstracts/abstract_wc_order.php
            // $order->add_product( get_product('275962'), 1); // This is an existing SIMPLE product
            // $order->set_address( $address, 'billing' );
            //
             
          }


          for ($i=0; $i < count($checkout->line_items); $i++) {
              $line_item = $checkout->line_items[$i];
              $sellCurrencyId = $line_item->sellCurrencyId;
              $tokenId = $line_item->tokenId;
              $type = $line_item->type;
              $title = $line_item->title;
              $action = $line_item->action;
              $price = $line_item->price;
              $frequency = $line_item->frequency;
              $portfolioId = $line_item->portfolioId;
              $quantity = $line_item->quantity;
              $fulfillable_quantity = $line_item->fulfillable_quantity;
              $line_item_total = $line_item->line_item_total;
              $line_item_sub_total = $line_item->line_item_sub_total;
              $shop_fee = $line_item->shop_fee;
              $external_fee = $line_item->external_fee;
              $total_fee = $line_item->total_fee;

              
              
              $tokenInfo = array();
              if($action == "payment"){
                $getTokenId = $tokenId;
              }else{
                $getTokenId = isset($sellCurrencyId)  ? $sellCurrencyId : $stableToken->id ;
              }
              $tokenResult = (object) $this->yohshow_api->request("get","/tokens/$getTokenId",$tokenInfo);
              $token = $tokenResult->token;

              $updatePrice = true;

              //if this is a table token, actions should be issueStableTokens
              if($action == "mint"){
                //get app mint product
                $token = $appToken; 
                $token->action = $action;
                $updatePrice = false;
                $quantity = 1;


              }else if($action == "payment"){
                $token->action = $action;
                $token->price = $stableToken->price;
              }else if($action == "sell" || $action == "sellUnits" || $action == "redeem"){
                $token->action = "sell";
                $token->price = $price;
              }else if($token->id == $stableToken->id){
                $token->action = "issueStableTokens";
              }else{
                $token->action = "invest";
              }
              

              $tokenProduct = $yohshow_tokenize->create_product($token, $updatePrice );
              $product_id = $tokenProduct->get_id();


               if( isset($importActions['addToCart']) && $importActions['addToCart'] && $token->action !== "sell" ){
//              if( isset($importActions['addToCart']) && $importActions['addToCart']  ){
                $woocommerce->cart->add_to_cart( $product_id, $quantity);
              }

              if(isset($importActions["createOrder"]) && $importActions["createOrder"]){
                $order->add_product( wc_get_product($product_id), $quantity); // This is an existing SIMPLE product
              
              }



              


              

              //get /form exchange product key //
              //search for product by exchange product key //
              //if product doesnt exist //
              //create product //
              //update product price//
              //add product to cart with correct quanity //
          }
          if(isset($importActions["createOrder"]) && $importActions["createOrder"]){
            $order->calculate_totals();
            // $order->update_status("Completed", 'Imported order', TRUE);  
            $order->update_status("Processing", 'Imported order', TRUE);  
          }
      }

      $result["checkout_redirect"] =  $checkout_redirect;
//      $result["products"] =  $products;
//      $result["product_ids"] =  $product_ids;
      $result["success"] =  $checkoutResult->success;
       $result["checkoutResult"] =  $checkoutResult;
      $result["order_id"] =  isset($importActions["createOrder"]) && $importActions["createOrder"] ? $checkout_order_key_order_id : $importActions["createOrder"];
      $result["exchange_external_order_id"] =  $checkout_order_key_order_id . "_" . $checkoutId;
      

      return $result;
      

   }

   
 

    

    public function update_checkout_payment_method($request){

      /*
        just needs to take checkout request and pass it to api controller and return result

      */

      try {
        $session = $_SESSION;
        $user = $_SESSION["me"];
        $checkoutId = $request['checkoutId'];
        $paymentMethod = $request['paymentMethod'];


        $sails_environment = $this->sails_environment ? $this->sails_environment : "staging";
        $updatePaymentMethodInfo = array(
          'checkoutId' => $checkoutId,
          'paymentMethod' => $paymentMethod,
        );

        $updatePaymentMethod = (object) $this->yohshow_api->request("post","/update-checkout-payment-method",$updatePaymentMethodInfo);
        $flag = true;
        $msg = "Your updatePaymentMethod was placed successfully";



        if($updatePaymentMethod == false){
            $flag = false;
            $msg = "There was an error placing your updatePaymentMethod";
        }else{

        }
        
        
        if($flag){
          return $updatePaymentMethod;
        }else{
          $result = [
            'exchangeError' => true,
            'error' => $msg,
            // 'flag' => false,
            'flag' => true, // probably not correct and must be fslse
            'lineItem' => [],
            'checkout' => [],
            'sellCurrency' => [],
            'stableToken' => [],
            'paymentMethods' => [],
            'redirect' => '',
            'environment' => $sails_environment,
          ];

        }

      } catch (\Throwable $th) {
        //throw $th;
        $result = [
          'exchangeError' => true,
          'error' => $th,
          'flag' => false,
          'sellCurrency' => [],
          'stableToken' => [],
          'sellCurrency' => [],
          'paymentMethods' => [],
          'redirect' => '',
          'environment' => $sails_environment,
        ];


      }
      return json_encode($result);
    }

    public function pay_checkout($request){

      /*
        just needs to take checkout request and pass it to api controller and return result


      */
      // error_log( "pay checkout called! " );


      try {
        $session = $_SESSION;
        $user = $_SESSION["me"];
        $apiKey =  $this->yohshow_api_key;
        $apiSecret =  $this->yohshow_api_secret;


        $checkoutId = $request['checkoutId'];
        $challengeId = $request['challengeId'];
        $forterTokenCookie = $request['forterTokenCookie'];
        $contributionId = $request['contributionId'];
        $fundsTransferMethodId = $request['fundsTransferMethodId'];
        $exchangeUserEmailAddress = $request['exchangeUserEmailAddress'];
        

        if($exchangeUserEmailAddress){
          $apiKey = $request['apiKey'];
          $apiSecret = $request['apiSecret'];
          if($this->yohshow_api_key !== $apiKey || $this->yohshow_api_secret !== $apiSecret  ){

            $result["flag"] = false;
            $result["success"] = false;
            $result["msg"] = "Unauthroized";
            $result["message"] = "Unauthroized";
            $result["error"] = "Unauthroized";
            return $result;
     
          }
          if( !session_id() )
          {
            session_start();
          }
          $loginResult = $this->yohshow_api->login($exchangeUserEmailAddress);
          // $_SESSION["exchange_wp_user_id"] =
        }


        $sails_environment = $this->sails_environment ? $this->sails_environment : "staging";

        $checkoutInfo = array(
          'checkoutId' => $checkoutId,
          'apiKey' => $apiKey,
        );


        // error_log( "pay checkout result checkoutInfo ". print_r( $checkoutInfo, true ) );

        $importCheckoutActions["addToCart"] = false;
        $importCheckoutActions["createOrder"] = true;
        $importCheckoutResult = $this->import_checkout($checkoutInfo,$importCheckoutActions );
        // error_log( "pay checkout result importCheckoutResult". print_r( $importCheckoutResult, true ) );

        // $externalOrderId = $importCheckoutResult["order_id"];
        $externalOrderId = $importCheckoutResult["exchange_external_order_id"];
        $order = new WC_Order($externalOrderId);

        $quote_source_key = "exchange_quote_source";
        $quote_source = get_option( $quote_source_key );

        $quote_source_buy_currency_key = "exchange_quote_source_buy_currency";
        $quote_source_buy_currency = get_option( $quote_source_buy_currency_key );

        //

        $quote_source_api_key_key = "exchange_quote_source_api_key";
        $quote_source_api_key = get_option( $quote_source_api_key_key );

        $quote_source_api_secret_key = "exchange_quote_source_api_secret";
        $quote_source_api_secret = get_option( $quote_source_api_secret_key );

        $quote_source_api_memo_key = "exchange_quote_source_api_memo";
        $quote_source_api_memo = get_option( $quote_source_api_memo_key );


        

        //checkt to see if there is an order id for the checkout id
        //if not
          //create products for line items
          //create order for checkout
          //save order id under site options for exchange checkout id
        //send order id as external order id



        $payCheckoutInfo = array(
          'checkoutId' => $checkoutId,
          'challengeId' => $challengeId,
          'forterTokenCookie' => $forterTokenCookie,
          'contributionId' => $contributionId,
          'fundsTransferMethodId' => $fundsTransferMethodId,
          'externalOrderId' => $externalOrderId,
          'apiKey' => $apiKey,
          'apiSecret' => $apiSecret,
        );

        $payCheckoutInfo["exchange"] = $quote_source;
        $payCheckoutInfo["exchangeApiKey"] = $quote_source_api_key;
        $payCheckoutInfo["exchangeApiSecret"] = $quote_source_api_secret;
        $payCheckoutInfo["exchangeApiMemo"] = $quote_source_api_memo;

        // error_log( "pay checkout result payCheckoutInfo". print_r( $payCheckoutInfo, true ) );


        $payCheckout = (object) $this->yohshow_api->request("post","/checkout/pay",$payCheckoutInfo);
        $flag = true;
        $msg = "Your payCheckout was placed successfully";
        // error_log( "pay checkout result payCheckout". print_r( $payCheckout, true ) );





        if($payCheckout == false){
            $flag = false;
            $msg = "There was an error placing your payCheckout";
        }else{

        }
        
        
        if($flag){
          $order->update_meta_data( 'exchange_order_fullfiled', true );
          $order->update_status("Completed", 'Fullfiled exchange order', TRUE);  

          // return $payCheckout;
          $result = $payCheckout;
        }else{
          $result = [
            'exchangeError' => true,
            'error' => $msg,
            // 'flag' => false,
            'flag' => true, // probably not correct and must be fslse
            'lineItem' => [],
            'checkout' => [],
            'sellCurrency' => [],
            'stableToken' => [],
            'paymentMethods' => [],
            'redirect' => '',
            'environment' => $sails_environment,
          ];

        }

      } catch (\Throwable $th) {
        //throw $th;
        $result = [
          'exchangeError' => true,
          'error' => $th,
          'flag' => false,
          'sellCurrency' => [],
          'stableToken' => [],
          'sellCurrency' => [],
          'paymentMethods' => [],
          'redirect' => '',
          'environment' => $sails_environment,
        ];


      }
        error_log( "pay_checkout result ". print_r( $result, true ) );
      
      return json_encode($result);
    }

    public function checkout($request){

      /*
        just needs to take checkout request and pass it to api controller and return result


      */

      try {
        $session = $_SESSION;
        $user = $_SESSION["me"];


        $checkoutId = $request['checkoutId'];


        $sails_environment = $this->sails_environment ? $this->sails_environment : "staging";
        $checkoutInfo = array(
          'checkoutId' => $checkoutId,
        );

        $checkout = (object) $this->yohshow_api->request("post","/checkout",$checkoutInfo);
        $flag = true;
        $msg = "Your checkout was placed successfully";



        if($checkout == false){
            $flag = false;
            $msg = "There was an error placing your checkout";
        }else{

        }
        
        
        if($flag){
          $result = $checkout;
        }else{
          $result = [
            'exchangeError' => true,
            'error' => $msg,
            // 'flag' => false,
            'flag' => true, // probably not correct and must be fslse
            'lineItem' => [],
            'checkout' => [],
            'sellCurrency' => [],
            'stableToken' => [],
            'paymentMethods' => [],
            'redirect' => '',
            'environment' => $sails_environment,
          ];

        }

      } catch (\Throwable $th) {
        //throw $th;
        $result = [
          'exchangeError' => true,
          'error' => $th,
          'flag' => false,
          'sellCurrency' => [],
          'stableToken' => [],
          'sellCurrency' => [],
          'paymentMethods' => [],
          'redirect' => '',
          'environment' => $sails_environment,
        ];


      }
      return json_encode($result);
    }

    public function orders($request){

      /*
        just needs to take checkout request and pass it to api controller and return result


      */

      try {
        $session = $_SESSION;
        $user = $_SESSION["me"];


        $userType = $request['userType'];
        $accountId = $request['accountId'];


        $sails_environment = $this->sails_environment ? $this->sails_environment : "staging";
        $ordersInfo = array(
          'userType' => $userType,
          'accountId' => $accountId,
        );

        $orders = (object) $this->yohshow_api->request("post","/api/orders",$ordersInfo);
        $flag = true;
        $msg = "Your orders was placed successfully";

        if($orders == false){
            $flag = false;
            $msg = "There was an error placing your orders";
        }else{

        }
        
        
        if($flag){
          return $orders;
        }else{
          $result = [
            'exchangeError' => true,
            'error' => $msg,
            // 'flag' => false,
            'flag' => true, // probably not correct and must be fslse
            'lineItem' => [],
            'checkout' => [],
            'sellCurrency' => [],
            'stableToken' => [],
            'paymentMethods' => [],
            'redirect' => '',
            'environment' => $sails_environment,
          ];

        }

      } catch (\Throwable $th) {
        //throw $th;
        $result = [
          'exchangeError' => true,
          'error' => $th,
          'flag' => false,
          'sellCurrency' => [],
          'stableToken' => [],
          'sellCurrency' => [],
          'paymentMethods' => [],
          'redirect' => '',
          'environment' => $sails_environment,
        ];


      }
      return json_encode($result);
    }
    public function pause_subscription($request){

      /*
        just needs to take checkout request and pass it to api controller and return result


      */

      $inputs = ["subscriptionId","pause"];
      $responseJson = $this->exchange_request("post","/subscriptions/pause",$inputs,$request);
      return $responseJson;


    }


    public function exchange_request($method,$endpoint,$inputs,$request){

      /*
        just needs to take checkout request and pass it to api controller and return result


      */

      try {
        $session = $_SESSION;
        $user = $_SESSION["me"];

        $requestInfo = array( );

        for ($i=0; $i < count($inputs); $i++) { 
          $label = $inputs[$i];
          $requestInfo[$label] = $request[$label];
        }


        $request = (object) $this->yohshow_api->request($method,$endpoint,$requestInfo);
        $flag = true;
        $msg = "Your request was placed successfully";

        if($request == false){
            $flag = false;
            $msg = "There was an error placing your request";
        }else{

        }
        
        
        if($flag){
          $result = $request;
        }else{
          $result = [
            'exchangeError' => true,
            'error' => $msg,
            // 'flag' => false,
            'flag' => true, // probably not correct and must be fslse
            'lineItem' => [],
            'checkout' => [],
            'sellCurrency' => [],
            'stableToken' => [],
            'paymentMethods' => [],
            'redirect' => '',
            'environment' => "",
          ];

        }

      } catch (\Throwable $th) {
        //throw $th;
        $result = [
          'exchangeError' => true,
          'error' => $th,
          'flag' => false,
          'sellCurrency' => [],
          'stableToken' => [],
          'sellCurrency' => [],
          'paymentMethods' => [],
          'redirect' => '',
          'environment' => "",
        ];


      }
      return json_encode($result);
    }
    

    public function enqueue_scripts(){
      $this->enqueue_scripts_folder("assets/dependencies");
      $this->enqueue_scripts_folder("assets/dependencies/exchange");
      $this->enqueue_scripts_folder("assets/dependencies/exchange/chart-org");
      $this->enqueue_scripts_folder("assets/dependencies/exchange/lightweight-chart");
      $this->enqueue_scripts_folder("assets/js");
      $this->enqueue_scripts_folder("assets/js/components");
      $this->enqueue_scripts_folder("assets/js/components/exchange");
      $this->enqueue_scripts_folder("assets/js/components/tokens");
      $this->enqueue_scripts_folder("assets/js/components/transactions");

      // $this->enqueue_scripts_folder("assets/js/components/folder"); // in case you want a to put code in a folder
      $this->enqueue_scripts_folder("assets/js/pages");
  }




  public function enqueue_scripts_folder($path){
      foreach( glob( plugin_dir_path( __FILE__ ) . "$path/*.js" ) as $file ) {
          // $file contains the name and extension of the file
          $file_name = basename($file);
          $file_url = plugin_dir_url( __FILE__ )."$path/".$file_name;
          //echo '<pre>'; 
          //// var_dump("file_url",$file_url);
          //echo '</pre>';
          // exit;
          wp_enqueue_script( $file_name, $file_url,array("jquery"));
      }
      // // var_dump("$path/*.css" );

      foreach( glob( plugin_dir_path( __FILE__ ) . "$path/*.css" ) as $file ) {
          // $file contains the name and extension of the file
          $file_name = basename($file);
          $file_url = plugin_dir_url( __FILE__ )."$path/".$file_name;
          // echo '<pre>'; 
          // // var_dump("file_url",$file_url);
          // echo '</pre>';
          // exit;
          wp_enqueue_style( $file_name, $file_url);
      }
      foreach( glob( plugin_dir_path( __FILE__ ) . "$path/*.less" ) as $file ) {
          // $file contains the name and extension of the file
          $file_name = basename($file);
          $file_url = plugin_dir_url( __FILE__ )."$path/".$file_name;
          // echo '<pre>'; 
          // // var_dump("file_url",$file_url);
          // echo '</pre>';
          // exit;
          wp_enqueue_style( $file_name, $file_url,array("jquery"));
      }
  }

    

}