<?php
/**
 * Creates the yohshow api item for the plugin.
 *
 * @package YohShow
 */

$origin_url = '*';
    
// Check if production environment or not
if (false) {
// if (ENVIRONMENT === 'production') {
  $origin_url = esc_url_raw( site_url() );
}

class Yohshow_Stripe extends Yohshow_WP {


    public function __construct($yohshow_api) {
        parent::__construct($yohshow_api);
        $this->init();

        //require_once('/path/to/stripe-php/init.php');
      
    }
    function init(){
        $this->create_endpoints();
        $this->add_shortcodes();
        $this->add_actions();
        //$this->get_account();

    }
    public function register_link($exchange_stripe_account_id){
      $exchange_environment = get_option( "exchange_environment" );
        if($exchange_environment == "production"){
          $exchange_stripe_apiSecret = get_option( "exchange_stripe_apiSecret" );

        }else{
          $exchange_stripe_apiSecret = get_option( "exchange_stripe_apiSecretTest" );

        }
      // Set your secret key. Remember to switch to your live secret key in production.
      // See your keys here: https://dashboard.stripe.com/apikeys
      
      $stripe = new \Stripe\StripeClient($exchange_stripe_apiSecret);

      // $account_result = $this->get_account();
      // $result = $account_result;


      // if($account_result["success"] && $account_result["mustOnboard"]){
        // $accountId = $account_result["accountId"];
				$exchange_path = get_option('exchange_path');

				$transfer_page_link =    get_permalink( get_page_by_path( $exchange_path ) ) .  "#/transfer/";

        $accountId = $exchange_stripe_account_id;
        $account_links_result = $stripe->accountLinks->create(
          [
            'account' => $accountId,
            'refresh_url' => $transfer_page_link ,
            'return_url' => $transfer_page_link ,
            'type' => 'account_onboarding',

          ]
        );
        $url = $account_links_result->url;
        $result["onboardUrl"] = $url;
        $result["url"] = $url;

      // }else{
      //   $result = $account_result;
      // }

      
      return $result;

      
    }
    //get accoun based on logged in user or false object if user not loged in
    public function get_account(){
      // Set your secret key. Remember to switch to your live secret key in production.
      // See your keys here: https://dashboard.stripe.com/apikeys
      $exchange_environment = get_option( "exchange_environment" );
        if($exchange_environment == "production"){
          $exchange_stripe_apiSecret = get_option( "exchange_stripe_apiSecret" );

        }else{
          $exchange_stripe_apiSecret = get_option( "exchange_stripe_apiSecretTest" );

        }
      // Set your secret key. Remember to switch to your live secret key in production.
      // See your keys here: https://dashboard.stripe.com/apikeys
      
      $stripe = new \Stripe\StripeClient($exchange_stripe_apiSecret);
      if( !session_id() )
      {
        session_start();
      }
      $user_id = $_SESSION["exchange_wp_user_id"];
      if($user_id){
        $exchange_stripe_account_id = get_user_meta($user_id, 'exchange_stripe_account_id',true);
        $exchange_environment_stripe_account_id = get_user_meta($user_id, 'exchange_'.$exchange_environment.'_stripe_account_id',true);
        // $exchange_stripe_account_id = false;
        if($exchange_environment_stripe_account_id){

          $account_result = $stripe->accounts->retrieve($exchange_environment_stripe_account_id);
          // check to see if we must onboard
            $result["mustOnboard"] = !$account_result->details_submitted;
            $result["transferCapabilities"] = $account_result->capabilities->transfers;
            if($result["transferCapabilities"] == "inactive"){
              $result["mustOnboard"] = true;

            }
        }else{
          // $account_result = $stripe->accounts->create([
          //   'type' => 'express'
          // ]);
          $account_result = $stripe->accounts->create([
            'type' => 'express',
            'capabilities' => [
              'card_payments' => ['requested' => true],
              'transfers' => ['requested' => true],
            ]
          ]);
          $exchange_stripe_account_id = $account_result->id;
          $exchange_stripe_account_id_meta_id = update_user_meta($user_id, 'exchange_stripe_account_id',$exchange_stripe_account_id);

          $exchange_environment_stripe_account_id = $account_result->id;
          $exchange_environment_stripe_account_id_meta_id = update_user_meta($user_id, 'exchange_'.$exchange_environment.'_stripe_account_id',$exchange_environment_stripe_account_id);

          $account_result["mustOnboard"] = true;
          $result["mustOnboard"] = true;
          

        }
        if($result["mustOnboard"]){
          $resgister_link_result = $this->register_link($exchange_environment_stripe_account_id);
          $result["url"] = $resgister_link_result["url"];
          $result["onboardUrl"] = $resgister_link_result["onboardUrl"];

        }
        $result["success"] = true;
        $result["account"] = $account_result;
        $result["accountId"] = $exchange_environment_stripe_account_id;
        $result["exchange_stripe_account_id"] = $exchange_environment_stripe_account_id;
        $result["id"] = $exchange_environment_stripe_account_id;
        $result["msg"] = "success";

      }else{
        $result["sucess"] = false;
        $result["msg"] = "not logged in";
        $account_result["mustOnboard"] = false;

      }
      return $result;


      
    }
    // get account with stripe id
    public function _get_account($exchange_stripe_account_id = false){
      // Set your secret key. Remember to switch to your live secret key in production.
      // See your keys here: https://dashboard.stripe.com/apikeys
      $exchange_environment = get_option( "exchange_environment" );
        if($exchange_environment == "production"){
          $exchange_stripe_apiSecret = get_option( "exchange_stripe_apiSecret" );

        }else{
          $exchange_stripe_apiSecret = get_option( "exchange_stripe_apiSecretTest" );

        }
      // Set your secret key. Remember to switch to your live secret key in production.
      // See your keys here: https://dashboard.stripe.com/apikeys
      
      $stripe = new \Stripe\StripeClient($exchange_stripe_apiSecret);

      if($exchange_stripe_account_id == false){
        if( !session_id() )
        {
          session_start();
        }
        $user_id = $_SESSION["exchange_wp_user_id"];
        if($user_id){
          $exchange_stripe_account_id = get_user_meta($user_id, 'exchange_stripe_account_id',true);
        }

      }
      if($exchange_stripe_account_id){

          $account_result = $stripe->accounts->retrieve($exchange_stripe_account_id);
      }else{
        $account_result = false;
      }


      return $account_result;

      
    }
    public function create_endpoints(){
      $register_result = add_action( 'rest_api_init', function () {

          // register_rest_route( 'yohshow/api/v1', '/mint', array(
          //   'methods' => 'POST',
          //   'callback' => array($this,"mint")
          // ) );  //

        });
      
    }

    //scripts 
    public function add_shortcodes(){
      
      


    }


 
  /**
   * Adds wp acctions and triggers
   */
  public function add_actions() {

      



  }



  


 

    

}